package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMWO_INNER;
import cn.ibizlab.eam.core.eam_core.service.IEMWO_INNERService;
import cn.ibizlab.eam.core.eam_core.filter.EMWO_INNERSearchContext;




@Slf4j
@Api(tags = {"EMWO_INNER" })
@RestController("WebApi-emwo_inner")
@RequestMapping("")
public class EMWO_INNERResource {

    @Autowired
    private IEMWO_INNERService emwo_innerService;

    @Autowired
    @Lazy
    private EMWO_INNERMapping emwo_innerMapping;




    @PreAuthorize("hasPermission(#emwo_inner_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMWO_INNER" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emwo_inners/{emwo_inner_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emwo_inner_id") String emwo_inner_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emwo_innerService.remove(emwo_inner_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMWO_INNER" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emwo_inners/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emwo_innerService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMWO_INNER" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emwo_inners/getdraft")
    public ResponseEntity<EMWO_INNERDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emwo_innerMapping.toDto(emwo_innerService.getDraft(new EMWO_INNER())));
    }




    @ApiOperation(value = "CheckKey", tags = {"EMWO_INNER" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_inners/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMWO_INNERDTO emwo_innerdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_innerService.checkKey(emwo_innerMapping.toDomain(emwo_innerdto)));
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMWO_INNER" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_inners")
    @Transactional
    public ResponseEntity<EMWO_INNERDTO> create(@RequestBody EMWO_INNERDTO emwo_innerdto) {
        EMWO_INNER domain = emwo_innerMapping.toDomain(emwo_innerdto);
		emwo_innerService.create(domain);
        EMWO_INNERDTO dto = emwo_innerMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMWO_INNER" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_inners/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMWO_INNERDTO> emwo_innerdtos) {
        emwo_innerService.createBatch(emwo_innerMapping.toDomain(emwo_innerdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMWO_INNER" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_inners/save")
    public ResponseEntity<Boolean> save(@RequestBody EMWO_INNERDTO emwo_innerdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emwo_innerService.save(emwo_innerMapping.toDomain(emwo_innerdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMWO_INNER" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_inners/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMWO_INNERDTO> emwo_innerdtos) {
        emwo_innerService.saveBatch(emwo_innerMapping.toDomain(emwo_innerdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emwo_inner_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMWO_INNER" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emwo_inners/{emwo_inner_id}")
    @Transactional
    public ResponseEntity<EMWO_INNERDTO> update(@PathVariable("emwo_inner_id") String emwo_inner_id, @RequestBody EMWO_INNERDTO emwo_innerdto) {
		EMWO_INNER domain = emwo_innerMapping.toDomain(emwo_innerdto);
        domain.setEmwoInnerid(emwo_inner_id);
		emwo_innerService.update(domain);
		EMWO_INNERDTO dto = emwo_innerMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emwo_inner_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMWO_INNER" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emwo_inners/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMWO_INNERDTO> emwo_innerdtos) {
        emwo_innerService.updateBatch(emwo_innerMapping.toDomain(emwo_innerdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emwo_inner_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMWO_INNER" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emwo_inners/{emwo_inner_id}")
    public ResponseEntity<EMWO_INNERDTO> get(@PathVariable("emwo_inner_id") String emwo_inner_id) {
        EMWO_INNER domain = emwo_innerService.get(emwo_inner_id);
        EMWO_INNERDTO dto = emwo_innerMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_INNER-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMWO_INNER" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emwo_inners/fetchdefault")
	public ResponseEntity<List<EMWO_INNERDTO>> fetchDefault(EMWO_INNERSearchContext context) {
        Page<EMWO_INNER> domains = emwo_innerService.searchDefault(context) ;
        List<EMWO_INNERDTO> list = emwo_innerMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_INNER-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMWO_INNER" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emwo_inners/searchdefault")
	public ResponseEntity<Page<EMWO_INNERDTO>> searchDefault(@RequestBody EMWO_INNERSearchContext context) {
        Page<EMWO_INNER> domains = emwo_innerService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_innerMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "RemoveByEMEquip", tags = {"EMWO_INNER" },  notes = "RemoveByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emwo_inners/{emwo_inner_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_inner_id") String emwo_inner_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwo_innerService.remove(emwo_inner_id));
    }

    @ApiOperation(value = "RemoveBatchByEMEquip", tags = {"EMWO_INNER" },  notes = "RemoveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emwo_inners/batch")
    public ResponseEntity<Boolean> removeBatchByEMEquip(@RequestBody List<String> ids) {
        emwo_innerService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMEquip", tags = {"EMWO_INNER" },  notes = "GetDraftByEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emwo_inners/getdraft")
    public ResponseEntity<EMWO_INNERDTO> getDraftByEMEquip(@PathVariable("emequip_id") String emequip_id) {
        EMWO_INNER domain = new EMWO_INNER();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_innerMapping.toDto(emwo_innerService.getDraft(domain)));
    }

    @ApiOperation(value = "CheckKeyByEMEquip", tags = {"EMWO_INNER" },  notes = "CheckKeyByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_inners/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_INNERDTO emwo_innerdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_innerService.checkKey(emwo_innerMapping.toDomain(emwo_innerdto)));
    }

    @ApiOperation(value = "CreateByEMEquip", tags = {"EMWO_INNER" },  notes = "CreateByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_inners")
    @Transactional
    public ResponseEntity<EMWO_INNERDTO> createByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_INNERDTO emwo_innerdto) {
        EMWO_INNER domain = emwo_innerMapping.toDomain(emwo_innerdto);
        domain.setEquipid(emequip_id);
		emwo_innerService.create(domain);
        EMWO_INNERDTO dto = emwo_innerMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMEquip", tags = {"EMWO_INNER" },  notes = "createBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_inners/batch")
    public ResponseEntity<Boolean> createBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_INNERDTO> emwo_innerdtos) {
        List<EMWO_INNER> domainlist=emwo_innerMapping.toDomain(emwo_innerdtos);
        for(EMWO_INNER domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_innerService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMEquip", tags = {"EMWO_INNER" },  notes = "SaveByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_inners/save")
    public ResponseEntity<Boolean> saveByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_INNERDTO emwo_innerdto) {
        EMWO_INNER domain = emwo_innerMapping.toDomain(emwo_innerdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_innerService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMEquip", tags = {"EMWO_INNER" },  notes = "SaveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_inners/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_INNERDTO> emwo_innerdtos) {
        List<EMWO_INNER> domainlist=emwo_innerMapping.toDomain(emwo_innerdtos);
        for(EMWO_INNER domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emwo_innerService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMEquip", tags = {"EMWO_INNER" },  notes = "UpdateByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emwo_inners/{emwo_inner_id}")
    @Transactional
    public ResponseEntity<EMWO_INNERDTO> updateByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_inner_id") String emwo_inner_id, @RequestBody EMWO_INNERDTO emwo_innerdto) {
        EMWO_INNER domain = emwo_innerMapping.toDomain(emwo_innerdto);
        domain.setEquipid(emequip_id);
        domain.setEmwoInnerid(emwo_inner_id);
		emwo_innerService.update(domain);
        EMWO_INNERDTO dto = emwo_innerMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMEquip", tags = {"EMWO_INNER" },  notes = "UpdateBatchByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emwo_inners/batch")
    public ResponseEntity<Boolean> updateBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_INNERDTO> emwo_innerdtos) {
        List<EMWO_INNER> domainlist=emwo_innerMapping.toDomain(emwo_innerdtos);
        for(EMWO_INNER domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_innerService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMEquip", tags = {"EMWO_INNER" },  notes = "GetByEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emwo_inners/{emwo_inner_id}")
    public ResponseEntity<EMWO_INNERDTO> getByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_inner_id") String emwo_inner_id) {
        EMWO_INNER domain = emwo_innerService.get(emwo_inner_id);
        EMWO_INNERDTO dto = emwo_innerMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

	@ApiOperation(value = "fetchDEFAULTByEMEquip", tags = {"EMWO_INNER" } ,notes = "fetchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/{emequip_id}/emwo_inners/fetchdefault")
	public ResponseEntity<List<EMWO_INNERDTO>> fetchEMWO_INNERDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id,EMWO_INNERSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_INNER> domains = emwo_innerService.searchDefault(context) ;
        List<EMWO_INNERDTO> list = emwo_innerMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMEquip", tags = {"EMWO_INNER" } ,notes = "searchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/{emequip_id}/emwo_inners/searchdefault")
	public ResponseEntity<Page<EMWO_INNERDTO>> searchEMWO_INNERDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_INNERSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_INNER> domains = emwo_innerService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_innerMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "RemoveByEMEQTypeEMEquip", tags = {"EMWO_INNER" },  notes = "RemoveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_inners/{emwo_inner_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_inner_id") String emwo_inner_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwo_innerService.remove(emwo_inner_id));
    }

    @ApiOperation(value = "RemoveBatchByEMEQTypeEMEquip", tags = {"EMWO_INNER" },  notes = "RemoveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_inners/batch")
    public ResponseEntity<Boolean> removeBatchByEMEQTypeEMEquip(@RequestBody List<String> ids) {
        emwo_innerService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMEQTypeEMEquip", tags = {"EMWO_INNER" },  notes = "GetDraftByEMEQTypeEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_inners/getdraft")
    public ResponseEntity<EMWO_INNERDTO> getDraftByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id) {
        EMWO_INNER domain = new EMWO_INNER();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_innerMapping.toDto(emwo_innerService.getDraft(domain)));
    }

    @ApiOperation(value = "CheckKeyByEMEQTypeEMEquip", tags = {"EMWO_INNER" },  notes = "CheckKeyByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_inners/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_INNERDTO emwo_innerdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_innerService.checkKey(emwo_innerMapping.toDomain(emwo_innerdto)));
    }

    @ApiOperation(value = "CreateByEMEQTypeEMEquip", tags = {"EMWO_INNER" },  notes = "CreateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_inners")
    @Transactional
    public ResponseEntity<EMWO_INNERDTO> createByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_INNERDTO emwo_innerdto) {
        EMWO_INNER domain = emwo_innerMapping.toDomain(emwo_innerdto);
        domain.setEquipid(emequip_id);
		emwo_innerService.create(domain);
        EMWO_INNERDTO dto = emwo_innerMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMEQTypeEMEquip", tags = {"EMWO_INNER" },  notes = "createBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_inners/batch")
    public ResponseEntity<Boolean> createBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_INNERDTO> emwo_innerdtos) {
        List<EMWO_INNER> domainlist=emwo_innerMapping.toDomain(emwo_innerdtos);
        for(EMWO_INNER domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_innerService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMEQTypeEMEquip", tags = {"EMWO_INNER" },  notes = "SaveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_inners/save")
    public ResponseEntity<Boolean> saveByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_INNERDTO emwo_innerdto) {
        EMWO_INNER domain = emwo_innerMapping.toDomain(emwo_innerdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_innerService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMEQTypeEMEquip", tags = {"EMWO_INNER" },  notes = "SaveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_inners/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_INNERDTO> emwo_innerdtos) {
        List<EMWO_INNER> domainlist=emwo_innerMapping.toDomain(emwo_innerdtos);
        for(EMWO_INNER domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emwo_innerService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMEQTypeEMEquip", tags = {"EMWO_INNER" },  notes = "UpdateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_inners/{emwo_inner_id}")
    @Transactional
    public ResponseEntity<EMWO_INNERDTO> updateByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_inner_id") String emwo_inner_id, @RequestBody EMWO_INNERDTO emwo_innerdto) {
        EMWO_INNER domain = emwo_innerMapping.toDomain(emwo_innerdto);
        domain.setEquipid(emequip_id);
        domain.setEmwoInnerid(emwo_inner_id);
		emwo_innerService.update(domain);
        EMWO_INNERDTO dto = emwo_innerMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMEQTypeEMEquip", tags = {"EMWO_INNER" },  notes = "UpdateBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_inners/batch")
    public ResponseEntity<Boolean> updateBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_INNERDTO> emwo_innerdtos) {
        List<EMWO_INNER> domainlist=emwo_innerMapping.toDomain(emwo_innerdtos);
        for(EMWO_INNER domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_innerService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMEQTypeEMEquip", tags = {"EMWO_INNER" },  notes = "GetByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_inners/{emwo_inner_id}")
    public ResponseEntity<EMWO_INNERDTO> getByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_inner_id") String emwo_inner_id) {
        EMWO_INNER domain = emwo_innerService.get(emwo_inner_id);
        EMWO_INNERDTO dto = emwo_innerMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

	@ApiOperation(value = "fetchDEFAULTByEMEQTypeEMEquip", tags = {"EMWO_INNER" } ,notes = "fetchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_inners/fetchdefault")
	public ResponseEntity<List<EMWO_INNERDTO>> fetchEMWO_INNERDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id,EMWO_INNERSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_INNER> domains = emwo_innerService.searchDefault(context) ;
        List<EMWO_INNERDTO> list = emwo_innerMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMEQTypeEMEquip", tags = {"EMWO_INNER" } ,notes = "searchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_inners/searchdefault")
	public ResponseEntity<Page<EMWO_INNERDTO>> searchEMWO_INNERDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_INNERSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_INNER> domains = emwo_innerService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_innerMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "RemoveByPFTeamEMEquip", tags = {"EMWO_INNER" },  notes = "RemoveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_inners/{emwo_inner_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_inner_id") String emwo_inner_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwo_innerService.remove(emwo_inner_id));
    }

    @ApiOperation(value = "RemoveBatchByPFTeamEMEquip", tags = {"EMWO_INNER" },  notes = "RemoveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_inners/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeamEMEquip(@RequestBody List<String> ids) {
        emwo_innerService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFTeamEMEquip", tags = {"EMWO_INNER" },  notes = "GetDraftByPFTeamEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_inners/getdraft")
    public ResponseEntity<EMWO_INNERDTO> getDraftByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id) {
        EMWO_INNER domain = new EMWO_INNER();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_innerMapping.toDto(emwo_innerService.getDraft(domain)));
    }

    @ApiOperation(value = "CheckKeyByPFTeamEMEquip", tags = {"EMWO_INNER" },  notes = "CheckKeyByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_inners/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_INNERDTO emwo_innerdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_innerService.checkKey(emwo_innerMapping.toDomain(emwo_innerdto)));
    }

    @ApiOperation(value = "CreateByPFTeamEMEquip", tags = {"EMWO_INNER" },  notes = "CreateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_inners")
    @Transactional
    public ResponseEntity<EMWO_INNERDTO> createByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_INNERDTO emwo_innerdto) {
        EMWO_INNER domain = emwo_innerMapping.toDomain(emwo_innerdto);
        domain.setEquipid(emequip_id);
		emwo_innerService.create(domain);
        EMWO_INNERDTO dto = emwo_innerMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFTeamEMEquip", tags = {"EMWO_INNER" },  notes = "createBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_inners/batch")
    public ResponseEntity<Boolean> createBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_INNERDTO> emwo_innerdtos) {
        List<EMWO_INNER> domainlist=emwo_innerMapping.toDomain(emwo_innerdtos);
        for(EMWO_INNER domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_innerService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByPFTeamEMEquip", tags = {"EMWO_INNER" },  notes = "SaveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_inners/save")
    public ResponseEntity<Boolean> saveByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_INNERDTO emwo_innerdto) {
        EMWO_INNER domain = emwo_innerMapping.toDomain(emwo_innerdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_innerService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFTeamEMEquip", tags = {"EMWO_INNER" },  notes = "SaveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_inners/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_INNERDTO> emwo_innerdtos) {
        List<EMWO_INNER> domainlist=emwo_innerMapping.toDomain(emwo_innerdtos);
        for(EMWO_INNER domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emwo_innerService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByPFTeamEMEquip", tags = {"EMWO_INNER" },  notes = "UpdateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_inners/{emwo_inner_id}")
    @Transactional
    public ResponseEntity<EMWO_INNERDTO> updateByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_inner_id") String emwo_inner_id, @RequestBody EMWO_INNERDTO emwo_innerdto) {
        EMWO_INNER domain = emwo_innerMapping.toDomain(emwo_innerdto);
        domain.setEquipid(emequip_id);
        domain.setEmwoInnerid(emwo_inner_id);
		emwo_innerService.update(domain);
        EMWO_INNERDTO dto = emwo_innerMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFTeamEMEquip", tags = {"EMWO_INNER" },  notes = "UpdateBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_inners/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_INNERDTO> emwo_innerdtos) {
        List<EMWO_INNER> domainlist=emwo_innerMapping.toDomain(emwo_innerdtos);
        for(EMWO_INNER domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_innerService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByPFTeamEMEquip", tags = {"EMWO_INNER" },  notes = "GetByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_inners/{emwo_inner_id}")
    public ResponseEntity<EMWO_INNERDTO> getByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_inner_id") String emwo_inner_id) {
        EMWO_INNER domain = emwo_innerService.get(emwo_inner_id);
        EMWO_INNERDTO dto = emwo_innerMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

	@ApiOperation(value = "fetchDEFAULTByPFTeamEMEquip", tags = {"EMWO_INNER" } ,notes = "fetchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_inners/fetchdefault")
	public ResponseEntity<List<EMWO_INNERDTO>> fetchEMWO_INNERDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id,EMWO_INNERSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_INNER> domains = emwo_innerService.searchDefault(context) ;
        List<EMWO_INNERDTO> list = emwo_innerMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFTeamEMEquip", tags = {"EMWO_INNER" } ,notes = "searchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_inners/searchdefault")
	public ResponseEntity<Page<EMWO_INNERDTO>> searchEMWO_INNERDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_INNERSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_INNER> domains = emwo_innerService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_innerMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMWO_INNER getEntity(){
        return new EMWO_INNER();
    }

}
