package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMRFODEMap;
import cn.ibizlab.eam.core.eam_core.service.IEMRFODEMapService;
import cn.ibizlab.eam.core.eam_core.filter.EMRFODEMapSearchContext;




@Slf4j
@Api(tags = {"EMRFODEMap" })
@RestController("WebApi-emrfodemap")
@RequestMapping("")
public class EMRFODEMapResource {

    @Autowired
    private IEMRFODEMapService emrfodemapService;

    @Autowired
    @Lazy
    private EMRFODEMapMapping emrfodemapMapping;




    @ApiOperation(value = "Save", tags = {"EMRFODEMap" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodemaps/save")
    public ResponseEntity<Boolean> save(@RequestBody EMRFODEMapDTO emrfodemapdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emrfodemapService.save(emrfodemapMapping.toDomain(emrfodemapdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMRFODEMap" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodemaps/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMRFODEMapDTO> emrfodemapdtos) {
        emrfodemapService.saveBatch(emrfodemapMapping.toDomain(emrfodemapdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emrfodemap_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMRFODEMap" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emrfodemaps/{emrfodemap_id}")
    public ResponseEntity<EMRFODEMapDTO> get(@PathVariable("emrfodemap_id") String emrfodemap_id) {
        EMRFODEMap domain = emrfodemapService.get(emrfodemap_id);
        EMRFODEMapDTO dto = emrfodemapMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @PreAuthorize("hasPermission(#emrfodemap_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMRFODEMap" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfodemaps/{emrfodemap_id}")
    @Transactional
    public ResponseEntity<EMRFODEMapDTO> update(@PathVariable("emrfodemap_id") String emrfodemap_id, @RequestBody EMRFODEMapDTO emrfodemapdto) {
		EMRFODEMap domain = emrfodemapMapping.toDomain(emrfodemapdto);
        domain.setEmrfodemapid(emrfodemap_id);
		emrfodemapService.update(domain);
		EMRFODEMapDTO dto = emrfodemapMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emrfodemap_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMRFODEMap" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfodemaps/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMRFODEMapDTO> emrfodemapdtos) {
        emrfodemapService.updateBatch(emrfodemapMapping.toDomain(emrfodemapdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMRFODEMap" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodemaps")
    @Transactional
    public ResponseEntity<EMRFODEMapDTO> create(@RequestBody EMRFODEMapDTO emrfodemapdto) {
        EMRFODEMap domain = emrfodemapMapping.toDomain(emrfodemapdto);
		emrfodemapService.create(domain);
        EMRFODEMapDTO dto = emrfodemapMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMRFODEMap" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodemaps/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMRFODEMapDTO> emrfodemapdtos) {
        emrfodemapService.createBatch(emrfodemapMapping.toDomain(emrfodemapdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emrfodemap_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMRFODEMap" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfodemaps/{emrfodemap_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emrfodemap_id") String emrfodemap_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emrfodemapService.remove(emrfodemap_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMRFODEMap" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfodemaps/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emrfodemapService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMRFODEMap" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emrfodemaps/getdraft")
    public ResponseEntity<EMRFODEMapDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emrfodemapMapping.toDto(emrfodemapService.getDraft(new EMRFODEMap())));
    }




    @ApiOperation(value = "CheckKey", tags = {"EMRFODEMap" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodemaps/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMRFODEMapDTO emrfodemapdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emrfodemapService.checkKey(emrfodemapMapping.toDomain(emrfodemapdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFODEMap-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMRFODEMap" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emrfodemaps/fetchdefault")
	public ResponseEntity<List<EMRFODEMapDTO>> fetchDefault(EMRFODEMapSearchContext context) {
        Page<EMRFODEMap> domains = emrfodemapService.searchDefault(context) ;
        List<EMRFODEMapDTO> list = emrfodemapMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFODEMap-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMRFODEMap" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emrfodemaps/searchdefault")
	public ResponseEntity<Page<EMRFODEMapDTO>> searchDefault(@RequestBody EMRFODEMapSearchContext context) {
        Page<EMRFODEMap> domains = emrfodemapService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emrfodemapMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMRFODEMap getEntity(){
        return new EMRFODEMap();
    }

}
