package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMRFOAC;
import cn.ibizlab.eam.core.eam_core.service.IEMRFOACService;
import cn.ibizlab.eam.core.eam_core.filter.EMRFOACSearchContext;




@Slf4j
@Api(tags = {"EMRFOAC" })
@RestController("WebApi-emrfoac")
@RequestMapping("")
public class EMRFOACResource {

    @Autowired
    private IEMRFOACService emrfoacService;

    @Autowired
    @Lazy
    private EMRFOACMapping emrfoacMapping;




    @ApiOperation(value = "CheckKey", tags = {"EMRFOAC" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfoacs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMRFOACDTO emrfoacdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emrfoacService.checkKey(emrfoacMapping.toDomain(emrfoacdto)));
    }




    @ApiOperation(value = "GetDraft", tags = {"EMRFOAC" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emrfoacs/getdraft")
    public ResponseEntity<EMRFOACDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emrfoacMapping.toDto(emrfoacService.getDraft(new EMRFOAC())));
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMRFOAC" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfoacs")
    @Transactional
    public ResponseEntity<EMRFOACDTO> create(@RequestBody EMRFOACDTO emrfoacdto) {
        EMRFOAC domain = emrfoacMapping.toDomain(emrfoacdto);
		emrfoacService.create(domain);
        EMRFOACDTO dto = emrfoacMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMRFOAC" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfoacs/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMRFOACDTO> emrfoacdtos) {
        emrfoacService.createBatch(emrfoacMapping.toDomain(emrfoacdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMRFOAC" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfoacs/save")
    public ResponseEntity<Boolean> save(@RequestBody EMRFOACDTO emrfoacdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emrfoacService.save(emrfoacMapping.toDomain(emrfoacdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMRFOAC" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfoacs/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMRFOACDTO> emrfoacdtos) {
        emrfoacService.saveBatch(emrfoacMapping.toDomain(emrfoacdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emrfoac_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMRFOAC" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emrfoacs/{emrfoac_id}")
    public ResponseEntity<EMRFOACDTO> get(@PathVariable("emrfoac_id") String emrfoac_id) {
        EMRFOAC domain = emrfoacService.get(emrfoac_id);
        EMRFOACDTO dto = emrfoacMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @PreAuthorize("hasPermission(#emrfoac_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMRFOAC" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfoacs/{emrfoac_id}")
    @Transactional
    public ResponseEntity<EMRFOACDTO> update(@PathVariable("emrfoac_id") String emrfoac_id, @RequestBody EMRFOACDTO emrfoacdto) {
		EMRFOAC domain = emrfoacMapping.toDomain(emrfoacdto);
        domain.setEmrfoacid(emrfoac_id);
		emrfoacService.update(domain);
		EMRFOACDTO dto = emrfoacMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emrfoac_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMRFOAC" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfoacs/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMRFOACDTO> emrfoacdtos) {
        emrfoacService.updateBatch(emrfoacMapping.toDomain(emrfoacdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emrfoac_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMRFOAC" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfoacs/{emrfoac_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emrfoac_id") String emrfoac_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emrfoacService.remove(emrfoac_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMRFOAC" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfoacs/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emrfoacService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOAC-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMRFOAC" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emrfoacs/fetchdefault")
	public ResponseEntity<List<EMRFOACDTO>> fetchDefault(EMRFOACSearchContext context) {
        Page<EMRFOAC> domains = emrfoacService.searchDefault(context) ;
        List<EMRFOACDTO> list = emrfoacMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFOAC-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMRFOAC" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emrfoacs/searchdefault")
	public ResponseEntity<Page<EMRFOACDTO>> searchDefault(@RequestBody EMRFOACSearchContext context) {
        Page<EMRFOAC> domains = emrfoacService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emrfoacMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "CheckKeyByEMRFODE", tags = {"EMRFOAC" },  notes = "CheckKeyByEMRFODE")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/{emrfode_id}/emrfoacs/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @RequestBody EMRFOACDTO emrfoacdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emrfoacService.checkKey(emrfoacMapping.toDomain(emrfoacdto)));
    }

    @ApiOperation(value = "GetDraftByEMRFODE", tags = {"EMRFOAC" },  notes = "GetDraftByEMRFODE")
    @RequestMapping(method = RequestMethod.GET, value = "/emrfodes/{emrfode_id}/emrfoacs/getdraft")
    public ResponseEntity<EMRFOACDTO> getDraftByEMRFODE(@PathVariable("emrfode_id") String emrfode_id) {
        EMRFOAC domain = new EMRFOAC();
        domain.setRfodeid(emrfode_id);
        return ResponseEntity.status(HttpStatus.OK).body(emrfoacMapping.toDto(emrfoacService.getDraft(domain)));
    }

    @ApiOperation(value = "CreateByEMRFODE", tags = {"EMRFOAC" },  notes = "CreateByEMRFODE")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/{emrfode_id}/emrfoacs")
    @Transactional
    public ResponseEntity<EMRFOACDTO> createByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @RequestBody EMRFOACDTO emrfoacdto) {
        EMRFOAC domain = emrfoacMapping.toDomain(emrfoacdto);
        domain.setRfodeid(emrfode_id);
		emrfoacService.create(domain);
        EMRFOACDTO dto = emrfoacMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMRFODE", tags = {"EMRFOAC" },  notes = "createBatchByEMRFODE")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/{emrfode_id}/emrfoacs/batch")
    public ResponseEntity<Boolean> createBatchByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @RequestBody List<EMRFOACDTO> emrfoacdtos) {
        List<EMRFOAC> domainlist=emrfoacMapping.toDomain(emrfoacdtos);
        for(EMRFOAC domain:domainlist){
            domain.setRfodeid(emrfode_id);
        }
        emrfoacService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMRFODE", tags = {"EMRFOAC" },  notes = "SaveByEMRFODE")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/{emrfode_id}/emrfoacs/save")
    public ResponseEntity<Boolean> saveByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @RequestBody EMRFOACDTO emrfoacdto) {
        EMRFOAC domain = emrfoacMapping.toDomain(emrfoacdto);
        domain.setRfodeid(emrfode_id);
        return ResponseEntity.status(HttpStatus.OK).body(emrfoacService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMRFODE", tags = {"EMRFOAC" },  notes = "SaveBatchByEMRFODE")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/{emrfode_id}/emrfoacs/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @RequestBody List<EMRFOACDTO> emrfoacdtos) {
        List<EMRFOAC> domainlist=emrfoacMapping.toDomain(emrfoacdtos);
        for(EMRFOAC domain:domainlist){
             domain.setRfodeid(emrfode_id);
        }
        emrfoacService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMRFODE", tags = {"EMRFOAC" },  notes = "GetByEMRFODE")
	@RequestMapping(method = RequestMethod.GET, value = "/emrfodes/{emrfode_id}/emrfoacs/{emrfoac_id}")
    public ResponseEntity<EMRFOACDTO> getByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfoac_id") String emrfoac_id) {
        EMRFOAC domain = emrfoacService.get(emrfoac_id);
        EMRFOACDTO dto = emrfoacMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateByEMRFODE", tags = {"EMRFOAC" },  notes = "UpdateByEMRFODE")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfodes/{emrfode_id}/emrfoacs/{emrfoac_id}")
    @Transactional
    public ResponseEntity<EMRFOACDTO> updateByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfoac_id") String emrfoac_id, @RequestBody EMRFOACDTO emrfoacdto) {
        EMRFOAC domain = emrfoacMapping.toDomain(emrfoacdto);
        domain.setRfodeid(emrfode_id);
        domain.setEmrfoacid(emrfoac_id);
		emrfoacService.update(domain);
        EMRFOACDTO dto = emrfoacMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMRFODE", tags = {"EMRFOAC" },  notes = "UpdateBatchByEMRFODE")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfodes/{emrfode_id}/emrfoacs/batch")
    public ResponseEntity<Boolean> updateBatchByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @RequestBody List<EMRFOACDTO> emrfoacdtos) {
        List<EMRFOAC> domainlist=emrfoacMapping.toDomain(emrfoacdtos);
        for(EMRFOAC domain:domainlist){
            domain.setRfodeid(emrfode_id);
        }
        emrfoacService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMRFODE", tags = {"EMRFOAC" },  notes = "RemoveByEMRFODE")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfodes/{emrfode_id}/emrfoacs/{emrfoac_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfoac_id") String emrfoac_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emrfoacService.remove(emrfoac_id));
    }

    @ApiOperation(value = "RemoveBatchByEMRFODE", tags = {"EMRFOAC" },  notes = "RemoveBatchByEMRFODE")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfodes/{emrfode_id}/emrfoacs/batch")
    public ResponseEntity<Boolean> removeBatchByEMRFODE(@RequestBody List<String> ids) {
        emrfoacService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMRFODE", tags = {"EMRFOAC" } ,notes = "fetchDEFAULTByEMRFODE")
    @RequestMapping(method= RequestMethod.GET , value="/emrfodes/{emrfode_id}/emrfoacs/fetchdefault")
	public ResponseEntity<List<EMRFOACDTO>> fetchEMRFOACDefaultByEMRFODE(@PathVariable("emrfode_id") String emrfode_id,EMRFOACSearchContext context) {
        context.setN_rfodeid_eq(emrfode_id);
        Page<EMRFOAC> domains = emrfoacService.searchDefault(context) ;
        List<EMRFOACDTO> list = emrfoacMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMRFODE", tags = {"EMRFOAC" } ,notes = "searchDEFAULTByEMRFODE")
    @RequestMapping(method= RequestMethod.POST , value="/emrfodes/{emrfode_id}/emrfoacs/searchdefault")
	public ResponseEntity<Page<EMRFOACDTO>> searchEMRFOACDefaultByEMRFODE(@PathVariable("emrfode_id") String emrfode_id, @RequestBody EMRFOACSearchContext context) {
        context.setN_rfodeid_eq(emrfode_id);
        Page<EMRFOAC> domains = emrfoacService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emrfoacMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "CheckKeyByEMRFOMO", tags = {"EMRFOAC" },  notes = "CheckKeyByEMRFOMO")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfomos/{emrfomo_id}/emrfoacs/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMRFOMO(@PathVariable("emrfomo_id") String emrfomo_id, @RequestBody EMRFOACDTO emrfoacdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emrfoacService.checkKey(emrfoacMapping.toDomain(emrfoacdto)));
    }

    @ApiOperation(value = "GetDraftByEMRFOMO", tags = {"EMRFOAC" },  notes = "GetDraftByEMRFOMO")
    @RequestMapping(method = RequestMethod.GET, value = "/emrfomos/{emrfomo_id}/emrfoacs/getdraft")
    public ResponseEntity<EMRFOACDTO> getDraftByEMRFOMO(@PathVariable("emrfomo_id") String emrfomo_id) {
        EMRFOAC domain = new EMRFOAC();
        domain.setRfomoid(emrfomo_id);
        return ResponseEntity.status(HttpStatus.OK).body(emrfoacMapping.toDto(emrfoacService.getDraft(domain)));
    }

    @ApiOperation(value = "CreateByEMRFOMO", tags = {"EMRFOAC" },  notes = "CreateByEMRFOMO")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfomos/{emrfomo_id}/emrfoacs")
    @Transactional
    public ResponseEntity<EMRFOACDTO> createByEMRFOMO(@PathVariable("emrfomo_id") String emrfomo_id, @RequestBody EMRFOACDTO emrfoacdto) {
        EMRFOAC domain = emrfoacMapping.toDomain(emrfoacdto);
        domain.setRfomoid(emrfomo_id);
		emrfoacService.create(domain);
        EMRFOACDTO dto = emrfoacMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMRFOMO", tags = {"EMRFOAC" },  notes = "createBatchByEMRFOMO")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfomos/{emrfomo_id}/emrfoacs/batch")
    public ResponseEntity<Boolean> createBatchByEMRFOMO(@PathVariable("emrfomo_id") String emrfomo_id, @RequestBody List<EMRFOACDTO> emrfoacdtos) {
        List<EMRFOAC> domainlist=emrfoacMapping.toDomain(emrfoacdtos);
        for(EMRFOAC domain:domainlist){
            domain.setRfomoid(emrfomo_id);
        }
        emrfoacService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMRFOMO", tags = {"EMRFOAC" },  notes = "SaveByEMRFOMO")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfomos/{emrfomo_id}/emrfoacs/save")
    public ResponseEntity<Boolean> saveByEMRFOMO(@PathVariable("emrfomo_id") String emrfomo_id, @RequestBody EMRFOACDTO emrfoacdto) {
        EMRFOAC domain = emrfoacMapping.toDomain(emrfoacdto);
        domain.setRfomoid(emrfomo_id);
        return ResponseEntity.status(HttpStatus.OK).body(emrfoacService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMRFOMO", tags = {"EMRFOAC" },  notes = "SaveBatchByEMRFOMO")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfomos/{emrfomo_id}/emrfoacs/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMRFOMO(@PathVariable("emrfomo_id") String emrfomo_id, @RequestBody List<EMRFOACDTO> emrfoacdtos) {
        List<EMRFOAC> domainlist=emrfoacMapping.toDomain(emrfoacdtos);
        for(EMRFOAC domain:domainlist){
             domain.setRfomoid(emrfomo_id);
        }
        emrfoacService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMRFOMO", tags = {"EMRFOAC" },  notes = "GetByEMRFOMO")
	@RequestMapping(method = RequestMethod.GET, value = "/emrfomos/{emrfomo_id}/emrfoacs/{emrfoac_id}")
    public ResponseEntity<EMRFOACDTO> getByEMRFOMO(@PathVariable("emrfomo_id") String emrfomo_id, @PathVariable("emrfoac_id") String emrfoac_id) {
        EMRFOAC domain = emrfoacService.get(emrfoac_id);
        EMRFOACDTO dto = emrfoacMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateByEMRFOMO", tags = {"EMRFOAC" },  notes = "UpdateByEMRFOMO")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfomos/{emrfomo_id}/emrfoacs/{emrfoac_id}")
    @Transactional
    public ResponseEntity<EMRFOACDTO> updateByEMRFOMO(@PathVariable("emrfomo_id") String emrfomo_id, @PathVariable("emrfoac_id") String emrfoac_id, @RequestBody EMRFOACDTO emrfoacdto) {
        EMRFOAC domain = emrfoacMapping.toDomain(emrfoacdto);
        domain.setRfomoid(emrfomo_id);
        domain.setEmrfoacid(emrfoac_id);
		emrfoacService.update(domain);
        EMRFOACDTO dto = emrfoacMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMRFOMO", tags = {"EMRFOAC" },  notes = "UpdateBatchByEMRFOMO")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfomos/{emrfomo_id}/emrfoacs/batch")
    public ResponseEntity<Boolean> updateBatchByEMRFOMO(@PathVariable("emrfomo_id") String emrfomo_id, @RequestBody List<EMRFOACDTO> emrfoacdtos) {
        List<EMRFOAC> domainlist=emrfoacMapping.toDomain(emrfoacdtos);
        for(EMRFOAC domain:domainlist){
            domain.setRfomoid(emrfomo_id);
        }
        emrfoacService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMRFOMO", tags = {"EMRFOAC" },  notes = "RemoveByEMRFOMO")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfomos/{emrfomo_id}/emrfoacs/{emrfoac_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMRFOMO(@PathVariable("emrfomo_id") String emrfomo_id, @PathVariable("emrfoac_id") String emrfoac_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emrfoacService.remove(emrfoac_id));
    }

    @ApiOperation(value = "RemoveBatchByEMRFOMO", tags = {"EMRFOAC" },  notes = "RemoveBatchByEMRFOMO")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfomos/{emrfomo_id}/emrfoacs/batch")
    public ResponseEntity<Boolean> removeBatchByEMRFOMO(@RequestBody List<String> ids) {
        emrfoacService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMRFOMO", tags = {"EMRFOAC" } ,notes = "fetchDEFAULTByEMRFOMO")
    @RequestMapping(method= RequestMethod.GET , value="/emrfomos/{emrfomo_id}/emrfoacs/fetchdefault")
	public ResponseEntity<List<EMRFOACDTO>> fetchEMRFOACDefaultByEMRFOMO(@PathVariable("emrfomo_id") String emrfomo_id,EMRFOACSearchContext context) {
        context.setN_rfomoid_eq(emrfomo_id);
        Page<EMRFOAC> domains = emrfoacService.searchDefault(context) ;
        List<EMRFOACDTO> list = emrfoacMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMRFOMO", tags = {"EMRFOAC" } ,notes = "searchDEFAULTByEMRFOMO")
    @RequestMapping(method= RequestMethod.POST , value="/emrfomos/{emrfomo_id}/emrfoacs/searchdefault")
	public ResponseEntity<Page<EMRFOACDTO>> searchEMRFOACDefaultByEMRFOMO(@PathVariable("emrfomo_id") String emrfomo_id, @RequestBody EMRFOACSearchContext context) {
        context.setN_rfomoid_eq(emrfomo_id);
        Page<EMRFOAC> domains = emrfoacService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emrfoacMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CheckKeyByEMRFODEEMRFOMO", tags = {"EMRFOAC" },  notes = "CheckKeyByEMRFODEEMRFOMO")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfoacs/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMRFODEEMRFOMO(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id, @RequestBody EMRFOACDTO emrfoacdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emrfoacService.checkKey(emrfoacMapping.toDomain(emrfoacdto)));
    }

    @ApiOperation(value = "GetDraftByEMRFODEEMRFOMO", tags = {"EMRFOAC" },  notes = "GetDraftByEMRFODEEMRFOMO")
    @RequestMapping(method = RequestMethod.GET, value = "/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfoacs/getdraft")
    public ResponseEntity<EMRFOACDTO> getDraftByEMRFODEEMRFOMO(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id) {
        EMRFOAC domain = new EMRFOAC();
        domain.setRfomoid(emrfomo_id);
        return ResponseEntity.status(HttpStatus.OK).body(emrfoacMapping.toDto(emrfoacService.getDraft(domain)));
    }

    @ApiOperation(value = "CreateByEMRFODEEMRFOMO", tags = {"EMRFOAC" },  notes = "CreateByEMRFODEEMRFOMO")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfoacs")
    @Transactional
    public ResponseEntity<EMRFOACDTO> createByEMRFODEEMRFOMO(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id, @RequestBody EMRFOACDTO emrfoacdto) {
        EMRFOAC domain = emrfoacMapping.toDomain(emrfoacdto);
        domain.setRfomoid(emrfomo_id);
		emrfoacService.create(domain);
        EMRFOACDTO dto = emrfoacMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMRFODEEMRFOMO", tags = {"EMRFOAC" },  notes = "createBatchByEMRFODEEMRFOMO")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfoacs/batch")
    public ResponseEntity<Boolean> createBatchByEMRFODEEMRFOMO(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id, @RequestBody List<EMRFOACDTO> emrfoacdtos) {
        List<EMRFOAC> domainlist=emrfoacMapping.toDomain(emrfoacdtos);
        for(EMRFOAC domain:domainlist){
            domain.setRfomoid(emrfomo_id);
        }
        emrfoacService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMRFODEEMRFOMO", tags = {"EMRFOAC" },  notes = "SaveByEMRFODEEMRFOMO")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfoacs/save")
    public ResponseEntity<Boolean> saveByEMRFODEEMRFOMO(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id, @RequestBody EMRFOACDTO emrfoacdto) {
        EMRFOAC domain = emrfoacMapping.toDomain(emrfoacdto);
        domain.setRfomoid(emrfomo_id);
        return ResponseEntity.status(HttpStatus.OK).body(emrfoacService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMRFODEEMRFOMO", tags = {"EMRFOAC" },  notes = "SaveBatchByEMRFODEEMRFOMO")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfoacs/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMRFODEEMRFOMO(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id, @RequestBody List<EMRFOACDTO> emrfoacdtos) {
        List<EMRFOAC> domainlist=emrfoacMapping.toDomain(emrfoacdtos);
        for(EMRFOAC domain:domainlist){
             domain.setRfomoid(emrfomo_id);
        }
        emrfoacService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMRFODEEMRFOMO", tags = {"EMRFOAC" },  notes = "GetByEMRFODEEMRFOMO")
	@RequestMapping(method = RequestMethod.GET, value = "/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfoacs/{emrfoac_id}")
    public ResponseEntity<EMRFOACDTO> getByEMRFODEEMRFOMO(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id, @PathVariable("emrfoac_id") String emrfoac_id) {
        EMRFOAC domain = emrfoacService.get(emrfoac_id);
        EMRFOACDTO dto = emrfoacMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateByEMRFODEEMRFOMO", tags = {"EMRFOAC" },  notes = "UpdateByEMRFODEEMRFOMO")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfoacs/{emrfoac_id}")
    @Transactional
    public ResponseEntity<EMRFOACDTO> updateByEMRFODEEMRFOMO(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id, @PathVariable("emrfoac_id") String emrfoac_id, @RequestBody EMRFOACDTO emrfoacdto) {
        EMRFOAC domain = emrfoacMapping.toDomain(emrfoacdto);
        domain.setRfomoid(emrfomo_id);
        domain.setEmrfoacid(emrfoac_id);
		emrfoacService.update(domain);
        EMRFOACDTO dto = emrfoacMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMRFODEEMRFOMO", tags = {"EMRFOAC" },  notes = "UpdateBatchByEMRFODEEMRFOMO")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfoacs/batch")
    public ResponseEntity<Boolean> updateBatchByEMRFODEEMRFOMO(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id, @RequestBody List<EMRFOACDTO> emrfoacdtos) {
        List<EMRFOAC> domainlist=emrfoacMapping.toDomain(emrfoacdtos);
        for(EMRFOAC domain:domainlist){
            domain.setRfomoid(emrfomo_id);
        }
        emrfoacService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMRFODEEMRFOMO", tags = {"EMRFOAC" },  notes = "RemoveByEMRFODEEMRFOMO")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfoacs/{emrfoac_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMRFODEEMRFOMO(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id, @PathVariable("emrfoac_id") String emrfoac_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emrfoacService.remove(emrfoac_id));
    }

    @ApiOperation(value = "RemoveBatchByEMRFODEEMRFOMO", tags = {"EMRFOAC" },  notes = "RemoveBatchByEMRFODEEMRFOMO")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfoacs/batch")
    public ResponseEntity<Boolean> removeBatchByEMRFODEEMRFOMO(@RequestBody List<String> ids) {
        emrfoacService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMRFODEEMRFOMO", tags = {"EMRFOAC" } ,notes = "fetchDEFAULTByEMRFODEEMRFOMO")
    @RequestMapping(method= RequestMethod.GET , value="/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfoacs/fetchdefault")
	public ResponseEntity<List<EMRFOACDTO>> fetchEMRFOACDefaultByEMRFODEEMRFOMO(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id,EMRFOACSearchContext context) {
        context.setN_rfomoid_eq(emrfomo_id);
        Page<EMRFOAC> domains = emrfoacService.searchDefault(context) ;
        List<EMRFOACDTO> list = emrfoacMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMRFODEEMRFOMO", tags = {"EMRFOAC" } ,notes = "searchDEFAULTByEMRFODEEMRFOMO")
    @RequestMapping(method= RequestMethod.POST , value="/emrfodes/{emrfode_id}/emrfomos/{emrfomo_id}/emrfoacs/searchdefault")
	public ResponseEntity<Page<EMRFOACDTO>> searchEMRFOACDefaultByEMRFODEEMRFOMO(@PathVariable("emrfode_id") String emrfode_id, @PathVariable("emrfomo_id") String emrfomo_id, @RequestBody EMRFOACSearchContext context) {
        context.setN_rfomoid_eq(emrfomo_id);
        Page<EMRFOAC> domains = emrfoacService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emrfoacMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMRFOAC getEntity(){
        return new EMRFOAC();
    }

}
