package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMMonthlyDetail;
import cn.ibizlab.eam.core.eam_core.service.IEMMonthlyDetailService;
import cn.ibizlab.eam.core.eam_core.filter.EMMonthlyDetailSearchContext;




@Slf4j
@Api(tags = {"EMMonthlyDetail" })
@RestController("WebApi-emmonthlydetail")
@RequestMapping("")
public class EMMonthlyDetailResource {

    @Autowired
    private IEMMonthlyDetailService emmonthlydetailService;

    @Autowired
    @Lazy
    private EMMonthlyDetailMapping emmonthlydetailMapping;




    @ApiOperation(value = "GetDraft", tags = {"EMMonthlyDetail" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emmonthlydetails/getdraft")
    public ResponseEntity<EMMonthlyDetailDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emmonthlydetailMapping.toDto(emmonthlydetailService.getDraft(new EMMonthlyDetail())));
    }




    @PreAuthorize("hasPermission(#emmonthlydetail_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMMonthlyDetail" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emmonthlydetails/{emmonthlydetail_id}")
    @Transactional
    public ResponseEntity<EMMonthlyDetailDTO> update(@PathVariable("emmonthlydetail_id") String emmonthlydetail_id, @RequestBody EMMonthlyDetailDTO emmonthlydetaildto) {
		EMMonthlyDetail domain = emmonthlydetailMapping.toDomain(emmonthlydetaildto);
        domain.setEmmonthlydetailid(emmonthlydetail_id);
		emmonthlydetailService.update(domain);
		EMMonthlyDetailDTO dto = emmonthlydetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emmonthlydetail_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMMonthlyDetail" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emmonthlydetails/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMMonthlyDetailDTO> emmonthlydetaildtos) {
        emmonthlydetailService.updateBatch(emmonthlydetailMapping.toDomain(emmonthlydetaildtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMMonthlyDetail" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emmonthlydetails/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMMonthlyDetailDTO emmonthlydetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emmonthlydetailService.checkKey(emmonthlydetailMapping.toDomain(emmonthlydetaildto)));
    }




    @PreAuthorize("hasPermission(#emmonthlydetail_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMMonthlyDetail" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emmonthlydetails/{emmonthlydetail_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emmonthlydetail_id") String emmonthlydetail_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emmonthlydetailService.remove(emmonthlydetail_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMMonthlyDetail" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emmonthlydetails/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emmonthlydetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emmonthlydetail_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMMonthlyDetail" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emmonthlydetails/{emmonthlydetail_id}")
    public ResponseEntity<EMMonthlyDetailDTO> get(@PathVariable("emmonthlydetail_id") String emmonthlydetail_id) {
        EMMonthlyDetail domain = emmonthlydetailService.get(emmonthlydetail_id);
        EMMonthlyDetailDTO dto = emmonthlydetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "Save", tags = {"EMMonthlyDetail" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emmonthlydetails/save")
    public ResponseEntity<Boolean> save(@RequestBody EMMonthlyDetailDTO emmonthlydetaildto) {
        return ResponseEntity.status(HttpStatus.OK).body(emmonthlydetailService.save(emmonthlydetailMapping.toDomain(emmonthlydetaildto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMMonthlyDetail" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emmonthlydetails/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMMonthlyDetailDTO> emmonthlydetaildtos) {
        emmonthlydetailService.saveBatch(emmonthlydetailMapping.toDomain(emmonthlydetaildtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMMonthlyDetail" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emmonthlydetails")
    @Transactional
    public ResponseEntity<EMMonthlyDetailDTO> create(@RequestBody EMMonthlyDetailDTO emmonthlydetaildto) {
        EMMonthlyDetail domain = emmonthlydetailMapping.toDomain(emmonthlydetaildto);
		emmonthlydetailService.create(domain);
        EMMonthlyDetailDTO dto = emmonthlydetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMMonthlyDetail" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emmonthlydetails/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMMonthlyDetailDTO> emmonthlydetaildtos) {
        emmonthlydetailService.createBatch(emmonthlydetailMapping.toDomain(emmonthlydetaildtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMMonthlyDetail-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMMonthlyDetail" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emmonthlydetails/fetchdefault")
	public ResponseEntity<List<EMMonthlyDetailDTO>> fetchDefault(EMMonthlyDetailSearchContext context) {
        Page<EMMonthlyDetail> domains = emmonthlydetailService.searchDefault(context) ;
        List<EMMonthlyDetailDTO> list = emmonthlydetailMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMMonthlyDetail-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMMonthlyDetail" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emmonthlydetails/searchdefault")
	public ResponseEntity<Page<EMMonthlyDetailDTO>> searchDefault(@RequestBody EMMonthlyDetailSearchContext context) {
        Page<EMMonthlyDetail> domains = emmonthlydetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emmonthlydetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMMonthlyDetail getEntity(){
        return new EMMonthlyDetail();
    }

}
