package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMItemTrade;
import cn.ibizlab.eam.core.eam_core.service.IEMItemTradeService;
import cn.ibizlab.eam.core.eam_core.filter.EMItemTradeSearchContext;




@Slf4j
@Api(tags = {"EMItemTrade" })
@RestController("WebApi-emitemtrade")
@RequestMapping("")
public class EMItemTradeResource {

    @Autowired
    private IEMItemTradeService emitemtradeService;

    @Autowired
    @Lazy
    private EMItemTradeMapping emitemtradeMapping;




    @PreAuthorize("hasPermission(#emitemtrade_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMItemTrade" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitemtrades/{emitemtrade_id}")
    @Transactional
    public ResponseEntity<EMItemTradeDTO> update(@PathVariable("emitemtrade_id") String emitemtrade_id, @RequestBody EMItemTradeDTO emitemtradedto) {
		EMItemTrade domain = emitemtradeMapping.toDomain(emitemtradedto);
        domain.setEmitemtradeid(emitemtrade_id);
		emitemtradeService.update(domain);
		EMItemTradeDTO dto = emitemtradeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emitemtrade_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMItemTrade" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitemtrades/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMItemTradeDTO> emitemtradedtos) {
        emitemtradeService.updateBatch(emitemtradeMapping.toDomain(emitemtradedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMItemTrade" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemtrades/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMItemTradeDTO emitemtradedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemtradeService.checkKey(emitemtradeMapping.toDomain(emitemtradedto)));
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMItemTrade" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemtrades")
    @Transactional
    public ResponseEntity<EMItemTradeDTO> create(@RequestBody EMItemTradeDTO emitemtradedto) {
        EMItemTrade domain = emitemtradeMapping.toDomain(emitemtradedto);
		emitemtradeService.create(domain);
        EMItemTradeDTO dto = emitemtradeMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMItemTrade" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemtrades/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMItemTradeDTO> emitemtradedtos) {
        emitemtradeService.createBatch(emitemtradeMapping.toDomain(emitemtradedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emitemtrade_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMItemTrade" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitemtrades/{emitemtrade_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emitemtrade_id") String emitemtrade_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emitemtradeService.remove(emitemtrade_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMItemTrade" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitemtrades/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emitemtradeService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMItemTrade" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemtrades/save")
    public ResponseEntity<Boolean> save(@RequestBody EMItemTradeDTO emitemtradedto) {
        return ResponseEntity.status(HttpStatus.OK).body(emitemtradeService.save(emitemtradeMapping.toDomain(emitemtradedto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMItemTrade" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemtrades/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMItemTradeDTO> emitemtradedtos) {
        emitemtradeService.saveBatch(emitemtradeMapping.toDomain(emitemtradedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMItemTrade" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emitemtrades/getdraft")
    public ResponseEntity<EMItemTradeDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emitemtradeMapping.toDto(emitemtradeService.getDraft(new EMItemTrade())));
    }




    @PreAuthorize("hasPermission(#emitemtrade_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMItemTrade" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emitemtrades/{emitemtrade_id}")
    public ResponseEntity<EMItemTradeDTO> get(@PathVariable("emitemtrade_id") String emitemtrade_id) {
        EMItemTrade domain = emitemtradeService.get(emitemtrade_id);
        EMItemTradeDTO dto = emitemtradeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemTrade-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMItemTrade" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emitemtrades/fetchdefault")
	public ResponseEntity<List<EMItemTradeDTO>> fetchDefault(EMItemTradeSearchContext context) {
        Page<EMItemTrade> domains = emitemtradeService.searchDefault(context) ;
        List<EMItemTradeDTO> list = emitemtradeMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemTrade-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMItemTrade" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emitemtrades/searchdefault")
	public ResponseEntity<Page<EMItemTradeDTO>> searchDefault(@RequestBody EMItemTradeSearchContext context) {
        Page<EMItemTrade> domains = emitemtradeService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemtradeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemTrade-IndexDER-all')")
	@ApiOperation(value = "fetchIndexDER", tags = {"EMItemTrade" } ,notes = "fetchIndexDER")
    @RequestMapping(method= RequestMethod.GET , value="/emitemtrades/fetchindexder")
	public ResponseEntity<List<EMItemTradeDTO>> fetchIndexDER(EMItemTradeSearchContext context) {
        Page<EMItemTrade> domains = emitemtradeService.searchIndexDER(context) ;
        List<EMItemTradeDTO> list = emitemtradeMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemTrade-IndexDER-all')")
	@ApiOperation(value = "searchIndexDER", tags = {"EMItemTrade" } ,notes = "searchIndexDER")
    @RequestMapping(method= RequestMethod.POST , value="/emitemtrades/searchindexder")
	public ResponseEntity<Page<EMItemTradeDTO>> searchIndexDER(@RequestBody EMItemTradeSearchContext context) {
        Page<EMItemTrade> domains = emitemtradeService.searchIndexDER(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemtradeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "UpdateByEMItem", tags = {"EMItemTrade" },  notes = "UpdateByEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emitemtrades/{emitemtrade_id}")
    @Transactional
    public ResponseEntity<EMItemTradeDTO> updateByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emitemtrade_id") String emitemtrade_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        EMItemTrade domain = emitemtradeMapping.toDomain(emitemtradedto);
        domain.setItemid(emitem_id);
        domain.setEmitemtradeid(emitemtrade_id);
		emitemtradeService.update(domain);
        EMItemTradeDTO dto = emitemtradeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMItem", tags = {"EMItemTrade" },  notes = "UpdateBatchByEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emitemtrades/batch")
    public ResponseEntity<Boolean> updateBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemTradeDTO> emitemtradedtos) {
        List<EMItemTrade> domainlist=emitemtradeMapping.toDomain(emitemtradedtos);
        for(EMItemTrade domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemtradeService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMItem", tags = {"EMItemTrade" },  notes = "CheckKeyByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemtrades/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemtradeService.checkKey(emitemtradeMapping.toDomain(emitemtradedto)));
    }

    @ApiOperation(value = "CreateByEMItem", tags = {"EMItemTrade" },  notes = "CreateByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemtrades")
    @Transactional
    public ResponseEntity<EMItemTradeDTO> createByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        EMItemTrade domain = emitemtradeMapping.toDomain(emitemtradedto);
        domain.setItemid(emitem_id);
		emitemtradeService.create(domain);
        EMItemTradeDTO dto = emitemtradeMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMItem", tags = {"EMItemTrade" },  notes = "createBatchByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemtrades/batch")
    public ResponseEntity<Boolean> createBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemTradeDTO> emitemtradedtos) {
        List<EMItemTrade> domainlist=emitemtradeMapping.toDomain(emitemtradedtos);
        for(EMItemTrade domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemtradeService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMItem", tags = {"EMItemTrade" },  notes = "RemoveByEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emitemtrades/{emitemtrade_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emitemtrade_id") String emitemtrade_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemtradeService.remove(emitemtrade_id));
    }

    @ApiOperation(value = "RemoveBatchByEMItem", tags = {"EMItemTrade" },  notes = "RemoveBatchByEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emitemtrades/batch")
    public ResponseEntity<Boolean> removeBatchByEMItem(@RequestBody List<String> ids) {
        emitemtradeService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMItem", tags = {"EMItemTrade" },  notes = "SaveByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemtrades/save")
    public ResponseEntity<Boolean> saveByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        EMItemTrade domain = emitemtradeMapping.toDomain(emitemtradedto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemtradeService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMItem", tags = {"EMItemTrade" },  notes = "SaveBatchByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemtrades/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemTradeDTO> emitemtradedtos) {
        List<EMItemTrade> domainlist=emitemtradeMapping.toDomain(emitemtradedtos);
        for(EMItemTrade domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemtradeService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMItem", tags = {"EMItemTrade" },  notes = "GetDraftByEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emitemtrades/getdraft")
    public ResponseEntity<EMItemTradeDTO> getDraftByEMItem(@PathVariable("emitem_id") String emitem_id) {
        EMItemTrade domain = new EMItemTrade();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemtradeMapping.toDto(emitemtradeService.getDraft(domain)));
    }

    @ApiOperation(value = "GetByEMItem", tags = {"EMItemTrade" },  notes = "GetByEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emitemtrades/{emitemtrade_id}")
    public ResponseEntity<EMItemTradeDTO> getByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emitemtrade_id") String emitemtrade_id) {
        EMItemTrade domain = emitemtradeService.get(emitemtrade_id);
        EMItemTradeDTO dto = emitemtradeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

	@ApiOperation(value = "fetchDEFAULTByEMItem", tags = {"EMItemTrade" } ,notes = "fetchDEFAULTByEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/emitemtrades/fetchdefault")
	public ResponseEntity<List<EMItemTradeDTO>> fetchEMItemTradeDefaultByEMItem(@PathVariable("emitem_id") String emitem_id,EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchDefault(context) ;
        List<EMItemTradeDTO> list = emitemtradeMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMItem", tags = {"EMItemTrade" } ,notes = "searchDEFAULTByEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/emitemtrades/searchdefault")
	public ResponseEntity<Page<EMItemTradeDTO>> searchEMItemTradeDefaultByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemtradeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchIndexDERByEMItem", tags = {"EMItemTrade" } ,notes = "fetchIndexDERByEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/emitemtrades/fetchindexder")
	public ResponseEntity<List<EMItemTradeDTO>> fetchEMItemTradeIndexDERByEMItem(@PathVariable("emitem_id") String emitem_id,EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchIndexDER(context) ;
        List<EMItemTradeDTO> list = emitemtradeMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchIndexDERByEMItem", tags = {"EMItemTrade" } ,notes = "searchIndexDERByEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/emitemtrades/searchindexder")
	public ResponseEntity<Page<EMItemTradeDTO>> searchEMItemTradeIndexDERByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchIndexDER(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemtradeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "UpdateByEMServiceEMItem", tags = {"EMItemTrade" },  notes = "UpdateByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemtrades/{emitemtrade_id}")
    @Transactional
    public ResponseEntity<EMItemTradeDTO> updateByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemtrade_id") String emitemtrade_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        EMItemTrade domain = emitemtradeMapping.toDomain(emitemtradedto);
        domain.setItemid(emitem_id);
        domain.setEmitemtradeid(emitemtrade_id);
		emitemtradeService.update(domain);
        EMItemTradeDTO dto = emitemtradeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMServiceEMItem", tags = {"EMItemTrade" },  notes = "UpdateBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemtrades/batch")
    public ResponseEntity<Boolean> updateBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemTradeDTO> emitemtradedtos) {
        List<EMItemTrade> domainlist=emitemtradeMapping.toDomain(emitemtradedtos);
        for(EMItemTrade domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemtradeService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMServiceEMItem", tags = {"EMItemTrade" },  notes = "CheckKeyByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemtrades/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemtradeService.checkKey(emitemtradeMapping.toDomain(emitemtradedto)));
    }

    @ApiOperation(value = "CreateByEMServiceEMItem", tags = {"EMItemTrade" },  notes = "CreateByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemtrades")
    @Transactional
    public ResponseEntity<EMItemTradeDTO> createByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        EMItemTrade domain = emitemtradeMapping.toDomain(emitemtradedto);
        domain.setItemid(emitem_id);
		emitemtradeService.create(domain);
        EMItemTradeDTO dto = emitemtradeMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMServiceEMItem", tags = {"EMItemTrade" },  notes = "createBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemtrades/batch")
    public ResponseEntity<Boolean> createBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemTradeDTO> emitemtradedtos) {
        List<EMItemTrade> domainlist=emitemtradeMapping.toDomain(emitemtradedtos);
        for(EMItemTrade domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemtradeService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMServiceEMItem", tags = {"EMItemTrade" },  notes = "RemoveByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemtrades/{emitemtrade_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemtrade_id") String emitemtrade_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemtradeService.remove(emitemtrade_id));
    }

    @ApiOperation(value = "RemoveBatchByEMServiceEMItem", tags = {"EMItemTrade" },  notes = "RemoveBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemtrades/batch")
    public ResponseEntity<Boolean> removeBatchByEMServiceEMItem(@RequestBody List<String> ids) {
        emitemtradeService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMServiceEMItem", tags = {"EMItemTrade" },  notes = "SaveByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemtrades/save")
    public ResponseEntity<Boolean> saveByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        EMItemTrade domain = emitemtradeMapping.toDomain(emitemtradedto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemtradeService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMServiceEMItem", tags = {"EMItemTrade" },  notes = "SaveBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemtrades/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemTradeDTO> emitemtradedtos) {
        List<EMItemTrade> domainlist=emitemtradeMapping.toDomain(emitemtradedtos);
        for(EMItemTrade domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemtradeService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMServiceEMItem", tags = {"EMItemTrade" },  notes = "GetDraftByEMServiceEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemtrades/getdraft")
    public ResponseEntity<EMItemTradeDTO> getDraftByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemTrade domain = new EMItemTrade();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemtradeMapping.toDto(emitemtradeService.getDraft(domain)));
    }

    @ApiOperation(value = "GetByEMServiceEMItem", tags = {"EMItemTrade" },  notes = "GetByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemtrades/{emitemtrade_id}")
    public ResponseEntity<EMItemTradeDTO> getByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemtrade_id") String emitemtrade_id) {
        EMItemTrade domain = emitemtradeService.get(emitemtrade_id);
        EMItemTradeDTO dto = emitemtradeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

	@ApiOperation(value = "fetchDEFAULTByEMServiceEMItem", tags = {"EMItemTrade" } ,notes = "fetchDEFAULTByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/emitemtrades/fetchdefault")
	public ResponseEntity<List<EMItemTradeDTO>> fetchEMItemTradeDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id,EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchDefault(context) ;
        List<EMItemTradeDTO> list = emitemtradeMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMServiceEMItem", tags = {"EMItemTrade" } ,notes = "searchDEFAULTByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/emitemtrades/searchdefault")
	public ResponseEntity<Page<EMItemTradeDTO>> searchEMItemTradeDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemtradeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchIndexDERByEMServiceEMItem", tags = {"EMItemTrade" } ,notes = "fetchIndexDERByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/emitemtrades/fetchindexder")
	public ResponseEntity<List<EMItemTradeDTO>> fetchEMItemTradeIndexDERByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id,EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchIndexDER(context) ;
        List<EMItemTradeDTO> list = emitemtradeMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchIndexDERByEMServiceEMItem", tags = {"EMItemTrade" } ,notes = "searchIndexDERByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/emitemtrades/searchindexder")
	public ResponseEntity<Page<EMItemTradeDTO>> searchEMItemTradeIndexDERByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchIndexDER(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemtradeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "UpdateByEMStorePartEMItem", tags = {"EMItemTrade" },  notes = "UpdateByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/{emitemtrade_id}")
    @Transactional
    public ResponseEntity<EMItemTradeDTO> updateByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemtrade_id") String emitemtrade_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        EMItemTrade domain = emitemtradeMapping.toDomain(emitemtradedto);
        domain.setItemid(emitem_id);
        domain.setEmitemtradeid(emitemtrade_id);
		emitemtradeService.update(domain);
        EMItemTradeDTO dto = emitemtradeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStorePartEMItem", tags = {"EMItemTrade" },  notes = "UpdateBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/batch")
    public ResponseEntity<Boolean> updateBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemTradeDTO> emitemtradedtos) {
        List<EMItemTrade> domainlist=emitemtradeMapping.toDomain(emitemtradedtos);
        for(EMItemTrade domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemtradeService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMStorePartEMItem", tags = {"EMItemTrade" },  notes = "CheckKeyByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemtradeService.checkKey(emitemtradeMapping.toDomain(emitemtradedto)));
    }

    @ApiOperation(value = "CreateByEMStorePartEMItem", tags = {"EMItemTrade" },  notes = "CreateByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades")
    @Transactional
    public ResponseEntity<EMItemTradeDTO> createByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        EMItemTrade domain = emitemtradeMapping.toDomain(emitemtradedto);
        domain.setItemid(emitem_id);
		emitemtradeService.create(domain);
        EMItemTradeDTO dto = emitemtradeMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStorePartEMItem", tags = {"EMItemTrade" },  notes = "createBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/batch")
    public ResponseEntity<Boolean> createBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemTradeDTO> emitemtradedtos) {
        List<EMItemTrade> domainlist=emitemtradeMapping.toDomain(emitemtradedtos);
        for(EMItemTrade domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemtradeService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMStorePartEMItem", tags = {"EMItemTrade" },  notes = "RemoveByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/{emitemtrade_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemtrade_id") String emitemtrade_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemtradeService.remove(emitemtrade_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStorePartEMItem", tags = {"EMItemTrade" },  notes = "RemoveBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/batch")
    public ResponseEntity<Boolean> removeBatchByEMStorePartEMItem(@RequestBody List<String> ids) {
        emitemtradeService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMStorePartEMItem", tags = {"EMItemTrade" },  notes = "SaveByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/save")
    public ResponseEntity<Boolean> saveByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        EMItemTrade domain = emitemtradeMapping.toDomain(emitemtradedto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemtradeService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStorePartEMItem", tags = {"EMItemTrade" },  notes = "SaveBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemTradeDTO> emitemtradedtos) {
        List<EMItemTrade> domainlist=emitemtradeMapping.toDomain(emitemtradedtos);
        for(EMItemTrade domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemtradeService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMStorePartEMItem", tags = {"EMItemTrade" },  notes = "GetDraftByEMStorePartEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/getdraft")
    public ResponseEntity<EMItemTradeDTO> getDraftByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemTrade domain = new EMItemTrade();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemtradeMapping.toDto(emitemtradeService.getDraft(domain)));
    }

    @ApiOperation(value = "GetByEMStorePartEMItem", tags = {"EMItemTrade" },  notes = "GetByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/{emitemtrade_id}")
    public ResponseEntity<EMItemTradeDTO> getByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemtrade_id") String emitemtrade_id) {
        EMItemTrade domain = emitemtradeService.get(emitemtrade_id);
        EMItemTradeDTO dto = emitemtradeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

	@ApiOperation(value = "fetchDEFAULTByEMStorePartEMItem", tags = {"EMItemTrade" } ,notes = "fetchDEFAULTByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/fetchdefault")
	public ResponseEntity<List<EMItemTradeDTO>> fetchEMItemTradeDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchDefault(context) ;
        List<EMItemTradeDTO> list = emitemtradeMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStorePartEMItem", tags = {"EMItemTrade" } ,notes = "searchDEFAULTByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/searchdefault")
	public ResponseEntity<Page<EMItemTradeDTO>> searchEMItemTradeDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemtradeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchIndexDERByEMStorePartEMItem", tags = {"EMItemTrade" } ,notes = "fetchIndexDERByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/fetchindexder")
	public ResponseEntity<List<EMItemTradeDTO>> fetchEMItemTradeIndexDERByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchIndexDER(context) ;
        List<EMItemTradeDTO> list = emitemtradeMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchIndexDERByEMStorePartEMItem", tags = {"EMItemTrade" } ,notes = "searchIndexDERByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/searchindexder")
	public ResponseEntity<Page<EMItemTradeDTO>> searchEMItemTradeIndexDERByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchIndexDER(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemtradeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "UpdateByEMStoreEMItem", tags = {"EMItemTrade" },  notes = "UpdateByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemtrades/{emitemtrade_id}")
    @Transactional
    public ResponseEntity<EMItemTradeDTO> updateByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemtrade_id") String emitemtrade_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        EMItemTrade domain = emitemtradeMapping.toDomain(emitemtradedto);
        domain.setItemid(emitem_id);
        domain.setEmitemtradeid(emitemtrade_id);
		emitemtradeService.update(domain);
        EMItemTradeDTO dto = emitemtradeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStoreEMItem", tags = {"EMItemTrade" },  notes = "UpdateBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemtrades/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemTradeDTO> emitemtradedtos) {
        List<EMItemTrade> domainlist=emitemtradeMapping.toDomain(emitemtradedtos);
        for(EMItemTrade domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemtradeService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMStoreEMItem", tags = {"EMItemTrade" },  notes = "CheckKeyByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemtrades/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemtradeService.checkKey(emitemtradeMapping.toDomain(emitemtradedto)));
    }

    @ApiOperation(value = "CreateByEMStoreEMItem", tags = {"EMItemTrade" },  notes = "CreateByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemtrades")
    @Transactional
    public ResponseEntity<EMItemTradeDTO> createByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        EMItemTrade domain = emitemtradeMapping.toDomain(emitemtradedto);
        domain.setItemid(emitem_id);
		emitemtradeService.create(domain);
        EMItemTradeDTO dto = emitemtradeMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStoreEMItem", tags = {"EMItemTrade" },  notes = "createBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemtrades/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemTradeDTO> emitemtradedtos) {
        List<EMItemTrade> domainlist=emitemtradeMapping.toDomain(emitemtradedtos);
        for(EMItemTrade domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemtradeService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMStoreEMItem", tags = {"EMItemTrade" },  notes = "RemoveByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemtrades/{emitemtrade_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemtrade_id") String emitemtrade_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemtradeService.remove(emitemtrade_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStoreEMItem", tags = {"EMItemTrade" },  notes = "RemoveBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemtrades/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMItem(@RequestBody List<String> ids) {
        emitemtradeService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMStoreEMItem", tags = {"EMItemTrade" },  notes = "SaveByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemtrades/save")
    public ResponseEntity<Boolean> saveByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        EMItemTrade domain = emitemtradeMapping.toDomain(emitemtradedto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemtradeService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStoreEMItem", tags = {"EMItemTrade" },  notes = "SaveBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemtrades/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemTradeDTO> emitemtradedtos) {
        List<EMItemTrade> domainlist=emitemtradeMapping.toDomain(emitemtradedtos);
        for(EMItemTrade domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemtradeService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMStoreEMItem", tags = {"EMItemTrade" },  notes = "GetDraftByEMStoreEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemtrades/getdraft")
    public ResponseEntity<EMItemTradeDTO> getDraftByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemTrade domain = new EMItemTrade();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemtradeMapping.toDto(emitemtradeService.getDraft(domain)));
    }

    @ApiOperation(value = "GetByEMStoreEMItem", tags = {"EMItemTrade" },  notes = "GetByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemtrades/{emitemtrade_id}")
    public ResponseEntity<EMItemTradeDTO> getByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemtrade_id") String emitemtrade_id) {
        EMItemTrade domain = emitemtradeService.get(emitemtrade_id);
        EMItemTradeDTO dto = emitemtradeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

	@ApiOperation(value = "fetchDEFAULTByEMStoreEMItem", tags = {"EMItemTrade" } ,notes = "fetchDEFAULTByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/emitemtrades/fetchdefault")
	public ResponseEntity<List<EMItemTradeDTO>> fetchEMItemTradeDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id,EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchDefault(context) ;
        List<EMItemTradeDTO> list = emitemtradeMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStoreEMItem", tags = {"EMItemTrade" } ,notes = "searchDEFAULTByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/emitemtrades/searchdefault")
	public ResponseEntity<Page<EMItemTradeDTO>> searchEMItemTradeDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemtradeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchIndexDERByEMStoreEMItem", tags = {"EMItemTrade" } ,notes = "fetchIndexDERByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/emitemtrades/fetchindexder")
	public ResponseEntity<List<EMItemTradeDTO>> fetchEMItemTradeIndexDERByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id,EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchIndexDER(context) ;
        List<EMItemTradeDTO> list = emitemtradeMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchIndexDERByEMStoreEMItem", tags = {"EMItemTrade" } ,notes = "searchIndexDERByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/emitemtrades/searchindexder")
	public ResponseEntity<Page<EMItemTradeDTO>> searchEMItemTradeIndexDERByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchIndexDER(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemtradeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "UpdateByPFEmpEMItem", tags = {"EMItemTrade" },  notes = "UpdateByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemtrades/{emitemtrade_id}")
    @Transactional
    public ResponseEntity<EMItemTradeDTO> updateByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemtrade_id") String emitemtrade_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        EMItemTrade domain = emitemtradeMapping.toDomain(emitemtradedto);
        domain.setItemid(emitem_id);
        domain.setEmitemtradeid(emitemtrade_id);
		emitemtradeService.update(domain);
        EMItemTradeDTO dto = emitemtradeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFEmpEMItem", tags = {"EMItemTrade" },  notes = "UpdateBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemtrades/batch")
    public ResponseEntity<Boolean> updateBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemTradeDTO> emitemtradedtos) {
        List<EMItemTrade> domainlist=emitemtradeMapping.toDomain(emitemtradedtos);
        for(EMItemTrade domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemtradeService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByPFEmpEMItem", tags = {"EMItemTrade" },  notes = "CheckKeyByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemtrades/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemtradeService.checkKey(emitemtradeMapping.toDomain(emitemtradedto)));
    }

    @ApiOperation(value = "CreateByPFEmpEMItem", tags = {"EMItemTrade" },  notes = "CreateByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemtrades")
    @Transactional
    public ResponseEntity<EMItemTradeDTO> createByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        EMItemTrade domain = emitemtradeMapping.toDomain(emitemtradedto);
        domain.setItemid(emitem_id);
		emitemtradeService.create(domain);
        EMItemTradeDTO dto = emitemtradeMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFEmpEMItem", tags = {"EMItemTrade" },  notes = "createBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemtrades/batch")
    public ResponseEntity<Boolean> createBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemTradeDTO> emitemtradedtos) {
        List<EMItemTrade> domainlist=emitemtradeMapping.toDomain(emitemtradedtos);
        for(EMItemTrade domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemtradeService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByPFEmpEMItem", tags = {"EMItemTrade" },  notes = "RemoveByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemtrades/{emitemtrade_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemtrade_id") String emitemtrade_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemtradeService.remove(emitemtrade_id));
    }

    @ApiOperation(value = "RemoveBatchByPFEmpEMItem", tags = {"EMItemTrade" },  notes = "RemoveBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemtrades/batch")
    public ResponseEntity<Boolean> removeBatchByPFEmpEMItem(@RequestBody List<String> ids) {
        emitemtradeService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByPFEmpEMItem", tags = {"EMItemTrade" },  notes = "SaveByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemtrades/save")
    public ResponseEntity<Boolean> saveByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        EMItemTrade domain = emitemtradeMapping.toDomain(emitemtradedto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemtradeService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFEmpEMItem", tags = {"EMItemTrade" },  notes = "SaveBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemtrades/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemTradeDTO> emitemtradedtos) {
        List<EMItemTrade> domainlist=emitemtradeMapping.toDomain(emitemtradedtos);
        for(EMItemTrade domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemtradeService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFEmpEMItem", tags = {"EMItemTrade" },  notes = "GetDraftByPFEmpEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemtrades/getdraft")
    public ResponseEntity<EMItemTradeDTO> getDraftByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemTrade domain = new EMItemTrade();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemtradeMapping.toDto(emitemtradeService.getDraft(domain)));
    }

    @ApiOperation(value = "GetByPFEmpEMItem", tags = {"EMItemTrade" },  notes = "GetByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemtrades/{emitemtrade_id}")
    public ResponseEntity<EMItemTradeDTO> getByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemtrade_id") String emitemtrade_id) {
        EMItemTrade domain = emitemtradeService.get(emitemtrade_id);
        EMItemTradeDTO dto = emitemtradeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

	@ApiOperation(value = "fetchDEFAULTByPFEmpEMItem", tags = {"EMItemTrade" } ,notes = "fetchDEFAULTByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemtrades/fetchdefault")
	public ResponseEntity<List<EMItemTradeDTO>> fetchEMItemTradeDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id,EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchDefault(context) ;
        List<EMItemTradeDTO> list = emitemtradeMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFEmpEMItem", tags = {"EMItemTrade" } ,notes = "searchDEFAULTByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemtrades/searchdefault")
	public ResponseEntity<Page<EMItemTradeDTO>> searchEMItemTradeDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemtradeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchIndexDERByPFEmpEMItem", tags = {"EMItemTrade" } ,notes = "fetchIndexDERByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemtrades/fetchindexder")
	public ResponseEntity<List<EMItemTradeDTO>> fetchEMItemTradeIndexDERByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id,EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchIndexDER(context) ;
        List<EMItemTradeDTO> list = emitemtradeMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchIndexDERByPFEmpEMItem", tags = {"EMItemTrade" } ,notes = "searchIndexDERByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemtrades/searchindexder")
	public ResponseEntity<Page<EMItemTradeDTO>> searchEMItemTradeIndexDERByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchIndexDER(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemtradeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "UpdateByPFUnitEMItem", tags = {"EMItemTrade" },  notes = "UpdateByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemtrades/{emitemtrade_id}")
    @Transactional
    public ResponseEntity<EMItemTradeDTO> updateByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemtrade_id") String emitemtrade_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        EMItemTrade domain = emitemtradeMapping.toDomain(emitemtradedto);
        domain.setItemid(emitem_id);
        domain.setEmitemtradeid(emitemtrade_id);
		emitemtradeService.update(domain);
        EMItemTradeDTO dto = emitemtradeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFUnitEMItem", tags = {"EMItemTrade" },  notes = "UpdateBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemtrades/batch")
    public ResponseEntity<Boolean> updateBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemTradeDTO> emitemtradedtos) {
        List<EMItemTrade> domainlist=emitemtradeMapping.toDomain(emitemtradedtos);
        for(EMItemTrade domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemtradeService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByPFUnitEMItem", tags = {"EMItemTrade" },  notes = "CheckKeyByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemtrades/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemtradeService.checkKey(emitemtradeMapping.toDomain(emitemtradedto)));
    }

    @ApiOperation(value = "CreateByPFUnitEMItem", tags = {"EMItemTrade" },  notes = "CreateByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemtrades")
    @Transactional
    public ResponseEntity<EMItemTradeDTO> createByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        EMItemTrade domain = emitemtradeMapping.toDomain(emitemtradedto);
        domain.setItemid(emitem_id);
		emitemtradeService.create(domain);
        EMItemTradeDTO dto = emitemtradeMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFUnitEMItem", tags = {"EMItemTrade" },  notes = "createBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemtrades/batch")
    public ResponseEntity<Boolean> createBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemTradeDTO> emitemtradedtos) {
        List<EMItemTrade> domainlist=emitemtradeMapping.toDomain(emitemtradedtos);
        for(EMItemTrade domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemtradeService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByPFUnitEMItem", tags = {"EMItemTrade" },  notes = "RemoveByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemtrades/{emitemtrade_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemtrade_id") String emitemtrade_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemtradeService.remove(emitemtrade_id));
    }

    @ApiOperation(value = "RemoveBatchByPFUnitEMItem", tags = {"EMItemTrade" },  notes = "RemoveBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemtrades/batch")
    public ResponseEntity<Boolean> removeBatchByPFUnitEMItem(@RequestBody List<String> ids) {
        emitemtradeService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByPFUnitEMItem", tags = {"EMItemTrade" },  notes = "SaveByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemtrades/save")
    public ResponseEntity<Boolean> saveByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        EMItemTrade domain = emitemtradeMapping.toDomain(emitemtradedto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemtradeService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFUnitEMItem", tags = {"EMItemTrade" },  notes = "SaveBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemtrades/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemTradeDTO> emitemtradedtos) {
        List<EMItemTrade> domainlist=emitemtradeMapping.toDomain(emitemtradedtos);
        for(EMItemTrade domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemtradeService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFUnitEMItem", tags = {"EMItemTrade" },  notes = "GetDraftByPFUnitEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemtrades/getdraft")
    public ResponseEntity<EMItemTradeDTO> getDraftByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemTrade domain = new EMItemTrade();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemtradeMapping.toDto(emitemtradeService.getDraft(domain)));
    }

    @ApiOperation(value = "GetByPFUnitEMItem", tags = {"EMItemTrade" },  notes = "GetByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemtrades/{emitemtrade_id}")
    public ResponseEntity<EMItemTradeDTO> getByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemtrade_id") String emitemtrade_id) {
        EMItemTrade domain = emitemtradeService.get(emitemtrade_id);
        EMItemTradeDTO dto = emitemtradeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

	@ApiOperation(value = "fetchDEFAULTByPFUnitEMItem", tags = {"EMItemTrade" } ,notes = "fetchDEFAULTByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemtrades/fetchdefault")
	public ResponseEntity<List<EMItemTradeDTO>> fetchEMItemTradeDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id,EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchDefault(context) ;
        List<EMItemTradeDTO> list = emitemtradeMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFUnitEMItem", tags = {"EMItemTrade" } ,notes = "searchDEFAULTByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemtrades/searchdefault")
	public ResponseEntity<Page<EMItemTradeDTO>> searchEMItemTradeDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemtradeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchIndexDERByPFUnitEMItem", tags = {"EMItemTrade" } ,notes = "fetchIndexDERByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemtrades/fetchindexder")
	public ResponseEntity<List<EMItemTradeDTO>> fetchEMItemTradeIndexDERByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id,EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchIndexDER(context) ;
        List<EMItemTradeDTO> list = emitemtradeMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchIndexDERByPFUnitEMItem", tags = {"EMItemTrade" } ,notes = "searchIndexDERByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemtrades/searchindexder")
	public ResponseEntity<Page<EMItemTradeDTO>> searchEMItemTradeIndexDERByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchIndexDER(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemtradeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}





    @ApiOperation(value = "UpdateByEMStoreEMStorePartEMItem", tags = {"EMItemTrade" },  notes = "UpdateByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/{emitemtrade_id}")
    @Transactional
    public ResponseEntity<EMItemTradeDTO> updateByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemtrade_id") String emitemtrade_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        EMItemTrade domain = emitemtradeMapping.toDomain(emitemtradedto);
        domain.setItemid(emitem_id);
        domain.setEmitemtradeid(emitemtrade_id);
		emitemtradeService.update(domain);
        EMItemTradeDTO dto = emitemtradeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStoreEMStorePartEMItem", tags = {"EMItemTrade" },  notes = "UpdateBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemTradeDTO> emitemtradedtos) {
        List<EMItemTrade> domainlist=emitemtradeMapping.toDomain(emitemtradedtos);
        for(EMItemTrade domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemtradeService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMStoreEMStorePartEMItem", tags = {"EMItemTrade" },  notes = "CheckKeyByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemtradeService.checkKey(emitemtradeMapping.toDomain(emitemtradedto)));
    }

    @ApiOperation(value = "CreateByEMStoreEMStorePartEMItem", tags = {"EMItemTrade" },  notes = "CreateByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades")
    @Transactional
    public ResponseEntity<EMItemTradeDTO> createByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        EMItemTrade domain = emitemtradeMapping.toDomain(emitemtradedto);
        domain.setItemid(emitem_id);
		emitemtradeService.create(domain);
        EMItemTradeDTO dto = emitemtradeMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStoreEMStorePartEMItem", tags = {"EMItemTrade" },  notes = "createBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemTradeDTO> emitemtradedtos) {
        List<EMItemTrade> domainlist=emitemtradeMapping.toDomain(emitemtradedtos);
        for(EMItemTrade domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemtradeService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMStoreEMStorePartEMItem", tags = {"EMItemTrade" },  notes = "RemoveByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/{emitemtrade_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemtrade_id") String emitemtrade_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemtradeService.remove(emitemtrade_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStoreEMStorePartEMItem", tags = {"EMItemTrade" },  notes = "RemoveBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMStorePartEMItem(@RequestBody List<String> ids) {
        emitemtradeService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMStoreEMStorePartEMItem", tags = {"EMItemTrade" },  notes = "SaveByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/save")
    public ResponseEntity<Boolean> saveByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeDTO emitemtradedto) {
        EMItemTrade domain = emitemtradeMapping.toDomain(emitemtradedto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemtradeService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStoreEMStorePartEMItem", tags = {"EMItemTrade" },  notes = "SaveBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemTradeDTO> emitemtradedtos) {
        List<EMItemTrade> domainlist=emitemtradeMapping.toDomain(emitemtradedtos);
        for(EMItemTrade domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemtradeService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMStoreEMStorePartEMItem", tags = {"EMItemTrade" },  notes = "GetDraftByEMStoreEMStorePartEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/getdraft")
    public ResponseEntity<EMItemTradeDTO> getDraftByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemTrade domain = new EMItemTrade();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemtradeMapping.toDto(emitemtradeService.getDraft(domain)));
    }

    @ApiOperation(value = "GetByEMStoreEMStorePartEMItem", tags = {"EMItemTrade" },  notes = "GetByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/{emitemtrade_id}")
    public ResponseEntity<EMItemTradeDTO> getByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemtrade_id") String emitemtrade_id) {
        EMItemTrade domain = emitemtradeService.get(emitemtrade_id);
        EMItemTradeDTO dto = emitemtradeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

	@ApiOperation(value = "fetchDEFAULTByEMStoreEMStorePartEMItem", tags = {"EMItemTrade" } ,notes = "fetchDEFAULTByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/fetchdefault")
	public ResponseEntity<List<EMItemTradeDTO>> fetchEMItemTradeDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchDefault(context) ;
        List<EMItemTradeDTO> list = emitemtradeMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStoreEMStorePartEMItem", tags = {"EMItemTrade" } ,notes = "searchDEFAULTByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/searchdefault")
	public ResponseEntity<Page<EMItemTradeDTO>> searchEMItemTradeDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemtradeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchIndexDERByEMStoreEMStorePartEMItem", tags = {"EMItemTrade" } ,notes = "fetchIndexDERByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/fetchindexder")
	public ResponseEntity<List<EMItemTradeDTO>> fetchEMItemTradeIndexDERByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchIndexDER(context) ;
        List<EMItemTradeDTO> list = emitemtradeMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchIndexDERByEMStoreEMStorePartEMItem", tags = {"EMItemTrade" } ,notes = "searchIndexDERByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemtrades/searchindexder")
	public ResponseEntity<Page<EMItemTradeDTO>> searchEMItemTradeIndexDERByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemTradeSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemTrade> domains = emitemtradeService.searchIndexDER(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemtradeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMItemTrade getEntity(){
        return new EMItemTrade();
    }

}
