package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMFileMenu;
import cn.ibizlab.eam.core.eam_core.service.IEMFileMenuService;
import cn.ibizlab.eam.core.eam_core.filter.EMFileMenuSearchContext;




@Slf4j
@Api(tags = {"EMFileMenu" })
@RestController("WebApi-emfilemenu")
@RequestMapping("")
public class EMFileMenuResource {

    @Autowired
    private IEMFileMenuService emfilemenuService;

    @Autowired
    @Lazy
    private EMFileMenuMapping emfilemenuMapping;




    @ApiOperation(value = "CheckKey", tags = {"EMFileMenu" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emfilemenus/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMFileMenuDTO emfilemenudto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emfilemenuService.checkKey(emfilemenuMapping.toDomain(emfilemenudto)));
    }




    @PreAuthorize("hasPermission(#emfilemenu_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMFileMenu" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emfilemenus/{emfilemenu_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emfilemenu_id") String emfilemenu_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emfilemenuService.remove(emfilemenu_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMFileMenu" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emfilemenus/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emfilemenuService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMFileMenu" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emfilemenus/save")
    public ResponseEntity<Boolean> save(@RequestBody EMFileMenuDTO emfilemenudto) {
        return ResponseEntity.status(HttpStatus.OK).body(emfilemenuService.save(emfilemenuMapping.toDomain(emfilemenudto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMFileMenu" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emfilemenus/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMFileMenuDTO> emfilemenudtos) {
        emfilemenuService.saveBatch(emfilemenuMapping.toDomain(emfilemenudtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emfilemenu_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMFileMenu" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emfilemenus/{emfilemenu_id}")
    @Transactional
    public ResponseEntity<EMFileMenuDTO> update(@PathVariable("emfilemenu_id") String emfilemenu_id, @RequestBody EMFileMenuDTO emfilemenudto) {
		EMFileMenu domain = emfilemenuMapping.toDomain(emfilemenudto);
        domain.setEmfilemenuid(emfilemenu_id);
		emfilemenuService.update(domain);
		EMFileMenuDTO dto = emfilemenuMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emfilemenu_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMFileMenu" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emfilemenus/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMFileMenuDTO> emfilemenudtos) {
        emfilemenuService.updateBatch(emfilemenuMapping.toDomain(emfilemenudtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emfilemenu_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMFileMenu" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emfilemenus/{emfilemenu_id}")
    public ResponseEntity<EMFileMenuDTO> get(@PathVariable("emfilemenu_id") String emfilemenu_id) {
        EMFileMenu domain = emfilemenuService.get(emfilemenu_id);
        EMFileMenuDTO dto = emfilemenuMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMFileMenu" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emfilemenus/getdraft")
    public ResponseEntity<EMFileMenuDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emfilemenuMapping.toDto(emfilemenuService.getDraft(new EMFileMenu())));
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMFileMenu" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emfilemenus")
    @Transactional
    public ResponseEntity<EMFileMenuDTO> create(@RequestBody EMFileMenuDTO emfilemenudto) {
        EMFileMenu domain = emfilemenuMapping.toDomain(emfilemenudto);
		emfilemenuService.create(domain);
        EMFileMenuDTO dto = emfilemenuMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMFileMenu" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emfilemenus/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMFileMenuDTO> emfilemenudtos) {
        emfilemenuService.createBatch(emfilemenuMapping.toDomain(emfilemenudtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMFileMenu-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMFileMenu" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emfilemenus/fetchdefault")
	public ResponseEntity<List<EMFileMenuDTO>> fetchDefault(EMFileMenuSearchContext context) {
        Page<EMFileMenu> domains = emfilemenuService.searchDefault(context) ;
        List<EMFileMenuDTO> list = emfilemenuMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMFileMenu-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMFileMenu" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emfilemenus/searchdefault")
	public ResponseEntity<Page<EMFileMenuDTO>> searchDefault(@RequestBody EMFileMenuSearchContext context) {
        Page<EMFileMenu> domains = emfilemenuService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emfilemenuMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMFileMenu getEntity(){
        return new EMFileMenu();
    }

}
