package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEquip;
import cn.ibizlab.eam.core.eam_core.service.IEMEquipService;
import cn.ibizlab.eam.core.eam_core.filter.EMEquipSearchContext;




@Slf4j
@Api(tags = {"EMEquip" })
@RestController("WebApi-emequip")
@RequestMapping("")
public class EMEquipResource {

    @Autowired
    private IEMEquipService emequipService;

    @Autowired
    @Lazy
    private EMEquipMapping emequipMapping;




    @PreAuthorize("hasPermission(#emequip_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMEquip" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}")
    @Transactional
    public ResponseEntity<EMEquipDTO> update(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEquipDTO emequipdto) {
		EMEquip domain = emequipMapping.toDomain(emequipdto);
        domain.setEmequipid(emequip_id);
		emequipService.update(domain);
		EMEquipDTO dto = emequipMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emequip_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEquip" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEquipDTO> emequipdtos) {
        emequipService.updateBatch(emequipMapping.toDomain(emequipdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMEquip" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips")
    @Transactional
    public ResponseEntity<EMEquipDTO> create(@RequestBody EMEquipDTO emequipdto) {
        EMEquip domain = emequipMapping.toDomain(emequipdto);
		emequipService.create(domain);
        EMEquipDTO dto = emequipMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMEquip" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEquipDTO> emequipdtos) {
        emequipService.createBatch(emequipMapping.toDomain(emequipdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMEquip" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEquipDTO emequipdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emequipService.checkKey(emequipMapping.toDomain(emequipdto)));
    }




    @PreAuthorize("hasPermission(#emequip_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMEquip" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}")
    public ResponseEntity<EMEquipDTO> get(@PathVariable("emequip_id") String emequip_id) {
        EMEquip domain = emequipService.get(emequip_id);
        EMEquipDTO dto = emequipMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "Save", tags = {"EMEquip" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEquipDTO emequipdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emequipService.save(emequipMapping.toDomain(emequipdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMEquip" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEquipDTO> emequipdtos) {
        emequipService.saveBatch(emequipMapping.toDomain(emequipdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emequip_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMEquip" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emequip_id") String emequip_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emequipService.remove(emequip_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMEquip" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emequipService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMEquip" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emequips/getdraft")
    public ResponseEntity<EMEquipDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emequipMapping.toDto(emequipService.getDraft(new EMEquip())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEquip-TypeEQNum-all')")
	@ApiOperation(value = "fetch各类型设备数量", tags = {"EMEquip" } ,notes = "fetch各类型设备数量")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/fetchtypeeqnum")
	public ResponseEntity<List<HashMap>> fetchTypeEQNum(EMEquipSearchContext context) {
        Page<HashMap> domains = emequipService.searchTypeEQNum(context) ;
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEquip-TypeEQNum-all')")
	@ApiOperation(value = "search各类型设备数量", tags = {"EMEquip" } ,notes = "search各类型设备数量")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/searchtypeeqnum")
	public ResponseEntity<Page<HashMap>> searchTypeEQNum(@RequestBody EMEquipSearchContext context) {
        Page<HashMap> domains = emequipService.searchTypeEQNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEquip-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEquip" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/fetchdefault")
	public ResponseEntity<List<EMEquipDTO>> fetchDefault(EMEquipSearchContext context) {
        Page<EMEquip> domains = emequipService.searchDefault(context) ;
        List<EMEquipDTO> list = emequipMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEquip-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEquip" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/searchdefault")
	public ResponseEntity<Page<EMEquipDTO>> searchDefault(@RequestBody EMEquipSearchContext context) {
        Page<EMEquip> domains = emequipService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emequipMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEquip-EQTypeTree-all')")
	@ApiOperation(value = "fetch类型下设备", tags = {"EMEquip" } ,notes = "fetch类型下设备")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/fetcheqtypetree")
	public ResponseEntity<List<EMEquipDTO>> fetchEQTypeTree(EMEquipSearchContext context) {
        Page<EMEquip> domains = emequipService.searchEQTypeTree(context) ;
        List<EMEquipDTO> list = emequipMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEquip-EQTypeTree-all')")
	@ApiOperation(value = "search类型下设备", tags = {"EMEquip" } ,notes = "search类型下设备")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/searcheqtypetree")
	public ResponseEntity<Page<EMEquipDTO>> searchEQTypeTree(@RequestBody EMEquipSearchContext context) {
        Page<EMEquip> domains = emequipService.searchEQTypeTree(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emequipMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "UpdateByEMEQType", tags = {"EMEquip" },  notes = "UpdateByEMEQType")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}")
    @Transactional
    public ResponseEntity<EMEquipDTO> updateByEMEQType(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEquipDTO emequipdto) {
        EMEquip domain = emequipMapping.toDomain(emequipdto);
        domain.setEqtypeid(emeqtype_id);
        domain.setEmequipid(emequip_id);
		emequipService.update(domain);
        EMEquipDTO dto = emequipMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMEQType", tags = {"EMEquip" },  notes = "UpdateBatchByEMEQType")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/batch")
    public ResponseEntity<Boolean> updateBatchByEMEQType(@PathVariable("emeqtype_id") String emeqtype_id, @RequestBody List<EMEquipDTO> emequipdtos) {
        List<EMEquip> domainlist=emequipMapping.toDomain(emequipdtos);
        for(EMEquip domain:domainlist){
            domain.setEqtypeid(emeqtype_id);
        }
        emequipService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMEQType", tags = {"EMEquip" },  notes = "CreateByEMEQType")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips")
    @Transactional
    public ResponseEntity<EMEquipDTO> createByEMEQType(@PathVariable("emeqtype_id") String emeqtype_id, @RequestBody EMEquipDTO emequipdto) {
        EMEquip domain = emequipMapping.toDomain(emequipdto);
        domain.setEqtypeid(emeqtype_id);
		emequipService.create(domain);
        EMEquipDTO dto = emequipMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMEQType", tags = {"EMEquip" },  notes = "createBatchByEMEQType")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/batch")
    public ResponseEntity<Boolean> createBatchByEMEQType(@PathVariable("emeqtype_id") String emeqtype_id, @RequestBody List<EMEquipDTO> emequipdtos) {
        List<EMEquip> domainlist=emequipMapping.toDomain(emequipdtos);
        for(EMEquip domain:domainlist){
            domain.setEqtypeid(emeqtype_id);
        }
        emequipService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMEQType", tags = {"EMEquip" },  notes = "CheckKeyByEMEQType")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEQType(@PathVariable("emeqtype_id") String emeqtype_id, @RequestBody EMEquipDTO emequipdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emequipService.checkKey(emequipMapping.toDomain(emequipdto)));
    }

    @ApiOperation(value = "GetByEMEQType", tags = {"EMEquip" },  notes = "GetByEMEQType")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}")
    public ResponseEntity<EMEquipDTO> getByEMEQType(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id) {
        EMEquip domain = emequipService.get(emequip_id);
        EMEquipDTO dto = emequipMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByEMEQType", tags = {"EMEquip" },  notes = "SaveByEMEQType")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/save")
    public ResponseEntity<Boolean> saveByEMEQType(@PathVariable("emeqtype_id") String emeqtype_id, @RequestBody EMEquipDTO emequipdto) {
        EMEquip domain = emequipMapping.toDomain(emequipdto);
        domain.setEqtypeid(emeqtype_id);
        return ResponseEntity.status(HttpStatus.OK).body(emequipService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMEQType", tags = {"EMEquip" },  notes = "SaveBatchByEMEQType")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEQType(@PathVariable("emeqtype_id") String emeqtype_id, @RequestBody List<EMEquipDTO> emequipdtos) {
        List<EMEquip> domainlist=emequipMapping.toDomain(emequipdtos);
        for(EMEquip domain:domainlist){
             domain.setEqtypeid(emeqtype_id);
        }
        emequipService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMEQType", tags = {"EMEquip" },  notes = "RemoveByEMEQType")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEQType(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emequipService.remove(emequip_id));
    }

    @ApiOperation(value = "RemoveBatchByEMEQType", tags = {"EMEquip" },  notes = "RemoveBatchByEMEQType")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/batch")
    public ResponseEntity<Boolean> removeBatchByEMEQType(@RequestBody List<String> ids) {
        emequipService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMEQType", tags = {"EMEquip" },  notes = "GetDraftByEMEQType")
    @RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/getdraft")
    public ResponseEntity<EMEquipDTO> getDraftByEMEQType(@PathVariable("emeqtype_id") String emeqtype_id) {
        EMEquip domain = new EMEquip();
        domain.setEqtypeid(emeqtype_id);
        return ResponseEntity.status(HttpStatus.OK).body(emequipMapping.toDto(emequipService.getDraft(domain)));
    }

	@ApiOperation(value = "fetch各类型设备数量ByEMEQType", tags = {"EMEquip" } ,notes = "fetch各类型设备数量ByEMEQType")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/fetchtypeeqnum")
	public ResponseEntity<List<HashMap>> fetchEMEquipTypeEQNumByEMEQType(@PathVariable("emeqtype_id") String emeqtype_id,EMEquipSearchContext context) {
        context.setN_eqtypeid_eq(emeqtype_id);
        Page<HashMap> domains = emequipService.searchTypeEQNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

	@ApiOperation(value = "search各类型设备数量ByEMEQType", tags = {"EMEquip" } ,notes = "search各类型设备数量ByEMEQType")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/searchtypeeqnum")
	public ResponseEntity<Page<HashMap>> searchEMEquipTypeEQNumByEMEQType(@PathVariable("emeqtype_id") String emeqtype_id, @RequestBody EMEquipSearchContext context) {
        context.setN_eqtypeid_eq(emeqtype_id);
        Page<HashMap> domains = emequipService.searchTypeEQNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchDEFAULTByEMEQType", tags = {"EMEquip" } ,notes = "fetchDEFAULTByEMEQType")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/fetchdefault")
	public ResponseEntity<List<EMEquipDTO>> fetchEMEquipDefaultByEMEQType(@PathVariable("emeqtype_id") String emeqtype_id,EMEquipSearchContext context) {
        context.setN_eqtypeid_eq(emeqtype_id);
        Page<EMEquip> domains = emequipService.searchDefault(context) ;
        List<EMEquipDTO> list = emequipMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMEQType", tags = {"EMEquip" } ,notes = "searchDEFAULTByEMEQType")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/searchdefault")
	public ResponseEntity<Page<EMEquipDTO>> searchEMEquipDefaultByEMEQType(@PathVariable("emeqtype_id") String emeqtype_id, @RequestBody EMEquipSearchContext context) {
        context.setN_eqtypeid_eq(emeqtype_id);
        Page<EMEquip> domains = emequipService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emequipMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch类型下设备ByEMEQType", tags = {"EMEquip" } ,notes = "fetch类型下设备ByEMEQType")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/fetcheqtypetree")
	public ResponseEntity<List<EMEquipDTO>> fetchEMEquipEQTypeTreeByEMEQType(@PathVariable("emeqtype_id") String emeqtype_id,EMEquipSearchContext context) {
        context.setN_eqtypeid_eq(emeqtype_id);
        Page<EMEquip> domains = emequipService.searchEQTypeTree(context) ;
        List<EMEquipDTO> list = emequipMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search类型下设备ByEMEQType", tags = {"EMEquip" } ,notes = "search类型下设备ByEMEQType")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/searcheqtypetree")
	public ResponseEntity<Page<EMEquipDTO>> searchEMEquipEQTypeTreeByEMEQType(@PathVariable("emeqtype_id") String emeqtype_id, @RequestBody EMEquipSearchContext context) {
        context.setN_eqtypeid_eq(emeqtype_id);
        Page<EMEquip> domains = emequipService.searchEQTypeTree(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emequipMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "UpdateByPFTeam", tags = {"EMEquip" },  notes = "UpdateByPFTeam")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}")
    @Transactional
    public ResponseEntity<EMEquipDTO> updateByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEquipDTO emequipdto) {
        EMEquip domain = emequipMapping.toDomain(emequipdto);
        domain.setRteamid(pfteam_id);
        domain.setEmequipid(emequip_id);
		emequipService.update(domain);
        EMEquipDTO dto = emequipMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFTeam", tags = {"EMEquip" },  notes = "UpdateBatchByPFTeam")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody List<EMEquipDTO> emequipdtos) {
        List<EMEquip> domainlist=emequipMapping.toDomain(emequipdtos);
        for(EMEquip domain:domainlist){
            domain.setRteamid(pfteam_id);
        }
        emequipService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByPFTeam", tags = {"EMEquip" },  notes = "CreateByPFTeam")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips")
    @Transactional
    public ResponseEntity<EMEquipDTO> createByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody EMEquipDTO emequipdto) {
        EMEquip domain = emequipMapping.toDomain(emequipdto);
        domain.setRteamid(pfteam_id);
		emequipService.create(domain);
        EMEquipDTO dto = emequipMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFTeam", tags = {"EMEquip" },  notes = "createBatchByPFTeam")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/batch")
    public ResponseEntity<Boolean> createBatchByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody List<EMEquipDTO> emequipdtos) {
        List<EMEquip> domainlist=emequipMapping.toDomain(emequipdtos);
        for(EMEquip domain:domainlist){
            domain.setRteamid(pfteam_id);
        }
        emequipService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByPFTeam", tags = {"EMEquip" },  notes = "CheckKeyByPFTeam")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody EMEquipDTO emequipdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emequipService.checkKey(emequipMapping.toDomain(emequipdto)));
    }

    @ApiOperation(value = "GetByPFTeam", tags = {"EMEquip" },  notes = "GetByPFTeam")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}")
    public ResponseEntity<EMEquipDTO> getByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id) {
        EMEquip domain = emequipService.get(emequip_id);
        EMEquipDTO dto = emequipMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByPFTeam", tags = {"EMEquip" },  notes = "SaveByPFTeam")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/save")
    public ResponseEntity<Boolean> saveByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody EMEquipDTO emequipdto) {
        EMEquip domain = emequipMapping.toDomain(emequipdto);
        domain.setRteamid(pfteam_id);
        return ResponseEntity.status(HttpStatus.OK).body(emequipService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFTeam", tags = {"EMEquip" },  notes = "SaveBatchByPFTeam")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody List<EMEquipDTO> emequipdtos) {
        List<EMEquip> domainlist=emequipMapping.toDomain(emequipdtos);
        for(EMEquip domain:domainlist){
             domain.setRteamid(pfteam_id);
        }
        emequipService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByPFTeam", tags = {"EMEquip" },  notes = "RemoveByPFTeam")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emequipService.remove(emequip_id));
    }

    @ApiOperation(value = "RemoveBatchByPFTeam", tags = {"EMEquip" },  notes = "RemoveBatchByPFTeam")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeam(@RequestBody List<String> ids) {
        emequipService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFTeam", tags = {"EMEquip" },  notes = "GetDraftByPFTeam")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/getdraft")
    public ResponseEntity<EMEquipDTO> getDraftByPFTeam(@PathVariable("pfteam_id") String pfteam_id) {
        EMEquip domain = new EMEquip();
        domain.setRteamid(pfteam_id);
        return ResponseEntity.status(HttpStatus.OK).body(emequipMapping.toDto(emequipService.getDraft(domain)));
    }

	@ApiOperation(value = "fetch各类型设备数量ByPFTeam", tags = {"EMEquip" } ,notes = "fetch各类型设备数量ByPFTeam")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/fetchtypeeqnum")
	public ResponseEntity<List<HashMap>> fetchEMEquipTypeEQNumByPFTeam(@PathVariable("pfteam_id") String pfteam_id,EMEquipSearchContext context) {
        context.setN_rteamid_eq(pfteam_id);
        Page<HashMap> domains = emequipService.searchTypeEQNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

	@ApiOperation(value = "search各类型设备数量ByPFTeam", tags = {"EMEquip" } ,notes = "search各类型设备数量ByPFTeam")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/searchtypeeqnum")
	public ResponseEntity<Page<HashMap>> searchEMEquipTypeEQNumByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody EMEquipSearchContext context) {
        context.setN_rteamid_eq(pfteam_id);
        Page<HashMap> domains = emequipService.searchTypeEQNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchDEFAULTByPFTeam", tags = {"EMEquip" } ,notes = "fetchDEFAULTByPFTeam")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/fetchdefault")
	public ResponseEntity<List<EMEquipDTO>> fetchEMEquipDefaultByPFTeam(@PathVariable("pfteam_id") String pfteam_id,EMEquipSearchContext context) {
        context.setN_rteamid_eq(pfteam_id);
        Page<EMEquip> domains = emequipService.searchDefault(context) ;
        List<EMEquipDTO> list = emequipMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFTeam", tags = {"EMEquip" } ,notes = "searchDEFAULTByPFTeam")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/searchdefault")
	public ResponseEntity<Page<EMEquipDTO>> searchEMEquipDefaultByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody EMEquipSearchContext context) {
        context.setN_rteamid_eq(pfteam_id);
        Page<EMEquip> domains = emequipService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emequipMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch类型下设备ByPFTeam", tags = {"EMEquip" } ,notes = "fetch类型下设备ByPFTeam")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/fetcheqtypetree")
	public ResponseEntity<List<EMEquipDTO>> fetchEMEquipEQTypeTreeByPFTeam(@PathVariable("pfteam_id") String pfteam_id,EMEquipSearchContext context) {
        context.setN_rteamid_eq(pfteam_id);
        Page<EMEquip> domains = emequipService.searchEQTypeTree(context) ;
        List<EMEquipDTO> list = emequipMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search类型下设备ByPFTeam", tags = {"EMEquip" } ,notes = "search类型下设备ByPFTeam")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/searcheqtypetree")
	public ResponseEntity<Page<EMEquipDTO>> searchEMEquipEQTypeTreeByPFTeam(@PathVariable("pfteam_id") String pfteam_id, @RequestBody EMEquipSearchContext context) {
        context.setN_rteamid_eq(pfteam_id);
        Page<EMEquip> domains = emequipService.searchEQTypeTree(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emequipMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMEquip getEntity(){
        return new EMEquip();
    }

}
