package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEQSpareDetail;
import cn.ibizlab.eam.core.eam_core.service.IEMEQSpareDetailService;
import cn.ibizlab.eam.core.eam_core.filter.EMEQSpareDetailSearchContext;




@Slf4j
@Api(tags = {"EMEQSpareDetail" })
@RestController("WebApi-emeqsparedetail")
@RequestMapping("")
public class EMEQSpareDetailResource {

    @Autowired
    private IEMEQSpareDetailService emeqsparedetailService;

    @Autowired
    @Lazy
    private EMEQSpareDetailMapping emeqsparedetailMapping;




    @PreAuthorize("hasPermission(#emeqsparedetail_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMEQSpareDetail" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqsparedetails/{emeqsparedetail_id}")
    public ResponseEntity<EMEQSpareDetailDTO> get(@PathVariable("emeqsparedetail_id") String emeqsparedetail_id) {
        EMEQSpareDetail domain = emeqsparedetailService.get(emeqsparedetail_id);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMEQSpareDetail" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqsparedetails")
    @Transactional
    public ResponseEntity<EMEQSpareDetailDTO> create(@RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
		emeqsparedetailService.create(domain);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMEQSpareDetail" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqsparedetails/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        emeqsparedetailService.createBatch(emeqsparedetailMapping.toDomain(emeqsparedetaildtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeqsparedetail_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMEQSpareDetail" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqsparedetails/{emeqsparedetail_id}")
    @Transactional
    public ResponseEntity<EMEQSpareDetailDTO> update(@PathVariable("emeqsparedetail_id") String emeqsparedetail_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
		EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
        domain.setEmeqsparedetailid(emeqsparedetail_id);
		emeqsparedetailService.update(domain);
		EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emeqsparedetail_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEQSpareDetail" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqsparedetails/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        emeqsparedetailService.updateBatch(emeqsparedetailMapping.toDomain(emeqsparedetaildtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeqsparedetail_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMEQSpareDetail" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqsparedetails/{emeqsparedetail_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeqsparedetail_id") String emeqsparedetail_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.remove(emeqsparedetail_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMEQSpareDetail" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqsparedetails/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeqsparedetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMEQSpareDetail" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqsparedetails/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.checkKey(emeqsparedetailMapping.toDomain(emeqsparedetaildto)));
    }




    @ApiOperation(value = "GetDraft", tags = {"EMEQSpareDetail" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqsparedetails/getdraft")
    public ResponseEntity<EMEQSpareDetailDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailMapping.toDto(emeqsparedetailService.getDraft(new EMEQSpareDetail())));
    }




    @ApiOperation(value = "Save", tags = {"EMEQSpareDetail" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqsparedetails/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.save(emeqsparedetailMapping.toDomain(emeqsparedetaildto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMEQSpareDetail" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqsparedetails/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        emeqsparedetailService.saveBatch(emeqsparedetailMapping.toDomain(emeqsparedetaildtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSpareDetail-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEQSpareDetail" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqsparedetails/fetchdefault")
	public ResponseEntity<List<EMEQSpareDetailDTO>> fetchDefault(EMEQSpareDetailSearchContext context) {
        Page<EMEQSpareDetail> domains = emeqsparedetailService.searchDefault(context) ;
        List<EMEQSpareDetailDTO> list = emeqsparedetailMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQSpareDetail-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEQSpareDetail" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqsparedetails/searchdefault")
	public ResponseEntity<Page<EMEQSpareDetailDTO>> searchDefault(@RequestBody EMEQSpareDetailSearchContext context) {
        Page<EMEQSpareDetail> domains = emeqsparedetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqsparedetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "GetByEMEQSpare", tags = {"EMEQSpareDetail" },  notes = "GetByEMEQSpare")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqspares/{emeqspare_id}/emeqsparedetails/{emeqsparedetail_id}")
    public ResponseEntity<EMEQSpareDetailDTO> getByEMEQSpare(@PathVariable("emeqspare_id") String emeqspare_id, @PathVariable("emeqsparedetail_id") String emeqsparedetail_id) {
        EMEQSpareDetail domain = emeqsparedetailService.get(emeqsparedetail_id);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CreateByEMEQSpare", tags = {"EMEQSpareDetail" },  notes = "CreateByEMEQSpare")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqspares/{emeqspare_id}/emeqsparedetails")
    @Transactional
    public ResponseEntity<EMEQSpareDetailDTO> createByEMEQSpare(@PathVariable("emeqspare_id") String emeqspare_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
        domain.setEqspareid(emeqspare_id);
		emeqsparedetailService.create(domain);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMEQSpare", tags = {"EMEQSpareDetail" },  notes = "createBatchByEMEQSpare")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqspares/{emeqspare_id}/emeqsparedetails/batch")
    public ResponseEntity<Boolean> createBatchByEMEQSpare(@PathVariable("emeqspare_id") String emeqspare_id, @RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        List<EMEQSpareDetail> domainlist=emeqsparedetailMapping.toDomain(emeqsparedetaildtos);
        for(EMEQSpareDetail domain:domainlist){
            domain.setEqspareid(emeqspare_id);
        }
        emeqsparedetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMEQSpare", tags = {"EMEQSpareDetail" },  notes = "UpdateByEMEQSpare")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqspares/{emeqspare_id}/emeqsparedetails/{emeqsparedetail_id}")
    @Transactional
    public ResponseEntity<EMEQSpareDetailDTO> updateByEMEQSpare(@PathVariable("emeqspare_id") String emeqspare_id, @PathVariable("emeqsparedetail_id") String emeqsparedetail_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
        domain.setEqspareid(emeqspare_id);
        domain.setEmeqsparedetailid(emeqsparedetail_id);
		emeqsparedetailService.update(domain);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMEQSpare", tags = {"EMEQSpareDetail" },  notes = "UpdateBatchByEMEQSpare")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqspares/{emeqspare_id}/emeqsparedetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMEQSpare(@PathVariable("emeqspare_id") String emeqspare_id, @RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        List<EMEQSpareDetail> domainlist=emeqsparedetailMapping.toDomain(emeqsparedetaildtos);
        for(EMEQSpareDetail domain:domainlist){
            domain.setEqspareid(emeqspare_id);
        }
        emeqsparedetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMEQSpare", tags = {"EMEQSpareDetail" },  notes = "RemoveByEMEQSpare")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqspares/{emeqspare_id}/emeqsparedetails/{emeqsparedetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEQSpare(@PathVariable("emeqspare_id") String emeqspare_id, @PathVariable("emeqsparedetail_id") String emeqsparedetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.remove(emeqsparedetail_id));
    }

    @ApiOperation(value = "RemoveBatchByEMEQSpare", tags = {"EMEQSpareDetail" },  notes = "RemoveBatchByEMEQSpare")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqspares/{emeqspare_id}/emeqsparedetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMEQSpare(@RequestBody List<String> ids) {
        emeqsparedetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMEQSpare", tags = {"EMEQSpareDetail" },  notes = "CheckKeyByEMEQSpare")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqspares/{emeqspare_id}/emeqsparedetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEQSpare(@PathVariable("emeqspare_id") String emeqspare_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.checkKey(emeqsparedetailMapping.toDomain(emeqsparedetaildto)));
    }

    @ApiOperation(value = "GetDraftByEMEQSpare", tags = {"EMEQSpareDetail" },  notes = "GetDraftByEMEQSpare")
    @RequestMapping(method = RequestMethod.GET, value = "/emeqspares/{emeqspare_id}/emeqsparedetails/getdraft")
    public ResponseEntity<EMEQSpareDetailDTO> getDraftByEMEQSpare(@PathVariable("emeqspare_id") String emeqspare_id) {
        EMEQSpareDetail domain = new EMEQSpareDetail();
        domain.setEqspareid(emeqspare_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailMapping.toDto(emeqsparedetailService.getDraft(domain)));
    }

    @ApiOperation(value = "SaveByEMEQSpare", tags = {"EMEQSpareDetail" },  notes = "SaveByEMEQSpare")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqspares/{emeqspare_id}/emeqsparedetails/save")
    public ResponseEntity<Boolean> saveByEMEQSpare(@PathVariable("emeqspare_id") String emeqspare_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
        domain.setEqspareid(emeqspare_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMEQSpare", tags = {"EMEQSpareDetail" },  notes = "SaveBatchByEMEQSpare")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqspares/{emeqspare_id}/emeqsparedetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEQSpare(@PathVariable("emeqspare_id") String emeqspare_id, @RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        List<EMEQSpareDetail> domainlist=emeqsparedetailMapping.toDomain(emeqsparedetaildtos);
        for(EMEQSpareDetail domain:domainlist){
             domain.setEqspareid(emeqspare_id);
        }
        emeqsparedetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMEQSpare", tags = {"EMEQSpareDetail" } ,notes = "fetchDEFAULTByEMEQSpare")
    @RequestMapping(method= RequestMethod.GET , value="/emeqspares/{emeqspare_id}/emeqsparedetails/fetchdefault")
	public ResponseEntity<List<EMEQSpareDetailDTO>> fetchEMEQSpareDetailDefaultByEMEQSpare(@PathVariable("emeqspare_id") String emeqspare_id,EMEQSpareDetailSearchContext context) {
        context.setN_eqspareid_eq(emeqspare_id);
        Page<EMEQSpareDetail> domains = emeqsparedetailService.searchDefault(context) ;
        List<EMEQSpareDetailDTO> list = emeqsparedetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMEQSpare", tags = {"EMEQSpareDetail" } ,notes = "searchDEFAULTByEMEQSpare")
    @RequestMapping(method= RequestMethod.POST , value="/emeqspares/{emeqspare_id}/emeqsparedetails/searchdefault")
	public ResponseEntity<Page<EMEQSpareDetailDTO>> searchEMEQSpareDetailDefaultByEMEQSpare(@PathVariable("emeqspare_id") String emeqspare_id, @RequestBody EMEQSpareDetailSearchContext context) {
        context.setN_eqspareid_eq(emeqspare_id);
        Page<EMEQSpareDetail> domains = emeqsparedetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqsparedetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "GetByEMItem", tags = {"EMEQSpareDetail" },  notes = "GetByEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emeqsparedetails/{emeqsparedetail_id}")
    public ResponseEntity<EMEQSpareDetailDTO> getByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emeqsparedetail_id") String emeqsparedetail_id) {
        EMEQSpareDetail domain = emeqsparedetailService.get(emeqsparedetail_id);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CreateByEMItem", tags = {"EMEQSpareDetail" },  notes = "CreateByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emeqsparedetails")
    @Transactional
    public ResponseEntity<EMEQSpareDetailDTO> createByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
        domain.setItemid(emitem_id);
		emeqsparedetailService.create(domain);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMItem", tags = {"EMEQSpareDetail" },  notes = "createBatchByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emeqsparedetails/batch")
    public ResponseEntity<Boolean> createBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        List<EMEQSpareDetail> domainlist=emeqsparedetailMapping.toDomain(emeqsparedetaildtos);
        for(EMEQSpareDetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emeqsparedetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMItem", tags = {"EMEQSpareDetail" },  notes = "UpdateByEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emeqsparedetails/{emeqsparedetail_id}")
    @Transactional
    public ResponseEntity<EMEQSpareDetailDTO> updateByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emeqsparedetail_id") String emeqsparedetail_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
        domain.setItemid(emitem_id);
        domain.setEmeqsparedetailid(emeqsparedetail_id);
		emeqsparedetailService.update(domain);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMItem", tags = {"EMEQSpareDetail" },  notes = "UpdateBatchByEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emeqsparedetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        List<EMEQSpareDetail> domainlist=emeqsparedetailMapping.toDomain(emeqsparedetaildtos);
        for(EMEQSpareDetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emeqsparedetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMItem", tags = {"EMEQSpareDetail" },  notes = "RemoveByEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emeqsparedetails/{emeqsparedetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emeqsparedetail_id") String emeqsparedetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.remove(emeqsparedetail_id));
    }

    @ApiOperation(value = "RemoveBatchByEMItem", tags = {"EMEQSpareDetail" },  notes = "RemoveBatchByEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emeqsparedetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMItem(@RequestBody List<String> ids) {
        emeqsparedetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMItem", tags = {"EMEQSpareDetail" },  notes = "CheckKeyByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emeqsparedetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.checkKey(emeqsparedetailMapping.toDomain(emeqsparedetaildto)));
    }

    @ApiOperation(value = "GetDraftByEMItem", tags = {"EMEQSpareDetail" },  notes = "GetDraftByEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emeqsparedetails/getdraft")
    public ResponseEntity<EMEQSpareDetailDTO> getDraftByEMItem(@PathVariable("emitem_id") String emitem_id) {
        EMEQSpareDetail domain = new EMEQSpareDetail();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailMapping.toDto(emeqsparedetailService.getDraft(domain)));
    }

    @ApiOperation(value = "SaveByEMItem", tags = {"EMEQSpareDetail" },  notes = "SaveByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emeqsparedetails/save")
    public ResponseEntity<Boolean> saveByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMItem", tags = {"EMEQSpareDetail" },  notes = "SaveBatchByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emeqsparedetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        List<EMEQSpareDetail> domainlist=emeqsparedetailMapping.toDomain(emeqsparedetaildtos);
        for(EMEQSpareDetail domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emeqsparedetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMItem", tags = {"EMEQSpareDetail" } ,notes = "fetchDEFAULTByEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/emeqsparedetails/fetchdefault")
	public ResponseEntity<List<EMEQSpareDetailDTO>> fetchEMEQSpareDetailDefaultByEMItem(@PathVariable("emitem_id") String emitem_id,EMEQSpareDetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEQSpareDetail> domains = emeqsparedetailService.searchDefault(context) ;
        List<EMEQSpareDetailDTO> list = emeqsparedetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMItem", tags = {"EMEQSpareDetail" } ,notes = "searchDEFAULTByEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/emeqsparedetails/searchdefault")
	public ResponseEntity<Page<EMEQSpareDetailDTO>> searchEMEQSpareDetailDefaultByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEQSpareDetail> domains = emeqsparedetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqsparedetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "GetByEMServiceEMItem", tags = {"EMEQSpareDetail" },  notes = "GetByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emeqsparedetails/{emeqsparedetail_id}")
    public ResponseEntity<EMEQSpareDetailDTO> getByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emeqsparedetail_id") String emeqsparedetail_id) {
        EMEQSpareDetail domain = emeqsparedetailService.get(emeqsparedetail_id);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CreateByEMServiceEMItem", tags = {"EMEQSpareDetail" },  notes = "CreateByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emeqsparedetails")
    @Transactional
    public ResponseEntity<EMEQSpareDetailDTO> createByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
        domain.setItemid(emitem_id);
		emeqsparedetailService.create(domain);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMServiceEMItem", tags = {"EMEQSpareDetail" },  notes = "createBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emeqsparedetails/batch")
    public ResponseEntity<Boolean> createBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        List<EMEQSpareDetail> domainlist=emeqsparedetailMapping.toDomain(emeqsparedetaildtos);
        for(EMEQSpareDetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emeqsparedetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMServiceEMItem", tags = {"EMEQSpareDetail" },  notes = "UpdateByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emeqsparedetails/{emeqsparedetail_id}")
    @Transactional
    public ResponseEntity<EMEQSpareDetailDTO> updateByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emeqsparedetail_id") String emeqsparedetail_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
        domain.setItemid(emitem_id);
        domain.setEmeqsparedetailid(emeqsparedetail_id);
		emeqsparedetailService.update(domain);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMServiceEMItem", tags = {"EMEQSpareDetail" },  notes = "UpdateBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emeqsparedetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        List<EMEQSpareDetail> domainlist=emeqsparedetailMapping.toDomain(emeqsparedetaildtos);
        for(EMEQSpareDetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emeqsparedetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMServiceEMItem", tags = {"EMEQSpareDetail" },  notes = "RemoveByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emeqsparedetails/{emeqsparedetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emeqsparedetail_id") String emeqsparedetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.remove(emeqsparedetail_id));
    }

    @ApiOperation(value = "RemoveBatchByEMServiceEMItem", tags = {"EMEQSpareDetail" },  notes = "RemoveBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emeqsparedetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMServiceEMItem(@RequestBody List<String> ids) {
        emeqsparedetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMServiceEMItem", tags = {"EMEQSpareDetail" },  notes = "CheckKeyByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emeqsparedetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.checkKey(emeqsparedetailMapping.toDomain(emeqsparedetaildto)));
    }

    @ApiOperation(value = "GetDraftByEMServiceEMItem", tags = {"EMEQSpareDetail" },  notes = "GetDraftByEMServiceEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emeqsparedetails/getdraft")
    public ResponseEntity<EMEQSpareDetailDTO> getDraftByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id) {
        EMEQSpareDetail domain = new EMEQSpareDetail();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailMapping.toDto(emeqsparedetailService.getDraft(domain)));
    }

    @ApiOperation(value = "SaveByEMServiceEMItem", tags = {"EMEQSpareDetail" },  notes = "SaveByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emeqsparedetails/save")
    public ResponseEntity<Boolean> saveByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMServiceEMItem", tags = {"EMEQSpareDetail" },  notes = "SaveBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emeqsparedetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        List<EMEQSpareDetail> domainlist=emeqsparedetailMapping.toDomain(emeqsparedetaildtos);
        for(EMEQSpareDetail domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emeqsparedetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMServiceEMItem", tags = {"EMEQSpareDetail" } ,notes = "fetchDEFAULTByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/emeqsparedetails/fetchdefault")
	public ResponseEntity<List<EMEQSpareDetailDTO>> fetchEMEQSpareDetailDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id,EMEQSpareDetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEQSpareDetail> domains = emeqsparedetailService.searchDefault(context) ;
        List<EMEQSpareDetailDTO> list = emeqsparedetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMServiceEMItem", tags = {"EMEQSpareDetail" } ,notes = "searchDEFAULTByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/emeqsparedetails/searchdefault")
	public ResponseEntity<Page<EMEQSpareDetailDTO>> searchEMEQSpareDetailDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEQSpareDetail> domains = emeqsparedetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqsparedetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "GetByEMStorePartEMItem", tags = {"EMEQSpareDetail" },  notes = "GetByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails/{emeqsparedetail_id}")
    public ResponseEntity<EMEQSpareDetailDTO> getByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emeqsparedetail_id") String emeqsparedetail_id) {
        EMEQSpareDetail domain = emeqsparedetailService.get(emeqsparedetail_id);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CreateByEMStorePartEMItem", tags = {"EMEQSpareDetail" },  notes = "CreateByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails")
    @Transactional
    public ResponseEntity<EMEQSpareDetailDTO> createByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
        domain.setItemid(emitem_id);
		emeqsparedetailService.create(domain);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStorePartEMItem", tags = {"EMEQSpareDetail" },  notes = "createBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails/batch")
    public ResponseEntity<Boolean> createBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        List<EMEQSpareDetail> domainlist=emeqsparedetailMapping.toDomain(emeqsparedetaildtos);
        for(EMEQSpareDetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emeqsparedetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMStorePartEMItem", tags = {"EMEQSpareDetail" },  notes = "UpdateByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails/{emeqsparedetail_id}")
    @Transactional
    public ResponseEntity<EMEQSpareDetailDTO> updateByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emeqsparedetail_id") String emeqsparedetail_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
        domain.setItemid(emitem_id);
        domain.setEmeqsparedetailid(emeqsparedetail_id);
		emeqsparedetailService.update(domain);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStorePartEMItem", tags = {"EMEQSpareDetail" },  notes = "UpdateBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        List<EMEQSpareDetail> domainlist=emeqsparedetailMapping.toDomain(emeqsparedetaildtos);
        for(EMEQSpareDetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emeqsparedetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMStorePartEMItem", tags = {"EMEQSpareDetail" },  notes = "RemoveByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails/{emeqsparedetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emeqsparedetail_id") String emeqsparedetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.remove(emeqsparedetail_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStorePartEMItem", tags = {"EMEQSpareDetail" },  notes = "RemoveBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMStorePartEMItem(@RequestBody List<String> ids) {
        emeqsparedetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMStorePartEMItem", tags = {"EMEQSpareDetail" },  notes = "CheckKeyByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.checkKey(emeqsparedetailMapping.toDomain(emeqsparedetaildto)));
    }

    @ApiOperation(value = "GetDraftByEMStorePartEMItem", tags = {"EMEQSpareDetail" },  notes = "GetDraftByEMStorePartEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails/getdraft")
    public ResponseEntity<EMEQSpareDetailDTO> getDraftByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMEQSpareDetail domain = new EMEQSpareDetail();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailMapping.toDto(emeqsparedetailService.getDraft(domain)));
    }

    @ApiOperation(value = "SaveByEMStorePartEMItem", tags = {"EMEQSpareDetail" },  notes = "SaveByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails/save")
    public ResponseEntity<Boolean> saveByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStorePartEMItem", tags = {"EMEQSpareDetail" },  notes = "SaveBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        List<EMEQSpareDetail> domainlist=emeqsparedetailMapping.toDomain(emeqsparedetaildtos);
        for(EMEQSpareDetail domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emeqsparedetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMStorePartEMItem", tags = {"EMEQSpareDetail" } ,notes = "fetchDEFAULTByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails/fetchdefault")
	public ResponseEntity<List<EMEQSpareDetailDTO>> fetchEMEQSpareDetailDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMEQSpareDetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEQSpareDetail> domains = emeqsparedetailService.searchDefault(context) ;
        List<EMEQSpareDetailDTO> list = emeqsparedetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStorePartEMItem", tags = {"EMEQSpareDetail" } ,notes = "searchDEFAULTByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails/searchdefault")
	public ResponseEntity<Page<EMEQSpareDetailDTO>> searchEMEQSpareDetailDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEQSpareDetail> domains = emeqsparedetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqsparedetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "GetByEMStoreEMItem", tags = {"EMEQSpareDetail" },  notes = "GetByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emeqsparedetails/{emeqsparedetail_id}")
    public ResponseEntity<EMEQSpareDetailDTO> getByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emeqsparedetail_id") String emeqsparedetail_id) {
        EMEQSpareDetail domain = emeqsparedetailService.get(emeqsparedetail_id);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CreateByEMStoreEMItem", tags = {"EMEQSpareDetail" },  notes = "CreateByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emeqsparedetails")
    @Transactional
    public ResponseEntity<EMEQSpareDetailDTO> createByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
        domain.setItemid(emitem_id);
		emeqsparedetailService.create(domain);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStoreEMItem", tags = {"EMEQSpareDetail" },  notes = "createBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emeqsparedetails/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        List<EMEQSpareDetail> domainlist=emeqsparedetailMapping.toDomain(emeqsparedetaildtos);
        for(EMEQSpareDetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emeqsparedetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMStoreEMItem", tags = {"EMEQSpareDetail" },  notes = "UpdateByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emeqsparedetails/{emeqsparedetail_id}")
    @Transactional
    public ResponseEntity<EMEQSpareDetailDTO> updateByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emeqsparedetail_id") String emeqsparedetail_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
        domain.setItemid(emitem_id);
        domain.setEmeqsparedetailid(emeqsparedetail_id);
		emeqsparedetailService.update(domain);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStoreEMItem", tags = {"EMEQSpareDetail" },  notes = "UpdateBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emeqsparedetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        List<EMEQSpareDetail> domainlist=emeqsparedetailMapping.toDomain(emeqsparedetaildtos);
        for(EMEQSpareDetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emeqsparedetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMStoreEMItem", tags = {"EMEQSpareDetail" },  notes = "RemoveByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emeqsparedetails/{emeqsparedetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emeqsparedetail_id") String emeqsparedetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.remove(emeqsparedetail_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStoreEMItem", tags = {"EMEQSpareDetail" },  notes = "RemoveBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emeqsparedetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMItem(@RequestBody List<String> ids) {
        emeqsparedetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMStoreEMItem", tags = {"EMEQSpareDetail" },  notes = "CheckKeyByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emeqsparedetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.checkKey(emeqsparedetailMapping.toDomain(emeqsparedetaildto)));
    }

    @ApiOperation(value = "GetDraftByEMStoreEMItem", tags = {"EMEQSpareDetail" },  notes = "GetDraftByEMStoreEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emeqsparedetails/getdraft")
    public ResponseEntity<EMEQSpareDetailDTO> getDraftByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id) {
        EMEQSpareDetail domain = new EMEQSpareDetail();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailMapping.toDto(emeqsparedetailService.getDraft(domain)));
    }

    @ApiOperation(value = "SaveByEMStoreEMItem", tags = {"EMEQSpareDetail" },  notes = "SaveByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emeqsparedetails/save")
    public ResponseEntity<Boolean> saveByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStoreEMItem", tags = {"EMEQSpareDetail" },  notes = "SaveBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emeqsparedetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        List<EMEQSpareDetail> domainlist=emeqsparedetailMapping.toDomain(emeqsparedetaildtos);
        for(EMEQSpareDetail domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emeqsparedetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMStoreEMItem", tags = {"EMEQSpareDetail" } ,notes = "fetchDEFAULTByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/emeqsparedetails/fetchdefault")
	public ResponseEntity<List<EMEQSpareDetailDTO>> fetchEMEQSpareDetailDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id,EMEQSpareDetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEQSpareDetail> domains = emeqsparedetailService.searchDefault(context) ;
        List<EMEQSpareDetailDTO> list = emeqsparedetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStoreEMItem", tags = {"EMEQSpareDetail" } ,notes = "searchDEFAULTByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/emeqsparedetails/searchdefault")
	public ResponseEntity<Page<EMEQSpareDetailDTO>> searchEMEQSpareDetailDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEQSpareDetail> domains = emeqsparedetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqsparedetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "GetByPFEmpEMItem", tags = {"EMEQSpareDetail" },  notes = "GetByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emeqsparedetails/{emeqsparedetail_id}")
    public ResponseEntity<EMEQSpareDetailDTO> getByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emeqsparedetail_id") String emeqsparedetail_id) {
        EMEQSpareDetail domain = emeqsparedetailService.get(emeqsparedetail_id);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CreateByPFEmpEMItem", tags = {"EMEQSpareDetail" },  notes = "CreateByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emeqsparedetails")
    @Transactional
    public ResponseEntity<EMEQSpareDetailDTO> createByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
        domain.setItemid(emitem_id);
		emeqsparedetailService.create(domain);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFEmpEMItem", tags = {"EMEQSpareDetail" },  notes = "createBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emeqsparedetails/batch")
    public ResponseEntity<Boolean> createBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        List<EMEQSpareDetail> domainlist=emeqsparedetailMapping.toDomain(emeqsparedetaildtos);
        for(EMEQSpareDetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emeqsparedetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByPFEmpEMItem", tags = {"EMEQSpareDetail" },  notes = "UpdateByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emeqsparedetails/{emeqsparedetail_id}")
    @Transactional
    public ResponseEntity<EMEQSpareDetailDTO> updateByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emeqsparedetail_id") String emeqsparedetail_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
        domain.setItemid(emitem_id);
        domain.setEmeqsparedetailid(emeqsparedetail_id);
		emeqsparedetailService.update(domain);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFEmpEMItem", tags = {"EMEQSpareDetail" },  notes = "UpdateBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emeqsparedetails/batch")
    public ResponseEntity<Boolean> updateBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        List<EMEQSpareDetail> domainlist=emeqsparedetailMapping.toDomain(emeqsparedetaildtos);
        for(EMEQSpareDetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emeqsparedetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByPFEmpEMItem", tags = {"EMEQSpareDetail" },  notes = "RemoveByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emeqsparedetails/{emeqsparedetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emeqsparedetail_id") String emeqsparedetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.remove(emeqsparedetail_id));
    }

    @ApiOperation(value = "RemoveBatchByPFEmpEMItem", tags = {"EMEQSpareDetail" },  notes = "RemoveBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emeqsparedetails/batch")
    public ResponseEntity<Boolean> removeBatchByPFEmpEMItem(@RequestBody List<String> ids) {
        emeqsparedetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByPFEmpEMItem", tags = {"EMEQSpareDetail" },  notes = "CheckKeyByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emeqsparedetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.checkKey(emeqsparedetailMapping.toDomain(emeqsparedetaildto)));
    }

    @ApiOperation(value = "GetDraftByPFEmpEMItem", tags = {"EMEQSpareDetail" },  notes = "GetDraftByPFEmpEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emeqsparedetails/getdraft")
    public ResponseEntity<EMEQSpareDetailDTO> getDraftByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id) {
        EMEQSpareDetail domain = new EMEQSpareDetail();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailMapping.toDto(emeqsparedetailService.getDraft(domain)));
    }

    @ApiOperation(value = "SaveByPFEmpEMItem", tags = {"EMEQSpareDetail" },  notes = "SaveByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emeqsparedetails/save")
    public ResponseEntity<Boolean> saveByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFEmpEMItem", tags = {"EMEQSpareDetail" },  notes = "SaveBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emeqsparedetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        List<EMEQSpareDetail> domainlist=emeqsparedetailMapping.toDomain(emeqsparedetaildtos);
        for(EMEQSpareDetail domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emeqsparedetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByPFEmpEMItem", tags = {"EMEQSpareDetail" } ,notes = "fetchDEFAULTByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emeqsparedetails/fetchdefault")
	public ResponseEntity<List<EMEQSpareDetailDTO>> fetchEMEQSpareDetailDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id,EMEQSpareDetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEQSpareDetail> domains = emeqsparedetailService.searchDefault(context) ;
        List<EMEQSpareDetailDTO> list = emeqsparedetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFEmpEMItem", tags = {"EMEQSpareDetail" } ,notes = "searchDEFAULTByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emeqsparedetails/searchdefault")
	public ResponseEntity<Page<EMEQSpareDetailDTO>> searchEMEQSpareDetailDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEQSpareDetail> domains = emeqsparedetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqsparedetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "GetByPFUnitEMItem", tags = {"EMEQSpareDetail" },  notes = "GetByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emeqsparedetails/{emeqsparedetail_id}")
    public ResponseEntity<EMEQSpareDetailDTO> getByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emeqsparedetail_id") String emeqsparedetail_id) {
        EMEQSpareDetail domain = emeqsparedetailService.get(emeqsparedetail_id);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CreateByPFUnitEMItem", tags = {"EMEQSpareDetail" },  notes = "CreateByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emeqsparedetails")
    @Transactional
    public ResponseEntity<EMEQSpareDetailDTO> createByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
        domain.setItemid(emitem_id);
		emeqsparedetailService.create(domain);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFUnitEMItem", tags = {"EMEQSpareDetail" },  notes = "createBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emeqsparedetails/batch")
    public ResponseEntity<Boolean> createBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        List<EMEQSpareDetail> domainlist=emeqsparedetailMapping.toDomain(emeqsparedetaildtos);
        for(EMEQSpareDetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emeqsparedetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByPFUnitEMItem", tags = {"EMEQSpareDetail" },  notes = "UpdateByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emeqsparedetails/{emeqsparedetail_id}")
    @Transactional
    public ResponseEntity<EMEQSpareDetailDTO> updateByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emeqsparedetail_id") String emeqsparedetail_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
        domain.setItemid(emitem_id);
        domain.setEmeqsparedetailid(emeqsparedetail_id);
		emeqsparedetailService.update(domain);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFUnitEMItem", tags = {"EMEQSpareDetail" },  notes = "UpdateBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emeqsparedetails/batch")
    public ResponseEntity<Boolean> updateBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        List<EMEQSpareDetail> domainlist=emeqsparedetailMapping.toDomain(emeqsparedetaildtos);
        for(EMEQSpareDetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emeqsparedetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByPFUnitEMItem", tags = {"EMEQSpareDetail" },  notes = "RemoveByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emeqsparedetails/{emeqsparedetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emeqsparedetail_id") String emeqsparedetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.remove(emeqsparedetail_id));
    }

    @ApiOperation(value = "RemoveBatchByPFUnitEMItem", tags = {"EMEQSpareDetail" },  notes = "RemoveBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emeqsparedetails/batch")
    public ResponseEntity<Boolean> removeBatchByPFUnitEMItem(@RequestBody List<String> ids) {
        emeqsparedetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByPFUnitEMItem", tags = {"EMEQSpareDetail" },  notes = "CheckKeyByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emeqsparedetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.checkKey(emeqsparedetailMapping.toDomain(emeqsparedetaildto)));
    }

    @ApiOperation(value = "GetDraftByPFUnitEMItem", tags = {"EMEQSpareDetail" },  notes = "GetDraftByPFUnitEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emeqsparedetails/getdraft")
    public ResponseEntity<EMEQSpareDetailDTO> getDraftByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id) {
        EMEQSpareDetail domain = new EMEQSpareDetail();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailMapping.toDto(emeqsparedetailService.getDraft(domain)));
    }

    @ApiOperation(value = "SaveByPFUnitEMItem", tags = {"EMEQSpareDetail" },  notes = "SaveByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emeqsparedetails/save")
    public ResponseEntity<Boolean> saveByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFUnitEMItem", tags = {"EMEQSpareDetail" },  notes = "SaveBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emeqsparedetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        List<EMEQSpareDetail> domainlist=emeqsparedetailMapping.toDomain(emeqsparedetaildtos);
        for(EMEQSpareDetail domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emeqsparedetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByPFUnitEMItem", tags = {"EMEQSpareDetail" } ,notes = "fetchDEFAULTByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emeqsparedetails/fetchdefault")
	public ResponseEntity<List<EMEQSpareDetailDTO>> fetchEMEQSpareDetailDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id,EMEQSpareDetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEQSpareDetail> domains = emeqsparedetailService.searchDefault(context) ;
        List<EMEQSpareDetailDTO> list = emeqsparedetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFUnitEMItem", tags = {"EMEQSpareDetail" } ,notes = "searchDEFAULTByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emeqsparedetails/searchdefault")
	public ResponseEntity<Page<EMEQSpareDetailDTO>> searchEMEQSpareDetailDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEQSpareDetail> domains = emeqsparedetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqsparedetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}





    @ApiOperation(value = "GetByEMStoreEMStorePartEMItem", tags = {"EMEQSpareDetail" },  notes = "GetByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails/{emeqsparedetail_id}")
    public ResponseEntity<EMEQSpareDetailDTO> getByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emeqsparedetail_id") String emeqsparedetail_id) {
        EMEQSpareDetail domain = emeqsparedetailService.get(emeqsparedetail_id);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CreateByEMStoreEMStorePartEMItem", tags = {"EMEQSpareDetail" },  notes = "CreateByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails")
    @Transactional
    public ResponseEntity<EMEQSpareDetailDTO> createByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
        domain.setItemid(emitem_id);
		emeqsparedetailService.create(domain);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStoreEMStorePartEMItem", tags = {"EMEQSpareDetail" },  notes = "createBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        List<EMEQSpareDetail> domainlist=emeqsparedetailMapping.toDomain(emeqsparedetaildtos);
        for(EMEQSpareDetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emeqsparedetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMStoreEMStorePartEMItem", tags = {"EMEQSpareDetail" },  notes = "UpdateByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails/{emeqsparedetail_id}")
    @Transactional
    public ResponseEntity<EMEQSpareDetailDTO> updateByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emeqsparedetail_id") String emeqsparedetail_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
        domain.setItemid(emitem_id);
        domain.setEmeqsparedetailid(emeqsparedetail_id);
		emeqsparedetailService.update(domain);
        EMEQSpareDetailDTO dto = emeqsparedetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStoreEMStorePartEMItem", tags = {"EMEQSpareDetail" },  notes = "UpdateBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        List<EMEQSpareDetail> domainlist=emeqsparedetailMapping.toDomain(emeqsparedetaildtos);
        for(EMEQSpareDetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emeqsparedetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMStoreEMStorePartEMItem", tags = {"EMEQSpareDetail" },  notes = "RemoveByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails/{emeqsparedetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emeqsparedetail_id") String emeqsparedetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.remove(emeqsparedetail_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStoreEMStorePartEMItem", tags = {"EMEQSpareDetail" },  notes = "RemoveBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMStorePartEMItem(@RequestBody List<String> ids) {
        emeqsparedetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMStoreEMStorePartEMItem", tags = {"EMEQSpareDetail" },  notes = "CheckKeyByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.checkKey(emeqsparedetailMapping.toDomain(emeqsparedetaildto)));
    }

    @ApiOperation(value = "GetDraftByEMStoreEMStorePartEMItem", tags = {"EMEQSpareDetail" },  notes = "GetDraftByEMStoreEMStorePartEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails/getdraft")
    public ResponseEntity<EMEQSpareDetailDTO> getDraftByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMEQSpareDetail domain = new EMEQSpareDetail();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailMapping.toDto(emeqsparedetailService.getDraft(domain)));
    }

    @ApiOperation(value = "SaveByEMStoreEMStorePartEMItem", tags = {"EMEQSpareDetail" },  notes = "SaveByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails/save")
    public ResponseEntity<Boolean> saveByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailDTO emeqsparedetaildto) {
        EMEQSpareDetail domain = emeqsparedetailMapping.toDomain(emeqsparedetaildto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqsparedetailService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStoreEMStorePartEMItem", tags = {"EMEQSpareDetail" },  notes = "SaveBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMEQSpareDetailDTO> emeqsparedetaildtos) {
        List<EMEQSpareDetail> domainlist=emeqsparedetailMapping.toDomain(emeqsparedetaildtos);
        for(EMEQSpareDetail domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emeqsparedetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMStoreEMStorePartEMItem", tags = {"EMEQSpareDetail" } ,notes = "fetchDEFAULTByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails/fetchdefault")
	public ResponseEntity<List<EMEQSpareDetailDTO>> fetchEMEQSpareDetailDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMEQSpareDetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEQSpareDetail> domains = emeqsparedetailService.searchDefault(context) ;
        List<EMEQSpareDetailDTO> list = emeqsparedetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStoreEMStorePartEMItem", tags = {"EMEQSpareDetail" } ,notes = "searchDEFAULTByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emeqsparedetails/searchdefault")
	public ResponseEntity<Page<EMEQSpareDetailDTO>> searchEMEQSpareDetailDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMEQSpareDetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMEQSpareDetail> domains = emeqsparedetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqsparedetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMEQSpareDetail getEntity(){
        return new EMEQSpareDetail();
    }

}
