package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEQMonitor;
import cn.ibizlab.eam.core.eam_core.service.IEMEQMonitorService;
import cn.ibizlab.eam.core.eam_core.filter.EMEQMonitorSearchContext;




@Slf4j
@Api(tags = {"EMEQMonitor" })
@RestController("WebApi-emeqmonitor")
@RequestMapping("")
public class EMEQMonitorResource {

    @Autowired
    private IEMEQMonitorService emeqmonitorService;

    @Autowired
    @Lazy
    private EMEQMonitorMapping emeqmonitorMapping;




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMEQMonitor" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqmonitors")
    @Transactional
    public ResponseEntity<EMEQMonitorDTO> create(@RequestBody EMEQMonitorDTO emeqmonitordto) {
        EMEQMonitor domain = emeqmonitorMapping.toDomain(emeqmonitordto);
		emeqmonitorService.create(domain);
        EMEQMonitorDTO dto = emeqmonitorMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMEQMonitor" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqmonitors/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEQMonitorDTO> emeqmonitordtos) {
        emeqmonitorService.createBatch(emeqmonitorMapping.toDomain(emeqmonitordtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMEQMonitor" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqmonitors/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEQMonitorDTO emeqmonitordto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeqmonitorService.save(emeqmonitorMapping.toDomain(emeqmonitordto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMEQMonitor" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqmonitors/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEQMonitorDTO> emeqmonitordtos) {
        emeqmonitorService.saveBatch(emeqmonitorMapping.toDomain(emeqmonitordtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMEQMonitor" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqmonitors/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEQMonitorDTO emeqmonitordto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqmonitorService.checkKey(emeqmonitorMapping.toDomain(emeqmonitordto)));
    }




    @PreAuthorize("hasPermission(#emeqmonitor_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMEQMonitor" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqmonitors/{emeqmonitor_id}")
    @Transactional
    public ResponseEntity<EMEQMonitorDTO> update(@PathVariable("emeqmonitor_id") String emeqmonitor_id, @RequestBody EMEQMonitorDTO emeqmonitordto) {
		EMEQMonitor domain = emeqmonitorMapping.toDomain(emeqmonitordto);
        domain.setEmeqmonitorid(emeqmonitor_id);
		emeqmonitorService.update(domain);
		EMEQMonitorDTO dto = emeqmonitorMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emeqmonitor_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEQMonitor" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqmonitors/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEQMonitorDTO> emeqmonitordtos) {
        emeqmonitorService.updateBatch(emeqmonitorMapping.toDomain(emeqmonitordtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeqmonitor_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMEQMonitor" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqmonitors/{emeqmonitor_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeqmonitor_id") String emeqmonitor_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeqmonitorService.remove(emeqmonitor_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMEQMonitor" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqmonitors/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeqmonitorService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeqmonitor_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMEQMonitor" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqmonitors/{emeqmonitor_id}")
    public ResponseEntity<EMEQMonitorDTO> get(@PathVariable("emeqmonitor_id") String emeqmonitor_id) {
        EMEQMonitor domain = emeqmonitorService.get(emeqmonitor_id);
        EMEQMonitorDTO dto = emeqmonitorMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMEQMonitor" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqmonitors/getdraft")
    public ResponseEntity<EMEQMonitorDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeqmonitorMapping.toDto(emeqmonitorService.getDraft(new EMEQMonitor())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQMonitor-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEQMonitor" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqmonitors/fetchdefault")
	public ResponseEntity<List<EMEQMonitorDTO>> fetchDefault(EMEQMonitorSearchContext context) {
        Page<EMEQMonitor> domains = emeqmonitorService.searchDefault(context) ;
        List<EMEQMonitorDTO> list = emeqmonitorMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQMonitor-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEQMonitor" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqmonitors/searchdefault")
	public ResponseEntity<Page<EMEQMonitorDTO>> searchDefault(@RequestBody EMEQMonitorSearchContext context) {
        Page<EMEQMonitor> domains = emeqmonitorService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqmonitorMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMEQMonitor getEntity(){
        return new EMEQMonitor();
    }

}
