package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEQLCTGSS;
import cn.ibizlab.eam.core.eam_core.service.IEMEQLCTGSSService;
import cn.ibizlab.eam.core.eam_core.filter.EMEQLCTGSSSearchContext;




@Slf4j
@Api(tags = {"EMEQLCTGSS" })
@RestController("WebApi-emeqlctgss")
@RequestMapping("")
public class EMEQLCTGSSResource {

    @Autowired
    private IEMEQLCTGSSService emeqlctgssService;

    @Autowired
    @Lazy
    private EMEQLCTGSSMapping emeqlctgssMapping;




    @PreAuthorize("hasPermission(#emeqlctgss_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMEQLCTGSS" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqlctgsses/{emeqlctgss_id}")
    @Transactional
    public ResponseEntity<EMEQLCTGSSDTO> update(@PathVariable("emeqlctgss_id") String emeqlctgss_id, @RequestBody EMEQLCTGSSDTO emeqlctgssdto) {
		EMEQLCTGSS domain = emeqlctgssMapping.toDomain(emeqlctgssdto);
        domain.setEmeqlocationid(emeqlctgss_id);
		emeqlctgssService.update(domain);
		EMEQLCTGSSDTO dto = emeqlctgssMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emeqlctgss_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEQLCTGSS" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqlctgsses/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEQLCTGSSDTO> emeqlctgssdtos) {
        emeqlctgssService.updateBatch(emeqlctgssMapping.toDomain(emeqlctgssdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMEQLCTGSS" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlctgsses/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEQLCTGSSDTO emeqlctgssdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqlctgssService.checkKey(emeqlctgssMapping.toDomain(emeqlctgssdto)));
    }




    @ApiOperation(value = "Save", tags = {"EMEQLCTGSS" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlctgsses/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEQLCTGSSDTO emeqlctgssdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeqlctgssService.save(emeqlctgssMapping.toDomain(emeqlctgssdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMEQLCTGSS" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlctgsses/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEQLCTGSSDTO> emeqlctgssdtos) {
        emeqlctgssService.saveBatch(emeqlctgssMapping.toDomain(emeqlctgssdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeqlctgss_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMEQLCTGSS" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqlctgsses/{emeqlctgss_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeqlctgss_id") String emeqlctgss_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeqlctgssService.remove(emeqlctgss_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMEQLCTGSS" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqlctgsses/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeqlctgssService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMEQLCTGSS" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqlctgsses/getdraft")
    public ResponseEntity<EMEQLCTGSSDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeqlctgssMapping.toDto(emeqlctgssService.getDraft(new EMEQLCTGSS())));
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMEQLCTGSS" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlctgsses")
    @Transactional
    public ResponseEntity<EMEQLCTGSSDTO> create(@RequestBody EMEQLCTGSSDTO emeqlctgssdto) {
        EMEQLCTGSS domain = emeqlctgssMapping.toDomain(emeqlctgssdto);
		emeqlctgssService.create(domain);
        EMEQLCTGSSDTO dto = emeqlctgssMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMEQLCTGSS" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlctgsses/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEQLCTGSSDTO> emeqlctgssdtos) {
        emeqlctgssService.createBatch(emeqlctgssMapping.toDomain(emeqlctgssdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeqlctgss_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMEQLCTGSS" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqlctgsses/{emeqlctgss_id}")
    public ResponseEntity<EMEQLCTGSSDTO> get(@PathVariable("emeqlctgss_id") String emeqlctgss_id) {
        EMEQLCTGSS domain = emeqlctgssService.get(emeqlctgss_id);
        EMEQLCTGSSDTO dto = emeqlctgssMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQLCTGSS-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEQLCTGSS" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqlctgsses/fetchdefault")
	public ResponseEntity<List<EMEQLCTGSSDTO>> fetchDefault(EMEQLCTGSSSearchContext context) {
        Page<EMEQLCTGSS> domains = emeqlctgssService.searchDefault(context) ;
        List<EMEQLCTGSSDTO> list = emeqlctgssMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQLCTGSS-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEQLCTGSS" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqlctgsses/searchdefault")
	public ResponseEntity<Page<EMEQLCTGSSDTO>> searchDefault(@RequestBody EMEQLCTGSSSearchContext context) {
        Page<EMEQLCTGSS> domains = emeqlctgssService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqlctgssMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQLCTGSS-Main3-all')")
	@ApiOperation(value = "fetch钢丝绳超期预警查询模型", tags = {"EMEQLCTGSS" } ,notes = "fetch钢丝绳超期预警查询模型")
    @RequestMapping(method= RequestMethod.GET , value="/emeqlctgsses/fetchmain3")
	public ResponseEntity<List<EMEQLCTGSSDTO>> fetchMain3(EMEQLCTGSSSearchContext context) {
        Page<EMEQLCTGSS> domains = emeqlctgssService.searchMain3(context) ;
        List<EMEQLCTGSSDTO> list = emeqlctgssMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQLCTGSS-Main3-all')")
	@ApiOperation(value = "search钢丝绳超期预警查询模型", tags = {"EMEQLCTGSS" } ,notes = "search钢丝绳超期预警查询模型")
    @RequestMapping(method= RequestMethod.POST , value="/emeqlctgsses/searchmain3")
	public ResponseEntity<Page<EMEQLCTGSSDTO>> searchMain3(@RequestBody EMEQLCTGSSSearchContext context) {
        Page<EMEQLCTGSS> domains = emeqlctgssService.searchMain3(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqlctgssMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMEQLCTGSS getEntity(){
        return new EMEQLCTGSS();
    }

}
