package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEQCheck;
import cn.ibizlab.eam.core.eam_core.service.IEMEQCheckService;
import cn.ibizlab.eam.core.eam_core.filter.EMEQCheckSearchContext;




@Slf4j
@Api(tags = {"EMEQCheck" })
@RestController("WebApi-emeqcheck")
@RequestMapping("")
public class EMEQCheckResource {

    @Autowired
    private IEMEQCheckService emeqcheckService;

    @Autowired
    @Lazy
    private EMEQCheckMapping emeqcheckMapping;




    @ApiOperation(value = "Save", tags = {"EMEQCheck" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqchecks/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEQCheckDTO emeqcheckdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeqcheckService.save(emeqcheckMapping.toDomain(emeqcheckdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMEQCheck" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqchecks/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEQCheckDTO> emeqcheckdtos) {
        emeqcheckService.saveBatch(emeqcheckMapping.toDomain(emeqcheckdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeqcheck_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMEQCheck" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqchecks/{emeqcheck_id}")
    @Transactional
    public ResponseEntity<EMEQCheckDTO> update(@PathVariable("emeqcheck_id") String emeqcheck_id, @RequestBody EMEQCheckDTO emeqcheckdto) {
		EMEQCheck domain = emeqcheckMapping.toDomain(emeqcheckdto);
        domain.setEmeqcheckid(emeqcheck_id);
		emeqcheckService.update(domain);
		EMEQCheckDTO dto = emeqcheckMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emeqcheck_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEQCheck" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqchecks/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEQCheckDTO> emeqcheckdtos) {
        emeqcheckService.updateBatch(emeqcheckMapping.toDomain(emeqcheckdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMEQCheck" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqchecks")
    @Transactional
    public ResponseEntity<EMEQCheckDTO> create(@RequestBody EMEQCheckDTO emeqcheckdto) {
        EMEQCheck domain = emeqcheckMapping.toDomain(emeqcheckdto);
		emeqcheckService.create(domain);
        EMEQCheckDTO dto = emeqcheckMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMEQCheck" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqchecks/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEQCheckDTO> emeqcheckdtos) {
        emeqcheckService.createBatch(emeqcheckMapping.toDomain(emeqcheckdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMEQCheck" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqchecks/getdraft")
    public ResponseEntity<EMEQCheckDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeqcheckMapping.toDto(emeqcheckService.getDraft(new EMEQCheck())));
    }




    @PreAuthorize("hasPermission(#emeqcheck_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMEQCheck" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqchecks/{emeqcheck_id}")
    public ResponseEntity<EMEQCheckDTO> get(@PathVariable("emeqcheck_id") String emeqcheck_id) {
        EMEQCheck domain = emeqcheckService.get(emeqcheck_id);
        EMEQCheckDTO dto = emeqcheckMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMEQCheck" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqchecks/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEQCheckDTO emeqcheckdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqcheckService.checkKey(emeqcheckMapping.toDomain(emeqcheckdto)));
    }




    @PreAuthorize("hasPermission(#emeqcheck_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMEQCheck" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqchecks/{emeqcheck_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeqcheck_id") String emeqcheck_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeqcheckService.remove(emeqcheck_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMEQCheck" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqchecks/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeqcheckService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQCheck-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEQCheck" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqchecks/fetchdefault")
	public ResponseEntity<List<EMEQCheckDTO>> fetchDefault(EMEQCheckSearchContext context) {
        Page<EMEQCheck> domains = emeqcheckService.searchDefault(context) ;
        List<EMEQCheckDTO> list = emeqcheckMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQCheck-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEQCheck" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqchecks/searchdefault")
	public ResponseEntity<Page<EMEQCheckDTO>> searchDefault(@RequestBody EMEQCheckSearchContext context) {
        Page<EMEQCheck> domains = emeqcheckService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqcheckMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "SaveByEMEquip", tags = {"EMEQCheck" },  notes = "SaveByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqchecks/save")
    public ResponseEntity<Boolean> saveByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEQCheckDTO emeqcheckdto) {
        EMEQCheck domain = emeqcheckMapping.toDomain(emeqcheckdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqcheckService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMEquip", tags = {"EMEQCheck" },  notes = "SaveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqchecks/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQCheckDTO> emeqcheckdtos) {
        List<EMEQCheck> domainlist=emeqcheckMapping.toDomain(emeqcheckdtos);
        for(EMEQCheck domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emeqcheckService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMEquip", tags = {"EMEQCheck" },  notes = "UpdateByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emeqchecks/{emeqcheck_id}")
    @Transactional
    public ResponseEntity<EMEQCheckDTO> updateByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emeqcheck_id") String emeqcheck_id, @RequestBody EMEQCheckDTO emeqcheckdto) {
        EMEQCheck domain = emeqcheckMapping.toDomain(emeqcheckdto);
        domain.setEquipid(emequip_id);
        domain.setEmeqcheckid(emeqcheck_id);
		emeqcheckService.update(domain);
        EMEQCheckDTO dto = emeqcheckMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMEquip", tags = {"EMEQCheck" },  notes = "UpdateBatchByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emeqchecks/batch")
    public ResponseEntity<Boolean> updateBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQCheckDTO> emeqcheckdtos) {
        List<EMEQCheck> domainlist=emeqcheckMapping.toDomain(emeqcheckdtos);
        for(EMEQCheck domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqcheckService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMEquip", tags = {"EMEQCheck" },  notes = "CreateByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqchecks")
    @Transactional
    public ResponseEntity<EMEQCheckDTO> createByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEQCheckDTO emeqcheckdto) {
        EMEQCheck domain = emeqcheckMapping.toDomain(emeqcheckdto);
        domain.setEquipid(emequip_id);
		emeqcheckService.create(domain);
        EMEQCheckDTO dto = emeqcheckMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMEquip", tags = {"EMEQCheck" },  notes = "createBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqchecks/batch")
    public ResponseEntity<Boolean> createBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQCheckDTO> emeqcheckdtos) {
        List<EMEQCheck> domainlist=emeqcheckMapping.toDomain(emeqcheckdtos);
        for(EMEQCheck domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqcheckService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMEquip", tags = {"EMEQCheck" },  notes = "GetDraftByEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emeqchecks/getdraft")
    public ResponseEntity<EMEQCheckDTO> getDraftByEMEquip(@PathVariable("emequip_id") String emequip_id) {
        EMEQCheck domain = new EMEQCheck();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqcheckMapping.toDto(emeqcheckService.getDraft(domain)));
    }

    @ApiOperation(value = "GetByEMEquip", tags = {"EMEQCheck" },  notes = "GetByEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emeqchecks/{emeqcheck_id}")
    public ResponseEntity<EMEQCheckDTO> getByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emeqcheck_id") String emeqcheck_id) {
        EMEQCheck domain = emeqcheckService.get(emeqcheck_id);
        EMEQCheckDTO dto = emeqcheckMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CheckKeyByEMEquip", tags = {"EMEQCheck" },  notes = "CheckKeyByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqchecks/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEQCheckDTO emeqcheckdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqcheckService.checkKey(emeqcheckMapping.toDomain(emeqcheckdto)));
    }

    @ApiOperation(value = "RemoveByEMEquip", tags = {"EMEQCheck" },  notes = "RemoveByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emeqchecks/{emeqcheck_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emeqcheck_id") String emeqcheck_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqcheckService.remove(emeqcheck_id));
    }

    @ApiOperation(value = "RemoveBatchByEMEquip", tags = {"EMEQCheck" },  notes = "RemoveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emeqchecks/batch")
    public ResponseEntity<Boolean> removeBatchByEMEquip(@RequestBody List<String> ids) {
        emeqcheckService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMEquip", tags = {"EMEQCheck" } ,notes = "fetchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/{emequip_id}/emeqchecks/fetchdefault")
	public ResponseEntity<List<EMEQCheckDTO>> fetchEMEQCheckDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id,EMEQCheckSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQCheck> domains = emeqcheckService.searchDefault(context) ;
        List<EMEQCheckDTO> list = emeqcheckMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMEquip", tags = {"EMEQCheck" } ,notes = "searchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/{emequip_id}/emeqchecks/searchdefault")
	public ResponseEntity<Page<EMEQCheckDTO>> searchEMEQCheckDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEQCheckSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQCheck> domains = emeqcheckService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqcheckMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "SaveByEMEQTypeEMEquip", tags = {"EMEQCheck" },  notes = "SaveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqchecks/save")
    public ResponseEntity<Boolean> saveByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQCheckDTO emeqcheckdto) {
        EMEQCheck domain = emeqcheckMapping.toDomain(emeqcheckdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqcheckService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMEQTypeEMEquip", tags = {"EMEQCheck" },  notes = "SaveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqchecks/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQCheckDTO> emeqcheckdtos) {
        List<EMEQCheck> domainlist=emeqcheckMapping.toDomain(emeqcheckdtos);
        for(EMEQCheck domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emeqcheckService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMEQTypeEMEquip", tags = {"EMEQCheck" },  notes = "UpdateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqchecks/{emeqcheck_id}")
    @Transactional
    public ResponseEntity<EMEQCheckDTO> updateByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqcheck_id") String emeqcheck_id, @RequestBody EMEQCheckDTO emeqcheckdto) {
        EMEQCheck domain = emeqcheckMapping.toDomain(emeqcheckdto);
        domain.setEquipid(emequip_id);
        domain.setEmeqcheckid(emeqcheck_id);
		emeqcheckService.update(domain);
        EMEQCheckDTO dto = emeqcheckMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMEQTypeEMEquip", tags = {"EMEQCheck" },  notes = "UpdateBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqchecks/batch")
    public ResponseEntity<Boolean> updateBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQCheckDTO> emeqcheckdtos) {
        List<EMEQCheck> domainlist=emeqcheckMapping.toDomain(emeqcheckdtos);
        for(EMEQCheck domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqcheckService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMEQTypeEMEquip", tags = {"EMEQCheck" },  notes = "CreateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqchecks")
    @Transactional
    public ResponseEntity<EMEQCheckDTO> createByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQCheckDTO emeqcheckdto) {
        EMEQCheck domain = emeqcheckMapping.toDomain(emeqcheckdto);
        domain.setEquipid(emequip_id);
		emeqcheckService.create(domain);
        EMEQCheckDTO dto = emeqcheckMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMEQTypeEMEquip", tags = {"EMEQCheck" },  notes = "createBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqchecks/batch")
    public ResponseEntity<Boolean> createBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQCheckDTO> emeqcheckdtos) {
        List<EMEQCheck> domainlist=emeqcheckMapping.toDomain(emeqcheckdtos);
        for(EMEQCheck domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqcheckService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMEQTypeEMEquip", tags = {"EMEQCheck" },  notes = "GetDraftByEMEQTypeEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqchecks/getdraft")
    public ResponseEntity<EMEQCheckDTO> getDraftByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id) {
        EMEQCheck domain = new EMEQCheck();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqcheckMapping.toDto(emeqcheckService.getDraft(domain)));
    }

    @ApiOperation(value = "GetByEMEQTypeEMEquip", tags = {"EMEQCheck" },  notes = "GetByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqchecks/{emeqcheck_id}")
    public ResponseEntity<EMEQCheckDTO> getByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqcheck_id") String emeqcheck_id) {
        EMEQCheck domain = emeqcheckService.get(emeqcheck_id);
        EMEQCheckDTO dto = emeqcheckMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CheckKeyByEMEQTypeEMEquip", tags = {"EMEQCheck" },  notes = "CheckKeyByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqchecks/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQCheckDTO emeqcheckdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqcheckService.checkKey(emeqcheckMapping.toDomain(emeqcheckdto)));
    }

    @ApiOperation(value = "RemoveByEMEQTypeEMEquip", tags = {"EMEQCheck" },  notes = "RemoveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqchecks/{emeqcheck_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqcheck_id") String emeqcheck_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqcheckService.remove(emeqcheck_id));
    }

    @ApiOperation(value = "RemoveBatchByEMEQTypeEMEquip", tags = {"EMEQCheck" },  notes = "RemoveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqchecks/batch")
    public ResponseEntity<Boolean> removeBatchByEMEQTypeEMEquip(@RequestBody List<String> ids) {
        emeqcheckService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMEQTypeEMEquip", tags = {"EMEQCheck" } ,notes = "fetchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqchecks/fetchdefault")
	public ResponseEntity<List<EMEQCheckDTO>> fetchEMEQCheckDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id,EMEQCheckSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQCheck> domains = emeqcheckService.searchDefault(context) ;
        List<EMEQCheckDTO> list = emeqcheckMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMEQTypeEMEquip", tags = {"EMEQCheck" } ,notes = "searchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqchecks/searchdefault")
	public ResponseEntity<Page<EMEQCheckDTO>> searchEMEQCheckDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQCheckSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQCheck> domains = emeqcheckService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqcheckMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "SaveByPFTeamEMEquip", tags = {"EMEQCheck" },  notes = "SaveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqchecks/save")
    public ResponseEntity<Boolean> saveByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQCheckDTO emeqcheckdto) {
        EMEQCheck domain = emeqcheckMapping.toDomain(emeqcheckdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqcheckService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFTeamEMEquip", tags = {"EMEQCheck" },  notes = "SaveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqchecks/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQCheckDTO> emeqcheckdtos) {
        List<EMEQCheck> domainlist=emeqcheckMapping.toDomain(emeqcheckdtos);
        for(EMEQCheck domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emeqcheckService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByPFTeamEMEquip", tags = {"EMEQCheck" },  notes = "UpdateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqchecks/{emeqcheck_id}")
    @Transactional
    public ResponseEntity<EMEQCheckDTO> updateByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqcheck_id") String emeqcheck_id, @RequestBody EMEQCheckDTO emeqcheckdto) {
        EMEQCheck domain = emeqcheckMapping.toDomain(emeqcheckdto);
        domain.setEquipid(emequip_id);
        domain.setEmeqcheckid(emeqcheck_id);
		emeqcheckService.update(domain);
        EMEQCheckDTO dto = emeqcheckMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFTeamEMEquip", tags = {"EMEQCheck" },  notes = "UpdateBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqchecks/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQCheckDTO> emeqcheckdtos) {
        List<EMEQCheck> domainlist=emeqcheckMapping.toDomain(emeqcheckdtos);
        for(EMEQCheck domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqcheckService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByPFTeamEMEquip", tags = {"EMEQCheck" },  notes = "CreateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqchecks")
    @Transactional
    public ResponseEntity<EMEQCheckDTO> createByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQCheckDTO emeqcheckdto) {
        EMEQCheck domain = emeqcheckMapping.toDomain(emeqcheckdto);
        domain.setEquipid(emequip_id);
		emeqcheckService.create(domain);
        EMEQCheckDTO dto = emeqcheckMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFTeamEMEquip", tags = {"EMEQCheck" },  notes = "createBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqchecks/batch")
    public ResponseEntity<Boolean> createBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQCheckDTO> emeqcheckdtos) {
        List<EMEQCheck> domainlist=emeqcheckMapping.toDomain(emeqcheckdtos);
        for(EMEQCheck domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqcheckService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFTeamEMEquip", tags = {"EMEQCheck" },  notes = "GetDraftByPFTeamEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqchecks/getdraft")
    public ResponseEntity<EMEQCheckDTO> getDraftByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id) {
        EMEQCheck domain = new EMEQCheck();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqcheckMapping.toDto(emeqcheckService.getDraft(domain)));
    }

    @ApiOperation(value = "GetByPFTeamEMEquip", tags = {"EMEQCheck" },  notes = "GetByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqchecks/{emeqcheck_id}")
    public ResponseEntity<EMEQCheckDTO> getByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqcheck_id") String emeqcheck_id) {
        EMEQCheck domain = emeqcheckService.get(emeqcheck_id);
        EMEQCheckDTO dto = emeqcheckMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CheckKeyByPFTeamEMEquip", tags = {"EMEQCheck" },  notes = "CheckKeyByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqchecks/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQCheckDTO emeqcheckdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqcheckService.checkKey(emeqcheckMapping.toDomain(emeqcheckdto)));
    }

    @ApiOperation(value = "RemoveByPFTeamEMEquip", tags = {"EMEQCheck" },  notes = "RemoveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqchecks/{emeqcheck_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqcheck_id") String emeqcheck_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqcheckService.remove(emeqcheck_id));
    }

    @ApiOperation(value = "RemoveBatchByPFTeamEMEquip", tags = {"EMEQCheck" },  notes = "RemoveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqchecks/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeamEMEquip(@RequestBody List<String> ids) {
        emeqcheckService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByPFTeamEMEquip", tags = {"EMEQCheck" } ,notes = "fetchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqchecks/fetchdefault")
	public ResponseEntity<List<EMEQCheckDTO>> fetchEMEQCheckDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id,EMEQCheckSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQCheck> domains = emeqcheckService.searchDefault(context) ;
        List<EMEQCheckDTO> list = emeqcheckMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFTeamEMEquip", tags = {"EMEQCheck" } ,notes = "searchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqchecks/searchdefault")
	public ResponseEntity<Page<EMEQCheckDTO>> searchEMEQCheckDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQCheckSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQCheck> domains = emeqcheckService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqcheckMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMEQCheck getEntity(){
        return new EMEQCheck();
    }

}
