package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMENConsum;
import cn.ibizlab.eam.core.eam_core.service.IEMENConsumService;
import cn.ibizlab.eam.core.eam_core.filter.EMENConsumSearchContext;




@Slf4j
@Api(tags = {"EMENConsum" })
@RestController("WebApi-emenconsum")
@RequestMapping("")
public class EMENConsumResource {

    @Autowired
    private IEMENConsumService emenconsumService;

    @Autowired
    @Lazy
    private EMENConsumMapping emenconsumMapping;




    @ApiOperation(value = "Save", tags = {"EMENConsum" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emenconsums/save")
    public ResponseEntity<Boolean> save(@RequestBody EMENConsumDTO emenconsumdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.save(emenconsumMapping.toDomain(emenconsumdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMENConsum" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emenconsums/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMENConsumDTO> emenconsumdtos) {
        emenconsumService.saveBatch(emenconsumMapping.toDomain(emenconsumdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emenconsum_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMENConsum" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emenconsums/{emenconsum_id}")
    public ResponseEntity<EMENConsumDTO> get(@PathVariable("emenconsum_id") String emenconsum_id) {
        EMENConsum domain = emenconsumService.get(emenconsum_id);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @PreAuthorize("hasPermission(#emenconsum_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMENConsum" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<EMENConsumDTO> update(@PathVariable("emenconsum_id") String emenconsum_id, @RequestBody EMENConsumDTO emenconsumdto) {
		EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEmenconsumid(emenconsum_id);
		emenconsumService.update(domain);
		EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emenconsum_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMENConsum" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emenconsums/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMENConsumDTO> emenconsumdtos) {
        emenconsumService.updateBatch(emenconsumMapping.toDomain(emenconsumdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMENConsum" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emenconsums")
    @Transactional
    public ResponseEntity<EMENConsumDTO> create(@RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
		emenconsumService.create(domain);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMENConsum" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emenconsums/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMENConsumDTO> emenconsumdtos) {
        emenconsumService.createBatch(emenconsumMapping.toDomain(emenconsumdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emenconsum_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMENConsum" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emenconsum_id") String emenconsum_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.remove(emenconsum_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMENConsum" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emenconsums/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emenconsumService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMENConsum" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emenconsums/getdraft")
    public ResponseEntity<EMENConsumDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumMapping.toDto(emenconsumService.getDraft(new EMENConsum())));
    }




    @ApiOperation(value = "CheckKey", tags = {"EMENConsum" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emenconsums/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMENConsumDTO emenconsumdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emenconsumService.checkKey(emenconsumMapping.toDomain(emenconsumdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMENConsum-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMENConsum" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emenconsums/fetchdefault")
	public ResponseEntity<List<EMENConsumDTO>> fetchDefault(EMENConsumSearchContext context) {
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
        List<EMENConsumDTO> list = emenconsumMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMENConsum-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMENConsum" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emenconsums/searchdefault")
	public ResponseEntity<Page<EMENConsumDTO>> searchDefault(@RequestBody EMENConsumSearchContext context) {
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emenconsumMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "SaveByEMEN", tags = {"EMENConsum" },  notes = "SaveByEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emen/{emen_id}/emenconsums/save")
    public ResponseEntity<Boolean> saveByEMEN(@PathVariable("emen_id") String emen_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEnid(emen_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMEN", tags = {"EMENConsum" },  notes = "SaveBatchByEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emen/{emen_id}/emenconsums/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEN(@PathVariable("emen_id") String emen_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
             domain.setEnid(emen_id);
        }
        emenconsumService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMEN", tags = {"EMENConsum" },  notes = "GetByEMEN")
	@RequestMapping(method = RequestMethod.GET, value = "/emen/{emen_id}/emenconsums/{emenconsum_id}")
    public ResponseEntity<EMENConsumDTO> getByEMEN(@PathVariable("emen_id") String emen_id, @PathVariable("emenconsum_id") String emenconsum_id) {
        EMENConsum domain = emenconsumService.get(emenconsum_id);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateByEMEN", tags = {"EMENConsum" },  notes = "UpdateByEMEN")
	@RequestMapping(method = RequestMethod.PUT, value = "/emen/{emen_id}/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<EMENConsumDTO> updateByEMEN(@PathVariable("emen_id") String emen_id, @PathVariable("emenconsum_id") String emenconsum_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEnid(emen_id);
        domain.setEmenconsumid(emenconsum_id);
		emenconsumService.update(domain);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMEN", tags = {"EMENConsum" },  notes = "UpdateBatchByEMEN")
	@RequestMapping(method = RequestMethod.PUT, value = "/emen/{emen_id}/emenconsums/batch")
    public ResponseEntity<Boolean> updateBatchByEMEN(@PathVariable("emen_id") String emen_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
            domain.setEnid(emen_id);
        }
        emenconsumService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMEN", tags = {"EMENConsum" },  notes = "CreateByEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emen/{emen_id}/emenconsums")
    @Transactional
    public ResponseEntity<EMENConsumDTO> createByEMEN(@PathVariable("emen_id") String emen_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEnid(emen_id);
		emenconsumService.create(domain);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMEN", tags = {"EMENConsum" },  notes = "createBatchByEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emen/{emen_id}/emenconsums/batch")
    public ResponseEntity<Boolean> createBatchByEMEN(@PathVariable("emen_id") String emen_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
            domain.setEnid(emen_id);
        }
        emenconsumService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMEN", tags = {"EMENConsum" },  notes = "RemoveByEMEN")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emen/{emen_id}/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEN(@PathVariable("emen_id") String emen_id, @PathVariable("emenconsum_id") String emenconsum_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.remove(emenconsum_id));
    }

    @ApiOperation(value = "RemoveBatchByEMEN", tags = {"EMENConsum" },  notes = "RemoveBatchByEMEN")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emen/{emen_id}/emenconsums/batch")
    public ResponseEntity<Boolean> removeBatchByEMEN(@RequestBody List<String> ids) {
        emenconsumService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMEN", tags = {"EMENConsum" },  notes = "GetDraftByEMEN")
    @RequestMapping(method = RequestMethod.GET, value = "/emen/{emen_id}/emenconsums/getdraft")
    public ResponseEntity<EMENConsumDTO> getDraftByEMEN(@PathVariable("emen_id") String emen_id) {
        EMENConsum domain = new EMENConsum();
        domain.setEnid(emen_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumMapping.toDto(emenconsumService.getDraft(domain)));
    }

    @ApiOperation(value = "CheckKeyByEMEN", tags = {"EMENConsum" },  notes = "CheckKeyByEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emen/{emen_id}/emenconsums/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEN(@PathVariable("emen_id") String emen_id, @RequestBody EMENConsumDTO emenconsumdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emenconsumService.checkKey(emenconsumMapping.toDomain(emenconsumdto)));
    }

	@ApiOperation(value = "fetchDEFAULTByEMEN", tags = {"EMENConsum" } ,notes = "fetchDEFAULTByEMEN")
    @RequestMapping(method= RequestMethod.GET , value="/emen/{emen_id}/emenconsums/fetchdefault")
	public ResponseEntity<List<EMENConsumDTO>> fetchEMENConsumDefaultByEMEN(@PathVariable("emen_id") String emen_id,EMENConsumSearchContext context) {
        context.setN_enid_eq(emen_id);
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
        List<EMENConsumDTO> list = emenconsumMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMEN", tags = {"EMENConsum" } ,notes = "searchDEFAULTByEMEN")
    @RequestMapping(method= RequestMethod.POST , value="/emen/{emen_id}/emenconsums/searchdefault")
	public ResponseEntity<Page<EMENConsumDTO>> searchEMENConsumDefaultByEMEN(@PathVariable("emen_id") String emen_id, @RequestBody EMENConsumSearchContext context) {
        context.setN_enid_eq(emen_id);
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emenconsumMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "SaveByEMEquip", tags = {"EMENConsum" },  notes = "SaveByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emenconsums/save")
    public ResponseEntity<Boolean> saveByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMEquip", tags = {"EMENConsum" },  notes = "SaveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emenconsums/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emenconsumService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMEquip", tags = {"EMENConsum" },  notes = "GetByEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emenconsums/{emenconsum_id}")
    public ResponseEntity<EMENConsumDTO> getByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emenconsum_id") String emenconsum_id) {
        EMENConsum domain = emenconsumService.get(emenconsum_id);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateByEMEquip", tags = {"EMENConsum" },  notes = "UpdateByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<EMENConsumDTO> updateByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emenconsum_id") String emenconsum_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEquipid(emequip_id);
        domain.setEmenconsumid(emenconsum_id);
		emenconsumService.update(domain);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMEquip", tags = {"EMENConsum" },  notes = "UpdateBatchByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emenconsums/batch")
    public ResponseEntity<Boolean> updateBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emenconsumService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMEquip", tags = {"EMENConsum" },  notes = "CreateByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emenconsums")
    @Transactional
    public ResponseEntity<EMENConsumDTO> createByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEquipid(emequip_id);
		emenconsumService.create(domain);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMEquip", tags = {"EMENConsum" },  notes = "createBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emenconsums/batch")
    public ResponseEntity<Boolean> createBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emenconsumService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMEquip", tags = {"EMENConsum" },  notes = "RemoveByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emenconsum_id") String emenconsum_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.remove(emenconsum_id));
    }

    @ApiOperation(value = "RemoveBatchByEMEquip", tags = {"EMENConsum" },  notes = "RemoveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emenconsums/batch")
    public ResponseEntity<Boolean> removeBatchByEMEquip(@RequestBody List<String> ids) {
        emenconsumService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMEquip", tags = {"EMENConsum" },  notes = "GetDraftByEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emenconsums/getdraft")
    public ResponseEntity<EMENConsumDTO> getDraftByEMEquip(@PathVariable("emequip_id") String emequip_id) {
        EMENConsum domain = new EMENConsum();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumMapping.toDto(emenconsumService.getDraft(domain)));
    }

    @ApiOperation(value = "CheckKeyByEMEquip", tags = {"EMENConsum" },  notes = "CheckKeyByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emenconsums/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMENConsumDTO emenconsumdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emenconsumService.checkKey(emenconsumMapping.toDomain(emenconsumdto)));
    }

	@ApiOperation(value = "fetchDEFAULTByEMEquip", tags = {"EMENConsum" } ,notes = "fetchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/{emequip_id}/emenconsums/fetchdefault")
	public ResponseEntity<List<EMENConsumDTO>> fetchEMENConsumDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id,EMENConsumSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
        List<EMENConsumDTO> list = emenconsumMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMEquip", tags = {"EMENConsum" } ,notes = "searchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/{emequip_id}/emenconsums/searchdefault")
	public ResponseEntity<Page<EMENConsumDTO>> searchEMENConsumDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMENConsumSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emenconsumMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "SaveByPFDept", tags = {"EMENConsum" },  notes = "SaveByPFDept")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emenconsums/save")
    public ResponseEntity<Boolean> saveByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setDeptid(pfdept_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFDept", tags = {"EMENConsum" },  notes = "SaveBatchByPFDept")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emenconsums/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
             domain.setDeptid(pfdept_id);
        }
        emenconsumService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByPFDept", tags = {"EMENConsum" },  notes = "GetByPFDept")
	@RequestMapping(method = RequestMethod.GET, value = "/pfdepts/{pfdept_id}/emenconsums/{emenconsum_id}")
    public ResponseEntity<EMENConsumDTO> getByPFDept(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emenconsum_id") String emenconsum_id) {
        EMENConsum domain = emenconsumService.get(emenconsum_id);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateByPFDept", tags = {"EMENConsum" },  notes = "UpdateByPFDept")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfdepts/{pfdept_id}/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<EMENConsumDTO> updateByPFDept(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emenconsum_id") String emenconsum_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setDeptid(pfdept_id);
        domain.setEmenconsumid(emenconsum_id);
		emenconsumService.update(domain);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFDept", tags = {"EMENConsum" },  notes = "UpdateBatchByPFDept")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfdepts/{pfdept_id}/emenconsums/batch")
    public ResponseEntity<Boolean> updateBatchByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
            domain.setDeptid(pfdept_id);
        }
        emenconsumService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByPFDept", tags = {"EMENConsum" },  notes = "CreateByPFDept")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emenconsums")
    @Transactional
    public ResponseEntity<EMENConsumDTO> createByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setDeptid(pfdept_id);
		emenconsumService.create(domain);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFDept", tags = {"EMENConsum" },  notes = "createBatchByPFDept")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emenconsums/batch")
    public ResponseEntity<Boolean> createBatchByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
            domain.setDeptid(pfdept_id);
        }
        emenconsumService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByPFDept", tags = {"EMENConsum" },  notes = "RemoveByPFDept")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfdepts/{pfdept_id}/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFDept(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emenconsum_id") String emenconsum_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.remove(emenconsum_id));
    }

    @ApiOperation(value = "RemoveBatchByPFDept", tags = {"EMENConsum" },  notes = "RemoveBatchByPFDept")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfdepts/{pfdept_id}/emenconsums/batch")
    public ResponseEntity<Boolean> removeBatchByPFDept(@RequestBody List<String> ids) {
        emenconsumService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFDept", tags = {"EMENConsum" },  notes = "GetDraftByPFDept")
    @RequestMapping(method = RequestMethod.GET, value = "/pfdepts/{pfdept_id}/emenconsums/getdraft")
    public ResponseEntity<EMENConsumDTO> getDraftByPFDept(@PathVariable("pfdept_id") String pfdept_id) {
        EMENConsum domain = new EMENConsum();
        domain.setDeptid(pfdept_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumMapping.toDto(emenconsumService.getDraft(domain)));
    }

    @ApiOperation(value = "CheckKeyByPFDept", tags = {"EMENConsum" },  notes = "CheckKeyByPFDept")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emenconsums/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody EMENConsumDTO emenconsumdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emenconsumService.checkKey(emenconsumMapping.toDomain(emenconsumdto)));
    }

	@ApiOperation(value = "fetchDEFAULTByPFDept", tags = {"EMENConsum" } ,notes = "fetchDEFAULTByPFDept")
    @RequestMapping(method= RequestMethod.GET , value="/pfdepts/{pfdept_id}/emenconsums/fetchdefault")
	public ResponseEntity<List<EMENConsumDTO>> fetchEMENConsumDefaultByPFDept(@PathVariable("pfdept_id") String pfdept_id,EMENConsumSearchContext context) {
        context.setN_deptid_eq(pfdept_id);
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
        List<EMENConsumDTO> list = emenconsumMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFDept", tags = {"EMENConsum" } ,notes = "searchDEFAULTByPFDept")
    @RequestMapping(method= RequestMethod.POST , value="/pfdepts/{pfdept_id}/emenconsums/searchdefault")
	public ResponseEntity<Page<EMENConsumDTO>> searchEMENConsumDefaultByPFDept(@PathVariable("pfdept_id") String pfdept_id, @RequestBody EMENConsumSearchContext context) {
        context.setN_deptid_eq(pfdept_id);
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emenconsumMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "SaveByEMItemEMEN", tags = {"EMENConsum" },  notes = "SaveByEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emen/{emen_id}/emenconsums/save")
    public ResponseEntity<Boolean> saveByEMItemEMEN(@PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEnid(emen_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMItemEMEN", tags = {"EMENConsum" },  notes = "SaveBatchByEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emen/{emen_id}/emenconsums/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMItemEMEN(@PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
             domain.setEnid(emen_id);
        }
        emenconsumService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMItemEMEN", tags = {"EMENConsum" },  notes = "GetByEMItemEMEN")
	@RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emen/{emen_id}/emenconsums/{emenconsum_id}")
    public ResponseEntity<EMENConsumDTO> getByEMItemEMEN(@PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @PathVariable("emenconsum_id") String emenconsum_id) {
        EMENConsum domain = emenconsumService.get(emenconsum_id);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateByEMItemEMEN", tags = {"EMENConsum" },  notes = "UpdateByEMItemEMEN")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emen/{emen_id}/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<EMENConsumDTO> updateByEMItemEMEN(@PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @PathVariable("emenconsum_id") String emenconsum_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEnid(emen_id);
        domain.setEmenconsumid(emenconsum_id);
		emenconsumService.update(domain);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMItemEMEN", tags = {"EMENConsum" },  notes = "UpdateBatchByEMItemEMEN")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emen/{emen_id}/emenconsums/batch")
    public ResponseEntity<Boolean> updateBatchByEMItemEMEN(@PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
            domain.setEnid(emen_id);
        }
        emenconsumService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMItemEMEN", tags = {"EMENConsum" },  notes = "CreateByEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emen/{emen_id}/emenconsums")
    @Transactional
    public ResponseEntity<EMENConsumDTO> createByEMItemEMEN(@PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEnid(emen_id);
		emenconsumService.create(domain);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMItemEMEN", tags = {"EMENConsum" },  notes = "createBatchByEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emen/{emen_id}/emenconsums/batch")
    public ResponseEntity<Boolean> createBatchByEMItemEMEN(@PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
            domain.setEnid(emen_id);
        }
        emenconsumService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMItemEMEN", tags = {"EMENConsum" },  notes = "RemoveByEMItemEMEN")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emen/{emen_id}/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMItemEMEN(@PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @PathVariable("emenconsum_id") String emenconsum_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.remove(emenconsum_id));
    }

    @ApiOperation(value = "RemoveBatchByEMItemEMEN", tags = {"EMENConsum" },  notes = "RemoveBatchByEMItemEMEN")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emen/{emen_id}/emenconsums/batch")
    public ResponseEntity<Boolean> removeBatchByEMItemEMEN(@RequestBody List<String> ids) {
        emenconsumService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMItemEMEN", tags = {"EMENConsum" },  notes = "GetDraftByEMItemEMEN")
    @RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emen/{emen_id}/emenconsums/getdraft")
    public ResponseEntity<EMENConsumDTO> getDraftByEMItemEMEN(@PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id) {
        EMENConsum domain = new EMENConsum();
        domain.setEnid(emen_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumMapping.toDto(emenconsumService.getDraft(domain)));
    }

    @ApiOperation(value = "CheckKeyByEMItemEMEN", tags = {"EMENConsum" },  notes = "CheckKeyByEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emen/{emen_id}/emenconsums/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMItemEMEN(@PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumDTO emenconsumdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emenconsumService.checkKey(emenconsumMapping.toDomain(emenconsumdto)));
    }

	@ApiOperation(value = "fetchDEFAULTByEMItemEMEN", tags = {"EMENConsum" } ,notes = "fetchDEFAULTByEMItemEMEN")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/emen/{emen_id}/emenconsums/fetchdefault")
	public ResponseEntity<List<EMENConsumDTO>> fetchEMENConsumDefaultByEMItemEMEN(@PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id,EMENConsumSearchContext context) {
        context.setN_enid_eq(emen_id);
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
        List<EMENConsumDTO> list = emenconsumMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMItemEMEN", tags = {"EMENConsum" } ,notes = "searchDEFAULTByEMItemEMEN")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/emen/{emen_id}/emenconsums/searchdefault")
	public ResponseEntity<Page<EMENConsumDTO>> searchEMENConsumDefaultByEMItemEMEN(@PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumSearchContext context) {
        context.setN_enid_eq(emen_id);
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emenconsumMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "SaveByEMEQTypeEMEquip", tags = {"EMENConsum" },  notes = "SaveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emenconsums/save")
    public ResponseEntity<Boolean> saveByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMEQTypeEMEquip", tags = {"EMENConsum" },  notes = "SaveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emenconsums/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emenconsumService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMEQTypeEMEquip", tags = {"EMENConsum" },  notes = "GetByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emenconsums/{emenconsum_id}")
    public ResponseEntity<EMENConsumDTO> getByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emenconsum_id") String emenconsum_id) {
        EMENConsum domain = emenconsumService.get(emenconsum_id);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateByEMEQTypeEMEquip", tags = {"EMENConsum" },  notes = "UpdateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<EMENConsumDTO> updateByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emenconsum_id") String emenconsum_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEquipid(emequip_id);
        domain.setEmenconsumid(emenconsum_id);
		emenconsumService.update(domain);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMEQTypeEMEquip", tags = {"EMENConsum" },  notes = "UpdateBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emenconsums/batch")
    public ResponseEntity<Boolean> updateBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emenconsumService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMEQTypeEMEquip", tags = {"EMENConsum" },  notes = "CreateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emenconsums")
    @Transactional
    public ResponseEntity<EMENConsumDTO> createByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEquipid(emequip_id);
		emenconsumService.create(domain);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMEQTypeEMEquip", tags = {"EMENConsum" },  notes = "createBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emenconsums/batch")
    public ResponseEntity<Boolean> createBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emenconsumService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMEQTypeEMEquip", tags = {"EMENConsum" },  notes = "RemoveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emenconsum_id") String emenconsum_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.remove(emenconsum_id));
    }

    @ApiOperation(value = "RemoveBatchByEMEQTypeEMEquip", tags = {"EMENConsum" },  notes = "RemoveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emenconsums/batch")
    public ResponseEntity<Boolean> removeBatchByEMEQTypeEMEquip(@RequestBody List<String> ids) {
        emenconsumService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMEQTypeEMEquip", tags = {"EMENConsum" },  notes = "GetDraftByEMEQTypeEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emenconsums/getdraft")
    public ResponseEntity<EMENConsumDTO> getDraftByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id) {
        EMENConsum domain = new EMENConsum();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumMapping.toDto(emenconsumService.getDraft(domain)));
    }

    @ApiOperation(value = "CheckKeyByEMEQTypeEMEquip", tags = {"EMENConsum" },  notes = "CheckKeyByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emenconsums/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMENConsumDTO emenconsumdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emenconsumService.checkKey(emenconsumMapping.toDomain(emenconsumdto)));
    }

	@ApiOperation(value = "fetchDEFAULTByEMEQTypeEMEquip", tags = {"EMENConsum" } ,notes = "fetchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emenconsums/fetchdefault")
	public ResponseEntity<List<EMENConsumDTO>> fetchEMENConsumDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id,EMENConsumSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
        List<EMENConsumDTO> list = emenconsumMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMEQTypeEMEquip", tags = {"EMENConsum" } ,notes = "searchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emenconsums/searchdefault")
	public ResponseEntity<Page<EMENConsumDTO>> searchEMENConsumDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMENConsumSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emenconsumMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "SaveByPFTeamEMEquip", tags = {"EMENConsum" },  notes = "SaveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emenconsums/save")
    public ResponseEntity<Boolean> saveByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFTeamEMEquip", tags = {"EMENConsum" },  notes = "SaveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emenconsums/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emenconsumService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByPFTeamEMEquip", tags = {"EMENConsum" },  notes = "GetByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emenconsums/{emenconsum_id}")
    public ResponseEntity<EMENConsumDTO> getByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emenconsum_id") String emenconsum_id) {
        EMENConsum domain = emenconsumService.get(emenconsum_id);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateByPFTeamEMEquip", tags = {"EMENConsum" },  notes = "UpdateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<EMENConsumDTO> updateByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emenconsum_id") String emenconsum_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEquipid(emequip_id);
        domain.setEmenconsumid(emenconsum_id);
		emenconsumService.update(domain);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFTeamEMEquip", tags = {"EMENConsum" },  notes = "UpdateBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emenconsums/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emenconsumService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByPFTeamEMEquip", tags = {"EMENConsum" },  notes = "CreateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emenconsums")
    @Transactional
    public ResponseEntity<EMENConsumDTO> createByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEquipid(emequip_id);
		emenconsumService.create(domain);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFTeamEMEquip", tags = {"EMENConsum" },  notes = "createBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emenconsums/batch")
    public ResponseEntity<Boolean> createBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emenconsumService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByPFTeamEMEquip", tags = {"EMENConsum" },  notes = "RemoveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emenconsum_id") String emenconsum_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.remove(emenconsum_id));
    }

    @ApiOperation(value = "RemoveBatchByPFTeamEMEquip", tags = {"EMENConsum" },  notes = "RemoveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emenconsums/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeamEMEquip(@RequestBody List<String> ids) {
        emenconsumService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFTeamEMEquip", tags = {"EMENConsum" },  notes = "GetDraftByPFTeamEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emenconsums/getdraft")
    public ResponseEntity<EMENConsumDTO> getDraftByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id) {
        EMENConsum domain = new EMENConsum();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumMapping.toDto(emenconsumService.getDraft(domain)));
    }

    @ApiOperation(value = "CheckKeyByPFTeamEMEquip", tags = {"EMENConsum" },  notes = "CheckKeyByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emenconsums/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMENConsumDTO emenconsumdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emenconsumService.checkKey(emenconsumMapping.toDomain(emenconsumdto)));
    }

	@ApiOperation(value = "fetchDEFAULTByPFTeamEMEquip", tags = {"EMENConsum" } ,notes = "fetchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emenconsums/fetchdefault")
	public ResponseEntity<List<EMENConsumDTO>> fetchEMENConsumDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id,EMENConsumSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
        List<EMENConsumDTO> list = emenconsumMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFTeamEMEquip", tags = {"EMENConsum" } ,notes = "searchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emenconsums/searchdefault")
	public ResponseEntity<Page<EMENConsumDTO>> searchEMENConsumDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMENConsumSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emenconsumMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}





    @ApiOperation(value = "SaveByEMServiceEMItemEMEN", tags = {"EMENConsum" },  notes = "SaveByEMServiceEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/save")
    public ResponseEntity<Boolean> saveByEMServiceEMItemEMEN(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEnid(emen_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMServiceEMItemEMEN", tags = {"EMENConsum" },  notes = "SaveBatchByEMServiceEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMServiceEMItemEMEN(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
             domain.setEnid(emen_id);
        }
        emenconsumService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMServiceEMItemEMEN", tags = {"EMENConsum" },  notes = "GetByEMServiceEMItemEMEN")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/{emenconsum_id}")
    public ResponseEntity<EMENConsumDTO> getByEMServiceEMItemEMEN(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @PathVariable("emenconsum_id") String emenconsum_id) {
        EMENConsum domain = emenconsumService.get(emenconsum_id);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateByEMServiceEMItemEMEN", tags = {"EMENConsum" },  notes = "UpdateByEMServiceEMItemEMEN")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<EMENConsumDTO> updateByEMServiceEMItemEMEN(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @PathVariable("emenconsum_id") String emenconsum_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEnid(emen_id);
        domain.setEmenconsumid(emenconsum_id);
		emenconsumService.update(domain);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMServiceEMItemEMEN", tags = {"EMENConsum" },  notes = "UpdateBatchByEMServiceEMItemEMEN")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/batch")
    public ResponseEntity<Boolean> updateBatchByEMServiceEMItemEMEN(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
            domain.setEnid(emen_id);
        }
        emenconsumService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMServiceEMItemEMEN", tags = {"EMENConsum" },  notes = "CreateByEMServiceEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums")
    @Transactional
    public ResponseEntity<EMENConsumDTO> createByEMServiceEMItemEMEN(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEnid(emen_id);
		emenconsumService.create(domain);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMServiceEMItemEMEN", tags = {"EMENConsum" },  notes = "createBatchByEMServiceEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/batch")
    public ResponseEntity<Boolean> createBatchByEMServiceEMItemEMEN(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
            domain.setEnid(emen_id);
        }
        emenconsumService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMServiceEMItemEMEN", tags = {"EMENConsum" },  notes = "RemoveByEMServiceEMItemEMEN")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMServiceEMItemEMEN(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @PathVariable("emenconsum_id") String emenconsum_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.remove(emenconsum_id));
    }

    @ApiOperation(value = "RemoveBatchByEMServiceEMItemEMEN", tags = {"EMENConsum" },  notes = "RemoveBatchByEMServiceEMItemEMEN")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/batch")
    public ResponseEntity<Boolean> removeBatchByEMServiceEMItemEMEN(@RequestBody List<String> ids) {
        emenconsumService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMServiceEMItemEMEN", tags = {"EMENConsum" },  notes = "GetDraftByEMServiceEMItemEMEN")
    @RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/getdraft")
    public ResponseEntity<EMENConsumDTO> getDraftByEMServiceEMItemEMEN(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id) {
        EMENConsum domain = new EMENConsum();
        domain.setEnid(emen_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumMapping.toDto(emenconsumService.getDraft(domain)));
    }

    @ApiOperation(value = "CheckKeyByEMServiceEMItemEMEN", tags = {"EMENConsum" },  notes = "CheckKeyByEMServiceEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMServiceEMItemEMEN(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumDTO emenconsumdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emenconsumService.checkKey(emenconsumMapping.toDomain(emenconsumdto)));
    }

	@ApiOperation(value = "fetchDEFAULTByEMServiceEMItemEMEN", tags = {"EMENConsum" } ,notes = "fetchDEFAULTByEMServiceEMItemEMEN")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/fetchdefault")
	public ResponseEntity<List<EMENConsumDTO>> fetchEMENConsumDefaultByEMServiceEMItemEMEN(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id,EMENConsumSearchContext context) {
        context.setN_enid_eq(emen_id);
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
        List<EMENConsumDTO> list = emenconsumMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMServiceEMItemEMEN", tags = {"EMENConsum" } ,notes = "searchDEFAULTByEMServiceEMItemEMEN")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/searchdefault")
	public ResponseEntity<Page<EMENConsumDTO>> searchEMENConsumDefaultByEMServiceEMItemEMEN(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumSearchContext context) {
        context.setN_enid_eq(emen_id);
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emenconsumMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}





    @ApiOperation(value = "SaveByEMStorePartEMItemEMEN", tags = {"EMENConsum" },  notes = "SaveByEMStorePartEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/save")
    public ResponseEntity<Boolean> saveByEMStorePartEMItemEMEN(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEnid(emen_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStorePartEMItemEMEN", tags = {"EMENConsum" },  notes = "SaveBatchByEMStorePartEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStorePartEMItemEMEN(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
             domain.setEnid(emen_id);
        }
        emenconsumService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMStorePartEMItemEMEN", tags = {"EMENConsum" },  notes = "GetByEMStorePartEMItemEMEN")
	@RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/{emenconsum_id}")
    public ResponseEntity<EMENConsumDTO> getByEMStorePartEMItemEMEN(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @PathVariable("emenconsum_id") String emenconsum_id) {
        EMENConsum domain = emenconsumService.get(emenconsum_id);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateByEMStorePartEMItemEMEN", tags = {"EMENConsum" },  notes = "UpdateByEMStorePartEMItemEMEN")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<EMENConsumDTO> updateByEMStorePartEMItemEMEN(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @PathVariable("emenconsum_id") String emenconsum_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEnid(emen_id);
        domain.setEmenconsumid(emenconsum_id);
		emenconsumService.update(domain);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStorePartEMItemEMEN", tags = {"EMENConsum" },  notes = "UpdateBatchByEMStorePartEMItemEMEN")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/batch")
    public ResponseEntity<Boolean> updateBatchByEMStorePartEMItemEMEN(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
            domain.setEnid(emen_id);
        }
        emenconsumService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMStorePartEMItemEMEN", tags = {"EMENConsum" },  notes = "CreateByEMStorePartEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums")
    @Transactional
    public ResponseEntity<EMENConsumDTO> createByEMStorePartEMItemEMEN(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEnid(emen_id);
		emenconsumService.create(domain);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStorePartEMItemEMEN", tags = {"EMENConsum" },  notes = "createBatchByEMStorePartEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/batch")
    public ResponseEntity<Boolean> createBatchByEMStorePartEMItemEMEN(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
            domain.setEnid(emen_id);
        }
        emenconsumService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMStorePartEMItemEMEN", tags = {"EMENConsum" },  notes = "RemoveByEMStorePartEMItemEMEN")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStorePartEMItemEMEN(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @PathVariable("emenconsum_id") String emenconsum_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.remove(emenconsum_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStorePartEMItemEMEN", tags = {"EMENConsum" },  notes = "RemoveBatchByEMStorePartEMItemEMEN")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/batch")
    public ResponseEntity<Boolean> removeBatchByEMStorePartEMItemEMEN(@RequestBody List<String> ids) {
        emenconsumService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMStorePartEMItemEMEN", tags = {"EMENConsum" },  notes = "GetDraftByEMStorePartEMItemEMEN")
    @RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/getdraft")
    public ResponseEntity<EMENConsumDTO> getDraftByEMStorePartEMItemEMEN(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id) {
        EMENConsum domain = new EMENConsum();
        domain.setEnid(emen_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumMapping.toDto(emenconsumService.getDraft(domain)));
    }

    @ApiOperation(value = "CheckKeyByEMStorePartEMItemEMEN", tags = {"EMENConsum" },  notes = "CheckKeyByEMStorePartEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStorePartEMItemEMEN(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumDTO emenconsumdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emenconsumService.checkKey(emenconsumMapping.toDomain(emenconsumdto)));
    }

	@ApiOperation(value = "fetchDEFAULTByEMStorePartEMItemEMEN", tags = {"EMENConsum" } ,notes = "fetchDEFAULTByEMStorePartEMItemEMEN")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/fetchdefault")
	public ResponseEntity<List<EMENConsumDTO>> fetchEMENConsumDefaultByEMStorePartEMItemEMEN(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id,EMENConsumSearchContext context) {
        context.setN_enid_eq(emen_id);
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
        List<EMENConsumDTO> list = emenconsumMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStorePartEMItemEMEN", tags = {"EMENConsum" } ,notes = "searchDEFAULTByEMStorePartEMItemEMEN")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/searchdefault")
	public ResponseEntity<Page<EMENConsumDTO>> searchEMENConsumDefaultByEMStorePartEMItemEMEN(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumSearchContext context) {
        context.setN_enid_eq(emen_id);
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emenconsumMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}





    @ApiOperation(value = "SaveByEMStoreEMItemEMEN", tags = {"EMENConsum" },  notes = "SaveByEMStoreEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/save")
    public ResponseEntity<Boolean> saveByEMStoreEMItemEMEN(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEnid(emen_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStoreEMItemEMEN", tags = {"EMENConsum" },  notes = "SaveBatchByEMStoreEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMItemEMEN(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
             domain.setEnid(emen_id);
        }
        emenconsumService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMStoreEMItemEMEN", tags = {"EMENConsum" },  notes = "GetByEMStoreEMItemEMEN")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/{emenconsum_id}")
    public ResponseEntity<EMENConsumDTO> getByEMStoreEMItemEMEN(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @PathVariable("emenconsum_id") String emenconsum_id) {
        EMENConsum domain = emenconsumService.get(emenconsum_id);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateByEMStoreEMItemEMEN", tags = {"EMENConsum" },  notes = "UpdateByEMStoreEMItemEMEN")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<EMENConsumDTO> updateByEMStoreEMItemEMEN(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @PathVariable("emenconsum_id") String emenconsum_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEnid(emen_id);
        domain.setEmenconsumid(emenconsum_id);
		emenconsumService.update(domain);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStoreEMItemEMEN", tags = {"EMENConsum" },  notes = "UpdateBatchByEMStoreEMItemEMEN")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMItemEMEN(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
            domain.setEnid(emen_id);
        }
        emenconsumService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMStoreEMItemEMEN", tags = {"EMENConsum" },  notes = "CreateByEMStoreEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums")
    @Transactional
    public ResponseEntity<EMENConsumDTO> createByEMStoreEMItemEMEN(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEnid(emen_id);
		emenconsumService.create(domain);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStoreEMItemEMEN", tags = {"EMENConsum" },  notes = "createBatchByEMStoreEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMItemEMEN(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
            domain.setEnid(emen_id);
        }
        emenconsumService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMStoreEMItemEMEN", tags = {"EMENConsum" },  notes = "RemoveByEMStoreEMItemEMEN")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMItemEMEN(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @PathVariable("emenconsum_id") String emenconsum_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.remove(emenconsum_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStoreEMItemEMEN", tags = {"EMENConsum" },  notes = "RemoveBatchByEMStoreEMItemEMEN")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMItemEMEN(@RequestBody List<String> ids) {
        emenconsumService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMStoreEMItemEMEN", tags = {"EMENConsum" },  notes = "GetDraftByEMStoreEMItemEMEN")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/getdraft")
    public ResponseEntity<EMENConsumDTO> getDraftByEMStoreEMItemEMEN(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id) {
        EMENConsum domain = new EMENConsum();
        domain.setEnid(emen_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumMapping.toDto(emenconsumService.getDraft(domain)));
    }

    @ApiOperation(value = "CheckKeyByEMStoreEMItemEMEN", tags = {"EMENConsum" },  notes = "CheckKeyByEMStoreEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMItemEMEN(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumDTO emenconsumdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emenconsumService.checkKey(emenconsumMapping.toDomain(emenconsumdto)));
    }

	@ApiOperation(value = "fetchDEFAULTByEMStoreEMItemEMEN", tags = {"EMENConsum" } ,notes = "fetchDEFAULTByEMStoreEMItemEMEN")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/fetchdefault")
	public ResponseEntity<List<EMENConsumDTO>> fetchEMENConsumDefaultByEMStoreEMItemEMEN(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id,EMENConsumSearchContext context) {
        context.setN_enid_eq(emen_id);
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
        List<EMENConsumDTO> list = emenconsumMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStoreEMItemEMEN", tags = {"EMENConsum" } ,notes = "searchDEFAULTByEMStoreEMItemEMEN")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/searchdefault")
	public ResponseEntity<Page<EMENConsumDTO>> searchEMENConsumDefaultByEMStoreEMItemEMEN(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumSearchContext context) {
        context.setN_enid_eq(emen_id);
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emenconsumMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}





    @ApiOperation(value = "SaveByPFEmpEMItemEMEN", tags = {"EMENConsum" },  notes = "SaveByPFEmpEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/save")
    public ResponseEntity<Boolean> saveByPFEmpEMItemEMEN(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEnid(emen_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFEmpEMItemEMEN", tags = {"EMENConsum" },  notes = "SaveBatchByPFEmpEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFEmpEMItemEMEN(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
             domain.setEnid(emen_id);
        }
        emenconsumService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByPFEmpEMItemEMEN", tags = {"EMENConsum" },  notes = "GetByPFEmpEMItemEMEN")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/{emenconsum_id}")
    public ResponseEntity<EMENConsumDTO> getByPFEmpEMItemEMEN(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @PathVariable("emenconsum_id") String emenconsum_id) {
        EMENConsum domain = emenconsumService.get(emenconsum_id);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateByPFEmpEMItemEMEN", tags = {"EMENConsum" },  notes = "UpdateByPFEmpEMItemEMEN")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<EMENConsumDTO> updateByPFEmpEMItemEMEN(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @PathVariable("emenconsum_id") String emenconsum_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEnid(emen_id);
        domain.setEmenconsumid(emenconsum_id);
		emenconsumService.update(domain);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFEmpEMItemEMEN", tags = {"EMENConsum" },  notes = "UpdateBatchByPFEmpEMItemEMEN")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/batch")
    public ResponseEntity<Boolean> updateBatchByPFEmpEMItemEMEN(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
            domain.setEnid(emen_id);
        }
        emenconsumService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByPFEmpEMItemEMEN", tags = {"EMENConsum" },  notes = "CreateByPFEmpEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums")
    @Transactional
    public ResponseEntity<EMENConsumDTO> createByPFEmpEMItemEMEN(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEnid(emen_id);
		emenconsumService.create(domain);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFEmpEMItemEMEN", tags = {"EMENConsum" },  notes = "createBatchByPFEmpEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/batch")
    public ResponseEntity<Boolean> createBatchByPFEmpEMItemEMEN(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
            domain.setEnid(emen_id);
        }
        emenconsumService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByPFEmpEMItemEMEN", tags = {"EMENConsum" },  notes = "RemoveByPFEmpEMItemEMEN")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFEmpEMItemEMEN(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @PathVariable("emenconsum_id") String emenconsum_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.remove(emenconsum_id));
    }

    @ApiOperation(value = "RemoveBatchByPFEmpEMItemEMEN", tags = {"EMENConsum" },  notes = "RemoveBatchByPFEmpEMItemEMEN")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/batch")
    public ResponseEntity<Boolean> removeBatchByPFEmpEMItemEMEN(@RequestBody List<String> ids) {
        emenconsumService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFEmpEMItemEMEN", tags = {"EMENConsum" },  notes = "GetDraftByPFEmpEMItemEMEN")
    @RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/getdraft")
    public ResponseEntity<EMENConsumDTO> getDraftByPFEmpEMItemEMEN(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id) {
        EMENConsum domain = new EMENConsum();
        domain.setEnid(emen_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumMapping.toDto(emenconsumService.getDraft(domain)));
    }

    @ApiOperation(value = "CheckKeyByPFEmpEMItemEMEN", tags = {"EMENConsum" },  notes = "CheckKeyByPFEmpEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFEmpEMItemEMEN(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumDTO emenconsumdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emenconsumService.checkKey(emenconsumMapping.toDomain(emenconsumdto)));
    }

	@ApiOperation(value = "fetchDEFAULTByPFEmpEMItemEMEN", tags = {"EMENConsum" } ,notes = "fetchDEFAULTByPFEmpEMItemEMEN")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/fetchdefault")
	public ResponseEntity<List<EMENConsumDTO>> fetchEMENConsumDefaultByPFEmpEMItemEMEN(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id,EMENConsumSearchContext context) {
        context.setN_enid_eq(emen_id);
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
        List<EMENConsumDTO> list = emenconsumMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFEmpEMItemEMEN", tags = {"EMENConsum" } ,notes = "searchDEFAULTByPFEmpEMItemEMEN")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/searchdefault")
	public ResponseEntity<Page<EMENConsumDTO>> searchEMENConsumDefaultByPFEmpEMItemEMEN(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumSearchContext context) {
        context.setN_enid_eq(emen_id);
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emenconsumMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}





    @ApiOperation(value = "SaveByPFUnitEMItemEMEN", tags = {"EMENConsum" },  notes = "SaveByPFUnitEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/save")
    public ResponseEntity<Boolean> saveByPFUnitEMItemEMEN(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEnid(emen_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFUnitEMItemEMEN", tags = {"EMENConsum" },  notes = "SaveBatchByPFUnitEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFUnitEMItemEMEN(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
             domain.setEnid(emen_id);
        }
        emenconsumService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByPFUnitEMItemEMEN", tags = {"EMENConsum" },  notes = "GetByPFUnitEMItemEMEN")
	@RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/{emenconsum_id}")
    public ResponseEntity<EMENConsumDTO> getByPFUnitEMItemEMEN(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @PathVariable("emenconsum_id") String emenconsum_id) {
        EMENConsum domain = emenconsumService.get(emenconsum_id);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateByPFUnitEMItemEMEN", tags = {"EMENConsum" },  notes = "UpdateByPFUnitEMItemEMEN")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<EMENConsumDTO> updateByPFUnitEMItemEMEN(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @PathVariable("emenconsum_id") String emenconsum_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEnid(emen_id);
        domain.setEmenconsumid(emenconsum_id);
		emenconsumService.update(domain);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFUnitEMItemEMEN", tags = {"EMENConsum" },  notes = "UpdateBatchByPFUnitEMItemEMEN")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/batch")
    public ResponseEntity<Boolean> updateBatchByPFUnitEMItemEMEN(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
            domain.setEnid(emen_id);
        }
        emenconsumService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByPFUnitEMItemEMEN", tags = {"EMENConsum" },  notes = "CreateByPFUnitEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums")
    @Transactional
    public ResponseEntity<EMENConsumDTO> createByPFUnitEMItemEMEN(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEnid(emen_id);
		emenconsumService.create(domain);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFUnitEMItemEMEN", tags = {"EMENConsum" },  notes = "createBatchByPFUnitEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/batch")
    public ResponseEntity<Boolean> createBatchByPFUnitEMItemEMEN(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
            domain.setEnid(emen_id);
        }
        emenconsumService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByPFUnitEMItemEMEN", tags = {"EMENConsum" },  notes = "RemoveByPFUnitEMItemEMEN")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFUnitEMItemEMEN(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @PathVariable("emenconsum_id") String emenconsum_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.remove(emenconsum_id));
    }

    @ApiOperation(value = "RemoveBatchByPFUnitEMItemEMEN", tags = {"EMENConsum" },  notes = "RemoveBatchByPFUnitEMItemEMEN")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/batch")
    public ResponseEntity<Boolean> removeBatchByPFUnitEMItemEMEN(@RequestBody List<String> ids) {
        emenconsumService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFUnitEMItemEMEN", tags = {"EMENConsum" },  notes = "GetDraftByPFUnitEMItemEMEN")
    @RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/getdraft")
    public ResponseEntity<EMENConsumDTO> getDraftByPFUnitEMItemEMEN(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id) {
        EMENConsum domain = new EMENConsum();
        domain.setEnid(emen_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumMapping.toDto(emenconsumService.getDraft(domain)));
    }

    @ApiOperation(value = "CheckKeyByPFUnitEMItemEMEN", tags = {"EMENConsum" },  notes = "CheckKeyByPFUnitEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFUnitEMItemEMEN(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumDTO emenconsumdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emenconsumService.checkKey(emenconsumMapping.toDomain(emenconsumdto)));
    }

	@ApiOperation(value = "fetchDEFAULTByPFUnitEMItemEMEN", tags = {"EMENConsum" } ,notes = "fetchDEFAULTByPFUnitEMItemEMEN")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/fetchdefault")
	public ResponseEntity<List<EMENConsumDTO>> fetchEMENConsumDefaultByPFUnitEMItemEMEN(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id,EMENConsumSearchContext context) {
        context.setN_enid_eq(emen_id);
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
        List<EMENConsumDTO> list = emenconsumMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFUnitEMItemEMEN", tags = {"EMENConsum" } ,notes = "searchDEFAULTByPFUnitEMItemEMEN")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/searchdefault")
	public ResponseEntity<Page<EMENConsumDTO>> searchEMENConsumDefaultByPFUnitEMItemEMEN(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumSearchContext context) {
        context.setN_enid_eq(emen_id);
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emenconsumMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}






    @ApiOperation(value = "SaveByEMStoreEMStorePartEMItemEMEN", tags = {"EMENConsum" },  notes = "SaveByEMStoreEMStorePartEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/save")
    public ResponseEntity<Boolean> saveByEMStoreEMStorePartEMItemEMEN(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEnid(emen_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStoreEMStorePartEMItemEMEN", tags = {"EMENConsum" },  notes = "SaveBatchByEMStoreEMStorePartEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMStorePartEMItemEMEN(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
             domain.setEnid(emen_id);
        }
        emenconsumService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMStoreEMStorePartEMItemEMEN", tags = {"EMENConsum" },  notes = "GetByEMStoreEMStorePartEMItemEMEN")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/{emenconsum_id}")
    public ResponseEntity<EMENConsumDTO> getByEMStoreEMStorePartEMItemEMEN(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @PathVariable("emenconsum_id") String emenconsum_id) {
        EMENConsum domain = emenconsumService.get(emenconsum_id);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateByEMStoreEMStorePartEMItemEMEN", tags = {"EMENConsum" },  notes = "UpdateByEMStoreEMStorePartEMItemEMEN")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<EMENConsumDTO> updateByEMStoreEMStorePartEMItemEMEN(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @PathVariable("emenconsum_id") String emenconsum_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEnid(emen_id);
        domain.setEmenconsumid(emenconsum_id);
		emenconsumService.update(domain);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStoreEMStorePartEMItemEMEN", tags = {"EMENConsum" },  notes = "UpdateBatchByEMStoreEMStorePartEMItemEMEN")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMStorePartEMItemEMEN(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
            domain.setEnid(emen_id);
        }
        emenconsumService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMStoreEMStorePartEMItemEMEN", tags = {"EMENConsum" },  notes = "CreateByEMStoreEMStorePartEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums")
    @Transactional
    public ResponseEntity<EMENConsumDTO> createByEMStoreEMStorePartEMItemEMEN(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumDTO emenconsumdto) {
        EMENConsum domain = emenconsumMapping.toDomain(emenconsumdto);
        domain.setEnid(emen_id);
		emenconsumService.create(domain);
        EMENConsumDTO dto = emenconsumMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStoreEMStorePartEMItemEMEN", tags = {"EMENConsum" },  notes = "createBatchByEMStoreEMStorePartEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMStorePartEMItemEMEN(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody List<EMENConsumDTO> emenconsumdtos) {
        List<EMENConsum> domainlist=emenconsumMapping.toDomain(emenconsumdtos);
        for(EMENConsum domain:domainlist){
            domain.setEnid(emen_id);
        }
        emenconsumService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMStoreEMStorePartEMItemEMEN", tags = {"EMENConsum" },  notes = "RemoveByEMStoreEMStorePartEMItemEMEN")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/{emenconsum_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMStorePartEMItemEMEN(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @PathVariable("emenconsum_id") String emenconsum_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emenconsumService.remove(emenconsum_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStoreEMStorePartEMItemEMEN", tags = {"EMENConsum" },  notes = "RemoveBatchByEMStoreEMStorePartEMItemEMEN")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMStorePartEMItemEMEN(@RequestBody List<String> ids) {
        emenconsumService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMStoreEMStorePartEMItemEMEN", tags = {"EMENConsum" },  notes = "GetDraftByEMStoreEMStorePartEMItemEMEN")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/getdraft")
    public ResponseEntity<EMENConsumDTO> getDraftByEMStoreEMStorePartEMItemEMEN(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id) {
        EMENConsum domain = new EMENConsum();
        domain.setEnid(emen_id);
        return ResponseEntity.status(HttpStatus.OK).body(emenconsumMapping.toDto(emenconsumService.getDraft(domain)));
    }

    @ApiOperation(value = "CheckKeyByEMStoreEMStorePartEMItemEMEN", tags = {"EMENConsum" },  notes = "CheckKeyByEMStoreEMStorePartEMItemEMEN")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMStorePartEMItemEMEN(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumDTO emenconsumdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emenconsumService.checkKey(emenconsumMapping.toDomain(emenconsumdto)));
    }

	@ApiOperation(value = "fetchDEFAULTByEMStoreEMStorePartEMItemEMEN", tags = {"EMENConsum" } ,notes = "fetchDEFAULTByEMStoreEMStorePartEMItemEMEN")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/fetchdefault")
	public ResponseEntity<List<EMENConsumDTO>> fetchEMENConsumDefaultByEMStoreEMStorePartEMItemEMEN(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id,EMENConsumSearchContext context) {
        context.setN_enid_eq(emen_id);
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
        List<EMENConsumDTO> list = emenconsumMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStoreEMStorePartEMItemEMEN", tags = {"EMENConsum" } ,notes = "searchDEFAULTByEMStoreEMStorePartEMItemEMEN")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emen/{emen_id}/emenconsums/searchdefault")
	public ResponseEntity<Page<EMENConsumDTO>> searchEMENConsumDefaultByEMStoreEMStorePartEMItemEMEN(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emen_id") String emen_id, @RequestBody EMENConsumSearchContext context) {
        context.setN_enid_eq(emen_id);
        Page<EMENConsum> domains = emenconsumService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emenconsumMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMENConsum getEntity(){
        return new EMENConsum();
    }

}
