package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEITIRes;
import cn.ibizlab.eam.core.eam_core.service.IEMEITIResService;
import cn.ibizlab.eam.core.eam_core.filter.EMEITIResSearchContext;




@Slf4j
@Api(tags = {"EMEITIRes" })
@RestController("WebApi-emeitires")
@RequestMapping("")
public class EMEITIResResource {

    @Autowired
    private IEMEITIResService emeitiresService;

    @Autowired
    @Lazy
    private EMEITIResMapping emeitiresMapping;




    @ApiOperation(value = "GetDraft", tags = {"EMEITIRes" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeitires/getdraft")
    public ResponseEntity<EMEITIResDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeitiresMapping.toDto(emeitiresService.getDraft(new EMEITIRes())));
    }




    @ApiOperation(value = "Save", tags = {"EMEITIRes" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeitires/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEITIResDTO emeitiresdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeitiresService.save(emeitiresMapping.toDomain(emeitiresdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMEITIRes" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeitires/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEITIResDTO> emeitiresdtos) {
        emeitiresService.saveBatch(emeitiresMapping.toDomain(emeitiresdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeitires_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMEITIRes" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeitires/{emeitires_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeitires_id") String emeitires_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeitiresService.remove(emeitires_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMEITIRes" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeitires/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeitiresService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMEITIRes" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeitires")
    @Transactional
    public ResponseEntity<EMEITIResDTO> create(@RequestBody EMEITIResDTO emeitiresdto) {
        EMEITIRes domain = emeitiresMapping.toDomain(emeitiresdto);
		emeitiresService.create(domain);
        EMEITIResDTO dto = emeitiresMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMEITIRes" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeitires/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEITIResDTO> emeitiresdtos) {
        emeitiresService.createBatch(emeitiresMapping.toDomain(emeitiresdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeitires_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMEITIRes" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeitires/{emeitires_id}")
    public ResponseEntity<EMEITIResDTO> get(@PathVariable("emeitires_id") String emeitires_id) {
        EMEITIRes domain = emeitiresService.get(emeitires_id);
        EMEITIResDTO dto = emeitiresMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMEITIRes" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeitires/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEITIResDTO emeitiresdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeitiresService.checkKey(emeitiresMapping.toDomain(emeitiresdto)));
    }




    @PreAuthorize("hasPermission(#emeitires_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMEITIRes" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeitires/{emeitires_id}")
    @Transactional
    public ResponseEntity<EMEITIResDTO> update(@PathVariable("emeitires_id") String emeitires_id, @RequestBody EMEITIResDTO emeitiresdto) {
		EMEITIRes domain = emeitiresMapping.toDomain(emeitiresdto);
        domain.setEmeitiresid(emeitires_id);
		emeitiresService.update(domain);
		EMEITIResDTO dto = emeitiresMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emeitires_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEITIRes" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeitires/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEITIResDTO> emeitiresdtos) {
        emeitiresService.updateBatch(emeitiresMapping.toDomain(emeitiresdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEITIRes-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEITIRes" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeitires/fetchdefault")
	public ResponseEntity<List<EMEITIResDTO>> fetchDefault(EMEITIResSearchContext context) {
        Page<EMEITIRes> domains = emeitiresService.searchDefault(context) ;
        List<EMEITIResDTO> list = emeitiresMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEITIRes-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEITIRes" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeitires/searchdefault")
	public ResponseEntity<Page<EMEITIResDTO>> searchDefault(@RequestBody EMEITIResSearchContext context) {
        Page<EMEITIRes> domains = emeitiresService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeitiresMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMEITIRes getEntity(){
        return new EMEITIRes();
    }

}
