package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMDRWG;
import cn.ibizlab.eam.core.eam_core.service.IEMDRWGService;
import cn.ibizlab.eam.core.eam_core.filter.EMDRWGSearchContext;




@Slf4j
@Api(tags = {"EMDRWG" })
@RestController("WebApi-emdrwg")
@RequestMapping("")
public class EMDRWGResource {

    @Autowired
    private IEMDRWGService emdrwgService;

    @Autowired
    @Lazy
    private EMDRWGMapping emdrwgMapping;




    @PreAuthorize("hasPermission(#emdrwg_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMDRWG" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emdrwgs/{emdrwg_id}")
    @Transactional
    public ResponseEntity<EMDRWGDTO> update(@PathVariable("emdrwg_id") String emdrwg_id, @RequestBody EMDRWGDTO emdrwgdto) {
		EMDRWG domain = emdrwgMapping.toDomain(emdrwgdto);
        domain.setEmdrwgid(emdrwg_id);
		emdrwgService.update(domain);
		EMDRWGDTO dto = emdrwgMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emdrwg_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMDRWG" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emdrwgs/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMDRWGDTO> emdrwgdtos) {
        emdrwgService.updateBatch(emdrwgMapping.toDomain(emdrwgdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMDRWG" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emdrwgs/getdraft")
    public ResponseEntity<EMDRWGDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emdrwgMapping.toDto(emdrwgService.getDraft(new EMDRWG())));
    }




    @ApiOperation(value = "Save", tags = {"EMDRWG" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emdrwgs/save")
    public ResponseEntity<Boolean> save(@RequestBody EMDRWGDTO emdrwgdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emdrwgService.save(emdrwgMapping.toDomain(emdrwgdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMDRWG" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emdrwgs/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMDRWGDTO> emdrwgdtos) {
        emdrwgService.saveBatch(emdrwgMapping.toDomain(emdrwgdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMDRWG" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emdrwgs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMDRWGDTO emdrwgdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emdrwgService.checkKey(emdrwgMapping.toDomain(emdrwgdto)));
    }




    @PreAuthorize("hasPermission(#emdrwg_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMDRWG" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emdrwgs/{emdrwg_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emdrwg_id") String emdrwg_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emdrwgService.remove(emdrwg_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMDRWG" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emdrwgs/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emdrwgService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMDRWG" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emdrwgs")
    @Transactional
    public ResponseEntity<EMDRWGDTO> create(@RequestBody EMDRWGDTO emdrwgdto) {
        EMDRWG domain = emdrwgMapping.toDomain(emdrwgdto);
		emdrwgService.create(domain);
        EMDRWGDTO dto = emdrwgMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMDRWG" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emdrwgs/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMDRWGDTO> emdrwgdtos) {
        emdrwgService.createBatch(emdrwgMapping.toDomain(emdrwgdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emdrwg_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMDRWG" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emdrwgs/{emdrwg_id}")
    public ResponseEntity<EMDRWGDTO> get(@PathVariable("emdrwg_id") String emdrwg_id) {
        EMDRWG domain = emdrwgService.get(emdrwg_id);
        EMDRWGDTO dto = emdrwgMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMDRWG-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMDRWG" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emdrwgs/fetchdefault")
	public ResponseEntity<List<EMDRWGDTO>> fetchDefault(EMDRWGSearchContext context) {
        Page<EMDRWG> domains = emdrwgService.searchDefault(context) ;
        List<EMDRWGDTO> list = emdrwgMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMDRWG-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMDRWG" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emdrwgs/searchdefault")
	public ResponseEntity<Page<EMDRWGDTO>> searchDefault(@RequestBody EMDRWGSearchContext context) {
        Page<EMDRWG> domains = emdrwgService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emdrwgMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "UpdateByPFEmp", tags = {"EMDRWG" },  notes = "UpdateByPFEmp")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emdrwgs/{emdrwg_id}")
    @Transactional
    public ResponseEntity<EMDRWGDTO> updateByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emdrwg_id") String emdrwg_id, @RequestBody EMDRWGDTO emdrwgdto) {
        EMDRWG domain = emdrwgMapping.toDomain(emdrwgdto);
        domain.setBpersonid(pfemp_id);
        domain.setEmdrwgid(emdrwg_id);
		emdrwgService.update(domain);
        EMDRWGDTO dto = emdrwgMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFEmp", tags = {"EMDRWG" },  notes = "UpdateBatchByPFEmp")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emdrwgs/batch")
    public ResponseEntity<Boolean> updateBatchByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody List<EMDRWGDTO> emdrwgdtos) {
        List<EMDRWG> domainlist=emdrwgMapping.toDomain(emdrwgdtos);
        for(EMDRWG domain:domainlist){
            domain.setBpersonid(pfemp_id);
        }
        emdrwgService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFEmp", tags = {"EMDRWG" },  notes = "GetDraftByPFEmp")
    @RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emdrwgs/getdraft")
    public ResponseEntity<EMDRWGDTO> getDraftByPFEmp(@PathVariable("pfemp_id") String pfemp_id) {
        EMDRWG domain = new EMDRWG();
        domain.setBpersonid(pfemp_id);
        return ResponseEntity.status(HttpStatus.OK).body(emdrwgMapping.toDto(emdrwgService.getDraft(domain)));
    }

    @ApiOperation(value = "SaveByPFEmp", tags = {"EMDRWG" },  notes = "SaveByPFEmp")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emdrwgs/save")
    public ResponseEntity<Boolean> saveByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody EMDRWGDTO emdrwgdto) {
        EMDRWG domain = emdrwgMapping.toDomain(emdrwgdto);
        domain.setBpersonid(pfemp_id);
        return ResponseEntity.status(HttpStatus.OK).body(emdrwgService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFEmp", tags = {"EMDRWG" },  notes = "SaveBatchByPFEmp")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emdrwgs/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody List<EMDRWGDTO> emdrwgdtos) {
        List<EMDRWG> domainlist=emdrwgMapping.toDomain(emdrwgdtos);
        for(EMDRWG domain:domainlist){
             domain.setBpersonid(pfemp_id);
        }
        emdrwgService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByPFEmp", tags = {"EMDRWG" },  notes = "CheckKeyByPFEmp")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emdrwgs/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody EMDRWGDTO emdrwgdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emdrwgService.checkKey(emdrwgMapping.toDomain(emdrwgdto)));
    }

    @ApiOperation(value = "RemoveByPFEmp", tags = {"EMDRWG" },  notes = "RemoveByPFEmp")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emdrwgs/{emdrwg_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emdrwg_id") String emdrwg_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emdrwgService.remove(emdrwg_id));
    }

    @ApiOperation(value = "RemoveBatchByPFEmp", tags = {"EMDRWG" },  notes = "RemoveBatchByPFEmp")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emdrwgs/batch")
    public ResponseEntity<Boolean> removeBatchByPFEmp(@RequestBody List<String> ids) {
        emdrwgService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByPFEmp", tags = {"EMDRWG" },  notes = "CreateByPFEmp")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emdrwgs")
    @Transactional
    public ResponseEntity<EMDRWGDTO> createByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody EMDRWGDTO emdrwgdto) {
        EMDRWG domain = emdrwgMapping.toDomain(emdrwgdto);
        domain.setBpersonid(pfemp_id);
		emdrwgService.create(domain);
        EMDRWGDTO dto = emdrwgMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFEmp", tags = {"EMDRWG" },  notes = "createBatchByPFEmp")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emdrwgs/batch")
    public ResponseEntity<Boolean> createBatchByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody List<EMDRWGDTO> emdrwgdtos) {
        List<EMDRWG> domainlist=emdrwgMapping.toDomain(emdrwgdtos);
        for(EMDRWG domain:domainlist){
            domain.setBpersonid(pfemp_id);
        }
        emdrwgService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByPFEmp", tags = {"EMDRWG" },  notes = "GetByPFEmp")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emdrwgs/{emdrwg_id}")
    public ResponseEntity<EMDRWGDTO> getByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emdrwg_id") String emdrwg_id) {
        EMDRWG domain = emdrwgService.get(emdrwg_id);
        EMDRWGDTO dto = emdrwgMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

	@ApiOperation(value = "fetchDEFAULTByPFEmp", tags = {"EMDRWG" } ,notes = "fetchDEFAULTByPFEmp")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emdrwgs/fetchdefault")
	public ResponseEntity<List<EMDRWGDTO>> fetchEMDRWGDefaultByPFEmp(@PathVariable("pfemp_id") String pfemp_id,EMDRWGSearchContext context) {
        context.setN_bpersonid_eq(pfemp_id);
        Page<EMDRWG> domains = emdrwgService.searchDefault(context) ;
        List<EMDRWGDTO> list = emdrwgMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFEmp", tags = {"EMDRWG" } ,notes = "searchDEFAULTByPFEmp")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emdrwgs/searchdefault")
	public ResponseEntity<Page<EMDRWGDTO>> searchEMDRWGDefaultByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody EMDRWGSearchContext context) {
        context.setN_bpersonid_eq(pfemp_id);
        Page<EMDRWG> domains = emdrwgService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emdrwgMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMDRWG getEntity(){
        return new EMDRWG();
    }

}
