package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMAssetClear;
import cn.ibizlab.eam.core.eam_core.service.IEMAssetClearService;
import cn.ibizlab.eam.core.eam_core.filter.EMAssetClearSearchContext;




@Slf4j
@Api(tags = {"EMAssetClear" })
@RestController("WebApi-emassetclear")
@RequestMapping("")
public class EMAssetClearResource {

    @Autowired
    private IEMAssetClearService emassetclearService;

    @Autowired
    @Lazy
    private EMAssetClearMapping emassetclearMapping;




    @ApiOperation(value = "GetDraft", tags = {"EMAssetClear" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emassetclears/getdraft")
    public ResponseEntity<EMAssetClearDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emassetclearMapping.toDto(emassetclearService.getDraft(new EMAssetClear())));
    }




    @ApiOperation(value = "Save", tags = {"EMAssetClear" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emassetclears/save")
    public ResponseEntity<Boolean> save(@RequestBody EMAssetClearDTO emassetcleardto) {
        return ResponseEntity.status(HttpStatus.OK).body(emassetclearService.save(emassetclearMapping.toDomain(emassetcleardto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMAssetClear" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emassetclears/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMAssetClearDTO> emassetcleardtos) {
        emassetclearService.saveBatch(emassetclearMapping.toDomain(emassetcleardtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emassetclear_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMAssetClear" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emassetclears/{emassetclear_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emassetclear_id") String emassetclear_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emassetclearService.remove(emassetclear_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMAssetClear" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emassetclears/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emassetclearService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMAssetClear" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emassetclears/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMAssetClearDTO emassetcleardto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emassetclearService.checkKey(emassetclearMapping.toDomain(emassetcleardto)));
    }




    @PreAuthorize("hasPermission(#emassetclear_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMAssetClear" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emassetclears/{emassetclear_id}")
    public ResponseEntity<EMAssetClearDTO> get(@PathVariable("emassetclear_id") String emassetclear_id) {
        EMAssetClear domain = emassetclearService.get(emassetclear_id);
        EMAssetClearDTO dto = emassetclearMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @PreAuthorize("hasPermission(#emassetclear_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMAssetClear" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emassetclears/{emassetclear_id}")
    @Transactional
    public ResponseEntity<EMAssetClearDTO> update(@PathVariable("emassetclear_id") String emassetclear_id, @RequestBody EMAssetClearDTO emassetcleardto) {
		EMAssetClear domain = emassetclearMapping.toDomain(emassetcleardto);
        domain.setEmassetclearid(emassetclear_id);
		emassetclearService.update(domain);
		EMAssetClearDTO dto = emassetclearMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emassetclear_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMAssetClear" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emassetclears/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMAssetClearDTO> emassetcleardtos) {
        emassetclearService.updateBatch(emassetclearMapping.toDomain(emassetcleardtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMAssetClear" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emassetclears")
    @Transactional
    public ResponseEntity<EMAssetClearDTO> create(@RequestBody EMAssetClearDTO emassetcleardto) {
        EMAssetClear domain = emassetclearMapping.toDomain(emassetcleardto);
		emassetclearService.create(domain);
        EMAssetClearDTO dto = emassetclearMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMAssetClear" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emassetclears/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMAssetClearDTO> emassetcleardtos) {
        emassetclearService.createBatch(emassetclearMapping.toDomain(emassetcleardtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMAssetClear-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMAssetClear" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emassetclears/fetchdefault")
	public ResponseEntity<List<EMAssetClearDTO>> fetchDefault(EMAssetClearSearchContext context) {
        Page<EMAssetClear> domains = emassetclearService.searchDefault(context) ;
        List<EMAssetClearDTO> list = emassetclearMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMAssetClear-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMAssetClear" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emassetclears/searchdefault")
	public ResponseEntity<Page<EMAssetClearDTO>> searchDefault(@RequestBody EMAssetClearSearchContext context) {
        Page<EMAssetClear> domains = emassetclearService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emassetclearMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "GetDraftByEMAsset", tags = {"EMAssetClear" },  notes = "GetDraftByEMAsset")
    @RequestMapping(method = RequestMethod.GET, value = "/emassets/{emasset_id}/emassetclears/getdraft")
    public ResponseEntity<EMAssetClearDTO> getDraftByEMAsset(@PathVariable("emasset_id") String emasset_id) {
        EMAssetClear domain = new EMAssetClear();
        domain.setEmassetid(emasset_id);
        return ResponseEntity.status(HttpStatus.OK).body(emassetclearMapping.toDto(emassetclearService.getDraft(domain)));
    }

    @ApiOperation(value = "SaveByEMAsset", tags = {"EMAssetClear" },  notes = "SaveByEMAsset")
	@RequestMapping(method = RequestMethod.POST, value = "/emassets/{emasset_id}/emassetclears/save")
    public ResponseEntity<Boolean> saveByEMAsset(@PathVariable("emasset_id") String emasset_id, @RequestBody EMAssetClearDTO emassetcleardto) {
        EMAssetClear domain = emassetclearMapping.toDomain(emassetcleardto);
        domain.setEmassetid(emasset_id);
        return ResponseEntity.status(HttpStatus.OK).body(emassetclearService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMAsset", tags = {"EMAssetClear" },  notes = "SaveBatchByEMAsset")
	@RequestMapping(method = RequestMethod.POST, value = "/emassets/{emasset_id}/emassetclears/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMAsset(@PathVariable("emasset_id") String emasset_id, @RequestBody List<EMAssetClearDTO> emassetcleardtos) {
        List<EMAssetClear> domainlist=emassetclearMapping.toDomain(emassetcleardtos);
        for(EMAssetClear domain:domainlist){
             domain.setEmassetid(emasset_id);
        }
        emassetclearService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMAsset", tags = {"EMAssetClear" },  notes = "RemoveByEMAsset")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emassets/{emasset_id}/emassetclears/{emassetclear_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMAsset(@PathVariable("emasset_id") String emasset_id, @PathVariable("emassetclear_id") String emassetclear_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emassetclearService.remove(emassetclear_id));
    }

    @ApiOperation(value = "RemoveBatchByEMAsset", tags = {"EMAssetClear" },  notes = "RemoveBatchByEMAsset")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emassets/{emasset_id}/emassetclears/batch")
    public ResponseEntity<Boolean> removeBatchByEMAsset(@RequestBody List<String> ids) {
        emassetclearService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMAsset", tags = {"EMAssetClear" },  notes = "CheckKeyByEMAsset")
	@RequestMapping(method = RequestMethod.POST, value = "/emassets/{emasset_id}/emassetclears/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMAsset(@PathVariable("emasset_id") String emasset_id, @RequestBody EMAssetClearDTO emassetcleardto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emassetclearService.checkKey(emassetclearMapping.toDomain(emassetcleardto)));
    }

    @ApiOperation(value = "GetByEMAsset", tags = {"EMAssetClear" },  notes = "GetByEMAsset")
	@RequestMapping(method = RequestMethod.GET, value = "/emassets/{emasset_id}/emassetclears/{emassetclear_id}")
    public ResponseEntity<EMAssetClearDTO> getByEMAsset(@PathVariable("emasset_id") String emasset_id, @PathVariable("emassetclear_id") String emassetclear_id) {
        EMAssetClear domain = emassetclearService.get(emassetclear_id);
        EMAssetClearDTO dto = emassetclearMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateByEMAsset", tags = {"EMAssetClear" },  notes = "UpdateByEMAsset")
	@RequestMapping(method = RequestMethod.PUT, value = "/emassets/{emasset_id}/emassetclears/{emassetclear_id}")
    @Transactional
    public ResponseEntity<EMAssetClearDTO> updateByEMAsset(@PathVariable("emasset_id") String emasset_id, @PathVariable("emassetclear_id") String emassetclear_id, @RequestBody EMAssetClearDTO emassetcleardto) {
        EMAssetClear domain = emassetclearMapping.toDomain(emassetcleardto);
        domain.setEmassetid(emasset_id);
        domain.setEmassetclearid(emassetclear_id);
		emassetclearService.update(domain);
        EMAssetClearDTO dto = emassetclearMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMAsset", tags = {"EMAssetClear" },  notes = "UpdateBatchByEMAsset")
	@RequestMapping(method = RequestMethod.PUT, value = "/emassets/{emasset_id}/emassetclears/batch")
    public ResponseEntity<Boolean> updateBatchByEMAsset(@PathVariable("emasset_id") String emasset_id, @RequestBody List<EMAssetClearDTO> emassetcleardtos) {
        List<EMAssetClear> domainlist=emassetclearMapping.toDomain(emassetcleardtos);
        for(EMAssetClear domain:domainlist){
            domain.setEmassetid(emasset_id);
        }
        emassetclearService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMAsset", tags = {"EMAssetClear" },  notes = "CreateByEMAsset")
	@RequestMapping(method = RequestMethod.POST, value = "/emassets/{emasset_id}/emassetclears")
    @Transactional
    public ResponseEntity<EMAssetClearDTO> createByEMAsset(@PathVariable("emasset_id") String emasset_id, @RequestBody EMAssetClearDTO emassetcleardto) {
        EMAssetClear domain = emassetclearMapping.toDomain(emassetcleardto);
        domain.setEmassetid(emasset_id);
		emassetclearService.create(domain);
        EMAssetClearDTO dto = emassetclearMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMAsset", tags = {"EMAssetClear" },  notes = "createBatchByEMAsset")
	@RequestMapping(method = RequestMethod.POST, value = "/emassets/{emasset_id}/emassetclears/batch")
    public ResponseEntity<Boolean> createBatchByEMAsset(@PathVariable("emasset_id") String emasset_id, @RequestBody List<EMAssetClearDTO> emassetcleardtos) {
        List<EMAssetClear> domainlist=emassetclearMapping.toDomain(emassetcleardtos);
        for(EMAssetClear domain:domainlist){
            domain.setEmassetid(emasset_id);
        }
        emassetclearService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMAsset", tags = {"EMAssetClear" } ,notes = "fetchDEFAULTByEMAsset")
    @RequestMapping(method= RequestMethod.GET , value="/emassets/{emasset_id}/emassetclears/fetchdefault")
	public ResponseEntity<List<EMAssetClearDTO>> fetchEMAssetClearDefaultByEMAsset(@PathVariable("emasset_id") String emasset_id,EMAssetClearSearchContext context) {
        context.setN_emassetid_eq(emasset_id);
        Page<EMAssetClear> domains = emassetclearService.searchDefault(context) ;
        List<EMAssetClearDTO> list = emassetclearMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMAsset", tags = {"EMAssetClear" } ,notes = "searchDEFAULTByEMAsset")
    @RequestMapping(method= RequestMethod.POST , value="/emassets/{emasset_id}/emassetclears/searchdefault")
	public ResponseEntity<Page<EMAssetClearDTO>> searchEMAssetClearDefaultByEMAsset(@PathVariable("emasset_id") String emasset_id, @RequestBody EMAssetClearSearchContext context) {
        context.setN_emassetid_eq(emasset_id);
        Page<EMAssetClear> domains = emassetclearService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emassetclearMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMAssetClear getEntity(){
        return new EMAssetClear();
    }

}
