package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMAssessMX;
import cn.ibizlab.eam.core.eam_core.service.IEMAssessMXService;
import cn.ibizlab.eam.core.eam_core.filter.EMAssessMXSearchContext;




@Slf4j
@Api(tags = {"EMAssessMX" })
@RestController("WebApi-emassessmx")
@RequestMapping("")
public class EMAssessMXResource {

    @Autowired
    private IEMAssessMXService emassessmxService;

    @Autowired
    @Lazy
    private EMAssessMXMapping emassessmxMapping;




    @PreAuthorize("hasPermission(#emassessmx_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMAssessMX" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emassessmxes/{emassessmx_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emassessmx_id") String emassessmx_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emassessmxService.remove(emassessmx_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMAssessMX" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emassessmxes/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emassessmxService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMAssessMX" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emassessmxes")
    @Transactional
    public ResponseEntity<EMAssessMXDTO> create(@RequestBody EMAssessMXDTO emassessmxdto) {
        EMAssessMX domain = emassessmxMapping.toDomain(emassessmxdto);
		emassessmxService.create(domain);
        EMAssessMXDTO dto = emassessmxMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMAssessMX" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emassessmxes/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMAssessMXDTO> emassessmxdtos) {
        emassessmxService.createBatch(emassessmxMapping.toDomain(emassessmxdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMAssessMX" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emassessmxes/getdraft")
    public ResponseEntity<EMAssessMXDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emassessmxMapping.toDto(emassessmxService.getDraft(new EMAssessMX())));
    }




    @PreAuthorize("hasPermission(#emassessmx_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMAssessMX" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emassessmxes/{emassessmx_id}")
    public ResponseEntity<EMAssessMXDTO> get(@PathVariable("emassessmx_id") String emassessmx_id) {
        EMAssessMX domain = emassessmxService.get(emassessmx_id);
        EMAssessMXDTO dto = emassessmxMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMAssessMX" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emassessmxes/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMAssessMXDTO emassessmxdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emassessmxService.checkKey(emassessmxMapping.toDomain(emassessmxdto)));
    }




    @PreAuthorize("hasPermission(#emassessmx_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMAssessMX" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emassessmxes/{emassessmx_id}")
    @Transactional
    public ResponseEntity<EMAssessMXDTO> update(@PathVariable("emassessmx_id") String emassessmx_id, @RequestBody EMAssessMXDTO emassessmxdto) {
		EMAssessMX domain = emassessmxMapping.toDomain(emassessmxdto);
        domain.setEmassessmxid(emassessmx_id);
		emassessmxService.update(domain);
		EMAssessMXDTO dto = emassessmxMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emassessmx_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMAssessMX" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emassessmxes/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMAssessMXDTO> emassessmxdtos) {
        emassessmxService.updateBatch(emassessmxMapping.toDomain(emassessmxdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMAssessMX" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emassessmxes/save")
    public ResponseEntity<Boolean> save(@RequestBody EMAssessMXDTO emassessmxdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emassessmxService.save(emassessmxMapping.toDomain(emassessmxdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMAssessMX" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emassessmxes/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMAssessMXDTO> emassessmxdtos) {
        emassessmxService.saveBatch(emassessmxMapping.toDomain(emassessmxdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMAssessMX-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMAssessMX" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emassessmxes/fetchdefault")
	public ResponseEntity<List<EMAssessMXDTO>> fetchDefault(EMAssessMXSearchContext context) {
        Page<EMAssessMX> domains = emassessmxService.searchDefault(context) ;
        List<EMAssessMXDTO> list = emassessmxMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMAssessMX-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMAssessMX" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emassessmxes/searchdefault")
	public ResponseEntity<Page<EMAssessMXDTO>> searchDefault(@RequestBody EMAssessMXSearchContext context) {
        Page<EMAssessMX> domains = emassessmxService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emassessmxMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMAssessMX getEntity(){
        return new EMAssessMX();
    }

}
