package cn.ibizlab.eam.webapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;
import cn.ibizlab.eam.util.domain.DTOBase;
import lombok.Data;

/**
 * 服务DTO对象[EMMonthlyDTO]
 */
@Data
public class EMMonthlyDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [EMMONTHLYID]
     *
     */
    @JSONField(name = "emmonthlyid")
    @JsonProperty("emmonthlyid")
    private String emmonthlyid;

    /**
     * 属性 [ENABLE]
     *
     */
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;

    /**
     * 属性 [SAFEWORK]
     *
     */
    @JSONField(name = "safework")
    @JsonProperty("safework")
    private String safework;

    /**
     * 属性 [LASTMONTH2]
     *
     */
    @JSONField(name = "lastmonth2")
    @JsonProperty("lastmonth2")
    private String lastmonth2;

    /**
     * 属性 [EMMONTHLYNAME]
     *
     */
    @JSONField(name = "emmonthlyname")
    @JsonProperty("emmonthlyname")
    private String emmonthlyname;

    /**
     * 属性 [LASTMONTH]
     *
     */
    @JSONField(name = "lastmonth")
    @JsonProperty("lastmonth")
    private String lastmonth;

    /**
     * 属性 [THISMONTH]
     *
     */
    @JSONField(name = "thismonth")
    @JsonProperty("thismonth")
    private String thismonth;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;


    /**
     * 设置 [SAFEWORK]
     */
    public void setSafework(String  safework){
        this.safework = safework ;
        this.modify("safework",safework);
    }

    /**
     * 设置 [LASTMONTH2]
     */
    public void setLastmonth2(String  lastmonth2){
        this.lastmonth2 = lastmonth2 ;
        this.modify("lastmonth2",lastmonth2);
    }

    /**
     * 设置 [EMMONTHLYNAME]
     */
    public void setEmmonthlyname(String  emmonthlyname){
        this.emmonthlyname = emmonthlyname ;
        this.modify("emmonthlyname",emmonthlyname);
    }

    /**
     * 设置 [LASTMONTH]
     */
    public void setLastmonth(String  lastmonth){
        this.lastmonth = lastmonth ;
        this.modify("lastmonth",lastmonth);
    }

    /**
     * 设置 [THISMONTH]
     */
    public void setThismonth(String  thismonth){
        this.thismonth = thismonth ;
        this.modify("thismonth",thismonth);
    }


}

