package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_pf.domain.PFTeam;
import cn.ibizlab.eam.core.eam_pf.service.IPFTeamService;
import cn.ibizlab.eam.core.eam_pf.filter.PFTeamSearchContext;




@Slf4j
@Api(tags = {"PFTeam" })
@RestController("WebApi-pfteam")
@RequestMapping("")
public class PFTeamResource {

    @Autowired
    private IPFTeamService pfteamService;

    @Autowired
    @Lazy
    private PFTeamMapping pfteamMapping;




    @PreAuthorize("hasPermission(#pfteam_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"PFTeam" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("pfteam_id") String pfteam_id) {
         return ResponseEntity.status(HttpStatus.OK).body(pfteamService.remove(pfteam_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"PFTeam" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        pfteamService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"PFTeam" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/getdraft")
    public ResponseEntity<PFTeamDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(pfteamMapping.toDto(pfteamService.getDraft(new PFTeam())));
    }




    @ApiOperation(value = "Save", tags = {"PFTeam" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/save")
    public ResponseEntity<Boolean> save(@RequestBody PFTeamDTO pfteamdto) {
        return ResponseEntity.status(HttpStatus.OK).body(pfteamService.save(pfteamMapping.toDomain(pfteamdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"PFTeam" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<PFTeamDTO> pfteamdtos) {
        pfteamService.saveBatch(pfteamMapping.toDomain(pfteamdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"PFTeam" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams")
    @Transactional
    public ResponseEntity<PFTeamDTO> create(@RequestBody PFTeamDTO pfteamdto) {
        PFTeam domain = pfteamMapping.toDomain(pfteamdto);
		pfteamService.create(domain);
        PFTeamDTO dto = pfteamMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"PFTeam" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<PFTeamDTO> pfteamdtos) {
        pfteamService.createBatch(pfteamMapping.toDomain(pfteamdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"PFTeam" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody PFTeamDTO pfteamdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(pfteamService.checkKey(pfteamMapping.toDomain(pfteamdto)));
    }




    @PreAuthorize("hasPermission(#pfteam_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"PFTeam" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}")
    @Transactional
    public ResponseEntity<PFTeamDTO> update(@PathVariable("pfteam_id") String pfteam_id, @RequestBody PFTeamDTO pfteamdto) {
		PFTeam domain = pfteamMapping.toDomain(pfteamdto);
        domain.setPfteamid(pfteam_id);
		pfteamService.update(domain);
		PFTeamDTO dto = pfteamMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#pfteam_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"PFTeam" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<PFTeamDTO> pfteamdtos) {
        pfteamService.updateBatch(pfteamMapping.toDomain(pfteamdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#pfteam_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"PFTeam" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}")
    public ResponseEntity<PFTeamDTO> get(@PathVariable("pfteam_id") String pfteam_id) {
        PFTeam domain = pfteamService.get(pfteam_id);
        PFTeamDTO dto = pfteamMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-PFTeam-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"PFTeam" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/fetchdefault")
	public ResponseEntity<List<PFTeamDTO>> fetchDefault(PFTeamSearchContext context) {
        Page<PFTeam> domains = pfteamService.searchDefault(context) ;
        List<PFTeamDTO> list = pfteamMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-PFTeam-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"PFTeam" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/searchdefault")
	public ResponseEntity<Page<PFTeamDTO>> searchDefault(@RequestBody PFTeamSearchContext context) {
        Page<PFTeam> domains = pfteamService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(pfteamMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public PFTeam getEntity(){
        return new PFTeam();
    }

}
