package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMWPList;
import cn.ibizlab.eam.core.eam_core.service.IEMWPListService;
import cn.ibizlab.eam.core.eam_core.filter.EMWPListSearchContext;




@Slf4j
@Api(tags = {"EMWPList" })
@RestController("WebApi-emwplist")
@RequestMapping("")
public class EMWPListResource {

    @Autowired
    private IEMWPListService emwplistService;

    @Autowired
    @Lazy
    private EMWPListMapping emwplistMapping;




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMWPList" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emwplists")
    @Transactional
    public ResponseEntity<EMWPListDTO> create(@RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
		emwplistService.create(domain);
        EMWPListDTO dto = emwplistMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMWPList" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emwplists/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMWPListDTO> emwplistdtos) {
        emwplistService.createBatch(emwplistMapping.toDomain(emwplistdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emwplist_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMWPList" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emwplists/{emwplist_id}")
    public ResponseEntity<EMWPListDTO> get(@PathVariable("emwplist_id") String emwplist_id) {
        EMWPList domain = emwplistService.get(emwplist_id);
        EMWPListDTO dto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMWPList" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emwplists/getdraft")
    public ResponseEntity<EMWPListDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emwplistMapping.toDto(emwplistService.getDraft(new EMWPList())));
    }




    @ApiOperation(value = "询价填报", tags = {"EMWPList" },  notes = "询价填报")
	@RequestMapping(method = RequestMethod.POST, value = "/emwplists/{emwplist_id}/fillcost")
    @Transactional
    public ResponseEntity<EMWPListDTO> fillCost(@PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList emwplist = emwplistMapping.toDomain(emwplistdto);
        emwplist = emwplistService.fillCost(emwplist);
        emwplistdto = emwplistMapping.toDto(emwplist);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }




    @ApiOperation(value = "根据物品获取采购员", tags = {"EMWPList" },  notes = "根据物品获取采购员")
	@RequestMapping(method = RequestMethod.GET, value = "/emwplists/{emwplist_id}/getremp")
    @Transactional
    public ResponseEntity<EMWPListDTO> getREMP(@PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList emwplist = emwplistMapping.toDomain(emwplistdto);
        emwplist = emwplistService.getREMP(emwplist);
        emwplistdto = emwplistMapping.toDto(emwplist);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }




    @ApiOperation(value = "Save", tags = {"EMWPList" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emwplists/save")
    public ResponseEntity<Boolean> save(@RequestBody EMWPListDTO emwplistdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emwplistService.save(emwplistMapping.toDomain(emwplistdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMWPList" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emwplists/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMWPListDTO> emwplistdtos) {
        emwplistService.saveBatch(emwplistMapping.toDomain(emwplistdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "询价确认", tags = {"EMWPList" },  notes = "询价确认")
	@RequestMapping(method = RequestMethod.POST, value = "/emwplists/{emwplist_id}/confirmcost")
    @Transactional
    public ResponseEntity<EMWPListDTO> confirmCost(@PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList emwplist = emwplistMapping.toDomain(emwplistdto);
        emwplist = emwplistService.confirmCost(emwplist);
        emwplistdto = emwplistMapping.toDto(emwplist);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }




    @ApiOperation(value = "生成订单", tags = {"EMWPList" },  notes = "生成订单")
	@RequestMapping(method = RequestMethod.POST, value = "/emwplists/{emwplist_id}/genpo")
    @Transactional
    public ResponseEntity<EMWPListDTO> genPO(@PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList emwplist = emwplistMapping.toDomain(emwplistdto);
        emwplist = emwplistService.genPO(emwplist);
        emwplistdto = emwplistMapping.toDto(emwplist);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }




    @PreAuthorize("hasPermission(#emwplist_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMWPList" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emwplists/{emwplist_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emwplist_id") String emwplist_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emwplistService.remove(emwplist_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMWPList" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emwplists/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emwplistService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emwplist_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMWPList" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emwplists/{emwplist_id}")
    @Transactional
    public ResponseEntity<EMWPListDTO> update(@PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
		EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setEmwplistid(emwplist_id);
		emwplistService.update(domain);
		EMWPListDTO dto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emwplist_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMWPList" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emwplists/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMWPListDTO> emwplistdtos) {
        emwplistService.updateBatch(emwplistMapping.toDomain(emwplistdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "提交", tags = {"EMWPList" },  notes = "提交")
	@RequestMapping(method = RequestMethod.POST, value = "/emwplists/{emwplist_id}/submit")
    @Transactional
    public ResponseEntity<EMWPListDTO> submit(@PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList emwplist = emwplistMapping.toDomain(emwplistdto);
        emwplist = emwplistService.submit(emwplist);
        emwplistdto = emwplistMapping.toDto(emwplist);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMWPList" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emwplists/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMWPListDTO emwplistdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwplistService.checkKey(emwplistMapping.toDomain(emwplistdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPList-WaitCost-all')")
	@ApiOperation(value = "fetch待询价", tags = {"EMWPList" } ,notes = "fetch待询价")
    @RequestMapping(method= RequestMethod.GET , value="/emwplists/fetchwaitcost")
	public ResponseEntity<List<EMWPListDTO>> fetchWaitCost(EMWPListSearchContext context) {
        Page<EMWPList> domains = emwplistService.searchWaitCost(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPList-WaitCost-all')")
	@ApiOperation(value = "search待询价", tags = {"EMWPList" } ,notes = "search待询价")
    @RequestMapping(method= RequestMethod.POST , value="/emwplists/searchwaitcost")
	public ResponseEntity<Page<EMWPListDTO>> searchWaitCost(@RequestBody EMWPListSearchContext context) {
        Page<EMWPList> domains = emwplistService.searchWaitCost(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPList-WpStateNum-all')")
	@ApiOperation(value = "fetch采购情况统计", tags = {"EMWPList" } ,notes = "fetch采购情况统计")
    @RequestMapping(method= RequestMethod.GET , value="/emwplists/fetchwpstatenum")
	public ResponseEntity<List<HashMap>> fetchWpStateNum(EMWPListSearchContext context) {
        Page<HashMap> domains = emwplistService.searchWpStateNum(context) ;
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPList-WpStateNum-all')")
	@ApiOperation(value = "search采购情况统计", tags = {"EMWPList" } ,notes = "search采购情况统计")
    @RequestMapping(method= RequestMethod.POST , value="/emwplists/searchwpstatenum")
	public ResponseEntity<Page<HashMap>> searchWpStateNum(@RequestBody EMWPListSearchContext context) {
        Page<HashMap> domains = emwplistService.searchWpStateNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPList-Main6-all')")
	@ApiOperation(value = "fetch已生成订单采购申请", tags = {"EMWPList" } ,notes = "fetch已生成订单采购申请")
    @RequestMapping(method= RequestMethod.GET , value="/emwplists/fetchmain6")
	public ResponseEntity<List<EMWPListDTO>> fetchMain6(EMWPListSearchContext context) {
        Page<EMWPList> domains = emwplistService.searchMain6(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPList-Main6-all')")
	@ApiOperation(value = "search已生成订单采购申请", tags = {"EMWPList" } ,notes = "search已生成订单采购申请")
    @RequestMapping(method= RequestMethod.POST , value="/emwplists/searchmain6")
	public ResponseEntity<Page<EMWPListDTO>> searchMain6(@RequestBody EMWPListSearchContext context) {
        Page<EMWPList> domains = emwplistService.searchMain6(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPList-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMWPList" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emwplists/fetchdefault")
	public ResponseEntity<List<EMWPListDTO>> fetchDefault(EMWPListSearchContext context) {
        Page<EMWPList> domains = emwplistService.searchDefault(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPList-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMWPList" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emwplists/searchdefault")
	public ResponseEntity<Page<EMWPListDTO>> searchDefault(@RequestBody EMWPListSearchContext context) {
        Page<EMWPList> domains = emwplistService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPList-Main6_8692-all')")
	@ApiOperation(value = "fetch已到货采购申请", tags = {"EMWPList" } ,notes = "fetch已到货采购申请")
    @RequestMapping(method= RequestMethod.GET , value="/emwplists/fetchmain6_8692")
	public ResponseEntity<List<EMWPListDTO>> fetchMain6_8692(EMWPListSearchContext context) {
        Page<EMWPList> domains = emwplistService.searchMain6_8692(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPList-Main6_8692-all')")
	@ApiOperation(value = "search已到货采购申请", tags = {"EMWPList" } ,notes = "search已到货采购申请")
    @RequestMapping(method= RequestMethod.POST , value="/emwplists/searchmain6_8692")
	public ResponseEntity<Page<EMWPListDTO>> searchMain6_8692(@RequestBody EMWPListSearchContext context) {
        Page<EMWPList> domains = emwplistService.searchMain6_8692(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPList-Cancel-all')")
	@ApiOperation(value = "fetch已取消申请", tags = {"EMWPList" } ,notes = "fetch已取消申请")
    @RequestMapping(method= RequestMethod.GET , value="/emwplists/fetchcancel")
	public ResponseEntity<List<EMWPListDTO>> fetchCancel(EMWPListSearchContext context) {
        Page<EMWPList> domains = emwplistService.searchCancel(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPList-Cancel-all')")
	@ApiOperation(value = "search已取消申请", tags = {"EMWPList" } ,notes = "search已取消申请")
    @RequestMapping(method= RequestMethod.POST , value="/emwplists/searchcancel")
	public ResponseEntity<Page<EMWPListDTO>> searchCancel(@RequestBody EMWPListSearchContext context) {
        Page<EMWPList> domains = emwplistService.searchCancel(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPList-In-all')")
	@ApiOperation(value = "fetch已入库申请", tags = {"EMWPList" } ,notes = "fetch已入库申请")
    @RequestMapping(method= RequestMethod.GET , value="/emwplists/fetchin")
	public ResponseEntity<List<EMWPListDTO>> fetchIn(EMWPListSearchContext context) {
        Page<EMWPList> domains = emwplistService.searchIn(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPList-In-all')")
	@ApiOperation(value = "search已入库申请", tags = {"EMWPList" } ,notes = "search已入库申请")
    @RequestMapping(method= RequestMethod.POST , value="/emwplists/searchin")
	public ResponseEntity<Page<EMWPListDTO>> searchIn(@RequestBody EMWPListSearchContext context) {
        Page<EMWPList> domains = emwplistService.searchIn(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPList-Draft-all')")
	@ApiOperation(value = "fetch草稿", tags = {"EMWPList" } ,notes = "fetch草稿")
    @RequestMapping(method= RequestMethod.GET , value="/emwplists/fetchdraft")
	public ResponseEntity<List<EMWPListDTO>> fetchDraft(EMWPListSearchContext context) {
        Page<EMWPList> domains = emwplistService.searchDraft(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPList-Draft-all')")
	@ApiOperation(value = "search草稿", tags = {"EMWPList" } ,notes = "search草稿")
    @RequestMapping(method= RequestMethod.POST , value="/emwplists/searchdraft")
	public ResponseEntity<Page<EMWPListDTO>> searchDraft(@RequestBody EMWPListSearchContext context) {
        Page<EMWPList> domains = emwplistService.searchDraft(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPList-ConfimCost-all')")
	@ApiOperation(value = "fetch待确认询价", tags = {"EMWPList" } ,notes = "fetch待确认询价")
    @RequestMapping(method= RequestMethod.GET , value="/emwplists/fetchconfimcost")
	public ResponseEntity<List<EMWPListDTO>> fetchConfimCost(EMWPListSearchContext context) {
        Page<EMWPList> domains = emwplistService.searchConfimCost(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPList-ConfimCost-all')")
	@ApiOperation(value = "search待确认询价", tags = {"EMWPList" } ,notes = "search待确认询价")
    @RequestMapping(method= RequestMethod.POST , value="/emwplists/searchconfimcost")
	public ResponseEntity<Page<EMWPListDTO>> searchConfimCost(@RequestBody EMWPListSearchContext context) {
        Page<EMWPList> domains = emwplistService.searchConfimCost(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPList-WaitPo-all')")
	@ApiOperation(value = "fetch待生成订单", tags = {"EMWPList" } ,notes = "fetch待生成订单")
    @RequestMapping(method= RequestMethod.GET , value="/emwplists/fetchwaitpo")
	public ResponseEntity<List<EMWPListDTO>> fetchWaitPo(EMWPListSearchContext context) {
        Page<EMWPList> domains = emwplistService.searchWaitPo(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWPList-WaitPo-all')")
	@ApiOperation(value = "search待生成订单", tags = {"EMWPList" } ,notes = "search待生成订单")
    @RequestMapping(method= RequestMethod.POST , value="/emwplists/searchwaitpo")
	public ResponseEntity<Page<EMWPListDTO>> searchWaitPo(@RequestBody EMWPListSearchContext context) {
        Page<EMWPList> domains = emwplistService.searchWaitPo(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "CreateByEMItem", tags = {"EMWPList" },  notes = "CreateByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emwplists")
    @Transactional
    public ResponseEntity<EMWPListDTO> createByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
		emwplistService.create(domain);
        EMWPListDTO dto = emwplistMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMItem", tags = {"EMWPList" },  notes = "createBatchByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emwplists/batch")
    public ResponseEntity<Boolean> createBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListDTO> emwplistdtos) {
        List<EMWPList> domainlist=emwplistMapping.toDomain(emwplistdtos);
        for(EMWPList domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMItem", tags = {"EMWPList" },  notes = "GetByEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emwplists/{emwplist_id}")
    public ResponseEntity<EMWPListDTO> getByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id) {
        EMWPList domain = emwplistService.get(emwplist_id);
        EMWPListDTO dto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "GetDraftByEMItem", tags = {"EMWPList" },  notes = "GetDraftByEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emwplists/getdraft")
    public ResponseEntity<EMWPListDTO> getDraftByEMItem(@PathVariable("emitem_id") String emitem_id) {
        EMWPList domain = new EMWPList();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistMapping.toDto(emwplistService.getDraft(domain)));
    }

    @ApiOperation(value = "询价填报ByEMItem", tags = {"EMWPList" },  notes = "询价填报ByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/fillcost")
    @Transactional
    public ResponseEntity<EMWPListDTO> fillCostByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.fillCost(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "根据物品获取采购员ByEMItem", tags = {"EMWPList" },  notes = "根据物品获取采购员ByEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/getremp")
    @Transactional
    public ResponseEntity<EMWPListDTO> getREMPByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.getREMP(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "SaveByEMItem", tags = {"EMWPList" },  notes = "SaveByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emwplists/save")
    public ResponseEntity<Boolean> saveByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMItem", tags = {"EMWPList" },  notes = "SaveBatchByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emwplists/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListDTO> emwplistdtos) {
        List<EMWPList> domainlist=emwplistMapping.toDomain(emwplistdtos);
        for(EMWPList domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emwplistService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "询价确认ByEMItem", tags = {"EMWPList" },  notes = "询价确认ByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/confirmcost")
    @Transactional
    public ResponseEntity<EMWPListDTO> confirmCostByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.confirmCost(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "生成订单ByEMItem", tags = {"EMWPList" },  notes = "生成订单ByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/genpo")
    @Transactional
    public ResponseEntity<EMWPListDTO> genPOByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.genPO(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "RemoveByEMItem", tags = {"EMWPList" },  notes = "RemoveByEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emwplists/{emwplist_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwplistService.remove(emwplist_id));
    }

    @ApiOperation(value = "RemoveBatchByEMItem", tags = {"EMWPList" },  notes = "RemoveBatchByEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emwplists/batch")
    public ResponseEntity<Boolean> removeBatchByEMItem(@RequestBody List<String> ids) {
        emwplistService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMItem", tags = {"EMWPList" },  notes = "UpdateByEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emwplists/{emwplist_id}")
    @Transactional
    public ResponseEntity<EMWPListDTO> updateByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain.setEmwplistid(emwplist_id);
		emwplistService.update(domain);
        EMWPListDTO dto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMItem", tags = {"EMWPList" },  notes = "UpdateBatchByEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emwplists/batch")
    public ResponseEntity<Boolean> updateBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListDTO> emwplistdtos) {
        List<EMWPList> domainlist=emwplistMapping.toDomain(emwplistdtos);
        for(EMWPList domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "提交ByEMItem", tags = {"EMWPList" },  notes = "提交ByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/submit")
    @Transactional
    public ResponseEntity<EMWPListDTO> submitByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.submit(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "CheckKeyByEMItem", tags = {"EMWPList" },  notes = "CheckKeyByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emwplists/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListDTO emwplistdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwplistService.checkKey(emwplistMapping.toDomain(emwplistdto)));
    }

	@ApiOperation(value = "fetch待询价ByEMItem", tags = {"EMWPList" } ,notes = "fetch待询价ByEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/emwplists/fetchwaitcost")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListWaitCostByEMItem(@PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitCost(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search待询价ByEMItem", tags = {"EMWPList" } ,notes = "search待询价ByEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/emwplists/searchwaitcost")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListWaitCostByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitCost(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch采购情况统计ByEMItem", tags = {"EMWPList" } ,notes = "fetch采购情况统计ByEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/emwplists/fetchwpstatenum")
	public ResponseEntity<List<HashMap>> fetchEMWPListWpStateNumByEMItem(@PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = emwplistService.searchWpStateNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

	@ApiOperation(value = "search采购情况统计ByEMItem", tags = {"EMWPList" } ,notes = "search采购情况统计ByEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/emwplists/searchwpstatenum")
	public ResponseEntity<Page<HashMap>> searchEMWPListWpStateNumByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = emwplistService.searchWpStateNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已生成订单采购申请ByEMItem", tags = {"EMWPList" } ,notes = "fetch已生成订单采购申请ByEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/emwplists/fetchmain6")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListMain6ByEMItem(@PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已生成订单采购申请ByEMItem", tags = {"EMWPList" } ,notes = "search已生成订单采购申请ByEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/emwplists/searchmain6")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListMain6ByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchDEFAULTByEMItem", tags = {"EMWPList" } ,notes = "fetchDEFAULTByEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/emwplists/fetchdefault")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListDefaultByEMItem(@PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDefault(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMItem", tags = {"EMWPList" } ,notes = "searchDEFAULTByEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/emwplists/searchdefault")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListDefaultByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已到货采购申请ByEMItem", tags = {"EMWPList" } ,notes = "fetch已到货采购申请ByEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/emwplists/fetchmain6_8692")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListMain6_8692ByEMItem(@PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6_8692(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已到货采购申请ByEMItem", tags = {"EMWPList" } ,notes = "search已到货采购申请ByEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/emwplists/searchmain6_8692")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListMain6_8692ByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6_8692(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已取消申请ByEMItem", tags = {"EMWPList" } ,notes = "fetch已取消申请ByEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/emwplists/fetchcancel")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListCancelByEMItem(@PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchCancel(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已取消申请ByEMItem", tags = {"EMWPList" } ,notes = "search已取消申请ByEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/emwplists/searchcancel")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListCancelByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchCancel(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已入库申请ByEMItem", tags = {"EMWPList" } ,notes = "fetch已入库申请ByEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/emwplists/fetchin")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListInByEMItem(@PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchIn(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已入库申请ByEMItem", tags = {"EMWPList" } ,notes = "search已入库申请ByEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/emwplists/searchin")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListInByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchIn(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch草稿ByEMItem", tags = {"EMWPList" } ,notes = "fetch草稿ByEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/emwplists/fetchdraft")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListDraftByEMItem(@PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDraft(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search草稿ByEMItem", tags = {"EMWPList" } ,notes = "search草稿ByEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/emwplists/searchdraft")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListDraftByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDraft(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch待确认询价ByEMItem", tags = {"EMWPList" } ,notes = "fetch待确认询价ByEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/emwplists/fetchconfimcost")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListConfimCostByEMItem(@PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchConfimCost(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search待确认询价ByEMItem", tags = {"EMWPList" } ,notes = "search待确认询价ByEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/emwplists/searchconfimcost")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListConfimCostByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchConfimCost(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch待生成订单ByEMItem", tags = {"EMWPList" } ,notes = "fetch待生成订单ByEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/emwplists/fetchwaitpo")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListWaitPoByEMItem(@PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitPo(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search待生成订单ByEMItem", tags = {"EMWPList" } ,notes = "search待生成订单ByEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/emwplists/searchwaitpo")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListWaitPoByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitPo(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CreateByEMServiceEMItem", tags = {"EMWPList" },  notes = "CreateByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists")
    @Transactional
    public ResponseEntity<EMWPListDTO> createByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
		emwplistService.create(domain);
        EMWPListDTO dto = emwplistMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMServiceEMItem", tags = {"EMWPList" },  notes = "createBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/batch")
    public ResponseEntity<Boolean> createBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListDTO> emwplistdtos) {
        List<EMWPList> domainlist=emwplistMapping.toDomain(emwplistdtos);
        for(EMWPList domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMServiceEMItem", tags = {"EMWPList" },  notes = "GetByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/{emwplist_id}")
    public ResponseEntity<EMWPListDTO> getByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id) {
        EMWPList domain = emwplistService.get(emwplist_id);
        EMWPListDTO dto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "GetDraftByEMServiceEMItem", tags = {"EMWPList" },  notes = "GetDraftByEMServiceEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/getdraft")
    public ResponseEntity<EMWPListDTO> getDraftByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id) {
        EMWPList domain = new EMWPList();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistMapping.toDto(emwplistService.getDraft(domain)));
    }

    @ApiOperation(value = "询价填报ByEMServiceEMItem", tags = {"EMWPList" },  notes = "询价填报ByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/fillcost")
    @Transactional
    public ResponseEntity<EMWPListDTO> fillCostByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.fillCost(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "根据物品获取采购员ByEMServiceEMItem", tags = {"EMWPList" },  notes = "根据物品获取采购员ByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/getremp")
    @Transactional
    public ResponseEntity<EMWPListDTO> getREMPByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.getREMP(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "SaveByEMServiceEMItem", tags = {"EMWPList" },  notes = "SaveByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/save")
    public ResponseEntity<Boolean> saveByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMServiceEMItem", tags = {"EMWPList" },  notes = "SaveBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListDTO> emwplistdtos) {
        List<EMWPList> domainlist=emwplistMapping.toDomain(emwplistdtos);
        for(EMWPList domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emwplistService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "询价确认ByEMServiceEMItem", tags = {"EMWPList" },  notes = "询价确认ByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/confirmcost")
    @Transactional
    public ResponseEntity<EMWPListDTO> confirmCostByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.confirmCost(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "生成订单ByEMServiceEMItem", tags = {"EMWPList" },  notes = "生成订单ByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/genpo")
    @Transactional
    public ResponseEntity<EMWPListDTO> genPOByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.genPO(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "RemoveByEMServiceEMItem", tags = {"EMWPList" },  notes = "RemoveByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/{emwplist_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwplistService.remove(emwplist_id));
    }

    @ApiOperation(value = "RemoveBatchByEMServiceEMItem", tags = {"EMWPList" },  notes = "RemoveBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/batch")
    public ResponseEntity<Boolean> removeBatchByEMServiceEMItem(@RequestBody List<String> ids) {
        emwplistService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMServiceEMItem", tags = {"EMWPList" },  notes = "UpdateByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/{emwplist_id}")
    @Transactional
    public ResponseEntity<EMWPListDTO> updateByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain.setEmwplistid(emwplist_id);
		emwplistService.update(domain);
        EMWPListDTO dto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMServiceEMItem", tags = {"EMWPList" },  notes = "UpdateBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/batch")
    public ResponseEntity<Boolean> updateBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListDTO> emwplistdtos) {
        List<EMWPList> domainlist=emwplistMapping.toDomain(emwplistdtos);
        for(EMWPList domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "提交ByEMServiceEMItem", tags = {"EMWPList" },  notes = "提交ByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/submit")
    @Transactional
    public ResponseEntity<EMWPListDTO> submitByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.submit(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "CheckKeyByEMServiceEMItem", tags = {"EMWPList" },  notes = "CheckKeyByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListDTO emwplistdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwplistService.checkKey(emwplistMapping.toDomain(emwplistdto)));
    }

	@ApiOperation(value = "fetch待询价ByEMServiceEMItem", tags = {"EMWPList" } ,notes = "fetch待询价ByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/fetchwaitcost")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListWaitCostByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitCost(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search待询价ByEMServiceEMItem", tags = {"EMWPList" } ,notes = "search待询价ByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/searchwaitcost")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListWaitCostByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitCost(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch采购情况统计ByEMServiceEMItem", tags = {"EMWPList" } ,notes = "fetch采购情况统计ByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/fetchwpstatenum")
	public ResponseEntity<List<HashMap>> fetchEMWPListWpStateNumByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = emwplistService.searchWpStateNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

	@ApiOperation(value = "search采购情况统计ByEMServiceEMItem", tags = {"EMWPList" } ,notes = "search采购情况统计ByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/searchwpstatenum")
	public ResponseEntity<Page<HashMap>> searchEMWPListWpStateNumByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = emwplistService.searchWpStateNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已生成订单采购申请ByEMServiceEMItem", tags = {"EMWPList" } ,notes = "fetch已生成订单采购申请ByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/fetchmain6")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListMain6ByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已生成订单采购申请ByEMServiceEMItem", tags = {"EMWPList" } ,notes = "search已生成订单采购申请ByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/searchmain6")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListMain6ByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchDEFAULTByEMServiceEMItem", tags = {"EMWPList" } ,notes = "fetchDEFAULTByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/fetchdefault")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDefault(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMServiceEMItem", tags = {"EMWPList" } ,notes = "searchDEFAULTByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/searchdefault")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已到货采购申请ByEMServiceEMItem", tags = {"EMWPList" } ,notes = "fetch已到货采购申请ByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/fetchmain6_8692")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListMain6_8692ByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6_8692(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已到货采购申请ByEMServiceEMItem", tags = {"EMWPList" } ,notes = "search已到货采购申请ByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/searchmain6_8692")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListMain6_8692ByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6_8692(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已取消申请ByEMServiceEMItem", tags = {"EMWPList" } ,notes = "fetch已取消申请ByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/fetchcancel")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListCancelByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchCancel(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已取消申请ByEMServiceEMItem", tags = {"EMWPList" } ,notes = "search已取消申请ByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/searchcancel")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListCancelByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchCancel(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已入库申请ByEMServiceEMItem", tags = {"EMWPList" } ,notes = "fetch已入库申请ByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/fetchin")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListInByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchIn(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已入库申请ByEMServiceEMItem", tags = {"EMWPList" } ,notes = "search已入库申请ByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/searchin")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListInByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchIn(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch草稿ByEMServiceEMItem", tags = {"EMWPList" } ,notes = "fetch草稿ByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/fetchdraft")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListDraftByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDraft(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search草稿ByEMServiceEMItem", tags = {"EMWPList" } ,notes = "search草稿ByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/searchdraft")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListDraftByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDraft(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch待确认询价ByEMServiceEMItem", tags = {"EMWPList" } ,notes = "fetch待确认询价ByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/fetchconfimcost")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListConfimCostByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchConfimCost(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search待确认询价ByEMServiceEMItem", tags = {"EMWPList" } ,notes = "search待确认询价ByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/searchconfimcost")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListConfimCostByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchConfimCost(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch待生成订单ByEMServiceEMItem", tags = {"EMWPList" } ,notes = "fetch待生成订单ByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/fetchwaitpo")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListWaitPoByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitPo(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search待生成订单ByEMServiceEMItem", tags = {"EMWPList" } ,notes = "search待生成订单ByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/emwplists/searchwaitpo")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListWaitPoByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitPo(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CreateByEMStorePartEMItem", tags = {"EMWPList" },  notes = "CreateByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists")
    @Transactional
    public ResponseEntity<EMWPListDTO> createByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
		emwplistService.create(domain);
        EMWPListDTO dto = emwplistMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStorePartEMItem", tags = {"EMWPList" },  notes = "createBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/batch")
    public ResponseEntity<Boolean> createBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListDTO> emwplistdtos) {
        List<EMWPList> domainlist=emwplistMapping.toDomain(emwplistdtos);
        for(EMWPList domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMStorePartEMItem", tags = {"EMWPList" },  notes = "GetByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}")
    public ResponseEntity<EMWPListDTO> getByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id) {
        EMWPList domain = emwplistService.get(emwplist_id);
        EMWPListDTO dto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "GetDraftByEMStorePartEMItem", tags = {"EMWPList" },  notes = "GetDraftByEMStorePartEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/getdraft")
    public ResponseEntity<EMWPListDTO> getDraftByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMWPList domain = new EMWPList();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistMapping.toDto(emwplistService.getDraft(domain)));
    }

    @ApiOperation(value = "询价填报ByEMStorePartEMItem", tags = {"EMWPList" },  notes = "询价填报ByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/fillcost")
    @Transactional
    public ResponseEntity<EMWPListDTO> fillCostByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.fillCost(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "根据物品获取采购员ByEMStorePartEMItem", tags = {"EMWPList" },  notes = "根据物品获取采购员ByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/getremp")
    @Transactional
    public ResponseEntity<EMWPListDTO> getREMPByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.getREMP(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "SaveByEMStorePartEMItem", tags = {"EMWPList" },  notes = "SaveByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/save")
    public ResponseEntity<Boolean> saveByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStorePartEMItem", tags = {"EMWPList" },  notes = "SaveBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListDTO> emwplistdtos) {
        List<EMWPList> domainlist=emwplistMapping.toDomain(emwplistdtos);
        for(EMWPList domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emwplistService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "询价确认ByEMStorePartEMItem", tags = {"EMWPList" },  notes = "询价确认ByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/confirmcost")
    @Transactional
    public ResponseEntity<EMWPListDTO> confirmCostByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.confirmCost(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "生成订单ByEMStorePartEMItem", tags = {"EMWPList" },  notes = "生成订单ByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/genpo")
    @Transactional
    public ResponseEntity<EMWPListDTO> genPOByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.genPO(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "RemoveByEMStorePartEMItem", tags = {"EMWPList" },  notes = "RemoveByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwplistService.remove(emwplist_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStorePartEMItem", tags = {"EMWPList" },  notes = "RemoveBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/batch")
    public ResponseEntity<Boolean> removeBatchByEMStorePartEMItem(@RequestBody List<String> ids) {
        emwplistService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMStorePartEMItem", tags = {"EMWPList" },  notes = "UpdateByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}")
    @Transactional
    public ResponseEntity<EMWPListDTO> updateByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain.setEmwplistid(emwplist_id);
		emwplistService.update(domain);
        EMWPListDTO dto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStorePartEMItem", tags = {"EMWPList" },  notes = "UpdateBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/batch")
    public ResponseEntity<Boolean> updateBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListDTO> emwplistdtos) {
        List<EMWPList> domainlist=emwplistMapping.toDomain(emwplistdtos);
        for(EMWPList domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "提交ByEMStorePartEMItem", tags = {"EMWPList" },  notes = "提交ByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/submit")
    @Transactional
    public ResponseEntity<EMWPListDTO> submitByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.submit(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "CheckKeyByEMStorePartEMItem", tags = {"EMWPList" },  notes = "CheckKeyByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListDTO emwplistdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwplistService.checkKey(emwplistMapping.toDomain(emwplistdto)));
    }

	@ApiOperation(value = "fetch待询价ByEMStorePartEMItem", tags = {"EMWPList" } ,notes = "fetch待询价ByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/fetchwaitcost")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListWaitCostByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitCost(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search待询价ByEMStorePartEMItem", tags = {"EMWPList" } ,notes = "search待询价ByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/searchwaitcost")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListWaitCostByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitCost(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch采购情况统计ByEMStorePartEMItem", tags = {"EMWPList" } ,notes = "fetch采购情况统计ByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/fetchwpstatenum")
	public ResponseEntity<List<HashMap>> fetchEMWPListWpStateNumByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = emwplistService.searchWpStateNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

	@ApiOperation(value = "search采购情况统计ByEMStorePartEMItem", tags = {"EMWPList" } ,notes = "search采购情况统计ByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/searchwpstatenum")
	public ResponseEntity<Page<HashMap>> searchEMWPListWpStateNumByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = emwplistService.searchWpStateNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已生成订单采购申请ByEMStorePartEMItem", tags = {"EMWPList" } ,notes = "fetch已生成订单采购申请ByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/fetchmain6")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListMain6ByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已生成订单采购申请ByEMStorePartEMItem", tags = {"EMWPList" } ,notes = "search已生成订单采购申请ByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/searchmain6")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListMain6ByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchDEFAULTByEMStorePartEMItem", tags = {"EMWPList" } ,notes = "fetchDEFAULTByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/fetchdefault")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDefault(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStorePartEMItem", tags = {"EMWPList" } ,notes = "searchDEFAULTByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/searchdefault")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已到货采购申请ByEMStorePartEMItem", tags = {"EMWPList" } ,notes = "fetch已到货采购申请ByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/fetchmain6_8692")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListMain6_8692ByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6_8692(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已到货采购申请ByEMStorePartEMItem", tags = {"EMWPList" } ,notes = "search已到货采购申请ByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/searchmain6_8692")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListMain6_8692ByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6_8692(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已取消申请ByEMStorePartEMItem", tags = {"EMWPList" } ,notes = "fetch已取消申请ByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/fetchcancel")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListCancelByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchCancel(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已取消申请ByEMStorePartEMItem", tags = {"EMWPList" } ,notes = "search已取消申请ByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/searchcancel")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListCancelByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchCancel(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已入库申请ByEMStorePartEMItem", tags = {"EMWPList" } ,notes = "fetch已入库申请ByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/fetchin")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListInByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchIn(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已入库申请ByEMStorePartEMItem", tags = {"EMWPList" } ,notes = "search已入库申请ByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/searchin")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListInByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchIn(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch草稿ByEMStorePartEMItem", tags = {"EMWPList" } ,notes = "fetch草稿ByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/fetchdraft")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListDraftByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDraft(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search草稿ByEMStorePartEMItem", tags = {"EMWPList" } ,notes = "search草稿ByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/searchdraft")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListDraftByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDraft(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch待确认询价ByEMStorePartEMItem", tags = {"EMWPList" } ,notes = "fetch待确认询价ByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/fetchconfimcost")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListConfimCostByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchConfimCost(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search待确认询价ByEMStorePartEMItem", tags = {"EMWPList" } ,notes = "search待确认询价ByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/searchconfimcost")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListConfimCostByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchConfimCost(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch待生成订单ByEMStorePartEMItem", tags = {"EMWPList" } ,notes = "fetch待生成订单ByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/fetchwaitpo")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListWaitPoByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitPo(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search待生成订单ByEMStorePartEMItem", tags = {"EMWPList" } ,notes = "search待生成订单ByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/searchwaitpo")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListWaitPoByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitPo(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CreateByEMStoreEMItem", tags = {"EMWPList" },  notes = "CreateByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists")
    @Transactional
    public ResponseEntity<EMWPListDTO> createByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
		emwplistService.create(domain);
        EMWPListDTO dto = emwplistMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStoreEMItem", tags = {"EMWPList" },  notes = "createBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListDTO> emwplistdtos) {
        List<EMWPList> domainlist=emwplistMapping.toDomain(emwplistdtos);
        for(EMWPList domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMStoreEMItem", tags = {"EMWPList" },  notes = "GetByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/{emwplist_id}")
    public ResponseEntity<EMWPListDTO> getByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id) {
        EMWPList domain = emwplistService.get(emwplist_id);
        EMWPListDTO dto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "GetDraftByEMStoreEMItem", tags = {"EMWPList" },  notes = "GetDraftByEMStoreEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/getdraft")
    public ResponseEntity<EMWPListDTO> getDraftByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id) {
        EMWPList domain = new EMWPList();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistMapping.toDto(emwplistService.getDraft(domain)));
    }

    @ApiOperation(value = "询价填报ByEMStoreEMItem", tags = {"EMWPList" },  notes = "询价填报ByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/fillcost")
    @Transactional
    public ResponseEntity<EMWPListDTO> fillCostByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.fillCost(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "根据物品获取采购员ByEMStoreEMItem", tags = {"EMWPList" },  notes = "根据物品获取采购员ByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/getremp")
    @Transactional
    public ResponseEntity<EMWPListDTO> getREMPByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.getREMP(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "SaveByEMStoreEMItem", tags = {"EMWPList" },  notes = "SaveByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/save")
    public ResponseEntity<Boolean> saveByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStoreEMItem", tags = {"EMWPList" },  notes = "SaveBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListDTO> emwplistdtos) {
        List<EMWPList> domainlist=emwplistMapping.toDomain(emwplistdtos);
        for(EMWPList domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emwplistService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "询价确认ByEMStoreEMItem", tags = {"EMWPList" },  notes = "询价确认ByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/confirmcost")
    @Transactional
    public ResponseEntity<EMWPListDTO> confirmCostByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.confirmCost(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "生成订单ByEMStoreEMItem", tags = {"EMWPList" },  notes = "生成订单ByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/genpo")
    @Transactional
    public ResponseEntity<EMWPListDTO> genPOByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.genPO(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "RemoveByEMStoreEMItem", tags = {"EMWPList" },  notes = "RemoveByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/{emwplist_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwplistService.remove(emwplist_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStoreEMItem", tags = {"EMWPList" },  notes = "RemoveBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMItem(@RequestBody List<String> ids) {
        emwplistService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMStoreEMItem", tags = {"EMWPList" },  notes = "UpdateByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/{emwplist_id}")
    @Transactional
    public ResponseEntity<EMWPListDTO> updateByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain.setEmwplistid(emwplist_id);
		emwplistService.update(domain);
        EMWPListDTO dto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStoreEMItem", tags = {"EMWPList" },  notes = "UpdateBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListDTO> emwplistdtos) {
        List<EMWPList> domainlist=emwplistMapping.toDomain(emwplistdtos);
        for(EMWPList domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "提交ByEMStoreEMItem", tags = {"EMWPList" },  notes = "提交ByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/submit")
    @Transactional
    public ResponseEntity<EMWPListDTO> submitByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.submit(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "CheckKeyByEMStoreEMItem", tags = {"EMWPList" },  notes = "CheckKeyByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListDTO emwplistdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwplistService.checkKey(emwplistMapping.toDomain(emwplistdto)));
    }

	@ApiOperation(value = "fetch待询价ByEMStoreEMItem", tags = {"EMWPList" } ,notes = "fetch待询价ByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/fetchwaitcost")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListWaitCostByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitCost(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search待询价ByEMStoreEMItem", tags = {"EMWPList" } ,notes = "search待询价ByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/searchwaitcost")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListWaitCostByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitCost(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch采购情况统计ByEMStoreEMItem", tags = {"EMWPList" } ,notes = "fetch采购情况统计ByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/fetchwpstatenum")
	public ResponseEntity<List<HashMap>> fetchEMWPListWpStateNumByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = emwplistService.searchWpStateNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

	@ApiOperation(value = "search采购情况统计ByEMStoreEMItem", tags = {"EMWPList" } ,notes = "search采购情况统计ByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/searchwpstatenum")
	public ResponseEntity<Page<HashMap>> searchEMWPListWpStateNumByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = emwplistService.searchWpStateNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已生成订单采购申请ByEMStoreEMItem", tags = {"EMWPList" } ,notes = "fetch已生成订单采购申请ByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/fetchmain6")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListMain6ByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已生成订单采购申请ByEMStoreEMItem", tags = {"EMWPList" } ,notes = "search已生成订单采购申请ByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/searchmain6")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListMain6ByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchDEFAULTByEMStoreEMItem", tags = {"EMWPList" } ,notes = "fetchDEFAULTByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/fetchdefault")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDefault(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStoreEMItem", tags = {"EMWPList" } ,notes = "searchDEFAULTByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/searchdefault")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已到货采购申请ByEMStoreEMItem", tags = {"EMWPList" } ,notes = "fetch已到货采购申请ByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/fetchmain6_8692")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListMain6_8692ByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6_8692(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已到货采购申请ByEMStoreEMItem", tags = {"EMWPList" } ,notes = "search已到货采购申请ByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/searchmain6_8692")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListMain6_8692ByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6_8692(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已取消申请ByEMStoreEMItem", tags = {"EMWPList" } ,notes = "fetch已取消申请ByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/fetchcancel")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListCancelByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchCancel(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已取消申请ByEMStoreEMItem", tags = {"EMWPList" } ,notes = "search已取消申请ByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/searchcancel")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListCancelByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchCancel(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已入库申请ByEMStoreEMItem", tags = {"EMWPList" } ,notes = "fetch已入库申请ByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/fetchin")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListInByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchIn(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已入库申请ByEMStoreEMItem", tags = {"EMWPList" } ,notes = "search已入库申请ByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/searchin")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListInByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchIn(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch草稿ByEMStoreEMItem", tags = {"EMWPList" } ,notes = "fetch草稿ByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/fetchdraft")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListDraftByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDraft(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search草稿ByEMStoreEMItem", tags = {"EMWPList" } ,notes = "search草稿ByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/searchdraft")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListDraftByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDraft(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch待确认询价ByEMStoreEMItem", tags = {"EMWPList" } ,notes = "fetch待确认询价ByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/fetchconfimcost")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListConfimCostByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchConfimCost(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search待确认询价ByEMStoreEMItem", tags = {"EMWPList" } ,notes = "search待确认询价ByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/searchconfimcost")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListConfimCostByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchConfimCost(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch待生成订单ByEMStoreEMItem", tags = {"EMWPList" } ,notes = "fetch待生成订单ByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/fetchwaitpo")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListWaitPoByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitPo(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search待生成订单ByEMStoreEMItem", tags = {"EMWPList" } ,notes = "search待生成订单ByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/emwplists/searchwaitpo")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListWaitPoByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitPo(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CreateByPFEmpEMItem", tags = {"EMWPList" },  notes = "CreateByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists")
    @Transactional
    public ResponseEntity<EMWPListDTO> createByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
		emwplistService.create(domain);
        EMWPListDTO dto = emwplistMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFEmpEMItem", tags = {"EMWPList" },  notes = "createBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/batch")
    public ResponseEntity<Boolean> createBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListDTO> emwplistdtos) {
        List<EMWPList> domainlist=emwplistMapping.toDomain(emwplistdtos);
        for(EMWPList domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByPFEmpEMItem", tags = {"EMWPList" },  notes = "GetByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/{emwplist_id}")
    public ResponseEntity<EMWPListDTO> getByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id) {
        EMWPList domain = emwplistService.get(emwplist_id);
        EMWPListDTO dto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "GetDraftByPFEmpEMItem", tags = {"EMWPList" },  notes = "GetDraftByPFEmpEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/getdraft")
    public ResponseEntity<EMWPListDTO> getDraftByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id) {
        EMWPList domain = new EMWPList();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistMapping.toDto(emwplistService.getDraft(domain)));
    }

    @ApiOperation(value = "询价填报ByPFEmpEMItem", tags = {"EMWPList" },  notes = "询价填报ByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/fillcost")
    @Transactional
    public ResponseEntity<EMWPListDTO> fillCostByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.fillCost(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "根据物品获取采购员ByPFEmpEMItem", tags = {"EMWPList" },  notes = "根据物品获取采购员ByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/getremp")
    @Transactional
    public ResponseEntity<EMWPListDTO> getREMPByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.getREMP(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "SaveByPFEmpEMItem", tags = {"EMWPList" },  notes = "SaveByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/save")
    public ResponseEntity<Boolean> saveByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFEmpEMItem", tags = {"EMWPList" },  notes = "SaveBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListDTO> emwplistdtos) {
        List<EMWPList> domainlist=emwplistMapping.toDomain(emwplistdtos);
        for(EMWPList domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emwplistService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "询价确认ByPFEmpEMItem", tags = {"EMWPList" },  notes = "询价确认ByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/confirmcost")
    @Transactional
    public ResponseEntity<EMWPListDTO> confirmCostByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.confirmCost(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "生成订单ByPFEmpEMItem", tags = {"EMWPList" },  notes = "生成订单ByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/genpo")
    @Transactional
    public ResponseEntity<EMWPListDTO> genPOByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.genPO(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "RemoveByPFEmpEMItem", tags = {"EMWPList" },  notes = "RemoveByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/{emwplist_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwplistService.remove(emwplist_id));
    }

    @ApiOperation(value = "RemoveBatchByPFEmpEMItem", tags = {"EMWPList" },  notes = "RemoveBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/batch")
    public ResponseEntity<Boolean> removeBatchByPFEmpEMItem(@RequestBody List<String> ids) {
        emwplistService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByPFEmpEMItem", tags = {"EMWPList" },  notes = "UpdateByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/{emwplist_id}")
    @Transactional
    public ResponseEntity<EMWPListDTO> updateByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain.setEmwplistid(emwplist_id);
		emwplistService.update(domain);
        EMWPListDTO dto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFEmpEMItem", tags = {"EMWPList" },  notes = "UpdateBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/batch")
    public ResponseEntity<Boolean> updateBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListDTO> emwplistdtos) {
        List<EMWPList> domainlist=emwplistMapping.toDomain(emwplistdtos);
        for(EMWPList domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "提交ByPFEmpEMItem", tags = {"EMWPList" },  notes = "提交ByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/submit")
    @Transactional
    public ResponseEntity<EMWPListDTO> submitByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.submit(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "CheckKeyByPFEmpEMItem", tags = {"EMWPList" },  notes = "CheckKeyByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListDTO emwplistdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwplistService.checkKey(emwplistMapping.toDomain(emwplistdto)));
    }

	@ApiOperation(value = "fetch待询价ByPFEmpEMItem", tags = {"EMWPList" } ,notes = "fetch待询价ByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/fetchwaitcost")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListWaitCostByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitCost(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search待询价ByPFEmpEMItem", tags = {"EMWPList" } ,notes = "search待询价ByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/searchwaitcost")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListWaitCostByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitCost(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch采购情况统计ByPFEmpEMItem", tags = {"EMWPList" } ,notes = "fetch采购情况统计ByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/fetchwpstatenum")
	public ResponseEntity<List<HashMap>> fetchEMWPListWpStateNumByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = emwplistService.searchWpStateNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

	@ApiOperation(value = "search采购情况统计ByPFEmpEMItem", tags = {"EMWPList" } ,notes = "search采购情况统计ByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/searchwpstatenum")
	public ResponseEntity<Page<HashMap>> searchEMWPListWpStateNumByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = emwplistService.searchWpStateNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已生成订单采购申请ByPFEmpEMItem", tags = {"EMWPList" } ,notes = "fetch已生成订单采购申请ByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/fetchmain6")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListMain6ByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已生成订单采购申请ByPFEmpEMItem", tags = {"EMWPList" } ,notes = "search已生成订单采购申请ByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/searchmain6")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListMain6ByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchDEFAULTByPFEmpEMItem", tags = {"EMWPList" } ,notes = "fetchDEFAULTByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/fetchdefault")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDefault(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFEmpEMItem", tags = {"EMWPList" } ,notes = "searchDEFAULTByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/searchdefault")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已到货采购申请ByPFEmpEMItem", tags = {"EMWPList" } ,notes = "fetch已到货采购申请ByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/fetchmain6_8692")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListMain6_8692ByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6_8692(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已到货采购申请ByPFEmpEMItem", tags = {"EMWPList" } ,notes = "search已到货采购申请ByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/searchmain6_8692")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListMain6_8692ByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6_8692(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已取消申请ByPFEmpEMItem", tags = {"EMWPList" } ,notes = "fetch已取消申请ByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/fetchcancel")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListCancelByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchCancel(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已取消申请ByPFEmpEMItem", tags = {"EMWPList" } ,notes = "search已取消申请ByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/searchcancel")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListCancelByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchCancel(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已入库申请ByPFEmpEMItem", tags = {"EMWPList" } ,notes = "fetch已入库申请ByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/fetchin")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListInByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchIn(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已入库申请ByPFEmpEMItem", tags = {"EMWPList" } ,notes = "search已入库申请ByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/searchin")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListInByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchIn(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch草稿ByPFEmpEMItem", tags = {"EMWPList" } ,notes = "fetch草稿ByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/fetchdraft")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListDraftByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDraft(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search草稿ByPFEmpEMItem", tags = {"EMWPList" } ,notes = "search草稿ByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/searchdraft")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListDraftByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDraft(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch待确认询价ByPFEmpEMItem", tags = {"EMWPList" } ,notes = "fetch待确认询价ByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/fetchconfimcost")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListConfimCostByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchConfimCost(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search待确认询价ByPFEmpEMItem", tags = {"EMWPList" } ,notes = "search待确认询价ByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/searchconfimcost")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListConfimCostByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchConfimCost(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch待生成订单ByPFEmpEMItem", tags = {"EMWPList" } ,notes = "fetch待生成订单ByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/fetchwaitpo")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListWaitPoByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitPo(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search待生成订单ByPFEmpEMItem", tags = {"EMWPList" } ,notes = "search待生成订单ByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emwplists/searchwaitpo")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListWaitPoByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitPo(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CreateByPFUnitEMItem", tags = {"EMWPList" },  notes = "CreateByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists")
    @Transactional
    public ResponseEntity<EMWPListDTO> createByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
		emwplistService.create(domain);
        EMWPListDTO dto = emwplistMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFUnitEMItem", tags = {"EMWPList" },  notes = "createBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/batch")
    public ResponseEntity<Boolean> createBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListDTO> emwplistdtos) {
        List<EMWPList> domainlist=emwplistMapping.toDomain(emwplistdtos);
        for(EMWPList domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByPFUnitEMItem", tags = {"EMWPList" },  notes = "GetByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/{emwplist_id}")
    public ResponseEntity<EMWPListDTO> getByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id) {
        EMWPList domain = emwplistService.get(emwplist_id);
        EMWPListDTO dto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "GetDraftByPFUnitEMItem", tags = {"EMWPList" },  notes = "GetDraftByPFUnitEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/getdraft")
    public ResponseEntity<EMWPListDTO> getDraftByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id) {
        EMWPList domain = new EMWPList();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistMapping.toDto(emwplistService.getDraft(domain)));
    }

    @ApiOperation(value = "询价填报ByPFUnitEMItem", tags = {"EMWPList" },  notes = "询价填报ByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/fillcost")
    @Transactional
    public ResponseEntity<EMWPListDTO> fillCostByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.fillCost(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "根据物品获取采购员ByPFUnitEMItem", tags = {"EMWPList" },  notes = "根据物品获取采购员ByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/getremp")
    @Transactional
    public ResponseEntity<EMWPListDTO> getREMPByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.getREMP(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "SaveByPFUnitEMItem", tags = {"EMWPList" },  notes = "SaveByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/save")
    public ResponseEntity<Boolean> saveByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFUnitEMItem", tags = {"EMWPList" },  notes = "SaveBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListDTO> emwplistdtos) {
        List<EMWPList> domainlist=emwplistMapping.toDomain(emwplistdtos);
        for(EMWPList domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emwplistService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "询价确认ByPFUnitEMItem", tags = {"EMWPList" },  notes = "询价确认ByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/confirmcost")
    @Transactional
    public ResponseEntity<EMWPListDTO> confirmCostByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.confirmCost(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "生成订单ByPFUnitEMItem", tags = {"EMWPList" },  notes = "生成订单ByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/genpo")
    @Transactional
    public ResponseEntity<EMWPListDTO> genPOByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.genPO(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "RemoveByPFUnitEMItem", tags = {"EMWPList" },  notes = "RemoveByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/{emwplist_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwplistService.remove(emwplist_id));
    }

    @ApiOperation(value = "RemoveBatchByPFUnitEMItem", tags = {"EMWPList" },  notes = "RemoveBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/batch")
    public ResponseEntity<Boolean> removeBatchByPFUnitEMItem(@RequestBody List<String> ids) {
        emwplistService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByPFUnitEMItem", tags = {"EMWPList" },  notes = "UpdateByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/{emwplist_id}")
    @Transactional
    public ResponseEntity<EMWPListDTO> updateByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain.setEmwplistid(emwplist_id);
		emwplistService.update(domain);
        EMWPListDTO dto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFUnitEMItem", tags = {"EMWPList" },  notes = "UpdateBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/batch")
    public ResponseEntity<Boolean> updateBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListDTO> emwplistdtos) {
        List<EMWPList> domainlist=emwplistMapping.toDomain(emwplistdtos);
        for(EMWPList domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "提交ByPFUnitEMItem", tags = {"EMWPList" },  notes = "提交ByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/submit")
    @Transactional
    public ResponseEntity<EMWPListDTO> submitByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.submit(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "CheckKeyByPFUnitEMItem", tags = {"EMWPList" },  notes = "CheckKeyByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListDTO emwplistdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwplistService.checkKey(emwplistMapping.toDomain(emwplistdto)));
    }

	@ApiOperation(value = "fetch待询价ByPFUnitEMItem", tags = {"EMWPList" } ,notes = "fetch待询价ByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/fetchwaitcost")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListWaitCostByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitCost(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search待询价ByPFUnitEMItem", tags = {"EMWPList" } ,notes = "search待询价ByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/searchwaitcost")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListWaitCostByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitCost(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch采购情况统计ByPFUnitEMItem", tags = {"EMWPList" } ,notes = "fetch采购情况统计ByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/fetchwpstatenum")
	public ResponseEntity<List<HashMap>> fetchEMWPListWpStateNumByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = emwplistService.searchWpStateNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

	@ApiOperation(value = "search采购情况统计ByPFUnitEMItem", tags = {"EMWPList" } ,notes = "search采购情况统计ByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/searchwpstatenum")
	public ResponseEntity<Page<HashMap>> searchEMWPListWpStateNumByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = emwplistService.searchWpStateNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已生成订单采购申请ByPFUnitEMItem", tags = {"EMWPList" } ,notes = "fetch已生成订单采购申请ByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/fetchmain6")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListMain6ByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已生成订单采购申请ByPFUnitEMItem", tags = {"EMWPList" } ,notes = "search已生成订单采购申请ByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/searchmain6")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListMain6ByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchDEFAULTByPFUnitEMItem", tags = {"EMWPList" } ,notes = "fetchDEFAULTByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/fetchdefault")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDefault(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFUnitEMItem", tags = {"EMWPList" } ,notes = "searchDEFAULTByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/searchdefault")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已到货采购申请ByPFUnitEMItem", tags = {"EMWPList" } ,notes = "fetch已到货采购申请ByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/fetchmain6_8692")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListMain6_8692ByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6_8692(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已到货采购申请ByPFUnitEMItem", tags = {"EMWPList" } ,notes = "search已到货采购申请ByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/searchmain6_8692")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListMain6_8692ByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6_8692(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已取消申请ByPFUnitEMItem", tags = {"EMWPList" } ,notes = "fetch已取消申请ByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/fetchcancel")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListCancelByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchCancel(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已取消申请ByPFUnitEMItem", tags = {"EMWPList" } ,notes = "search已取消申请ByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/searchcancel")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListCancelByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchCancel(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已入库申请ByPFUnitEMItem", tags = {"EMWPList" } ,notes = "fetch已入库申请ByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/fetchin")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListInByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchIn(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已入库申请ByPFUnitEMItem", tags = {"EMWPList" } ,notes = "search已入库申请ByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/searchin")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListInByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchIn(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch草稿ByPFUnitEMItem", tags = {"EMWPList" } ,notes = "fetch草稿ByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/fetchdraft")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListDraftByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDraft(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search草稿ByPFUnitEMItem", tags = {"EMWPList" } ,notes = "search草稿ByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/searchdraft")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListDraftByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDraft(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch待确认询价ByPFUnitEMItem", tags = {"EMWPList" } ,notes = "fetch待确认询价ByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/fetchconfimcost")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListConfimCostByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchConfimCost(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search待确认询价ByPFUnitEMItem", tags = {"EMWPList" } ,notes = "search待确认询价ByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/searchconfimcost")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListConfimCostByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchConfimCost(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch待生成订单ByPFUnitEMItem", tags = {"EMWPList" } ,notes = "fetch待生成订单ByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/fetchwaitpo")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListWaitPoByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitPo(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search待生成订单ByPFUnitEMItem", tags = {"EMWPList" } ,notes = "search待生成订单ByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emwplists/searchwaitpo")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListWaitPoByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitPo(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}





    @ApiOperation(value = "CreateByEMStoreEMStorePartEMItem", tags = {"EMWPList" },  notes = "CreateByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists")
    @Transactional
    public ResponseEntity<EMWPListDTO> createByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
		emwplistService.create(domain);
        EMWPListDTO dto = emwplistMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStoreEMStorePartEMItem", tags = {"EMWPList" },  notes = "createBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListDTO> emwplistdtos) {
        List<EMWPList> domainlist=emwplistMapping.toDomain(emwplistdtos);
        for(EMWPList domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMStoreEMStorePartEMItem", tags = {"EMWPList" },  notes = "GetByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}")
    public ResponseEntity<EMWPListDTO> getByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id) {
        EMWPList domain = emwplistService.get(emwplist_id);
        EMWPListDTO dto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "GetDraftByEMStoreEMStorePartEMItem", tags = {"EMWPList" },  notes = "GetDraftByEMStoreEMStorePartEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/getdraft")
    public ResponseEntity<EMWPListDTO> getDraftByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMWPList domain = new EMWPList();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistMapping.toDto(emwplistService.getDraft(domain)));
    }

    @ApiOperation(value = "询价填报ByEMStoreEMStorePartEMItem", tags = {"EMWPList" },  notes = "询价填报ByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/fillcost")
    @Transactional
    public ResponseEntity<EMWPListDTO> fillCostByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.fillCost(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "根据物品获取采购员ByEMStoreEMStorePartEMItem", tags = {"EMWPList" },  notes = "根据物品获取采购员ByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/getremp")
    @Transactional
    public ResponseEntity<EMWPListDTO> getREMPByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.getREMP(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "SaveByEMStoreEMStorePartEMItem", tags = {"EMWPList" },  notes = "SaveByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/save")
    public ResponseEntity<Boolean> saveByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStoreEMStorePartEMItem", tags = {"EMWPList" },  notes = "SaveBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListDTO> emwplistdtos) {
        List<EMWPList> domainlist=emwplistMapping.toDomain(emwplistdtos);
        for(EMWPList domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emwplistService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "询价确认ByEMStoreEMStorePartEMItem", tags = {"EMWPList" },  notes = "询价确认ByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/confirmcost")
    @Transactional
    public ResponseEntity<EMWPListDTO> confirmCostByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.confirmCost(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "生成订单ByEMStoreEMStorePartEMItem", tags = {"EMWPList" },  notes = "生成订单ByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/genpo")
    @Transactional
    public ResponseEntity<EMWPListDTO> genPOByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.genPO(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "RemoveByEMStoreEMStorePartEMItem", tags = {"EMWPList" },  notes = "RemoveByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwplistService.remove(emwplist_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStoreEMStorePartEMItem", tags = {"EMWPList" },  notes = "RemoveBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMStorePartEMItem(@RequestBody List<String> ids) {
        emwplistService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMStoreEMStorePartEMItem", tags = {"EMWPList" },  notes = "UpdateByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplist_id}")
    @Transactional
    public ResponseEntity<EMWPListDTO> updateByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain.setEmwplistid(emwplist_id);
		emwplistService.update(domain);
        EMWPListDTO dto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStoreEMStorePartEMItem", tags = {"EMWPList" },  notes = "UpdateBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMWPListDTO> emwplistdtos) {
        List<EMWPList> domainlist=emwplistMapping.toDomain(emwplistdtos);
        for(EMWPList domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emwplistService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "提交ByEMStoreEMStorePartEMItem", tags = {"EMWPList" },  notes = "提交ByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/{emwplistemwplistid}/submit")
    @Transactional
    public ResponseEntity<EMWPListDTO> submitByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emwplist_id") String emwplist_id, @RequestBody EMWPListDTO emwplistdto) {
        EMWPList domain = emwplistMapping.toDomain(emwplistdto);
        domain.setItemid(emitem_id);
        domain = emwplistService.submit(domain) ;
        emwplistdto = emwplistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(emwplistdto);
    }

    @ApiOperation(value = "CheckKeyByEMStoreEMStorePartEMItem", tags = {"EMWPList" },  notes = "CheckKeyByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListDTO emwplistdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwplistService.checkKey(emwplistMapping.toDomain(emwplistdto)));
    }

	@ApiOperation(value = "fetch待询价ByEMStoreEMStorePartEMItem", tags = {"EMWPList" } ,notes = "fetch待询价ByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/fetchwaitcost")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListWaitCostByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitCost(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search待询价ByEMStoreEMStorePartEMItem", tags = {"EMWPList" } ,notes = "search待询价ByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/searchwaitcost")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListWaitCostByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitCost(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch采购情况统计ByEMStoreEMStorePartEMItem", tags = {"EMWPList" } ,notes = "fetch采购情况统计ByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/fetchwpstatenum")
	public ResponseEntity<List<HashMap>> fetchEMWPListWpStateNumByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = emwplistService.searchWpStateNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

	@ApiOperation(value = "search采购情况统计ByEMStoreEMStorePartEMItem", tags = {"EMWPList" } ,notes = "search采购情况统计ByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/searchwpstatenum")
	public ResponseEntity<Page<HashMap>> searchEMWPListWpStateNumByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = emwplistService.searchWpStateNum(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已生成订单采购申请ByEMStoreEMStorePartEMItem", tags = {"EMWPList" } ,notes = "fetch已生成订单采购申请ByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/fetchmain6")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListMain6ByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已生成订单采购申请ByEMStoreEMStorePartEMItem", tags = {"EMWPList" } ,notes = "search已生成订单采购申请ByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/searchmain6")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListMain6ByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchDEFAULTByEMStoreEMStorePartEMItem", tags = {"EMWPList" } ,notes = "fetchDEFAULTByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/fetchdefault")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDefault(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStoreEMStorePartEMItem", tags = {"EMWPList" } ,notes = "searchDEFAULTByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/searchdefault")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已到货采购申请ByEMStoreEMStorePartEMItem", tags = {"EMWPList" } ,notes = "fetch已到货采购申请ByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/fetchmain6_8692")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListMain6_8692ByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6_8692(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已到货采购申请ByEMStoreEMStorePartEMItem", tags = {"EMWPList" } ,notes = "search已到货采购申请ByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/searchmain6_8692")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListMain6_8692ByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchMain6_8692(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已取消申请ByEMStoreEMStorePartEMItem", tags = {"EMWPList" } ,notes = "fetch已取消申请ByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/fetchcancel")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListCancelByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchCancel(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已取消申请ByEMStoreEMStorePartEMItem", tags = {"EMWPList" } ,notes = "search已取消申请ByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/searchcancel")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListCancelByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchCancel(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch已入库申请ByEMStoreEMStorePartEMItem", tags = {"EMWPList" } ,notes = "fetch已入库申请ByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/fetchin")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListInByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchIn(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search已入库申请ByEMStoreEMStorePartEMItem", tags = {"EMWPList" } ,notes = "search已入库申请ByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/searchin")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListInByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchIn(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch草稿ByEMStoreEMStorePartEMItem", tags = {"EMWPList" } ,notes = "fetch草稿ByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/fetchdraft")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListDraftByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDraft(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search草稿ByEMStoreEMStorePartEMItem", tags = {"EMWPList" } ,notes = "search草稿ByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/searchdraft")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListDraftByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchDraft(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch待确认询价ByEMStoreEMStorePartEMItem", tags = {"EMWPList" } ,notes = "fetch待确认询价ByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/fetchconfimcost")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListConfimCostByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchConfimCost(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search待确认询价ByEMStoreEMStorePartEMItem", tags = {"EMWPList" } ,notes = "search待确认询价ByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/searchconfimcost")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListConfimCostByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchConfimCost(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch待生成订单ByEMStoreEMStorePartEMItem", tags = {"EMWPList" } ,notes = "fetch待生成订单ByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/fetchwaitpo")
	public ResponseEntity<List<EMWPListDTO>> fetchEMWPListWaitPoByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitPo(context) ;
        List<EMWPListDTO> list = emwplistMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search待生成订单ByEMStoreEMStorePartEMItem", tags = {"EMWPList" } ,notes = "search待生成订单ByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emwplists/searchwaitpo")
	public ResponseEntity<Page<EMWPListDTO>> searchEMWPListWaitPoByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMWPListSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMWPList> domains = emwplistService.searchWaitPo(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwplistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMWPList getEntity(){
        return new EMWPList();
    }

}
