package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMStorePart;
import cn.ibizlab.eam.core.eam_core.service.IEMStorePartService;
import cn.ibizlab.eam.core.eam_core.filter.EMStorePartSearchContext;




@Slf4j
@Api(tags = {"EMStorePart" })
@RestController("WebApi-emstorepart")
@RequestMapping("")
public class EMStorePartResource {

    @Autowired
    private IEMStorePartService emstorepartService;

    @Autowired
    @Lazy
    private EMStorePartMapping emstorepartMapping;




    @PreAuthorize("hasPermission(#emstorepart_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMStorePart" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}")
    @Transactional
    public ResponseEntity<EMStorePartDTO> update(@PathVariable("emstorepart_id") String emstorepart_id, @RequestBody EMStorePartDTO emstorepartdto) {
		EMStorePart domain = emstorepartMapping.toDomain(emstorepartdto);
        domain.setEmstorepartid(emstorepart_id);
		emstorepartService.update(domain);
		EMStorePartDTO dto = emstorepartMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emstorepart_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMStorePart" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMStorePartDTO> emstorepartdtos) {
        emstorepartService.updateBatch(emstorepartMapping.toDomain(emstorepartdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMStorePart" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/getdraft")
    public ResponseEntity<EMStorePartDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emstorepartMapping.toDto(emstorepartService.getDraft(new EMStorePart())));
    }




    @ApiOperation(value = "Save", tags = {"EMStorePart" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/save")
    public ResponseEntity<Boolean> save(@RequestBody EMStorePartDTO emstorepartdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emstorepartService.save(emstorepartMapping.toDomain(emstorepartdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMStorePart" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMStorePartDTO> emstorepartdtos) {
        emstorepartService.saveBatch(emstorepartMapping.toDomain(emstorepartdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMStorePart" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts")
    @Transactional
    public ResponseEntity<EMStorePartDTO> create(@RequestBody EMStorePartDTO emstorepartdto) {
        EMStorePart domain = emstorepartMapping.toDomain(emstorepartdto);
		emstorepartService.create(domain);
        EMStorePartDTO dto = emstorepartMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMStorePart" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMStorePartDTO> emstorepartdtos) {
        emstorepartService.createBatch(emstorepartMapping.toDomain(emstorepartdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emstorepart_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMStorePart" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}")
    public ResponseEntity<EMStorePartDTO> get(@PathVariable("emstorepart_id") String emstorepart_id) {
        EMStorePart domain = emstorepartService.get(emstorepart_id);
        EMStorePartDTO dto = emstorepartMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @PreAuthorize("hasPermission(#emstorepart_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMStorePart" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emstorepart_id") String emstorepart_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emstorepartService.remove(emstorepart_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMStorePart" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emstorepartService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMStorePart" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMStorePartDTO emstorepartdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emstorepartService.checkKey(emstorepartMapping.toDomain(emstorepartdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMStorePart-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMStorePart" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/fetchdefault")
	public ResponseEntity<List<EMStorePartDTO>> fetchDefault(EMStorePartSearchContext context) {
        Page<EMStorePart> domains = emstorepartService.searchDefault(context) ;
        List<EMStorePartDTO> list = emstorepartMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMStorePart-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMStorePart" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/searchdefault")
	public ResponseEntity<Page<EMStorePartDTO>> searchDefault(@RequestBody EMStorePartSearchContext context) {
        Page<EMStorePart> domains = emstorepartService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emstorepartMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "UpdateByEMStore", tags = {"EMStorePart" },  notes = "UpdateByEMStore")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}")
    @Transactional
    public ResponseEntity<EMStorePartDTO> updateByEMStore(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @RequestBody EMStorePartDTO emstorepartdto) {
        EMStorePart domain = emstorepartMapping.toDomain(emstorepartdto);
        domain.setStoreid(emstore_id);
        domain.setEmstorepartid(emstorepart_id);
		emstorepartService.update(domain);
        EMStorePartDTO dto = emstorepartMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStore", tags = {"EMStorePart" },  notes = "UpdateBatchByEMStore")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/batch")
    public ResponseEntity<Boolean> updateBatchByEMStore(@PathVariable("emstore_id") String emstore_id, @RequestBody List<EMStorePartDTO> emstorepartdtos) {
        List<EMStorePart> domainlist=emstorepartMapping.toDomain(emstorepartdtos);
        for(EMStorePart domain:domainlist){
            domain.setStoreid(emstore_id);
        }
        emstorepartService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMStore", tags = {"EMStorePart" },  notes = "GetDraftByEMStore")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/getdraft")
    public ResponseEntity<EMStorePartDTO> getDraftByEMStore(@PathVariable("emstore_id") String emstore_id) {
        EMStorePart domain = new EMStorePart();
        domain.setStoreid(emstore_id);
        return ResponseEntity.status(HttpStatus.OK).body(emstorepartMapping.toDto(emstorepartService.getDraft(domain)));
    }

    @ApiOperation(value = "SaveByEMStore", tags = {"EMStorePart" },  notes = "SaveByEMStore")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/save")
    public ResponseEntity<Boolean> saveByEMStore(@PathVariable("emstore_id") String emstore_id, @RequestBody EMStorePartDTO emstorepartdto) {
        EMStorePart domain = emstorepartMapping.toDomain(emstorepartdto);
        domain.setStoreid(emstore_id);
        return ResponseEntity.status(HttpStatus.OK).body(emstorepartService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStore", tags = {"EMStorePart" },  notes = "SaveBatchByEMStore")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStore(@PathVariable("emstore_id") String emstore_id, @RequestBody List<EMStorePartDTO> emstorepartdtos) {
        List<EMStorePart> domainlist=emstorepartMapping.toDomain(emstorepartdtos);
        for(EMStorePart domain:domainlist){
             domain.setStoreid(emstore_id);
        }
        emstorepartService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMStore", tags = {"EMStorePart" },  notes = "CreateByEMStore")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts")
    @Transactional
    public ResponseEntity<EMStorePartDTO> createByEMStore(@PathVariable("emstore_id") String emstore_id, @RequestBody EMStorePartDTO emstorepartdto) {
        EMStorePart domain = emstorepartMapping.toDomain(emstorepartdto);
        domain.setStoreid(emstore_id);
		emstorepartService.create(domain);
        EMStorePartDTO dto = emstorepartMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStore", tags = {"EMStorePart" },  notes = "createBatchByEMStore")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/batch")
    public ResponseEntity<Boolean> createBatchByEMStore(@PathVariable("emstore_id") String emstore_id, @RequestBody List<EMStorePartDTO> emstorepartdtos) {
        List<EMStorePart> domainlist=emstorepartMapping.toDomain(emstorepartdtos);
        for(EMStorePart domain:domainlist){
            domain.setStoreid(emstore_id);
        }
        emstorepartService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMStore", tags = {"EMStorePart" },  notes = "GetByEMStore")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}")
    public ResponseEntity<EMStorePartDTO> getByEMStore(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id) {
        EMStorePart domain = emstorepartService.get(emstorepart_id);
        EMStorePartDTO dto = emstorepartMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "RemoveByEMStore", tags = {"EMStorePart" },  notes = "RemoveByEMStore")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStore(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emstorepartService.remove(emstorepart_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStore", tags = {"EMStorePart" },  notes = "RemoveBatchByEMStore")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/batch")
    public ResponseEntity<Boolean> removeBatchByEMStore(@RequestBody List<String> ids) {
        emstorepartService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMStore", tags = {"EMStorePart" },  notes = "CheckKeyByEMStore")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStore(@PathVariable("emstore_id") String emstore_id, @RequestBody EMStorePartDTO emstorepartdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emstorepartService.checkKey(emstorepartMapping.toDomain(emstorepartdto)));
    }

	@ApiOperation(value = "fetchDEFAULTByEMStore", tags = {"EMStorePart" } ,notes = "fetchDEFAULTByEMStore")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/fetchdefault")
	public ResponseEntity<List<EMStorePartDTO>> fetchEMStorePartDefaultByEMStore(@PathVariable("emstore_id") String emstore_id,EMStorePartSearchContext context) {
        context.setN_storeid_eq(emstore_id);
        Page<EMStorePart> domains = emstorepartService.searchDefault(context) ;
        List<EMStorePartDTO> list = emstorepartMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStore", tags = {"EMStorePart" } ,notes = "searchDEFAULTByEMStore")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/searchdefault")
	public ResponseEntity<Page<EMStorePartDTO>> searchEMStorePartDefaultByEMStore(@PathVariable("emstore_id") String emstore_id, @RequestBody EMStorePartSearchContext context) {
        context.setN_storeid_eq(emstore_id);
        Page<EMStorePart> domains = emstorepartService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emstorepartMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMStorePart getEntity(){
        return new EMStorePart();
    }

}
