package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMServiceHist;
import cn.ibizlab.eam.core.eam_core.service.IEMServiceHistService;
import cn.ibizlab.eam.core.eam_core.filter.EMServiceHistSearchContext;




@Slf4j
@Api(tags = {"EMServiceHist" })
@RestController("WebApi-emservicehist")
@RequestMapping("")
public class EMServiceHistResource {

    @Autowired
    private IEMServiceHistService emservicehistService;

    @Autowired
    @Lazy
    private EMServiceHistMapping emservicehistMapping;




    @ApiOperation(value = "CheckKey", tags = {"EMServiceHist" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emservicehists/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMServiceHistDTO emservicehistdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emservicehistService.checkKey(emservicehistMapping.toDomain(emservicehistdto)));
    }




    @ApiOperation(value = "Save", tags = {"EMServiceHist" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emservicehists/save")
    public ResponseEntity<Boolean> save(@RequestBody EMServiceHistDTO emservicehistdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emservicehistService.save(emservicehistMapping.toDomain(emservicehistdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMServiceHist" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emservicehists/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMServiceHistDTO> emservicehistdtos) {
        emservicehistService.saveBatch(emservicehistMapping.toDomain(emservicehistdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emservicehist_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMServiceHist" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emservicehists/{emservicehist_id}")
    public ResponseEntity<EMServiceHistDTO> get(@PathVariable("emservicehist_id") String emservicehist_id) {
        EMServiceHist domain = emservicehistService.get(emservicehist_id);
        EMServiceHistDTO dto = emservicehistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMServiceHist" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emservicehists/getdraft")
    public ResponseEntity<EMServiceHistDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emservicehistMapping.toDto(emservicehistService.getDraft(new EMServiceHist())));
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMServiceHist" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emservicehists")
    @Transactional
    public ResponseEntity<EMServiceHistDTO> create(@RequestBody EMServiceHistDTO emservicehistdto) {
        EMServiceHist domain = emservicehistMapping.toDomain(emservicehistdto);
		emservicehistService.create(domain);
        EMServiceHistDTO dto = emservicehistMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMServiceHist" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emservicehists/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMServiceHistDTO> emservicehistdtos) {
        emservicehistService.createBatch(emservicehistMapping.toDomain(emservicehistdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emservicehist_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMServiceHist" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservicehists/{emservicehist_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emservicehist_id") String emservicehist_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emservicehistService.remove(emservicehist_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMServiceHist" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservicehists/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emservicehistService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emservicehist_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMServiceHist" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservicehists/{emservicehist_id}")
    @Transactional
    public ResponseEntity<EMServiceHistDTO> update(@PathVariable("emservicehist_id") String emservicehist_id, @RequestBody EMServiceHistDTO emservicehistdto) {
		EMServiceHist domain = emservicehistMapping.toDomain(emservicehistdto);
        domain.setEmservicehistid(emservicehist_id);
		emservicehistService.update(domain);
		EMServiceHistDTO dto = emservicehistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emservicehist_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMServiceHist" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservicehists/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMServiceHistDTO> emservicehistdtos) {
        emservicehistService.updateBatch(emservicehistMapping.toDomain(emservicehistdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMServiceHist-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMServiceHist" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emservicehists/fetchdefault")
	public ResponseEntity<List<EMServiceHistDTO>> fetchDefault(EMServiceHistSearchContext context) {
        Page<EMServiceHist> domains = emservicehistService.searchDefault(context) ;
        List<EMServiceHistDTO> list = emservicehistMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMServiceHist-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMServiceHist" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emservicehists/searchdefault")
	public ResponseEntity<Page<EMServiceHistDTO>> searchDefault(@RequestBody EMServiceHistSearchContext context) {
        Page<EMServiceHist> domains = emservicehistService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emservicehistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMServiceHist getEntity(){
        return new EMServiceHist();
    }

}
