package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMResEmp;
import cn.ibizlab.eam.core.eam_core.service.IEMResEmpService;
import cn.ibizlab.eam.core.eam_core.filter.EMResEmpSearchContext;




@Slf4j
@Api(tags = {"EMResEmp" })
@RestController("WebApi-emresemp")
@RequestMapping("")
public class EMResEmpResource {

    @Autowired
    private IEMResEmpService emresempService;

    @Autowired
    @Lazy
    private EMResEmpMapping emresempMapping;




    @ApiOperation(value = "GetDraft", tags = {"EMResEmp" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emresemps/getdraft")
    public ResponseEntity<EMResEmpDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emresempMapping.toDto(emresempService.getDraft(new EMResEmp())));
    }




    @PreAuthorize("hasPermission(#emresemp_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMResEmp" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emresemps/{emresemp_id}")
    public ResponseEntity<EMResEmpDTO> get(@PathVariable("emresemp_id") String emresemp_id) {
        EMResEmp domain = emresempService.get(emresemp_id);
        EMResEmpDTO dto = emresempMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMResEmp" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emresemps")
    @Transactional
    public ResponseEntity<EMResEmpDTO> create(@RequestBody EMResEmpDTO emresempdto) {
        EMResEmp domain = emresempMapping.toDomain(emresempdto);
		emresempService.create(domain);
        EMResEmpDTO dto = emresempMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMResEmp" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emresemps/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMResEmpDTO> emresempdtos) {
        emresempService.createBatch(emresempMapping.toDomain(emresempdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emresemp_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMResEmp" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emresemps/{emresemp_id}")
    @Transactional
    public ResponseEntity<EMResEmpDTO> update(@PathVariable("emresemp_id") String emresemp_id, @RequestBody EMResEmpDTO emresempdto) {
		EMResEmp domain = emresempMapping.toDomain(emresempdto);
        domain.setEmresempid(emresemp_id);
		emresempService.update(domain);
		EMResEmpDTO dto = emresempMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emresemp_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMResEmp" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emresemps/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMResEmpDTO> emresempdtos) {
        emresempService.updateBatch(emresempMapping.toDomain(emresempdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMResEmp" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emresemps/save")
    public ResponseEntity<Boolean> save(@RequestBody EMResEmpDTO emresempdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emresempService.save(emresempMapping.toDomain(emresempdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMResEmp" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emresemps/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMResEmpDTO> emresempdtos) {
        emresempService.saveBatch(emresempMapping.toDomain(emresempdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emresemp_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMResEmp" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emresemps/{emresemp_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emresemp_id") String emresemp_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emresempService.remove(emresemp_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMResEmp" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emresemps/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emresempService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMResEmp" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emresemps/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMResEmpDTO emresempdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emresempService.checkKey(emresempMapping.toDomain(emresempdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMResEmp-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMResEmp" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emresemps/fetchdefault")
	public ResponseEntity<List<EMResEmpDTO>> fetchDefault(EMResEmpSearchContext context) {
        Page<EMResEmp> domains = emresempService.searchDefault(context) ;
        List<EMResEmpDTO> list = emresempMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMResEmp-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMResEmp" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emresemps/searchdefault")
	public ResponseEntity<Page<EMResEmpDTO>> searchDefault(@RequestBody EMResEmpSearchContext context) {
        Page<EMResEmp> domains = emresempService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emresempMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMResEmp getEntity(){
        return new EMResEmp();
    }

}
