package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMRepairCost;
import cn.ibizlab.eam.core.eam_core.service.IEMRepairCostService;
import cn.ibizlab.eam.core.eam_core.filter.EMRepairCostSearchContext;




@Slf4j
@Api(tags = {"EMRepairCost" })
@RestController("WebApi-emrepaircost")
@RequestMapping("")
public class EMRepairCostResource {

    @Autowired
    private IEMRepairCostService emrepaircostService;

    @Autowired
    @Lazy
    private EMRepairCostMapping emrepaircostMapping;




    @ApiOperation(value = "CheckKey", tags = {"EMRepairCost" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emrepaircosts/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMRepairCostDTO emrepaircostdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emrepaircostService.checkKey(emrepaircostMapping.toDomain(emrepaircostdto)));
    }




    @PreAuthorize("hasPermission(#emrepaircost_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMRepairCost" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrepaircosts/{emrepaircost_id}")
    @Transactional
    public ResponseEntity<EMRepairCostDTO> update(@PathVariable("emrepaircost_id") String emrepaircost_id, @RequestBody EMRepairCostDTO emrepaircostdto) {
		EMRepairCost domain = emrepaircostMapping.toDomain(emrepaircostdto);
        domain.setEmrepaircostid(emrepaircost_id);
		emrepaircostService.update(domain);
		EMRepairCostDTO dto = emrepaircostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emrepaircost_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMRepairCost" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrepaircosts/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMRepairCostDTO> emrepaircostdtos) {
        emrepaircostService.updateBatch(emrepaircostMapping.toDomain(emrepaircostdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMRepairCost" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emrepaircosts")
    @Transactional
    public ResponseEntity<EMRepairCostDTO> create(@RequestBody EMRepairCostDTO emrepaircostdto) {
        EMRepairCost domain = emrepaircostMapping.toDomain(emrepaircostdto);
		emrepaircostService.create(domain);
        EMRepairCostDTO dto = emrepaircostMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMRepairCost" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emrepaircosts/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMRepairCostDTO> emrepaircostdtos) {
        emrepaircostService.createBatch(emrepaircostMapping.toDomain(emrepaircostdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMRepairCost" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emrepaircosts/save")
    public ResponseEntity<Boolean> save(@RequestBody EMRepairCostDTO emrepaircostdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emrepaircostService.save(emrepaircostMapping.toDomain(emrepaircostdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMRepairCost" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emrepaircosts/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMRepairCostDTO> emrepaircostdtos) {
        emrepaircostService.saveBatch(emrepaircostMapping.toDomain(emrepaircostdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMRepairCost" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emrepaircosts/getdraft")
    public ResponseEntity<EMRepairCostDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emrepaircostMapping.toDto(emrepaircostService.getDraft(new EMRepairCost())));
    }




    @PreAuthorize("hasPermission(#emrepaircost_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMRepairCost" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrepaircosts/{emrepaircost_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emrepaircost_id") String emrepaircost_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emrepaircostService.remove(emrepaircost_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMRepairCost" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrepaircosts/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emrepaircostService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emrepaircost_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMRepairCost" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emrepaircosts/{emrepaircost_id}")
    public ResponseEntity<EMRepairCostDTO> get(@PathVariable("emrepaircost_id") String emrepaircost_id) {
        EMRepairCost domain = emrepaircostService.get(emrepaircost_id);
        EMRepairCostDTO dto = emrepaircostMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRepairCost-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMRepairCost" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emrepaircosts/fetchdefault")
	public ResponseEntity<List<EMRepairCostDTO>> fetchDefault(EMRepairCostSearchContext context) {
        Page<EMRepairCost> domains = emrepaircostService.searchDefault(context) ;
        List<EMRepairCostDTO> list = emrepaircostMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRepairCost-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMRepairCost" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emrepaircosts/searchdefault")
	public ResponseEntity<Page<EMRepairCostDTO>> searchDefault(@RequestBody EMRepairCostSearchContext context) {
        Page<EMRepairCost> domains = emrepaircostService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emrepaircostMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMRepairCost getEntity(){
        return new EMRepairCost();
    }

}
