package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMRFODEType;
import cn.ibizlab.eam.core.eam_core.service.IEMRFODETypeService;
import cn.ibizlab.eam.core.eam_core.filter.EMRFODETypeSearchContext;




@Slf4j
@Api(tags = {"EMRFODEType" })
@RestController("WebApi-emrfodetype")
@RequestMapping("")
public class EMRFODETypeResource {

    @Autowired
    private IEMRFODETypeService emrfodetypeService;

    @Autowired
    @Lazy
    private EMRFODETypeMapping emrfodetypeMapping;




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMRFODEType" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodetypes")
    @Transactional
    public ResponseEntity<EMRFODETypeDTO> create(@RequestBody EMRFODETypeDTO emrfodetypedto) {
        EMRFODEType domain = emrfodetypeMapping.toDomain(emrfodetypedto);
		emrfodetypeService.create(domain);
        EMRFODETypeDTO dto = emrfodetypeMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMRFODEType" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodetypes/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMRFODETypeDTO> emrfodetypedtos) {
        emrfodetypeService.createBatch(emrfodetypeMapping.toDomain(emrfodetypedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMRFODEType" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodetypes/save")
    public ResponseEntity<Boolean> save(@RequestBody EMRFODETypeDTO emrfodetypedto) {
        return ResponseEntity.status(HttpStatus.OK).body(emrfodetypeService.save(emrfodetypeMapping.toDomain(emrfodetypedto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMRFODEType" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodetypes/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMRFODETypeDTO> emrfodetypedtos) {
        emrfodetypeService.saveBatch(emrfodetypeMapping.toDomain(emrfodetypedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emrfodetype_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMRFODEType" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfodetypes/{emrfodetype_id}")
    @Transactional
    public ResponseEntity<EMRFODETypeDTO> update(@PathVariable("emrfodetype_id") String emrfodetype_id, @RequestBody EMRFODETypeDTO emrfodetypedto) {
		EMRFODEType domain = emrfodetypeMapping.toDomain(emrfodetypedto);
        domain.setEmrfodetypeid(emrfodetype_id);
		emrfodetypeService.update(domain);
		EMRFODETypeDTO dto = emrfodetypeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emrfodetype_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMRFODEType" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrfodetypes/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMRFODETypeDTO> emrfodetypedtos) {
        emrfodetypeService.updateBatch(emrfodetypeMapping.toDomain(emrfodetypedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emrfodetype_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMRFODEType" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfodetypes/{emrfodetype_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emrfodetype_id") String emrfodetype_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emrfodetypeService.remove(emrfodetype_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMRFODEType" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrfodetypes/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emrfodetypeService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMRFODEType" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emrfodetypes/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMRFODETypeDTO emrfodetypedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emrfodetypeService.checkKey(emrfodetypeMapping.toDomain(emrfodetypedto)));
    }




    @ApiOperation(value = "GetDraft", tags = {"EMRFODEType" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emrfodetypes/getdraft")
    public ResponseEntity<EMRFODETypeDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emrfodetypeMapping.toDto(emrfodetypeService.getDraft(new EMRFODEType())));
    }




    @PreAuthorize("hasPermission(#emrfodetype_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMRFODEType" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emrfodetypes/{emrfodetype_id}")
    public ResponseEntity<EMRFODETypeDTO> get(@PathVariable("emrfodetype_id") String emrfodetype_id) {
        EMRFODEType domain = emrfodetypeService.get(emrfodetype_id);
        EMRFODETypeDTO dto = emrfodetypeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFODEType-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMRFODEType" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emrfodetypes/fetchdefault")
	public ResponseEntity<List<EMRFODETypeDTO>> fetchDefault(EMRFODETypeSearchContext context) {
        Page<EMRFODEType> domains = emrfodetypeService.searchDefault(context) ;
        List<EMRFODETypeDTO> list = emrfodetypeMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRFODEType-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMRFODEType" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emrfodetypes/searchdefault")
	public ResponseEntity<Page<EMRFODETypeDTO>> searchDefault(@RequestBody EMRFODETypeSearchContext context) {
        Page<EMRFODEType> domains = emrfodetypeService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emrfodetypeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMRFODEType getEntity(){
        return new EMRFODEType();
    }

}
