package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMPODetail;
import cn.ibizlab.eam.core.eam_core.service.IEMPODetailService;
import cn.ibizlab.eam.core.eam_core.filter.EMPODetailSearchContext;




@Slf4j
@Api(tags = {"EMPODetail" })
@RestController("WebApi-empodetail")
@RequestMapping("")
public class EMPODetailResource {

    @Autowired
    private IEMPODetailService empodetailService;

    @Autowired
    @Lazy
    private EMPODetailMapping empodetailMapping;




    @PreAuthorize("hasPermission(#empodetail_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMPODetail" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<EMPODetailDTO> update(@PathVariable("empodetail_id") String empodetail_id, @RequestBody EMPODetailDTO empodetaildto) {
		EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setEmpodetailid(empodetail_id);
		empodetailService.update(domain);
		EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#empodetail_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMPODetail" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/empodetails/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMPODetailDTO> empodetaildtos) {
        empodetailService.updateBatch(empodetailMapping.toDomain(empodetaildtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#empodetail_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMPODetail" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/empodetails/{empodetail_id}")
    public ResponseEntity<EMPODetailDTO> get(@PathVariable("empodetail_id") String empodetail_id) {
        EMPODetail domain = empodetailService.get(empodetail_id);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMPODetail" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/empodetails")
    @Transactional
    public ResponseEntity<EMPODetailDTO> create(@RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
		empodetailService.create(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMPODetail" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/empodetails/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMPODetailDTO> empodetaildtos) {
        empodetailService.createBatch(empodetailMapping.toDomain(empodetaildtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMPODetail" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/empodetails/getdraft")
    public ResponseEntity<EMPODetailDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(empodetailMapping.toDto(empodetailService.getDraft(new EMPODetail())));
    }




    @ApiOperation(value = "Save", tags = {"EMPODetail" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/empodetails/save")
    public ResponseEntity<Boolean> save(@RequestBody EMPODetailDTO empodetaildto) {
        return ResponseEntity.status(HttpStatus.OK).body(empodetailService.save(empodetailMapping.toDomain(empodetaildto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMPODetail" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/empodetails/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMPODetailDTO> empodetaildtos) {
        empodetailService.saveBatch(empodetailMapping.toDomain(empodetaildtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMPODetail" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/empodetails/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMPODetailDTO empodetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(empodetailService.checkKey(empodetailMapping.toDomain(empodetaildto)));
    }




    @PreAuthorize("hasPermission(#empodetail_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMPODetail" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("empodetail_id") String empodetail_id) {
         return ResponseEntity.status(HttpStatus.OK).body(empodetailService.remove(empodetail_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMPODetail" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/empodetails/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        empodetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPODetail-LaterYear-all')")
	@ApiOperation(value = "fetch近五年采购", tags = {"EMPODetail" } ,notes = "fetch近五年采购")
    @RequestMapping(method= RequestMethod.GET , value="/empodetails/fetchlateryear")
	public ResponseEntity<List<HashMap>> fetchLaterYear(EMPODetailSearchContext context) {
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPODetail-LaterYear-all')")
	@ApiOperation(value = "search近五年采购", tags = {"EMPODetail" } ,notes = "search近五年采购")
    @RequestMapping(method= RequestMethod.POST , value="/empodetails/searchlateryear")
	public ResponseEntity<Page<HashMap>> searchLaterYear(@RequestBody EMPODetailSearchContext context) {
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPODetail-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMPODetail" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/empodetails/fetchdefault")
	public ResponseEntity<List<EMPODetailDTO>> fetchDefault(EMPODetailSearchContext context) {
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
        List<EMPODetailDTO> list = empodetailMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPODetail-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMPODetail" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/empodetails/searchdefault")
	public ResponseEntity<Page<EMPODetailDTO>> searchDefault(@RequestBody EMPODetailSearchContext context) {
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(empodetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "UpdateByEMItem", tags = {"EMPODetail" },  notes = "UpdateByEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<EMPODetailDTO> updateByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        domain.setEmpodetailid(empodetail_id);
		empodetailService.update(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMItem", tags = {"EMPODetail" },  notes = "UpdateBatchByEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMItem", tags = {"EMPODetail" },  notes = "GetByEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/empodetails/{empodetail_id}")
    public ResponseEntity<EMPODetailDTO> getByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
        EMPODetail domain = empodetailService.get(empodetail_id);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CreateByEMItem", tags = {"EMPODetail" },  notes = "CreateByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/empodetails")
    @Transactional
    public ResponseEntity<EMPODetailDTO> createByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
		empodetailService.create(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMItem", tags = {"EMPODetail" },  notes = "createBatchByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> createBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMItem", tags = {"EMPODetail" },  notes = "GetDraftByEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/empodetails/getdraft")
    public ResponseEntity<EMPODetailDTO> getDraftByEMItem(@PathVariable("emitem_id") String emitem_id) {
        EMPODetail domain = new EMPODetail();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailMapping.toDto(empodetailService.getDraft(domain)));
    }

    @ApiOperation(value = "SaveByEMItem", tags = {"EMPODetail" },  notes = "SaveByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/empodetails/save")
    public ResponseEntity<Boolean> saveByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMItem", tags = {"EMPODetail" },  notes = "SaveBatchByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/empodetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
             domain.setItemid(emitem_id);
        }
        empodetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMItem", tags = {"EMPODetail" },  notes = "CheckKeyByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/empodetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(empodetailService.checkKey(empodetailMapping.toDomain(empodetaildto)));
    }

    @ApiOperation(value = "RemoveByEMItem", tags = {"EMPODetail" },  notes = "RemoveByEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(empodetailService.remove(empodetail_id));
    }

    @ApiOperation(value = "RemoveBatchByEMItem", tags = {"EMPODetail" },  notes = "RemoveBatchByEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMItem(@RequestBody List<String> ids) {
        empodetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetch近五年采购ByEMItem", tags = {"EMPODetail" } ,notes = "fetch近五年采购ByEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/empodetails/fetchlateryear")
	public ResponseEntity<List<HashMap>> fetchEMPODetailLaterYearByEMItem(@PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

	@ApiOperation(value = "search近五年采购ByEMItem", tags = {"EMPODetail" } ,notes = "search近五年采购ByEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/empodetails/searchlateryear")
	public ResponseEntity<Page<HashMap>> searchEMPODetailLaterYearByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchDEFAULTByEMItem", tags = {"EMPODetail" } ,notes = "fetchDEFAULTByEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/empodetails/fetchdefault")
	public ResponseEntity<List<EMPODetailDTO>> fetchEMPODetailDefaultByEMItem(@PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
        List<EMPODetailDTO> list = empodetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMItem", tags = {"EMPODetail" } ,notes = "searchDEFAULTByEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/empodetails/searchdefault")
	public ResponseEntity<Page<EMPODetailDTO>> searchEMPODetailDefaultByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(empodetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "UpdateByEMPO", tags = {"EMPODetail" },  notes = "UpdateByEMPO")
	@RequestMapping(method = RequestMethod.PUT, value = "/empos/{empo_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<EMPODetailDTO> updateByEMPO(@PathVariable("empo_id") String empo_id, @PathVariable("empodetail_id") String empodetail_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setPoid(empo_id);
        domain.setEmpodetailid(empodetail_id);
		empodetailService.update(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMPO", tags = {"EMPODetail" },  notes = "UpdateBatchByEMPO")
	@RequestMapping(method = RequestMethod.PUT, value = "/empos/{empo_id}/empodetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMPO(@PathVariable("empo_id") String empo_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setPoid(empo_id);
        }
        empodetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMPO", tags = {"EMPODetail" },  notes = "GetByEMPO")
	@RequestMapping(method = RequestMethod.GET, value = "/empos/{empo_id}/empodetails/{empodetail_id}")
    public ResponseEntity<EMPODetailDTO> getByEMPO(@PathVariable("empo_id") String empo_id, @PathVariable("empodetail_id") String empodetail_id) {
        EMPODetail domain = empodetailService.get(empodetail_id);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CreateByEMPO", tags = {"EMPODetail" },  notes = "CreateByEMPO")
	@RequestMapping(method = RequestMethod.POST, value = "/empos/{empo_id}/empodetails")
    @Transactional
    public ResponseEntity<EMPODetailDTO> createByEMPO(@PathVariable("empo_id") String empo_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setPoid(empo_id);
		empodetailService.create(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMPO", tags = {"EMPODetail" },  notes = "createBatchByEMPO")
	@RequestMapping(method = RequestMethod.POST, value = "/empos/{empo_id}/empodetails/batch")
    public ResponseEntity<Boolean> createBatchByEMPO(@PathVariable("empo_id") String empo_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setPoid(empo_id);
        }
        empodetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMPO", tags = {"EMPODetail" },  notes = "GetDraftByEMPO")
    @RequestMapping(method = RequestMethod.GET, value = "/empos/{empo_id}/empodetails/getdraft")
    public ResponseEntity<EMPODetailDTO> getDraftByEMPO(@PathVariable("empo_id") String empo_id) {
        EMPODetail domain = new EMPODetail();
        domain.setPoid(empo_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailMapping.toDto(empodetailService.getDraft(domain)));
    }

    @ApiOperation(value = "SaveByEMPO", tags = {"EMPODetail" },  notes = "SaveByEMPO")
	@RequestMapping(method = RequestMethod.POST, value = "/empos/{empo_id}/empodetails/save")
    public ResponseEntity<Boolean> saveByEMPO(@PathVariable("empo_id") String empo_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setPoid(empo_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMPO", tags = {"EMPODetail" },  notes = "SaveBatchByEMPO")
	@RequestMapping(method = RequestMethod.POST, value = "/empos/{empo_id}/empodetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMPO(@PathVariable("empo_id") String empo_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
             domain.setPoid(empo_id);
        }
        empodetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMPO", tags = {"EMPODetail" },  notes = "CheckKeyByEMPO")
	@RequestMapping(method = RequestMethod.POST, value = "/empos/{empo_id}/empodetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMPO(@PathVariable("empo_id") String empo_id, @RequestBody EMPODetailDTO empodetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(empodetailService.checkKey(empodetailMapping.toDomain(empodetaildto)));
    }

    @ApiOperation(value = "RemoveByEMPO", tags = {"EMPODetail" },  notes = "RemoveByEMPO")
	@RequestMapping(method = RequestMethod.DELETE, value = "/empos/{empo_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMPO(@PathVariable("empo_id") String empo_id, @PathVariable("empodetail_id") String empodetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(empodetailService.remove(empodetail_id));
    }

    @ApiOperation(value = "RemoveBatchByEMPO", tags = {"EMPODetail" },  notes = "RemoveBatchByEMPO")
	@RequestMapping(method = RequestMethod.DELETE, value = "/empos/{empo_id}/empodetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMPO(@RequestBody List<String> ids) {
        empodetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetch近五年采购ByEMPO", tags = {"EMPODetail" } ,notes = "fetch近五年采购ByEMPO")
    @RequestMapping(method= RequestMethod.GET , value="/empos/{empo_id}/empodetails/fetchlateryear")
	public ResponseEntity<List<HashMap>> fetchEMPODetailLaterYearByEMPO(@PathVariable("empo_id") String empo_id,EMPODetailSearchContext context) {
        context.setN_poid_eq(empo_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

	@ApiOperation(value = "search近五年采购ByEMPO", tags = {"EMPODetail" } ,notes = "search近五年采购ByEMPO")
    @RequestMapping(method= RequestMethod.POST , value="/empos/{empo_id}/empodetails/searchlateryear")
	public ResponseEntity<Page<HashMap>> searchEMPODetailLaterYearByEMPO(@PathVariable("empo_id") String empo_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_poid_eq(empo_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchDEFAULTByEMPO", tags = {"EMPODetail" } ,notes = "fetchDEFAULTByEMPO")
    @RequestMapping(method= RequestMethod.GET , value="/empos/{empo_id}/empodetails/fetchdefault")
	public ResponseEntity<List<EMPODetailDTO>> fetchEMPODetailDefaultByEMPO(@PathVariable("empo_id") String empo_id,EMPODetailSearchContext context) {
        context.setN_poid_eq(empo_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
        List<EMPODetailDTO> list = empodetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMPO", tags = {"EMPODetail" } ,notes = "searchDEFAULTByEMPO")
    @RequestMapping(method= RequestMethod.POST , value="/empos/{empo_id}/empodetails/searchdefault")
	public ResponseEntity<Page<EMPODetailDTO>> searchEMPODetailDefaultByEMPO(@PathVariable("empo_id") String empo_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_poid_eq(empo_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(empodetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "UpdateByEMServiceEMItem", tags = {"EMPODetail" },  notes = "UpdateByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<EMPODetailDTO> updateByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        domain.setEmpodetailid(empodetail_id);
		empodetailService.update(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMServiceEMItem", tags = {"EMPODetail" },  notes = "UpdateBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMServiceEMItem", tags = {"EMPODetail" },  notes = "GetByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    public ResponseEntity<EMPODetailDTO> getByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
        EMPODetail domain = empodetailService.get(empodetail_id);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CreateByEMServiceEMItem", tags = {"EMPODetail" },  notes = "CreateByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/empodetails")
    @Transactional
    public ResponseEntity<EMPODetailDTO> createByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
		empodetailService.create(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMServiceEMItem", tags = {"EMPODetail" },  notes = "createBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> createBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMServiceEMItem", tags = {"EMPODetail" },  notes = "GetDraftByEMServiceEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/getdraft")
    public ResponseEntity<EMPODetailDTO> getDraftByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id) {
        EMPODetail domain = new EMPODetail();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailMapping.toDto(empodetailService.getDraft(domain)));
    }

    @ApiOperation(value = "SaveByEMServiceEMItem", tags = {"EMPODetail" },  notes = "SaveByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/save")
    public ResponseEntity<Boolean> saveByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMServiceEMItem", tags = {"EMPODetail" },  notes = "SaveBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
             domain.setItemid(emitem_id);
        }
        empodetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMServiceEMItem", tags = {"EMPODetail" },  notes = "CheckKeyByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(empodetailService.checkKey(empodetailMapping.toDomain(empodetaildto)));
    }

    @ApiOperation(value = "RemoveByEMServiceEMItem", tags = {"EMPODetail" },  notes = "RemoveByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(empodetailService.remove(empodetail_id));
    }

    @ApiOperation(value = "RemoveBatchByEMServiceEMItem", tags = {"EMPODetail" },  notes = "RemoveBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMServiceEMItem(@RequestBody List<String> ids) {
        empodetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetch近五年采购ByEMServiceEMItem", tags = {"EMPODetail" } ,notes = "fetch近五年采购ByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/fetchlateryear")
	public ResponseEntity<List<HashMap>> fetchEMPODetailLaterYearByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

	@ApiOperation(value = "search近五年采购ByEMServiceEMItem", tags = {"EMPODetail" } ,notes = "search近五年采购ByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/searchlateryear")
	public ResponseEntity<Page<HashMap>> searchEMPODetailLaterYearByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchDEFAULTByEMServiceEMItem", tags = {"EMPODetail" } ,notes = "fetchDEFAULTByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/fetchdefault")
	public ResponseEntity<List<EMPODetailDTO>> fetchEMPODetailDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
        List<EMPODetailDTO> list = empodetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMServiceEMItem", tags = {"EMPODetail" } ,notes = "searchDEFAULTByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/empodetails/searchdefault")
	public ResponseEntity<Page<EMPODetailDTO>> searchEMPODetailDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(empodetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "UpdateByEMStorePartEMItem", tags = {"EMPODetail" },  notes = "UpdateByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<EMPODetailDTO> updateByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        domain.setEmpodetailid(empodetail_id);
		empodetailService.update(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStorePartEMItem", tags = {"EMPODetail" },  notes = "UpdateBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMStorePartEMItem", tags = {"EMPODetail" },  notes = "GetByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    public ResponseEntity<EMPODetailDTO> getByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
        EMPODetail domain = empodetailService.get(empodetail_id);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CreateByEMStorePartEMItem", tags = {"EMPODetail" },  notes = "CreateByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails")
    @Transactional
    public ResponseEntity<EMPODetailDTO> createByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
		empodetailService.create(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStorePartEMItem", tags = {"EMPODetail" },  notes = "createBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> createBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMStorePartEMItem", tags = {"EMPODetail" },  notes = "GetDraftByEMStorePartEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/getdraft")
    public ResponseEntity<EMPODetailDTO> getDraftByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMPODetail domain = new EMPODetail();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailMapping.toDto(empodetailService.getDraft(domain)));
    }

    @ApiOperation(value = "SaveByEMStorePartEMItem", tags = {"EMPODetail" },  notes = "SaveByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/save")
    public ResponseEntity<Boolean> saveByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStorePartEMItem", tags = {"EMPODetail" },  notes = "SaveBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
             domain.setItemid(emitem_id);
        }
        empodetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMStorePartEMItem", tags = {"EMPODetail" },  notes = "CheckKeyByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(empodetailService.checkKey(empodetailMapping.toDomain(empodetaildto)));
    }

    @ApiOperation(value = "RemoveByEMStorePartEMItem", tags = {"EMPODetail" },  notes = "RemoveByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(empodetailService.remove(empodetail_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStorePartEMItem", tags = {"EMPODetail" },  notes = "RemoveBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMStorePartEMItem(@RequestBody List<String> ids) {
        empodetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetch近五年采购ByEMStorePartEMItem", tags = {"EMPODetail" } ,notes = "fetch近五年采购ByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/fetchlateryear")
	public ResponseEntity<List<HashMap>> fetchEMPODetailLaterYearByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

	@ApiOperation(value = "search近五年采购ByEMStorePartEMItem", tags = {"EMPODetail" } ,notes = "search近五年采购ByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/searchlateryear")
	public ResponseEntity<Page<HashMap>> searchEMPODetailLaterYearByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchDEFAULTByEMStorePartEMItem", tags = {"EMPODetail" } ,notes = "fetchDEFAULTByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/fetchdefault")
	public ResponseEntity<List<EMPODetailDTO>> fetchEMPODetailDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
        List<EMPODetailDTO> list = empodetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStorePartEMItem", tags = {"EMPODetail" } ,notes = "searchDEFAULTByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/searchdefault")
	public ResponseEntity<Page<EMPODetailDTO>> searchEMPODetailDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(empodetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "UpdateByEMStoreEMItem", tags = {"EMPODetail" },  notes = "UpdateByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<EMPODetailDTO> updateByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        domain.setEmpodetailid(empodetail_id);
		empodetailService.update(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStoreEMItem", tags = {"EMPODetail" },  notes = "UpdateBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMStoreEMItem", tags = {"EMPODetail" },  notes = "GetByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    public ResponseEntity<EMPODetailDTO> getByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
        EMPODetail domain = empodetailService.get(empodetail_id);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CreateByEMStoreEMItem", tags = {"EMPODetail" },  notes = "CreateByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/empodetails")
    @Transactional
    public ResponseEntity<EMPODetailDTO> createByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
		empodetailService.create(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStoreEMItem", tags = {"EMPODetail" },  notes = "createBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMStoreEMItem", tags = {"EMPODetail" },  notes = "GetDraftByEMStoreEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/getdraft")
    public ResponseEntity<EMPODetailDTO> getDraftByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id) {
        EMPODetail domain = new EMPODetail();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailMapping.toDto(empodetailService.getDraft(domain)));
    }

    @ApiOperation(value = "SaveByEMStoreEMItem", tags = {"EMPODetail" },  notes = "SaveByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/save")
    public ResponseEntity<Boolean> saveByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStoreEMItem", tags = {"EMPODetail" },  notes = "SaveBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
             domain.setItemid(emitem_id);
        }
        empodetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMStoreEMItem", tags = {"EMPODetail" },  notes = "CheckKeyByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(empodetailService.checkKey(empodetailMapping.toDomain(empodetaildto)));
    }

    @ApiOperation(value = "RemoveByEMStoreEMItem", tags = {"EMPODetail" },  notes = "RemoveByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(empodetailService.remove(empodetail_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStoreEMItem", tags = {"EMPODetail" },  notes = "RemoveBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMItem(@RequestBody List<String> ids) {
        empodetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetch近五年采购ByEMStoreEMItem", tags = {"EMPODetail" } ,notes = "fetch近五年采购ByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/fetchlateryear")
	public ResponseEntity<List<HashMap>> fetchEMPODetailLaterYearByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

	@ApiOperation(value = "search近五年采购ByEMStoreEMItem", tags = {"EMPODetail" } ,notes = "search近五年采购ByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/searchlateryear")
	public ResponseEntity<Page<HashMap>> searchEMPODetailLaterYearByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchDEFAULTByEMStoreEMItem", tags = {"EMPODetail" } ,notes = "fetchDEFAULTByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/fetchdefault")
	public ResponseEntity<List<EMPODetailDTO>> fetchEMPODetailDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
        List<EMPODetailDTO> list = empodetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStoreEMItem", tags = {"EMPODetail" } ,notes = "searchDEFAULTByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/empodetails/searchdefault")
	public ResponseEntity<Page<EMPODetailDTO>> searchEMPODetailDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(empodetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "UpdateByPFEmpEMItem", tags = {"EMPODetail" },  notes = "UpdateByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<EMPODetailDTO> updateByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        domain.setEmpodetailid(empodetail_id);
		empodetailService.update(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFEmpEMItem", tags = {"EMPODetail" },  notes = "UpdateBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> updateBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByPFEmpEMItem", tags = {"EMPODetail" },  notes = "GetByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    public ResponseEntity<EMPODetailDTO> getByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
        EMPODetail domain = empodetailService.get(empodetail_id);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CreateByPFEmpEMItem", tags = {"EMPODetail" },  notes = "CreateByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails")
    @Transactional
    public ResponseEntity<EMPODetailDTO> createByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
		empodetailService.create(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFEmpEMItem", tags = {"EMPODetail" },  notes = "createBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> createBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFEmpEMItem", tags = {"EMPODetail" },  notes = "GetDraftByPFEmpEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/getdraft")
    public ResponseEntity<EMPODetailDTO> getDraftByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id) {
        EMPODetail domain = new EMPODetail();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailMapping.toDto(empodetailService.getDraft(domain)));
    }

    @ApiOperation(value = "SaveByPFEmpEMItem", tags = {"EMPODetail" },  notes = "SaveByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/save")
    public ResponseEntity<Boolean> saveByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFEmpEMItem", tags = {"EMPODetail" },  notes = "SaveBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
             domain.setItemid(emitem_id);
        }
        empodetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByPFEmpEMItem", tags = {"EMPODetail" },  notes = "CheckKeyByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(empodetailService.checkKey(empodetailMapping.toDomain(empodetaildto)));
    }

    @ApiOperation(value = "RemoveByPFEmpEMItem", tags = {"EMPODetail" },  notes = "RemoveByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(empodetailService.remove(empodetail_id));
    }

    @ApiOperation(value = "RemoveBatchByPFEmpEMItem", tags = {"EMPODetail" },  notes = "RemoveBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> removeBatchByPFEmpEMItem(@RequestBody List<String> ids) {
        empodetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetch近五年采购ByPFEmpEMItem", tags = {"EMPODetail" } ,notes = "fetch近五年采购ByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/fetchlateryear")
	public ResponseEntity<List<HashMap>> fetchEMPODetailLaterYearByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

	@ApiOperation(value = "search近五年采购ByPFEmpEMItem", tags = {"EMPODetail" } ,notes = "search近五年采购ByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/searchlateryear")
	public ResponseEntity<Page<HashMap>> searchEMPODetailLaterYearByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchDEFAULTByPFEmpEMItem", tags = {"EMPODetail" } ,notes = "fetchDEFAULTByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/fetchdefault")
	public ResponseEntity<List<EMPODetailDTO>> fetchEMPODetailDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
        List<EMPODetailDTO> list = empodetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFEmpEMItem", tags = {"EMPODetail" } ,notes = "searchDEFAULTByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/empodetails/searchdefault")
	public ResponseEntity<Page<EMPODetailDTO>> searchEMPODetailDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(empodetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "UpdateByPFUnitEMItem", tags = {"EMPODetail" },  notes = "UpdateByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<EMPODetailDTO> updateByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        domain.setEmpodetailid(empodetail_id);
		empodetailService.update(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFUnitEMItem", tags = {"EMPODetail" },  notes = "UpdateBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> updateBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByPFUnitEMItem", tags = {"EMPODetail" },  notes = "GetByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    public ResponseEntity<EMPODetailDTO> getByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
        EMPODetail domain = empodetailService.get(empodetail_id);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CreateByPFUnitEMItem", tags = {"EMPODetail" },  notes = "CreateByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails")
    @Transactional
    public ResponseEntity<EMPODetailDTO> createByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
		empodetailService.create(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFUnitEMItem", tags = {"EMPODetail" },  notes = "createBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> createBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFUnitEMItem", tags = {"EMPODetail" },  notes = "GetDraftByPFUnitEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/getdraft")
    public ResponseEntity<EMPODetailDTO> getDraftByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id) {
        EMPODetail domain = new EMPODetail();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailMapping.toDto(empodetailService.getDraft(domain)));
    }

    @ApiOperation(value = "SaveByPFUnitEMItem", tags = {"EMPODetail" },  notes = "SaveByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/save")
    public ResponseEntity<Boolean> saveByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFUnitEMItem", tags = {"EMPODetail" },  notes = "SaveBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
             domain.setItemid(emitem_id);
        }
        empodetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByPFUnitEMItem", tags = {"EMPODetail" },  notes = "CheckKeyByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(empodetailService.checkKey(empodetailMapping.toDomain(empodetaildto)));
    }

    @ApiOperation(value = "RemoveByPFUnitEMItem", tags = {"EMPODetail" },  notes = "RemoveByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(empodetailService.remove(empodetail_id));
    }

    @ApiOperation(value = "RemoveBatchByPFUnitEMItem", tags = {"EMPODetail" },  notes = "RemoveBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> removeBatchByPFUnitEMItem(@RequestBody List<String> ids) {
        empodetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetch近五年采购ByPFUnitEMItem", tags = {"EMPODetail" } ,notes = "fetch近五年采购ByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/fetchlateryear")
	public ResponseEntity<List<HashMap>> fetchEMPODetailLaterYearByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

	@ApiOperation(value = "search近五年采购ByPFUnitEMItem", tags = {"EMPODetail" } ,notes = "search近五年采购ByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/searchlateryear")
	public ResponseEntity<Page<HashMap>> searchEMPODetailLaterYearByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchDEFAULTByPFUnitEMItem", tags = {"EMPODetail" } ,notes = "fetchDEFAULTByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/fetchdefault")
	public ResponseEntity<List<EMPODetailDTO>> fetchEMPODetailDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
        List<EMPODetailDTO> list = empodetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFUnitEMItem", tags = {"EMPODetail" } ,notes = "searchDEFAULTByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/empodetails/searchdefault")
	public ResponseEntity<Page<EMPODetailDTO>> searchEMPODetailDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(empodetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}





    @ApiOperation(value = "UpdateByEMStoreEMStorePartEMItem", tags = {"EMPODetail" },  notes = "UpdateByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<EMPODetailDTO> updateByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        domain.setEmpodetailid(empodetail_id);
		empodetailService.update(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStoreEMStorePartEMItem", tags = {"EMPODetail" },  notes = "UpdateBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMStoreEMStorePartEMItem", tags = {"EMPODetail" },  notes = "GetByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    public ResponseEntity<EMPODetailDTO> getByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
        EMPODetail domain = empodetailService.get(empodetail_id);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CreateByEMStoreEMStorePartEMItem", tags = {"EMPODetail" },  notes = "CreateByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails")
    @Transactional
    public ResponseEntity<EMPODetailDTO> createByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
		empodetailService.create(domain);
        EMPODetailDTO dto = empodetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStoreEMStorePartEMItem", tags = {"EMPODetail" },  notes = "createBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
            domain.setItemid(emitem_id);
        }
        empodetailService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMStoreEMStorePartEMItem", tags = {"EMPODetail" },  notes = "GetDraftByEMStoreEMStorePartEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/getdraft")
    public ResponseEntity<EMPODetailDTO> getDraftByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMPODetail domain = new EMPODetail();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailMapping.toDto(empodetailService.getDraft(domain)));
    }

    @ApiOperation(value = "SaveByEMStoreEMStorePartEMItem", tags = {"EMPODetail" },  notes = "SaveByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/save")
    public ResponseEntity<Boolean> saveByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        EMPODetail domain = empodetailMapping.toDomain(empodetaildto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(empodetailService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStoreEMStorePartEMItem", tags = {"EMPODetail" },  notes = "SaveBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMPODetailDTO> empodetaildtos) {
        List<EMPODetail> domainlist=empodetailMapping.toDomain(empodetaildtos);
        for(EMPODetail domain:domainlist){
             domain.setItemid(emitem_id);
        }
        empodetailService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMStoreEMStorePartEMItem", tags = {"EMPODetail" },  notes = "CheckKeyByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailDTO empodetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(empodetailService.checkKey(empodetailMapping.toDomain(empodetaildto)));
    }

    @ApiOperation(value = "RemoveByEMStoreEMStorePartEMItem", tags = {"EMPODetail" },  notes = "RemoveByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/{empodetail_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("empodetail_id") String empodetail_id) {
		return ResponseEntity.status(HttpStatus.OK).body(empodetailService.remove(empodetail_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStoreEMStorePartEMItem", tags = {"EMPODetail" },  notes = "RemoveBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMStorePartEMItem(@RequestBody List<String> ids) {
        empodetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetch近五年采购ByEMStoreEMStorePartEMItem", tags = {"EMPODetail" } ,notes = "fetch近五年采购ByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/fetchlateryear")
	public ResponseEntity<List<HashMap>> fetchEMPODetailLaterYearByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(domains.getContent());
	}

	@ApiOperation(value = "search近五年采购ByEMStoreEMStorePartEMItem", tags = {"EMPODetail" } ,notes = "search近五年采购ByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/searchlateryear")
	public ResponseEntity<Page<HashMap>> searchEMPODetailLaterYearByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<HashMap> domains = empodetailService.searchLaterYear(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(domains.getContent(), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchDEFAULTByEMStoreEMStorePartEMItem", tags = {"EMPODetail" } ,notes = "fetchDEFAULTByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/fetchdefault")
	public ResponseEntity<List<EMPODetailDTO>> fetchEMPODetailDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
        List<EMPODetailDTO> list = empodetailMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStoreEMStorePartEMItem", tags = {"EMPODetail" } ,notes = "searchDEFAULTByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/empodetails/searchdefault")
	public ResponseEntity<Page<EMPODetailDTO>> searchEMPODetailDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMPODetailSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMPODetail> domains = empodetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(empodetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMPODetail getEntity(){
        return new EMPODetail();
    }

}
