package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMMachModel;
import cn.ibizlab.eam.core.eam_core.service.IEMMachModelService;
import cn.ibizlab.eam.core.eam_core.filter.EMMachModelSearchContext;




@Slf4j
@Api(tags = {"EMMachModel" })
@RestController("WebApi-emmachmodel")
@RequestMapping("")
public class EMMachModelResource {

    @Autowired
    private IEMMachModelService emmachmodelService;

    @Autowired
    @Lazy
    private EMMachModelMapping emmachmodelMapping;




    @ApiOperation(value = "GetDraft", tags = {"EMMachModel" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emmachmodels/getdraft")
    public ResponseEntity<EMMachModelDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emmachmodelMapping.toDto(emmachmodelService.getDraft(new EMMachModel())));
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMMachModel" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emmachmodels")
    @Transactional
    public ResponseEntity<EMMachModelDTO> create(@RequestBody EMMachModelDTO emmachmodeldto) {
        EMMachModel domain = emmachmodelMapping.toDomain(emmachmodeldto);
		emmachmodelService.create(domain);
        EMMachModelDTO dto = emmachmodelMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMMachModel" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emmachmodels/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMMachModelDTO> emmachmodeldtos) {
        emmachmodelService.createBatch(emmachmodelMapping.toDomain(emmachmodeldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emmachmodel_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMMachModel" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emmachmodels/{emmachmodel_id}")
    public ResponseEntity<EMMachModelDTO> get(@PathVariable("emmachmodel_id") String emmachmodel_id) {
        EMMachModel domain = emmachmodelService.get(emmachmodel_id);
        EMMachModelDTO dto = emmachmodelMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @PreAuthorize("hasPermission(#emmachmodel_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMMachModel" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emmachmodels/{emmachmodel_id}")
    @Transactional
    public ResponseEntity<EMMachModelDTO> update(@PathVariable("emmachmodel_id") String emmachmodel_id, @RequestBody EMMachModelDTO emmachmodeldto) {
		EMMachModel domain = emmachmodelMapping.toDomain(emmachmodeldto);
        domain.setEmmachmodelid(emmachmodel_id);
		emmachmodelService.update(domain);
		EMMachModelDTO dto = emmachmodelMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emmachmodel_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMMachModel" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emmachmodels/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMMachModelDTO> emmachmodeldtos) {
        emmachmodelService.updateBatch(emmachmodelMapping.toDomain(emmachmodeldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMMachModel" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emmachmodels/save")
    public ResponseEntity<Boolean> save(@RequestBody EMMachModelDTO emmachmodeldto) {
        return ResponseEntity.status(HttpStatus.OK).body(emmachmodelService.save(emmachmodelMapping.toDomain(emmachmodeldto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMMachModel" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emmachmodels/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMMachModelDTO> emmachmodeldtos) {
        emmachmodelService.saveBatch(emmachmodelMapping.toDomain(emmachmodeldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMMachModel" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emmachmodels/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMMachModelDTO emmachmodeldto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emmachmodelService.checkKey(emmachmodelMapping.toDomain(emmachmodeldto)));
    }




    @PreAuthorize("hasPermission(#emmachmodel_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMMachModel" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emmachmodels/{emmachmodel_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emmachmodel_id") String emmachmodel_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emmachmodelService.remove(emmachmodel_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMMachModel" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emmachmodels/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emmachmodelService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMMachModel-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMMachModel" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emmachmodels/fetchdefault")
	public ResponseEntity<List<EMMachModelDTO>> fetchDefault(EMMachModelSearchContext context) {
        Page<EMMachModel> domains = emmachmodelService.searchDefault(context) ;
        List<EMMachModelDTO> list = emmachmodelMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMMachModel-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMMachModel" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emmachmodels/searchdefault")
	public ResponseEntity<Page<EMMachModelDTO>> searchDefault(@RequestBody EMMachModelSearchContext context) {
        Page<EMMachModel> domains = emmachmodelService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emmachmodelMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMMachModel getEntity(){
        return new EMMachModel();
    }

}
