package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMItemType;
import cn.ibizlab.eam.core.eam_core.service.IEMItemTypeService;
import cn.ibizlab.eam.core.eam_core.filter.EMItemTypeSearchContext;




@Slf4j
@Api(tags = {"EMItemType" })
@RestController("WebApi-emitemtype")
@RequestMapping("")
public class EMItemTypeResource {

    @Autowired
    private IEMItemTypeService emitemtypeService;

    @Autowired
    @Lazy
    private EMItemTypeMapping emitemtypeMapping;




    @ApiOperation(value = "GetDraft", tags = {"EMItemType" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emitemtypes/getdraft")
    public ResponseEntity<EMItemTypeDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emitemtypeMapping.toDto(emitemtypeService.getDraft(new EMItemType())));
    }




    @PreAuthorize("hasPermission(#emitemtype_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMItemType" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emitemtypes/{emitemtype_id}")
    public ResponseEntity<EMItemTypeDTO> get(@PathVariable("emitemtype_id") String emitemtype_id) {
        EMItemType domain = emitemtypeService.get(emitemtype_id);
        EMItemTypeDTO dto = emitemtypeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "Save", tags = {"EMItemType" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemtypes/save")
    public ResponseEntity<Boolean> save(@RequestBody EMItemTypeDTO emitemtypedto) {
        return ResponseEntity.status(HttpStatus.OK).body(emitemtypeService.save(emitemtypeMapping.toDomain(emitemtypedto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMItemType" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemtypes/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMItemTypeDTO> emitemtypedtos) {
        emitemtypeService.saveBatch(emitemtypeMapping.toDomain(emitemtypedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMItemType" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemtypes/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMItemTypeDTO emitemtypedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemtypeService.checkKey(emitemtypeMapping.toDomain(emitemtypedto)));
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMItemType" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemtypes")
    @Transactional
    public ResponseEntity<EMItemTypeDTO> create(@RequestBody EMItemTypeDTO emitemtypedto) {
        EMItemType domain = emitemtypeMapping.toDomain(emitemtypedto);
		emitemtypeService.create(domain);
        EMItemTypeDTO dto = emitemtypeMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMItemType" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemtypes/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMItemTypeDTO> emitemtypedtos) {
        emitemtypeService.createBatch(emitemtypeMapping.toDomain(emitemtypedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emitemtype_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMItemType" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitemtypes/{emitemtype_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emitemtype_id") String emitemtype_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emitemtypeService.remove(emitemtype_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMItemType" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitemtypes/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emitemtypeService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emitemtype_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMItemType" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitemtypes/{emitemtype_id}")
    @Transactional
    public ResponseEntity<EMItemTypeDTO> update(@PathVariable("emitemtype_id") String emitemtype_id, @RequestBody EMItemTypeDTO emitemtypedto) {
		EMItemType domain = emitemtypeMapping.toDomain(emitemtypedto);
        domain.setEmitemtypeid(emitemtype_id);
		emitemtypeService.update(domain);
		EMItemTypeDTO dto = emitemtypeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emitemtype_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMItemType" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitemtypes/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMItemTypeDTO> emitemtypedtos) {
        emitemtypeService.updateBatch(emitemtypeMapping.toDomain(emitemtypedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemType-ItemType-all')")
	@ApiOperation(value = "fetch上级类型查询", tags = {"EMItemType" } ,notes = "fetch上级类型查询")
    @RequestMapping(method= RequestMethod.GET , value="/emitemtypes/fetchitemtype")
	public ResponseEntity<List<EMItemTypeDTO>> fetchItemType(EMItemTypeSearchContext context) {
        Page<EMItemType> domains = emitemtypeService.searchItemType(context) ;
        List<EMItemTypeDTO> list = emitemtypeMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemType-ItemType-all')")
	@ApiOperation(value = "search上级类型查询", tags = {"EMItemType" } ,notes = "search上级类型查询")
    @RequestMapping(method= RequestMethod.POST , value="/emitemtypes/searchitemtype")
	public ResponseEntity<Page<EMItemTypeDTO>> searchItemType(@RequestBody EMItemTypeSearchContext context) {
        Page<EMItemType> domains = emitemtypeService.searchItemType(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemtypeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemType-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMItemType" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emitemtypes/fetchdefault")
	public ResponseEntity<List<EMItemTypeDTO>> fetchDefault(EMItemTypeSearchContext context) {
        Page<EMItemType> domains = emitemtypeService.searchDefault(context) ;
        List<EMItemTypeDTO> list = emitemtypeMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemType-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMItemType" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emitemtypes/searchdefault")
	public ResponseEntity<Page<EMItemTypeDTO>> searchDefault(@RequestBody EMItemTypeSearchContext context) {
        Page<EMItemType> domains = emitemtypeService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemtypeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMItemType getEntity(){
        return new EMItemType();
    }

}
