package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMItem;
import cn.ibizlab.eam.core.eam_core.service.IEMItemService;
import cn.ibizlab.eam.core.eam_core.filter.EMItemSearchContext;




@Slf4j
@Api(tags = {"EMItem" })
@RestController("WebApi-emitem")
@RequestMapping("")
public class EMItemResource {

    @Autowired
    private IEMItemService emitemService;

    @Autowired
    @Lazy
    private EMItemMapping emitemMapping;




    @PreAuthorize("hasPermission(#emitem_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMItem" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emitem_id") String emitem_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emitemService.remove(emitem_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMItem" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emitemService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emitem_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMItem" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}")
    public ResponseEntity<EMItemDTO> get(@PathVariable("emitem_id") String emitem_id) {
        EMItem domain = emitemService.get(emitem_id);
        EMItemDTO dto = emitemMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "Save", tags = {"EMItem" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/save")
    public ResponseEntity<Boolean> save(@RequestBody EMItemDTO emitemdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emitemService.save(emitemMapping.toDomain(emitemdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMItem" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMItemDTO> emitemdtos) {
        emitemService.saveBatch(emitemMapping.toDomain(emitemdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMItem" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emitems/getdraft")
    public ResponseEntity<EMItemDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emitemMapping.toDto(emitemService.getDraft(new EMItem())));
    }




    @PreAuthorize("hasPermission(#emitem_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMItem" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}")
    @Transactional
    public ResponseEntity<EMItemDTO> update(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemDTO emitemdto) {
		EMItem domain = emitemMapping.toDomain(emitemdto);
        domain.setEmitemid(emitem_id);
		emitemService.update(domain);
		EMItemDTO dto = emitemMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emitem_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMItem" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMItemDTO> emitemdtos) {
        emitemService.updateBatch(emitemMapping.toDomain(emitemdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMItem" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems")
    @Transactional
    public ResponseEntity<EMItemDTO> create(@RequestBody EMItemDTO emitemdto) {
        EMItem domain = emitemMapping.toDomain(emitemdto);
		emitemService.create(domain);
        EMItemDTO dto = emitemMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMItem" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMItemDTO> emitemdtos) {
        emitemService.createBatch(emitemMapping.toDomain(emitemdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMItem" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMItemDTO emitemdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemService.checkKey(emitemMapping.toDomain(emitemdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItem-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMItem" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/fetchdefault")
	public ResponseEntity<List<EMItemDTO>> fetchDefault(EMItemSearchContext context) {
        Page<EMItem> domains = emitemService.searchDefault(context) ;
        List<EMItemDTO> list = emitemMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItem-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMItem" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/searchdefault")
	public ResponseEntity<Page<EMItemDTO>> searchDefault(@RequestBody EMItemSearchContext context) {
        Page<EMItem> domains = emitemService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItem-ItemTypeTree-all')")
	@ApiOperation(value = "fetch类型树物品", tags = {"EMItem" } ,notes = "fetch类型树物品")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/fetchitemtypetree")
	public ResponseEntity<List<EMItemDTO>> fetchItemTypeTree(EMItemSearchContext context) {
        Page<EMItem> domains = emitemService.searchItemTypeTree(context) ;
        List<EMItemDTO> list = emitemMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItem-ItemTypeTree-all')")
	@ApiOperation(value = "search类型树物品", tags = {"EMItem" } ,notes = "search类型树物品")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/searchitemtypetree")
	public ResponseEntity<Page<EMItemDTO>> searchItemTypeTree(@RequestBody EMItemSearchContext context) {
        Page<EMItem> domains = emitemService.searchItemTypeTree(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "RemoveByEMService", tags = {"EMItem" },  notes = "RemoveByEMService")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMService(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemService.remove(emitem_id));
    }

    @ApiOperation(value = "RemoveBatchByEMService", tags = {"EMItem" },  notes = "RemoveBatchByEMService")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/batch")
    public ResponseEntity<Boolean> removeBatchByEMService(@RequestBody List<String> ids) {
        emitemService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMService", tags = {"EMItem" },  notes = "GetByEMService")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}")
    public ResponseEntity<EMItemDTO> getByEMService(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id) {
        EMItem domain = emitemService.get(emitem_id);
        EMItemDTO dto = emitemMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByEMService", tags = {"EMItem" },  notes = "SaveByEMService")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/save")
    public ResponseEntity<Boolean> saveByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody EMItemDTO emitemdto) {
        EMItem domain = emitemMapping.toDomain(emitemdto);
        domain.setMserviceid(emservice_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMService", tags = {"EMItem" },  notes = "SaveBatchByEMService")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody List<EMItemDTO> emitemdtos) {
        List<EMItem> domainlist=emitemMapping.toDomain(emitemdtos);
        for(EMItem domain:domainlist){
             domain.setMserviceid(emservice_id);
        }
        emitemService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMService", tags = {"EMItem" },  notes = "GetDraftByEMService")
    @RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/getdraft")
    public ResponseEntity<EMItemDTO> getDraftByEMService(@PathVariable("emservice_id") String emservice_id) {
        EMItem domain = new EMItem();
        domain.setMserviceid(emservice_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemMapping.toDto(emitemService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByEMService", tags = {"EMItem" },  notes = "UpdateByEMService")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}")
    @Transactional
    public ResponseEntity<EMItemDTO> updateByEMService(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemDTO emitemdto) {
        EMItem domain = emitemMapping.toDomain(emitemdto);
        domain.setMserviceid(emservice_id);
        domain.setEmitemid(emitem_id);
		emitemService.update(domain);
        EMItemDTO dto = emitemMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMService", tags = {"EMItem" },  notes = "UpdateBatchByEMService")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/batch")
    public ResponseEntity<Boolean> updateBatchByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody List<EMItemDTO> emitemdtos) {
        List<EMItem> domainlist=emitemMapping.toDomain(emitemdtos);
        for(EMItem domain:domainlist){
            domain.setMserviceid(emservice_id);
        }
        emitemService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMService", tags = {"EMItem" },  notes = "CreateByEMService")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems")
    @Transactional
    public ResponseEntity<EMItemDTO> createByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody EMItemDTO emitemdto) {
        EMItem domain = emitemMapping.toDomain(emitemdto);
        domain.setMserviceid(emservice_id);
		emitemService.create(domain);
        EMItemDTO dto = emitemMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMService", tags = {"EMItem" },  notes = "createBatchByEMService")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/batch")
    public ResponseEntity<Boolean> createBatchByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody List<EMItemDTO> emitemdtos) {
        List<EMItem> domainlist=emitemMapping.toDomain(emitemdtos);
        for(EMItem domain:domainlist){
            domain.setMserviceid(emservice_id);
        }
        emitemService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMService", tags = {"EMItem" },  notes = "CheckKeyByEMService")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody EMItemDTO emitemdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemService.checkKey(emitemMapping.toDomain(emitemdto)));
    }

	@ApiOperation(value = "fetchDEFAULTByEMService", tags = {"EMItem" } ,notes = "fetchDEFAULTByEMService")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/fetchdefault")
	public ResponseEntity<List<EMItemDTO>> fetchEMItemDefaultByEMService(@PathVariable("emservice_id") String emservice_id,EMItemSearchContext context) {
        context.setN_mserviceid_eq(emservice_id);
        Page<EMItem> domains = emitemService.searchDefault(context) ;
        List<EMItemDTO> list = emitemMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMService", tags = {"EMItem" } ,notes = "searchDEFAULTByEMService")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/searchdefault")
	public ResponseEntity<Page<EMItemDTO>> searchEMItemDefaultByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody EMItemSearchContext context) {
        context.setN_mserviceid_eq(emservice_id);
        Page<EMItem> domains = emitemService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch类型树物品ByEMService", tags = {"EMItem" } ,notes = "fetch类型树物品ByEMService")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/fetchitemtypetree")
	public ResponseEntity<List<EMItemDTO>> fetchEMItemItemTypeTreeByEMService(@PathVariable("emservice_id") String emservice_id,EMItemSearchContext context) {
        context.setN_mserviceid_eq(emservice_id);
        Page<EMItem> domains = emitemService.searchItemTypeTree(context) ;
        List<EMItemDTO> list = emitemMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search类型树物品ByEMService", tags = {"EMItem" } ,notes = "search类型树物品ByEMService")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/searchitemtypetree")
	public ResponseEntity<Page<EMItemDTO>> searchEMItemItemTypeTreeByEMService(@PathVariable("emservice_id") String emservice_id, @RequestBody EMItemSearchContext context) {
        context.setN_mserviceid_eq(emservice_id);
        Page<EMItem> domains = emitemService.searchItemTypeTree(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "RemoveByEMStorePart", tags = {"EMItem" },  notes = "RemoveByEMStorePart")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemService.remove(emitem_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStorePart", tags = {"EMItem" },  notes = "RemoveBatchByEMStorePart")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/batch")
    public ResponseEntity<Boolean> removeBatchByEMStorePart(@RequestBody List<String> ids) {
        emitemService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMStorePart", tags = {"EMItem" },  notes = "GetByEMStorePart")
	@RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}")
    public ResponseEntity<EMItemDTO> getByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMItem domain = emitemService.get(emitem_id);
        EMItemDTO dto = emitemMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByEMStorePart", tags = {"EMItem" },  notes = "SaveByEMStorePart")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/save")
    public ResponseEntity<Boolean> saveByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id, @RequestBody EMItemDTO emitemdto) {
        EMItem domain = emitemMapping.toDomain(emitemdto);
        domain.setStorepartid(emstorepart_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStorePart", tags = {"EMItem" },  notes = "SaveBatchByEMStorePart")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id, @RequestBody List<EMItemDTO> emitemdtos) {
        List<EMItem> domainlist=emitemMapping.toDomain(emitemdtos);
        for(EMItem domain:domainlist){
             domain.setStorepartid(emstorepart_id);
        }
        emitemService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMStorePart", tags = {"EMItem" },  notes = "GetDraftByEMStorePart")
    @RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/getdraft")
    public ResponseEntity<EMItemDTO> getDraftByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id) {
        EMItem domain = new EMItem();
        domain.setStorepartid(emstorepart_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemMapping.toDto(emitemService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByEMStorePart", tags = {"EMItem" },  notes = "UpdateByEMStorePart")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}")
    @Transactional
    public ResponseEntity<EMItemDTO> updateByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemDTO emitemdto) {
        EMItem domain = emitemMapping.toDomain(emitemdto);
        domain.setStorepartid(emstorepart_id);
        domain.setEmitemid(emitem_id);
		emitemService.update(domain);
        EMItemDTO dto = emitemMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStorePart", tags = {"EMItem" },  notes = "UpdateBatchByEMStorePart")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/batch")
    public ResponseEntity<Boolean> updateBatchByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id, @RequestBody List<EMItemDTO> emitemdtos) {
        List<EMItem> domainlist=emitemMapping.toDomain(emitemdtos);
        for(EMItem domain:domainlist){
            domain.setStorepartid(emstorepart_id);
        }
        emitemService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMStorePart", tags = {"EMItem" },  notes = "CreateByEMStorePart")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems")
    @Transactional
    public ResponseEntity<EMItemDTO> createByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id, @RequestBody EMItemDTO emitemdto) {
        EMItem domain = emitemMapping.toDomain(emitemdto);
        domain.setStorepartid(emstorepart_id);
		emitemService.create(domain);
        EMItemDTO dto = emitemMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStorePart", tags = {"EMItem" },  notes = "createBatchByEMStorePart")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/batch")
    public ResponseEntity<Boolean> createBatchByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id, @RequestBody List<EMItemDTO> emitemdtos) {
        List<EMItem> domainlist=emitemMapping.toDomain(emitemdtos);
        for(EMItem domain:domainlist){
            domain.setStorepartid(emstorepart_id);
        }
        emitemService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMStorePart", tags = {"EMItem" },  notes = "CheckKeyByEMStorePart")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id, @RequestBody EMItemDTO emitemdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemService.checkKey(emitemMapping.toDomain(emitemdto)));
    }

	@ApiOperation(value = "fetchDEFAULTByEMStorePart", tags = {"EMItem" } ,notes = "fetchDEFAULTByEMStorePart")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/fetchdefault")
	public ResponseEntity<List<EMItemDTO>> fetchEMItemDefaultByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id,EMItemSearchContext context) {
        context.setN_storepartid_eq(emstorepart_id);
        Page<EMItem> domains = emitemService.searchDefault(context) ;
        List<EMItemDTO> list = emitemMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStorePart", tags = {"EMItem" } ,notes = "searchDEFAULTByEMStorePart")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/searchdefault")
	public ResponseEntity<Page<EMItemDTO>> searchEMItemDefaultByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id, @RequestBody EMItemSearchContext context) {
        context.setN_storepartid_eq(emstorepart_id);
        Page<EMItem> domains = emitemService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch类型树物品ByEMStorePart", tags = {"EMItem" } ,notes = "fetch类型树物品ByEMStorePart")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/fetchitemtypetree")
	public ResponseEntity<List<EMItemDTO>> fetchEMItemItemTypeTreeByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id,EMItemSearchContext context) {
        context.setN_storepartid_eq(emstorepart_id);
        Page<EMItem> domains = emitemService.searchItemTypeTree(context) ;
        List<EMItemDTO> list = emitemMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search类型树物品ByEMStorePart", tags = {"EMItem" } ,notes = "search类型树物品ByEMStorePart")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/searchitemtypetree")
	public ResponseEntity<Page<EMItemDTO>> searchEMItemItemTypeTreeByEMStorePart(@PathVariable("emstorepart_id") String emstorepart_id, @RequestBody EMItemSearchContext context) {
        context.setN_storepartid_eq(emstorepart_id);
        Page<EMItem> domains = emitemService.searchItemTypeTree(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "RemoveByEMStore", tags = {"EMItem" },  notes = "RemoveByEMStore")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStore(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemService.remove(emitem_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStore", tags = {"EMItem" },  notes = "RemoveBatchByEMStore")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/batch")
    public ResponseEntity<Boolean> removeBatchByEMStore(@RequestBody List<String> ids) {
        emitemService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMStore", tags = {"EMItem" },  notes = "GetByEMStore")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}")
    public ResponseEntity<EMItemDTO> getByEMStore(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id) {
        EMItem domain = emitemService.get(emitem_id);
        EMItemDTO dto = emitemMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByEMStore", tags = {"EMItem" },  notes = "SaveByEMStore")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/save")
    public ResponseEntity<Boolean> saveByEMStore(@PathVariable("emstore_id") String emstore_id, @RequestBody EMItemDTO emitemdto) {
        EMItem domain = emitemMapping.toDomain(emitemdto);
        domain.setStoreid(emstore_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStore", tags = {"EMItem" },  notes = "SaveBatchByEMStore")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStore(@PathVariable("emstore_id") String emstore_id, @RequestBody List<EMItemDTO> emitemdtos) {
        List<EMItem> domainlist=emitemMapping.toDomain(emitemdtos);
        for(EMItem domain:domainlist){
             domain.setStoreid(emstore_id);
        }
        emitemService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMStore", tags = {"EMItem" },  notes = "GetDraftByEMStore")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/getdraft")
    public ResponseEntity<EMItemDTO> getDraftByEMStore(@PathVariable("emstore_id") String emstore_id) {
        EMItem domain = new EMItem();
        domain.setStoreid(emstore_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemMapping.toDto(emitemService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByEMStore", tags = {"EMItem" },  notes = "UpdateByEMStore")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}")
    @Transactional
    public ResponseEntity<EMItemDTO> updateByEMStore(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemDTO emitemdto) {
        EMItem domain = emitemMapping.toDomain(emitemdto);
        domain.setStoreid(emstore_id);
        domain.setEmitemid(emitem_id);
		emitemService.update(domain);
        EMItemDTO dto = emitemMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStore", tags = {"EMItem" },  notes = "UpdateBatchByEMStore")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/batch")
    public ResponseEntity<Boolean> updateBatchByEMStore(@PathVariable("emstore_id") String emstore_id, @RequestBody List<EMItemDTO> emitemdtos) {
        List<EMItem> domainlist=emitemMapping.toDomain(emitemdtos);
        for(EMItem domain:domainlist){
            domain.setStoreid(emstore_id);
        }
        emitemService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMStore", tags = {"EMItem" },  notes = "CreateByEMStore")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems")
    @Transactional
    public ResponseEntity<EMItemDTO> createByEMStore(@PathVariable("emstore_id") String emstore_id, @RequestBody EMItemDTO emitemdto) {
        EMItem domain = emitemMapping.toDomain(emitemdto);
        domain.setStoreid(emstore_id);
		emitemService.create(domain);
        EMItemDTO dto = emitemMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStore", tags = {"EMItem" },  notes = "createBatchByEMStore")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/batch")
    public ResponseEntity<Boolean> createBatchByEMStore(@PathVariable("emstore_id") String emstore_id, @RequestBody List<EMItemDTO> emitemdtos) {
        List<EMItem> domainlist=emitemMapping.toDomain(emitemdtos);
        for(EMItem domain:domainlist){
            domain.setStoreid(emstore_id);
        }
        emitemService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMStore", tags = {"EMItem" },  notes = "CheckKeyByEMStore")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStore(@PathVariable("emstore_id") String emstore_id, @RequestBody EMItemDTO emitemdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemService.checkKey(emitemMapping.toDomain(emitemdto)));
    }

	@ApiOperation(value = "fetchDEFAULTByEMStore", tags = {"EMItem" } ,notes = "fetchDEFAULTByEMStore")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/fetchdefault")
	public ResponseEntity<List<EMItemDTO>> fetchEMItemDefaultByEMStore(@PathVariable("emstore_id") String emstore_id,EMItemSearchContext context) {
        context.setN_storeid_eq(emstore_id);
        Page<EMItem> domains = emitemService.searchDefault(context) ;
        List<EMItemDTO> list = emitemMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStore", tags = {"EMItem" } ,notes = "searchDEFAULTByEMStore")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/searchdefault")
	public ResponseEntity<Page<EMItemDTO>> searchEMItemDefaultByEMStore(@PathVariable("emstore_id") String emstore_id, @RequestBody EMItemSearchContext context) {
        context.setN_storeid_eq(emstore_id);
        Page<EMItem> domains = emitemService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch类型树物品ByEMStore", tags = {"EMItem" } ,notes = "fetch类型树物品ByEMStore")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/fetchitemtypetree")
	public ResponseEntity<List<EMItemDTO>> fetchEMItemItemTypeTreeByEMStore(@PathVariable("emstore_id") String emstore_id,EMItemSearchContext context) {
        context.setN_storeid_eq(emstore_id);
        Page<EMItem> domains = emitemService.searchItemTypeTree(context) ;
        List<EMItemDTO> list = emitemMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search类型树物品ByEMStore", tags = {"EMItem" } ,notes = "search类型树物品ByEMStore")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/searchitemtypetree")
	public ResponseEntity<Page<EMItemDTO>> searchEMItemItemTypeTreeByEMStore(@PathVariable("emstore_id") String emstore_id, @RequestBody EMItemSearchContext context) {
        context.setN_storeid_eq(emstore_id);
        Page<EMItem> domains = emitemService.searchItemTypeTree(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "RemoveByPFEmp", tags = {"EMItem" },  notes = "RemoveByPFEmp")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemService.remove(emitem_id));
    }

    @ApiOperation(value = "RemoveBatchByPFEmp", tags = {"EMItem" },  notes = "RemoveBatchByPFEmp")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/batch")
    public ResponseEntity<Boolean> removeBatchByPFEmp(@RequestBody List<String> ids) {
        emitemService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByPFEmp", tags = {"EMItem" },  notes = "GetByPFEmp")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}")
    public ResponseEntity<EMItemDTO> getByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id) {
        EMItem domain = emitemService.get(emitem_id);
        EMItemDTO dto = emitemMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByPFEmp", tags = {"EMItem" },  notes = "SaveByPFEmp")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/save")
    public ResponseEntity<Boolean> saveByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody EMItemDTO emitemdto) {
        EMItem domain = emitemMapping.toDomain(emitemdto);
        domain.setSempid(pfemp_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFEmp", tags = {"EMItem" },  notes = "SaveBatchByPFEmp")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody List<EMItemDTO> emitemdtos) {
        List<EMItem> domainlist=emitemMapping.toDomain(emitemdtos);
        for(EMItem domain:domainlist){
             domain.setSempid(pfemp_id);
        }
        emitemService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFEmp", tags = {"EMItem" },  notes = "GetDraftByPFEmp")
    @RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/getdraft")
    public ResponseEntity<EMItemDTO> getDraftByPFEmp(@PathVariable("pfemp_id") String pfemp_id) {
        EMItem domain = new EMItem();
        domain.setSempid(pfemp_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemMapping.toDto(emitemService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByPFEmp", tags = {"EMItem" },  notes = "UpdateByPFEmp")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}")
    @Transactional
    public ResponseEntity<EMItemDTO> updateByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemDTO emitemdto) {
        EMItem domain = emitemMapping.toDomain(emitemdto);
        domain.setSempid(pfemp_id);
        domain.setEmitemid(emitem_id);
		emitemService.update(domain);
        EMItemDTO dto = emitemMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFEmp", tags = {"EMItem" },  notes = "UpdateBatchByPFEmp")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/batch")
    public ResponseEntity<Boolean> updateBatchByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody List<EMItemDTO> emitemdtos) {
        List<EMItem> domainlist=emitemMapping.toDomain(emitemdtos);
        for(EMItem domain:domainlist){
            domain.setSempid(pfemp_id);
        }
        emitemService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByPFEmp", tags = {"EMItem" },  notes = "CreateByPFEmp")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems")
    @Transactional
    public ResponseEntity<EMItemDTO> createByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody EMItemDTO emitemdto) {
        EMItem domain = emitemMapping.toDomain(emitemdto);
        domain.setSempid(pfemp_id);
		emitemService.create(domain);
        EMItemDTO dto = emitemMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFEmp", tags = {"EMItem" },  notes = "createBatchByPFEmp")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/batch")
    public ResponseEntity<Boolean> createBatchByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody List<EMItemDTO> emitemdtos) {
        List<EMItem> domainlist=emitemMapping.toDomain(emitemdtos);
        for(EMItem domain:domainlist){
            domain.setSempid(pfemp_id);
        }
        emitemService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByPFEmp", tags = {"EMItem" },  notes = "CheckKeyByPFEmp")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody EMItemDTO emitemdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemService.checkKey(emitemMapping.toDomain(emitemdto)));
    }

	@ApiOperation(value = "fetchDEFAULTByPFEmp", tags = {"EMItem" } ,notes = "fetchDEFAULTByPFEmp")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/fetchdefault")
	public ResponseEntity<List<EMItemDTO>> fetchEMItemDefaultByPFEmp(@PathVariable("pfemp_id") String pfemp_id,EMItemSearchContext context) {
        context.setN_sempid_eq(pfemp_id);
        Page<EMItem> domains = emitemService.searchDefault(context) ;
        List<EMItemDTO> list = emitemMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFEmp", tags = {"EMItem" } ,notes = "searchDEFAULTByPFEmp")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/searchdefault")
	public ResponseEntity<Page<EMItemDTO>> searchEMItemDefaultByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody EMItemSearchContext context) {
        context.setN_sempid_eq(pfemp_id);
        Page<EMItem> domains = emitemService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch类型树物品ByPFEmp", tags = {"EMItem" } ,notes = "fetch类型树物品ByPFEmp")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/fetchitemtypetree")
	public ResponseEntity<List<EMItemDTO>> fetchEMItemItemTypeTreeByPFEmp(@PathVariable("pfemp_id") String pfemp_id,EMItemSearchContext context) {
        context.setN_sempid_eq(pfemp_id);
        Page<EMItem> domains = emitemService.searchItemTypeTree(context) ;
        List<EMItemDTO> list = emitemMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search类型树物品ByPFEmp", tags = {"EMItem" } ,notes = "search类型树物品ByPFEmp")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/searchitemtypetree")
	public ResponseEntity<Page<EMItemDTO>> searchEMItemItemTypeTreeByPFEmp(@PathVariable("pfemp_id") String pfemp_id, @RequestBody EMItemSearchContext context) {
        context.setN_sempid_eq(pfemp_id);
        Page<EMItem> domains = emitemService.searchItemTypeTree(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "RemoveByPFUnit", tags = {"EMItem" },  notes = "RemoveByPFUnit")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFUnit(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemService.remove(emitem_id));
    }

    @ApiOperation(value = "RemoveBatchByPFUnit", tags = {"EMItem" },  notes = "RemoveBatchByPFUnit")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/batch")
    public ResponseEntity<Boolean> removeBatchByPFUnit(@RequestBody List<String> ids) {
        emitemService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByPFUnit", tags = {"EMItem" },  notes = "GetByPFUnit")
	@RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}")
    public ResponseEntity<EMItemDTO> getByPFUnit(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id) {
        EMItem domain = emitemService.get(emitem_id);
        EMItemDTO dto = emitemMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByPFUnit", tags = {"EMItem" },  notes = "SaveByPFUnit")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/save")
    public ResponseEntity<Boolean> saveByPFUnit(@PathVariable("pfunit_id") String pfunit_id, @RequestBody EMItemDTO emitemdto) {
        EMItem domain = emitemMapping.toDomain(emitemdto);
        domain.setUnitid(pfunit_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFUnit", tags = {"EMItem" },  notes = "SaveBatchByPFUnit")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFUnit(@PathVariable("pfunit_id") String pfunit_id, @RequestBody List<EMItemDTO> emitemdtos) {
        List<EMItem> domainlist=emitemMapping.toDomain(emitemdtos);
        for(EMItem domain:domainlist){
             domain.setUnitid(pfunit_id);
        }
        emitemService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFUnit", tags = {"EMItem" },  notes = "GetDraftByPFUnit")
    @RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/getdraft")
    public ResponseEntity<EMItemDTO> getDraftByPFUnit(@PathVariable("pfunit_id") String pfunit_id) {
        EMItem domain = new EMItem();
        domain.setUnitid(pfunit_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemMapping.toDto(emitemService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByPFUnit", tags = {"EMItem" },  notes = "UpdateByPFUnit")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}")
    @Transactional
    public ResponseEntity<EMItemDTO> updateByPFUnit(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemDTO emitemdto) {
        EMItem domain = emitemMapping.toDomain(emitemdto);
        domain.setUnitid(pfunit_id);
        domain.setEmitemid(emitem_id);
		emitemService.update(domain);
        EMItemDTO dto = emitemMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFUnit", tags = {"EMItem" },  notes = "UpdateBatchByPFUnit")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/batch")
    public ResponseEntity<Boolean> updateBatchByPFUnit(@PathVariable("pfunit_id") String pfunit_id, @RequestBody List<EMItemDTO> emitemdtos) {
        List<EMItem> domainlist=emitemMapping.toDomain(emitemdtos);
        for(EMItem domain:domainlist){
            domain.setUnitid(pfunit_id);
        }
        emitemService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByPFUnit", tags = {"EMItem" },  notes = "CreateByPFUnit")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems")
    @Transactional
    public ResponseEntity<EMItemDTO> createByPFUnit(@PathVariable("pfunit_id") String pfunit_id, @RequestBody EMItemDTO emitemdto) {
        EMItem domain = emitemMapping.toDomain(emitemdto);
        domain.setUnitid(pfunit_id);
		emitemService.create(domain);
        EMItemDTO dto = emitemMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFUnit", tags = {"EMItem" },  notes = "createBatchByPFUnit")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/batch")
    public ResponseEntity<Boolean> createBatchByPFUnit(@PathVariable("pfunit_id") String pfunit_id, @RequestBody List<EMItemDTO> emitemdtos) {
        List<EMItem> domainlist=emitemMapping.toDomain(emitemdtos);
        for(EMItem domain:domainlist){
            domain.setUnitid(pfunit_id);
        }
        emitemService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByPFUnit", tags = {"EMItem" },  notes = "CheckKeyByPFUnit")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFUnit(@PathVariable("pfunit_id") String pfunit_id, @RequestBody EMItemDTO emitemdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemService.checkKey(emitemMapping.toDomain(emitemdto)));
    }

	@ApiOperation(value = "fetchDEFAULTByPFUnit", tags = {"EMItem" } ,notes = "fetchDEFAULTByPFUnit")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/fetchdefault")
	public ResponseEntity<List<EMItemDTO>> fetchEMItemDefaultByPFUnit(@PathVariable("pfunit_id") String pfunit_id,EMItemSearchContext context) {
        context.setN_unitid_eq(pfunit_id);
        Page<EMItem> domains = emitemService.searchDefault(context) ;
        List<EMItemDTO> list = emitemMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFUnit", tags = {"EMItem" } ,notes = "searchDEFAULTByPFUnit")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/searchdefault")
	public ResponseEntity<Page<EMItemDTO>> searchEMItemDefaultByPFUnit(@PathVariable("pfunit_id") String pfunit_id, @RequestBody EMItemSearchContext context) {
        context.setN_unitid_eq(pfunit_id);
        Page<EMItem> domains = emitemService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch类型树物品ByPFUnit", tags = {"EMItem" } ,notes = "fetch类型树物品ByPFUnit")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/fetchitemtypetree")
	public ResponseEntity<List<EMItemDTO>> fetchEMItemItemTypeTreeByPFUnit(@PathVariable("pfunit_id") String pfunit_id,EMItemSearchContext context) {
        context.setN_unitid_eq(pfunit_id);
        Page<EMItem> domains = emitemService.searchItemTypeTree(context) ;
        List<EMItemDTO> list = emitemMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search类型树物品ByPFUnit", tags = {"EMItem" } ,notes = "search类型树物品ByPFUnit")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/searchitemtypetree")
	public ResponseEntity<Page<EMItemDTO>> searchEMItemItemTypeTreeByPFUnit(@PathVariable("pfunit_id") String pfunit_id, @RequestBody EMItemSearchContext context) {
        context.setN_unitid_eq(pfunit_id);
        Page<EMItem> domains = emitemService.searchItemTypeTree(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "RemoveByEMStoreEMStorePart", tags = {"EMItem" },  notes = "RemoveByEMStoreEMStorePart")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemService.remove(emitem_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStoreEMStorePart", tags = {"EMItem" },  notes = "RemoveBatchByEMStoreEMStorePart")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMStorePart(@RequestBody List<String> ids) {
        emitemService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMStoreEMStorePart", tags = {"EMItem" },  notes = "GetByEMStoreEMStorePart")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}")
    public ResponseEntity<EMItemDTO> getByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMItem domain = emitemService.get(emitem_id);
        EMItemDTO dto = emitemMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByEMStoreEMStorePart", tags = {"EMItem" },  notes = "SaveByEMStoreEMStorePart")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/save")
    public ResponseEntity<Boolean> saveByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @RequestBody EMItemDTO emitemdto) {
        EMItem domain = emitemMapping.toDomain(emitemdto);
        domain.setStorepartid(emstorepart_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStoreEMStorePart", tags = {"EMItem" },  notes = "SaveBatchByEMStoreEMStorePart")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @RequestBody List<EMItemDTO> emitemdtos) {
        List<EMItem> domainlist=emitemMapping.toDomain(emitemdtos);
        for(EMItem domain:domainlist){
             domain.setStorepartid(emstorepart_id);
        }
        emitemService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMStoreEMStorePart", tags = {"EMItem" },  notes = "GetDraftByEMStoreEMStorePart")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/getdraft")
    public ResponseEntity<EMItemDTO> getDraftByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id) {
        EMItem domain = new EMItem();
        domain.setStorepartid(emstorepart_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemMapping.toDto(emitemService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByEMStoreEMStorePart", tags = {"EMItem" },  notes = "UpdateByEMStoreEMStorePart")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}")
    @Transactional
    public ResponseEntity<EMItemDTO> updateByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemDTO emitemdto) {
        EMItem domain = emitemMapping.toDomain(emitemdto);
        domain.setStorepartid(emstorepart_id);
        domain.setEmitemid(emitem_id);
		emitemService.update(domain);
        EMItemDTO dto = emitemMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStoreEMStorePart", tags = {"EMItem" },  notes = "UpdateBatchByEMStoreEMStorePart")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @RequestBody List<EMItemDTO> emitemdtos) {
        List<EMItem> domainlist=emitemMapping.toDomain(emitemdtos);
        for(EMItem domain:domainlist){
            domain.setStorepartid(emstorepart_id);
        }
        emitemService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMStoreEMStorePart", tags = {"EMItem" },  notes = "CreateByEMStoreEMStorePart")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems")
    @Transactional
    public ResponseEntity<EMItemDTO> createByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @RequestBody EMItemDTO emitemdto) {
        EMItem domain = emitemMapping.toDomain(emitemdto);
        domain.setStorepartid(emstorepart_id);
		emitemService.create(domain);
        EMItemDTO dto = emitemMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStoreEMStorePart", tags = {"EMItem" },  notes = "createBatchByEMStoreEMStorePart")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @RequestBody List<EMItemDTO> emitemdtos) {
        List<EMItem> domainlist=emitemMapping.toDomain(emitemdtos);
        for(EMItem domain:domainlist){
            domain.setStorepartid(emstorepart_id);
        }
        emitemService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMStoreEMStorePart", tags = {"EMItem" },  notes = "CheckKeyByEMStoreEMStorePart")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @RequestBody EMItemDTO emitemdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemService.checkKey(emitemMapping.toDomain(emitemdto)));
    }

	@ApiOperation(value = "fetchDEFAULTByEMStoreEMStorePart", tags = {"EMItem" } ,notes = "fetchDEFAULTByEMStoreEMStorePart")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/fetchdefault")
	public ResponseEntity<List<EMItemDTO>> fetchEMItemDefaultByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id,EMItemSearchContext context) {
        context.setN_storepartid_eq(emstorepart_id);
        Page<EMItem> domains = emitemService.searchDefault(context) ;
        List<EMItemDTO> list = emitemMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStoreEMStorePart", tags = {"EMItem" } ,notes = "searchDEFAULTByEMStoreEMStorePart")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/searchdefault")
	public ResponseEntity<Page<EMItemDTO>> searchEMItemDefaultByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @RequestBody EMItemSearchContext context) {
        context.setN_storepartid_eq(emstorepart_id);
        Page<EMItem> domains = emitemService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetch类型树物品ByEMStoreEMStorePart", tags = {"EMItem" } ,notes = "fetch类型树物品ByEMStoreEMStorePart")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/fetchitemtypetree")
	public ResponseEntity<List<EMItemDTO>> fetchEMItemItemTypeTreeByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id,EMItemSearchContext context) {
        context.setN_storepartid_eq(emstorepart_id);
        Page<EMItem> domains = emitemService.searchItemTypeTree(context) ;
        List<EMItemDTO> list = emitemMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "search类型树物品ByEMStoreEMStorePart", tags = {"EMItem" } ,notes = "search类型树物品ByEMStoreEMStorePart")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/searchitemtypetree")
	public ResponseEntity<Page<EMItemDTO>> searchEMItemItemTypeTreeByEMStoreEMStorePart(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @RequestBody EMItemSearchContext context) {
        context.setN_storepartid_eq(emstorepart_id);
        Page<EMItem> domains = emitemService.searchItemTypeTree(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMItem getEntity(){
        return new EMItem();
    }

}
