package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMItemROut;
import cn.ibizlab.eam.core.eam_core.service.IEMItemROutService;
import cn.ibizlab.eam.core.eam_core.filter.EMItemROutSearchContext;




@Slf4j
@Api(tags = {"EMItemROut" })
@RestController("WebApi-emitemrout")
@RequestMapping("")
public class EMItemROutResource {

    @Autowired
    private IEMItemROutService emitemroutService;

    @Autowired
    @Lazy
    private EMItemROutMapping emitemroutMapping;




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMItemROut" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemrouts")
    @Transactional
    public ResponseEntity<EMItemROutDTO> create(@RequestBody EMItemROutDTO emitemroutdto) {
        EMItemROut domain = emitemroutMapping.toDomain(emitemroutdto);
		emitemroutService.create(domain);
        EMItemROutDTO dto = emitemroutMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMItemROut" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemrouts/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMItemROutDTO> emitemroutdtos) {
        emitemroutService.createBatch(emitemroutMapping.toDomain(emitemroutdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emitemrout_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMItemROut" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emitemrouts/{emitemrout_id}")
    public ResponseEntity<EMItemROutDTO> get(@PathVariable("emitemrout_id") String emitemrout_id) {
        EMItemROut domain = emitemroutService.get(emitemrout_id);
        EMItemROutDTO dto = emitemroutMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMItemROut" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemrouts/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMItemROutDTO emitemroutdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemroutService.checkKey(emitemroutMapping.toDomain(emitemroutdto)));
    }




    @PreAuthorize("hasPermission(#emitemrout_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMItemROut" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitemrouts/{emitemrout_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emitemrout_id") String emitemrout_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emitemroutService.remove(emitemrout_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMItemROut" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitemrouts/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emitemroutService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emitemrout_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMItemROut" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitemrouts/{emitemrout_id}")
    @Transactional
    public ResponseEntity<EMItemROutDTO> update(@PathVariable("emitemrout_id") String emitemrout_id, @RequestBody EMItemROutDTO emitemroutdto) {
		EMItemROut domain = emitemroutMapping.toDomain(emitemroutdto);
        domain.setEmitemroutid(emitemrout_id);
		emitemroutService.update(domain);
		EMItemROutDTO dto = emitemroutMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emitemrout_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMItemROut" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitemrouts/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMItemROutDTO> emitemroutdtos) {
        emitemroutService.updateBatch(emitemroutMapping.toDomain(emitemroutdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMItemROut" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemrouts/save")
    public ResponseEntity<Boolean> save(@RequestBody EMItemROutDTO emitemroutdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emitemroutService.save(emitemroutMapping.toDomain(emitemroutdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMItemROut" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemrouts/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMItemROutDTO> emitemroutdtos) {
        emitemroutService.saveBatch(emitemroutMapping.toDomain(emitemroutdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMItemROut" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emitemrouts/getdraft")
    public ResponseEntity<EMItemROutDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emitemroutMapping.toDto(emitemroutService.getDraft(new EMItemROut())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemROut-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMItemROut" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emitemrouts/fetchdefault")
	public ResponseEntity<List<EMItemROutDTO>> fetchDefault(EMItemROutSearchContext context) {
        Page<EMItemROut> domains = emitemroutService.searchDefault(context) ;
        List<EMItemROutDTO> list = emitemroutMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemROut-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMItemROut" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emitemrouts/searchdefault")
	public ResponseEntity<Page<EMItemROutDTO>> searchDefault(@RequestBody EMItemROutSearchContext context) {
        Page<EMItemROut> domains = emitemroutService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemroutMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "CreateByEMItem", tags = {"EMItemROut" },  notes = "CreateByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemrouts")
    @Transactional
    public ResponseEntity<EMItemROutDTO> createByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutDTO emitemroutdto) {
        EMItemROut domain = emitemroutMapping.toDomain(emitemroutdto);
        domain.setItemid(emitem_id);
		emitemroutService.create(domain);
        EMItemROutDTO dto = emitemroutMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMItem", tags = {"EMItemROut" },  notes = "createBatchByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemrouts/batch")
    public ResponseEntity<Boolean> createBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemROutDTO> emitemroutdtos) {
        List<EMItemROut> domainlist=emitemroutMapping.toDomain(emitemroutdtos);
        for(EMItemROut domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemroutService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMItem", tags = {"EMItemROut" },  notes = "GetByEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emitemrouts/{emitemrout_id}")
    public ResponseEntity<EMItemROutDTO> getByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrout_id") String emitemrout_id) {
        EMItemROut domain = emitemroutService.get(emitemrout_id);
        EMItemROutDTO dto = emitemroutMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CheckKeyByEMItem", tags = {"EMItemROut" },  notes = "CheckKeyByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemrouts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutDTO emitemroutdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemroutService.checkKey(emitemroutMapping.toDomain(emitemroutdto)));
    }

    @ApiOperation(value = "RemoveByEMItem", tags = {"EMItemROut" },  notes = "RemoveByEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emitemrouts/{emitemrout_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrout_id") String emitemrout_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemroutService.remove(emitemrout_id));
    }

    @ApiOperation(value = "RemoveBatchByEMItem", tags = {"EMItemROut" },  notes = "RemoveBatchByEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emitemrouts/batch")
    public ResponseEntity<Boolean> removeBatchByEMItem(@RequestBody List<String> ids) {
        emitemroutService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMItem", tags = {"EMItemROut" },  notes = "UpdateByEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emitemrouts/{emitemrout_id}")
    @Transactional
    public ResponseEntity<EMItemROutDTO> updateByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrout_id") String emitemrout_id, @RequestBody EMItemROutDTO emitemroutdto) {
        EMItemROut domain = emitemroutMapping.toDomain(emitemroutdto);
        domain.setItemid(emitem_id);
        domain.setEmitemroutid(emitemrout_id);
		emitemroutService.update(domain);
        EMItemROutDTO dto = emitemroutMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMItem", tags = {"EMItemROut" },  notes = "UpdateBatchByEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emitemrouts/batch")
    public ResponseEntity<Boolean> updateBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemROutDTO> emitemroutdtos) {
        List<EMItemROut> domainlist=emitemroutMapping.toDomain(emitemroutdtos);
        for(EMItemROut domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemroutService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMItem", tags = {"EMItemROut" },  notes = "SaveByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemrouts/save")
    public ResponseEntity<Boolean> saveByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutDTO emitemroutdto) {
        EMItemROut domain = emitemroutMapping.toDomain(emitemroutdto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemroutService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMItem", tags = {"EMItemROut" },  notes = "SaveBatchByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemrouts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemROutDTO> emitemroutdtos) {
        List<EMItemROut> domainlist=emitemroutMapping.toDomain(emitemroutdtos);
        for(EMItemROut domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemroutService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMItem", tags = {"EMItemROut" },  notes = "GetDraftByEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emitemrouts/getdraft")
    public ResponseEntity<EMItemROutDTO> getDraftByEMItem(@PathVariable("emitem_id") String emitem_id) {
        EMItemROut domain = new EMItemROut();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemroutMapping.toDto(emitemroutService.getDraft(domain)));
    }

	@ApiOperation(value = "fetchDEFAULTByEMItem", tags = {"EMItemROut" } ,notes = "fetchDEFAULTByEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/emitemrouts/fetchdefault")
	public ResponseEntity<List<EMItemROutDTO>> fetchEMItemROutDefaultByEMItem(@PathVariable("emitem_id") String emitem_id,EMItemROutSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemROut> domains = emitemroutService.searchDefault(context) ;
        List<EMItemROutDTO> list = emitemroutMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMItem", tags = {"EMItemROut" } ,notes = "searchDEFAULTByEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/emitemrouts/searchdefault")
	public ResponseEntity<Page<EMItemROutDTO>> searchEMItemROutDefaultByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemROut> domains = emitemroutService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemroutMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CreateByEMServiceEMItem", tags = {"EMItemROut" },  notes = "CreateByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrouts")
    @Transactional
    public ResponseEntity<EMItemROutDTO> createByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutDTO emitemroutdto) {
        EMItemROut domain = emitemroutMapping.toDomain(emitemroutdto);
        domain.setItemid(emitem_id);
		emitemroutService.create(domain);
        EMItemROutDTO dto = emitemroutMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMServiceEMItem", tags = {"EMItemROut" },  notes = "createBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrouts/batch")
    public ResponseEntity<Boolean> createBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemROutDTO> emitemroutdtos) {
        List<EMItemROut> domainlist=emitemroutMapping.toDomain(emitemroutdtos);
        for(EMItemROut domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemroutService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMServiceEMItem", tags = {"EMItemROut" },  notes = "GetByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrouts/{emitemrout_id}")
    public ResponseEntity<EMItemROutDTO> getByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrout_id") String emitemrout_id) {
        EMItemROut domain = emitemroutService.get(emitemrout_id);
        EMItemROutDTO dto = emitemroutMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CheckKeyByEMServiceEMItem", tags = {"EMItemROut" },  notes = "CheckKeyByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrouts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutDTO emitemroutdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemroutService.checkKey(emitemroutMapping.toDomain(emitemroutdto)));
    }

    @ApiOperation(value = "RemoveByEMServiceEMItem", tags = {"EMItemROut" },  notes = "RemoveByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrouts/{emitemrout_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrout_id") String emitemrout_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemroutService.remove(emitemrout_id));
    }

    @ApiOperation(value = "RemoveBatchByEMServiceEMItem", tags = {"EMItemROut" },  notes = "RemoveBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrouts/batch")
    public ResponseEntity<Boolean> removeBatchByEMServiceEMItem(@RequestBody List<String> ids) {
        emitemroutService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMServiceEMItem", tags = {"EMItemROut" },  notes = "UpdateByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrouts/{emitemrout_id}")
    @Transactional
    public ResponseEntity<EMItemROutDTO> updateByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrout_id") String emitemrout_id, @RequestBody EMItemROutDTO emitemroutdto) {
        EMItemROut domain = emitemroutMapping.toDomain(emitemroutdto);
        domain.setItemid(emitem_id);
        domain.setEmitemroutid(emitemrout_id);
		emitemroutService.update(domain);
        EMItemROutDTO dto = emitemroutMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMServiceEMItem", tags = {"EMItemROut" },  notes = "UpdateBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrouts/batch")
    public ResponseEntity<Boolean> updateBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemROutDTO> emitemroutdtos) {
        List<EMItemROut> domainlist=emitemroutMapping.toDomain(emitemroutdtos);
        for(EMItemROut domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemroutService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMServiceEMItem", tags = {"EMItemROut" },  notes = "SaveByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrouts/save")
    public ResponseEntity<Boolean> saveByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutDTO emitemroutdto) {
        EMItemROut domain = emitemroutMapping.toDomain(emitemroutdto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemroutService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMServiceEMItem", tags = {"EMItemROut" },  notes = "SaveBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrouts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemROutDTO> emitemroutdtos) {
        List<EMItemROut> domainlist=emitemroutMapping.toDomain(emitemroutdtos);
        for(EMItemROut domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemroutService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMServiceEMItem", tags = {"EMItemROut" },  notes = "GetDraftByEMServiceEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrouts/getdraft")
    public ResponseEntity<EMItemROutDTO> getDraftByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemROut domain = new EMItemROut();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemroutMapping.toDto(emitemroutService.getDraft(domain)));
    }

	@ApiOperation(value = "fetchDEFAULTByEMServiceEMItem", tags = {"EMItemROut" } ,notes = "fetchDEFAULTByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/emitemrouts/fetchdefault")
	public ResponseEntity<List<EMItemROutDTO>> fetchEMItemROutDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id,EMItemROutSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemROut> domains = emitemroutService.searchDefault(context) ;
        List<EMItemROutDTO> list = emitemroutMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMServiceEMItem", tags = {"EMItemROut" } ,notes = "searchDEFAULTByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/emitemrouts/searchdefault")
	public ResponseEntity<Page<EMItemROutDTO>> searchEMItemROutDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemROut> domains = emitemroutService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemroutMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CreateByEMStorePartEMItem", tags = {"EMItemROut" },  notes = "CreateByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts")
    @Transactional
    public ResponseEntity<EMItemROutDTO> createByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutDTO emitemroutdto) {
        EMItemROut domain = emitemroutMapping.toDomain(emitemroutdto);
        domain.setItemid(emitem_id);
		emitemroutService.create(domain);
        EMItemROutDTO dto = emitemroutMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStorePartEMItem", tags = {"EMItemROut" },  notes = "createBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts/batch")
    public ResponseEntity<Boolean> createBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemROutDTO> emitemroutdtos) {
        List<EMItemROut> domainlist=emitemroutMapping.toDomain(emitemroutdtos);
        for(EMItemROut domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemroutService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMStorePartEMItem", tags = {"EMItemROut" },  notes = "GetByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts/{emitemrout_id}")
    public ResponseEntity<EMItemROutDTO> getByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrout_id") String emitemrout_id) {
        EMItemROut domain = emitemroutService.get(emitemrout_id);
        EMItemROutDTO dto = emitemroutMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CheckKeyByEMStorePartEMItem", tags = {"EMItemROut" },  notes = "CheckKeyByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutDTO emitemroutdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemroutService.checkKey(emitemroutMapping.toDomain(emitemroutdto)));
    }

    @ApiOperation(value = "RemoveByEMStorePartEMItem", tags = {"EMItemROut" },  notes = "RemoveByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts/{emitemrout_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrout_id") String emitemrout_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemroutService.remove(emitemrout_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStorePartEMItem", tags = {"EMItemROut" },  notes = "RemoveBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts/batch")
    public ResponseEntity<Boolean> removeBatchByEMStorePartEMItem(@RequestBody List<String> ids) {
        emitemroutService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMStorePartEMItem", tags = {"EMItemROut" },  notes = "UpdateByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts/{emitemrout_id}")
    @Transactional
    public ResponseEntity<EMItemROutDTO> updateByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrout_id") String emitemrout_id, @RequestBody EMItemROutDTO emitemroutdto) {
        EMItemROut domain = emitemroutMapping.toDomain(emitemroutdto);
        domain.setItemid(emitem_id);
        domain.setEmitemroutid(emitemrout_id);
		emitemroutService.update(domain);
        EMItemROutDTO dto = emitemroutMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStorePartEMItem", tags = {"EMItemROut" },  notes = "UpdateBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts/batch")
    public ResponseEntity<Boolean> updateBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemROutDTO> emitemroutdtos) {
        List<EMItemROut> domainlist=emitemroutMapping.toDomain(emitemroutdtos);
        for(EMItemROut domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemroutService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMStorePartEMItem", tags = {"EMItemROut" },  notes = "SaveByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts/save")
    public ResponseEntity<Boolean> saveByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutDTO emitemroutdto) {
        EMItemROut domain = emitemroutMapping.toDomain(emitemroutdto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemroutService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStorePartEMItem", tags = {"EMItemROut" },  notes = "SaveBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemROutDTO> emitemroutdtos) {
        List<EMItemROut> domainlist=emitemroutMapping.toDomain(emitemroutdtos);
        for(EMItemROut domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemroutService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMStorePartEMItem", tags = {"EMItemROut" },  notes = "GetDraftByEMStorePartEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts/getdraft")
    public ResponseEntity<EMItemROutDTO> getDraftByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemROut domain = new EMItemROut();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemroutMapping.toDto(emitemroutService.getDraft(domain)));
    }

	@ApiOperation(value = "fetchDEFAULTByEMStorePartEMItem", tags = {"EMItemROut" } ,notes = "fetchDEFAULTByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts/fetchdefault")
	public ResponseEntity<List<EMItemROutDTO>> fetchEMItemROutDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMItemROutSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemROut> domains = emitemroutService.searchDefault(context) ;
        List<EMItemROutDTO> list = emitemroutMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStorePartEMItem", tags = {"EMItemROut" } ,notes = "searchDEFAULTByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts/searchdefault")
	public ResponseEntity<Page<EMItemROutDTO>> searchEMItemROutDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemROut> domains = emitemroutService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemroutMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CreateByEMStoreEMItem", tags = {"EMItemROut" },  notes = "CreateByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrouts")
    @Transactional
    public ResponseEntity<EMItemROutDTO> createByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutDTO emitemroutdto) {
        EMItemROut domain = emitemroutMapping.toDomain(emitemroutdto);
        domain.setItemid(emitem_id);
		emitemroutService.create(domain);
        EMItemROutDTO dto = emitemroutMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStoreEMItem", tags = {"EMItemROut" },  notes = "createBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrouts/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemROutDTO> emitemroutdtos) {
        List<EMItemROut> domainlist=emitemroutMapping.toDomain(emitemroutdtos);
        for(EMItemROut domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemroutService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMStoreEMItem", tags = {"EMItemROut" },  notes = "GetByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrouts/{emitemrout_id}")
    public ResponseEntity<EMItemROutDTO> getByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrout_id") String emitemrout_id) {
        EMItemROut domain = emitemroutService.get(emitemrout_id);
        EMItemROutDTO dto = emitemroutMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CheckKeyByEMStoreEMItem", tags = {"EMItemROut" },  notes = "CheckKeyByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrouts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutDTO emitemroutdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemroutService.checkKey(emitemroutMapping.toDomain(emitemroutdto)));
    }

    @ApiOperation(value = "RemoveByEMStoreEMItem", tags = {"EMItemROut" },  notes = "RemoveByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrouts/{emitemrout_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrout_id") String emitemrout_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemroutService.remove(emitemrout_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStoreEMItem", tags = {"EMItemROut" },  notes = "RemoveBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrouts/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMItem(@RequestBody List<String> ids) {
        emitemroutService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMStoreEMItem", tags = {"EMItemROut" },  notes = "UpdateByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrouts/{emitemrout_id}")
    @Transactional
    public ResponseEntity<EMItemROutDTO> updateByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrout_id") String emitemrout_id, @RequestBody EMItemROutDTO emitemroutdto) {
        EMItemROut domain = emitemroutMapping.toDomain(emitemroutdto);
        domain.setItemid(emitem_id);
        domain.setEmitemroutid(emitemrout_id);
		emitemroutService.update(domain);
        EMItemROutDTO dto = emitemroutMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStoreEMItem", tags = {"EMItemROut" },  notes = "UpdateBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrouts/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemROutDTO> emitemroutdtos) {
        List<EMItemROut> domainlist=emitemroutMapping.toDomain(emitemroutdtos);
        for(EMItemROut domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemroutService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMStoreEMItem", tags = {"EMItemROut" },  notes = "SaveByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrouts/save")
    public ResponseEntity<Boolean> saveByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutDTO emitemroutdto) {
        EMItemROut domain = emitemroutMapping.toDomain(emitemroutdto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemroutService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStoreEMItem", tags = {"EMItemROut" },  notes = "SaveBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrouts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemROutDTO> emitemroutdtos) {
        List<EMItemROut> domainlist=emitemroutMapping.toDomain(emitemroutdtos);
        for(EMItemROut domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemroutService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMStoreEMItem", tags = {"EMItemROut" },  notes = "GetDraftByEMStoreEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrouts/getdraft")
    public ResponseEntity<EMItemROutDTO> getDraftByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemROut domain = new EMItemROut();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemroutMapping.toDto(emitemroutService.getDraft(domain)));
    }

	@ApiOperation(value = "fetchDEFAULTByEMStoreEMItem", tags = {"EMItemROut" } ,notes = "fetchDEFAULTByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/emitemrouts/fetchdefault")
	public ResponseEntity<List<EMItemROutDTO>> fetchEMItemROutDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id,EMItemROutSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemROut> domains = emitemroutService.searchDefault(context) ;
        List<EMItemROutDTO> list = emitemroutMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStoreEMItem", tags = {"EMItemROut" } ,notes = "searchDEFAULTByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/emitemrouts/searchdefault")
	public ResponseEntity<Page<EMItemROutDTO>> searchEMItemROutDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemROut> domains = emitemroutService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemroutMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CreateByPFEmpEMItem", tags = {"EMItemROut" },  notes = "CreateByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrouts")
    @Transactional
    public ResponseEntity<EMItemROutDTO> createByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutDTO emitemroutdto) {
        EMItemROut domain = emitemroutMapping.toDomain(emitemroutdto);
        domain.setItemid(emitem_id);
		emitemroutService.create(domain);
        EMItemROutDTO dto = emitemroutMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFEmpEMItem", tags = {"EMItemROut" },  notes = "createBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrouts/batch")
    public ResponseEntity<Boolean> createBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemROutDTO> emitemroutdtos) {
        List<EMItemROut> domainlist=emitemroutMapping.toDomain(emitemroutdtos);
        for(EMItemROut domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemroutService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByPFEmpEMItem", tags = {"EMItemROut" },  notes = "GetByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrouts/{emitemrout_id}")
    public ResponseEntity<EMItemROutDTO> getByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrout_id") String emitemrout_id) {
        EMItemROut domain = emitemroutService.get(emitemrout_id);
        EMItemROutDTO dto = emitemroutMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CheckKeyByPFEmpEMItem", tags = {"EMItemROut" },  notes = "CheckKeyByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrouts/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutDTO emitemroutdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemroutService.checkKey(emitemroutMapping.toDomain(emitemroutdto)));
    }

    @ApiOperation(value = "RemoveByPFEmpEMItem", tags = {"EMItemROut" },  notes = "RemoveByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrouts/{emitemrout_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrout_id") String emitemrout_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemroutService.remove(emitemrout_id));
    }

    @ApiOperation(value = "RemoveBatchByPFEmpEMItem", tags = {"EMItemROut" },  notes = "RemoveBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrouts/batch")
    public ResponseEntity<Boolean> removeBatchByPFEmpEMItem(@RequestBody List<String> ids) {
        emitemroutService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByPFEmpEMItem", tags = {"EMItemROut" },  notes = "UpdateByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrouts/{emitemrout_id}")
    @Transactional
    public ResponseEntity<EMItemROutDTO> updateByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrout_id") String emitemrout_id, @RequestBody EMItemROutDTO emitemroutdto) {
        EMItemROut domain = emitemroutMapping.toDomain(emitemroutdto);
        domain.setItemid(emitem_id);
        domain.setEmitemroutid(emitemrout_id);
		emitemroutService.update(domain);
        EMItemROutDTO dto = emitemroutMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFEmpEMItem", tags = {"EMItemROut" },  notes = "UpdateBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrouts/batch")
    public ResponseEntity<Boolean> updateBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemROutDTO> emitemroutdtos) {
        List<EMItemROut> domainlist=emitemroutMapping.toDomain(emitemroutdtos);
        for(EMItemROut domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemroutService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByPFEmpEMItem", tags = {"EMItemROut" },  notes = "SaveByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrouts/save")
    public ResponseEntity<Boolean> saveByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutDTO emitemroutdto) {
        EMItemROut domain = emitemroutMapping.toDomain(emitemroutdto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemroutService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFEmpEMItem", tags = {"EMItemROut" },  notes = "SaveBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrouts/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemROutDTO> emitemroutdtos) {
        List<EMItemROut> domainlist=emitemroutMapping.toDomain(emitemroutdtos);
        for(EMItemROut domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemroutService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFEmpEMItem", tags = {"EMItemROut" },  notes = "GetDraftByPFEmpEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrouts/getdraft")
    public ResponseEntity<EMItemROutDTO> getDraftByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemROut domain = new EMItemROut();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemroutMapping.toDto(emitemroutService.getDraft(domain)));
    }

	@ApiOperation(value = "fetchDEFAULTByPFEmpEMItem", tags = {"EMItemROut" } ,notes = "fetchDEFAULTByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrouts/fetchdefault")
	public ResponseEntity<List<EMItemROutDTO>> fetchEMItemROutDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id,EMItemROutSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemROut> domains = emitemroutService.searchDefault(context) ;
        List<EMItemROutDTO> list = emitemroutMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFEmpEMItem", tags = {"EMItemROut" } ,notes = "searchDEFAULTByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrouts/searchdefault")
	public ResponseEntity<Page<EMItemROutDTO>> searchEMItemROutDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemROut> domains = emitemroutService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemroutMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CreateByPFUnitEMItem", tags = {"EMItemROut" },  notes = "CreateByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrouts")
    @Transactional
    public ResponseEntity<EMItemROutDTO> createByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutDTO emitemroutdto) {
        EMItemROut domain = emitemroutMapping.toDomain(emitemroutdto);
        domain.setItemid(emitem_id);
		emitemroutService.create(domain);
        EMItemROutDTO dto = emitemroutMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFUnitEMItem", tags = {"EMItemROut" },  notes = "createBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrouts/batch")
    public ResponseEntity<Boolean> createBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemROutDTO> emitemroutdtos) {
        List<EMItemROut> domainlist=emitemroutMapping.toDomain(emitemroutdtos);
        for(EMItemROut domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemroutService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByPFUnitEMItem", tags = {"EMItemROut" },  notes = "GetByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrouts/{emitemrout_id}")
    public ResponseEntity<EMItemROutDTO> getByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrout_id") String emitemrout_id) {
        EMItemROut domain = emitemroutService.get(emitemrout_id);
        EMItemROutDTO dto = emitemroutMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CheckKeyByPFUnitEMItem", tags = {"EMItemROut" },  notes = "CheckKeyByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrouts/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutDTO emitemroutdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemroutService.checkKey(emitemroutMapping.toDomain(emitemroutdto)));
    }

    @ApiOperation(value = "RemoveByPFUnitEMItem", tags = {"EMItemROut" },  notes = "RemoveByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrouts/{emitemrout_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrout_id") String emitemrout_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemroutService.remove(emitemrout_id));
    }

    @ApiOperation(value = "RemoveBatchByPFUnitEMItem", tags = {"EMItemROut" },  notes = "RemoveBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrouts/batch")
    public ResponseEntity<Boolean> removeBatchByPFUnitEMItem(@RequestBody List<String> ids) {
        emitemroutService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByPFUnitEMItem", tags = {"EMItemROut" },  notes = "UpdateByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrouts/{emitemrout_id}")
    @Transactional
    public ResponseEntity<EMItemROutDTO> updateByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrout_id") String emitemrout_id, @RequestBody EMItemROutDTO emitemroutdto) {
        EMItemROut domain = emitemroutMapping.toDomain(emitemroutdto);
        domain.setItemid(emitem_id);
        domain.setEmitemroutid(emitemrout_id);
		emitemroutService.update(domain);
        EMItemROutDTO dto = emitemroutMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFUnitEMItem", tags = {"EMItemROut" },  notes = "UpdateBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrouts/batch")
    public ResponseEntity<Boolean> updateBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemROutDTO> emitemroutdtos) {
        List<EMItemROut> domainlist=emitemroutMapping.toDomain(emitemroutdtos);
        for(EMItemROut domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemroutService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByPFUnitEMItem", tags = {"EMItemROut" },  notes = "SaveByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrouts/save")
    public ResponseEntity<Boolean> saveByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutDTO emitemroutdto) {
        EMItemROut domain = emitemroutMapping.toDomain(emitemroutdto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemroutService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFUnitEMItem", tags = {"EMItemROut" },  notes = "SaveBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrouts/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemROutDTO> emitemroutdtos) {
        List<EMItemROut> domainlist=emitemroutMapping.toDomain(emitemroutdtos);
        for(EMItemROut domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemroutService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFUnitEMItem", tags = {"EMItemROut" },  notes = "GetDraftByPFUnitEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrouts/getdraft")
    public ResponseEntity<EMItemROutDTO> getDraftByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemROut domain = new EMItemROut();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemroutMapping.toDto(emitemroutService.getDraft(domain)));
    }

	@ApiOperation(value = "fetchDEFAULTByPFUnitEMItem", tags = {"EMItemROut" } ,notes = "fetchDEFAULTByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrouts/fetchdefault")
	public ResponseEntity<List<EMItemROutDTO>> fetchEMItemROutDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id,EMItemROutSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemROut> domains = emitemroutService.searchDefault(context) ;
        List<EMItemROutDTO> list = emitemroutMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFUnitEMItem", tags = {"EMItemROut" } ,notes = "searchDEFAULTByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrouts/searchdefault")
	public ResponseEntity<Page<EMItemROutDTO>> searchEMItemROutDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemROut> domains = emitemroutService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemroutMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}





    @ApiOperation(value = "CreateByEMStoreEMStorePartEMItem", tags = {"EMItemROut" },  notes = "CreateByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts")
    @Transactional
    public ResponseEntity<EMItemROutDTO> createByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutDTO emitemroutdto) {
        EMItemROut domain = emitemroutMapping.toDomain(emitemroutdto);
        domain.setItemid(emitem_id);
		emitemroutService.create(domain);
        EMItemROutDTO dto = emitemroutMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStoreEMStorePartEMItem", tags = {"EMItemROut" },  notes = "createBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemROutDTO> emitemroutdtos) {
        List<EMItemROut> domainlist=emitemroutMapping.toDomain(emitemroutdtos);
        for(EMItemROut domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemroutService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMStoreEMStorePartEMItem", tags = {"EMItemROut" },  notes = "GetByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts/{emitemrout_id}")
    public ResponseEntity<EMItemROutDTO> getByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrout_id") String emitemrout_id) {
        EMItemROut domain = emitemroutService.get(emitemrout_id);
        EMItemROutDTO dto = emitemroutMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CheckKeyByEMStoreEMStorePartEMItem", tags = {"EMItemROut" },  notes = "CheckKeyByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutDTO emitemroutdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemroutService.checkKey(emitemroutMapping.toDomain(emitemroutdto)));
    }

    @ApiOperation(value = "RemoveByEMStoreEMStorePartEMItem", tags = {"EMItemROut" },  notes = "RemoveByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts/{emitemrout_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrout_id") String emitemrout_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemroutService.remove(emitemrout_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStoreEMStorePartEMItem", tags = {"EMItemROut" },  notes = "RemoveBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMStorePartEMItem(@RequestBody List<String> ids) {
        emitemroutService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMStoreEMStorePartEMItem", tags = {"EMItemROut" },  notes = "UpdateByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts/{emitemrout_id}")
    @Transactional
    public ResponseEntity<EMItemROutDTO> updateByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrout_id") String emitemrout_id, @RequestBody EMItemROutDTO emitemroutdto) {
        EMItemROut domain = emitemroutMapping.toDomain(emitemroutdto);
        domain.setItemid(emitem_id);
        domain.setEmitemroutid(emitemrout_id);
		emitemroutService.update(domain);
        EMItemROutDTO dto = emitemroutMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStoreEMStorePartEMItem", tags = {"EMItemROut" },  notes = "UpdateBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemROutDTO> emitemroutdtos) {
        List<EMItemROut> domainlist=emitemroutMapping.toDomain(emitemroutdtos);
        for(EMItemROut domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemroutService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMStoreEMStorePartEMItem", tags = {"EMItemROut" },  notes = "SaveByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts/save")
    public ResponseEntity<Boolean> saveByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutDTO emitemroutdto) {
        EMItemROut domain = emitemroutMapping.toDomain(emitemroutdto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemroutService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStoreEMStorePartEMItem", tags = {"EMItemROut" },  notes = "SaveBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemROutDTO> emitemroutdtos) {
        List<EMItemROut> domainlist=emitemroutMapping.toDomain(emitemroutdtos);
        for(EMItemROut domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemroutService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMStoreEMStorePartEMItem", tags = {"EMItemROut" },  notes = "GetDraftByEMStoreEMStorePartEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts/getdraft")
    public ResponseEntity<EMItemROutDTO> getDraftByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemROut domain = new EMItemROut();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemroutMapping.toDto(emitemroutService.getDraft(domain)));
    }

	@ApiOperation(value = "fetchDEFAULTByEMStoreEMStorePartEMItem", tags = {"EMItemROut" } ,notes = "fetchDEFAULTByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts/fetchdefault")
	public ResponseEntity<List<EMItemROutDTO>> fetchEMItemROutDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMItemROutSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemROut> domains = emitemroutService.searchDefault(context) ;
        List<EMItemROutDTO> list = emitemroutMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStoreEMStorePartEMItem", tags = {"EMItemROut" } ,notes = "searchDEFAULTByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrouts/searchdefault")
	public ResponseEntity<Page<EMItemROutDTO>> searchEMItemROutDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemROutSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemROut> domains = emitemroutService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemroutMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMItemROut getEntity(){
        return new EMItemROut();
    }

}
