package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMItemRIn;
import cn.ibizlab.eam.core.eam_core.service.IEMItemRInService;
import cn.ibizlab.eam.core.eam_core.filter.EMItemRInSearchContext;




@Slf4j
@Api(tags = {"EMItemRIn" })
@RestController("WebApi-emitemrin")
@RequestMapping("")
public class EMItemRInResource {

    @Autowired
    private IEMItemRInService emitemrinService;

    @Autowired
    @Lazy
    private EMItemRInMapping emitemrinMapping;




    @ApiOperation(value = "CheckKey", tags = {"EMItemRIn" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemrins/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMItemRInDTO emitemrindto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemrinService.checkKey(emitemrinMapping.toDomain(emitemrindto)));
    }




    @ApiOperation(value = "GetDraft", tags = {"EMItemRIn" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emitemrins/getdraft")
    public ResponseEntity<EMItemRInDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinMapping.toDto(emitemrinService.getDraft(new EMItemRIn())));
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMItemRIn" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemrins")
    @Transactional
    public ResponseEntity<EMItemRInDTO> create(@RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
		emitemrinService.create(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMItemRIn" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemrins/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMItemRInDTO> emitemrindtos) {
        emitemrinService.createBatch(emitemrinMapping.toDomain(emitemrindtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emitemrin_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMItemRIn" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<EMItemRInDTO> update(@PathVariable("emitemrin_id") String emitemrin_id, @RequestBody EMItemRInDTO emitemrindto) {
		EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setEmitemrinid(emitemrin_id);
		emitemrinService.update(domain);
		EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emitemrin_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMItemRIn" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitemrins/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMItemRInDTO> emitemrindtos) {
        emitemrinService.updateBatch(emitemrinMapping.toDomain(emitemrindtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMItemRIn" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemrins/save")
    public ResponseEntity<Boolean> save(@RequestBody EMItemRInDTO emitemrindto) {
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.save(emitemrinMapping.toDomain(emitemrindto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMItemRIn" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemrins/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMItemRInDTO> emitemrindtos) {
        emitemrinService.saveBatch(emitemrinMapping.toDomain(emitemrindtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emitemrin_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMItemRIn" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emitemrins/{emitemrin_id}")
    public ResponseEntity<EMItemRInDTO> get(@PathVariable("emitemrin_id") String emitemrin_id) {
        EMItemRIn domain = emitemrinService.get(emitemrin_id);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @PreAuthorize("hasPermission(#emitemrin_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMItemRIn" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emitemrin_id") String emitemrin_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.remove(emitemrin_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMItemRIn" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitemrins/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emitemrinService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemRIn-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMItemRIn" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emitemrins/fetchdefault")
	public ResponseEntity<List<EMItemRInDTO>> fetchDefault(EMItemRInSearchContext context) {
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
        List<EMItemRInDTO> list = emitemrinMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemRIn-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMItemRIn" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emitemrins/searchdefault")
	public ResponseEntity<Page<EMItemRInDTO>> searchDefault(@RequestBody EMItemRInSearchContext context) {
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemrinMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "CheckKeyByEMItem", tags = {"EMItemRIn" },  notes = "CheckKeyByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemrins/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemrinService.checkKey(emitemrinMapping.toDomain(emitemrindto)));
    }

    @ApiOperation(value = "GetDraftByEMItem", tags = {"EMItemRIn" },  notes = "GetDraftByEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emitemrins/getdraft")
    public ResponseEntity<EMItemRInDTO> getDraftByEMItem(@PathVariable("emitem_id") String emitem_id) {
        EMItemRIn domain = new EMItemRIn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinMapping.toDto(emitemrinService.getDraft(domain)));
    }

    @ApiOperation(value = "CreateByEMItem", tags = {"EMItemRIn" },  notes = "CreateByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemrins")
    @Transactional
    public ResponseEntity<EMItemRInDTO> createByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
		emitemrinService.create(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMItem", tags = {"EMItemRIn" },  notes = "createBatchByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> createBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMItem", tags = {"EMItemRIn" },  notes = "UpdateByEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<EMItemRInDTO> updateByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        domain.setEmitemrinid(emitemrin_id);
		emitemrinService.update(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMItem", tags = {"EMItemRIn" },  notes = "UpdateBatchByEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> updateBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMItem", tags = {"EMItemRIn" },  notes = "SaveByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemrins/save")
    public ResponseEntity<Boolean> saveByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMItem", tags = {"EMItemRIn" },  notes = "SaveBatchByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemrins/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemrinService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMItem", tags = {"EMItemRIn" },  notes = "GetByEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    public ResponseEntity<EMItemRInDTO> getByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
        EMItemRIn domain = emitemrinService.get(emitemrin_id);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "RemoveByEMItem", tags = {"EMItemRIn" },  notes = "RemoveByEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.remove(emitemrin_id));
    }

    @ApiOperation(value = "RemoveBatchByEMItem", tags = {"EMItemRIn" },  notes = "RemoveBatchByEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> removeBatchByEMItem(@RequestBody List<String> ids) {
        emitemrinService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMItem", tags = {"EMItemRIn" } ,notes = "fetchDEFAULTByEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/emitemrins/fetchdefault")
	public ResponseEntity<List<EMItemRInDTO>> fetchEMItemRInDefaultByEMItem(@PathVariable("emitem_id") String emitem_id,EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
        List<EMItemRInDTO> list = emitemrinMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMItem", tags = {"EMItemRIn" } ,notes = "searchDEFAULTByEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/emitemrins/searchdefault")
	public ResponseEntity<Page<EMItemRInDTO>> searchEMItemRInDefaultByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemrinMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CheckKeyByEMServiceEMItem", tags = {"EMItemRIn" },  notes = "CheckKeyByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemrinService.checkKey(emitemrinMapping.toDomain(emitemrindto)));
    }

    @ApiOperation(value = "GetDraftByEMServiceEMItem", tags = {"EMItemRIn" },  notes = "GetDraftByEMServiceEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins/getdraft")
    public ResponseEntity<EMItemRInDTO> getDraftByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemRIn domain = new EMItemRIn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinMapping.toDto(emitemrinService.getDraft(domain)));
    }

    @ApiOperation(value = "CreateByEMServiceEMItem", tags = {"EMItemRIn" },  notes = "CreateByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins")
    @Transactional
    public ResponseEntity<EMItemRInDTO> createByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
		emitemrinService.create(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMServiceEMItem", tags = {"EMItemRIn" },  notes = "createBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> createBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMServiceEMItem", tags = {"EMItemRIn" },  notes = "UpdateByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<EMItemRInDTO> updateByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        domain.setEmitemrinid(emitemrin_id);
		emitemrinService.update(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMServiceEMItem", tags = {"EMItemRIn" },  notes = "UpdateBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> updateBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMServiceEMItem", tags = {"EMItemRIn" },  notes = "SaveByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins/save")
    public ResponseEntity<Boolean> saveByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMServiceEMItem", tags = {"EMItemRIn" },  notes = "SaveBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemrinService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMServiceEMItem", tags = {"EMItemRIn" },  notes = "GetByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    public ResponseEntity<EMItemRInDTO> getByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
        EMItemRIn domain = emitemrinService.get(emitemrin_id);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "RemoveByEMServiceEMItem", tags = {"EMItemRIn" },  notes = "RemoveByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.remove(emitemrin_id));
    }

    @ApiOperation(value = "RemoveBatchByEMServiceEMItem", tags = {"EMItemRIn" },  notes = "RemoveBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> removeBatchByEMServiceEMItem(@RequestBody List<String> ids) {
        emitemrinService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMServiceEMItem", tags = {"EMItemRIn" } ,notes = "fetchDEFAULTByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins/fetchdefault")
	public ResponseEntity<List<EMItemRInDTO>> fetchEMItemRInDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id,EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
        List<EMItemRInDTO> list = emitemrinMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMServiceEMItem", tags = {"EMItemRIn" } ,notes = "searchDEFAULTByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins/searchdefault")
	public ResponseEntity<Page<EMItemRInDTO>> searchEMItemRInDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemrinMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CheckKeyByEMStorePartEMItem", tags = {"EMItemRIn" },  notes = "CheckKeyByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemrinService.checkKey(emitemrinMapping.toDomain(emitemrindto)));
    }

    @ApiOperation(value = "GetDraftByEMStorePartEMItem", tags = {"EMItemRIn" },  notes = "GetDraftByEMStorePartEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/getdraft")
    public ResponseEntity<EMItemRInDTO> getDraftByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemRIn domain = new EMItemRIn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinMapping.toDto(emitemrinService.getDraft(domain)));
    }

    @ApiOperation(value = "CreateByEMStorePartEMItem", tags = {"EMItemRIn" },  notes = "CreateByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins")
    @Transactional
    public ResponseEntity<EMItemRInDTO> createByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
		emitemrinService.create(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStorePartEMItem", tags = {"EMItemRIn" },  notes = "createBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> createBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMStorePartEMItem", tags = {"EMItemRIn" },  notes = "UpdateByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<EMItemRInDTO> updateByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        domain.setEmitemrinid(emitemrin_id);
		emitemrinService.update(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStorePartEMItem", tags = {"EMItemRIn" },  notes = "UpdateBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> updateBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMStorePartEMItem", tags = {"EMItemRIn" },  notes = "SaveByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/save")
    public ResponseEntity<Boolean> saveByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStorePartEMItem", tags = {"EMItemRIn" },  notes = "SaveBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemrinService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMStorePartEMItem", tags = {"EMItemRIn" },  notes = "GetByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    public ResponseEntity<EMItemRInDTO> getByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
        EMItemRIn domain = emitemrinService.get(emitemrin_id);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "RemoveByEMStorePartEMItem", tags = {"EMItemRIn" },  notes = "RemoveByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.remove(emitemrin_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStorePartEMItem", tags = {"EMItemRIn" },  notes = "RemoveBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> removeBatchByEMStorePartEMItem(@RequestBody List<String> ids) {
        emitemrinService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMStorePartEMItem", tags = {"EMItemRIn" } ,notes = "fetchDEFAULTByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/fetchdefault")
	public ResponseEntity<List<EMItemRInDTO>> fetchEMItemRInDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
        List<EMItemRInDTO> list = emitemrinMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStorePartEMItem", tags = {"EMItemRIn" } ,notes = "searchDEFAULTByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/searchdefault")
	public ResponseEntity<Page<EMItemRInDTO>> searchEMItemRInDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemrinMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CheckKeyByEMStoreEMItem", tags = {"EMItemRIn" },  notes = "CheckKeyByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemrinService.checkKey(emitemrinMapping.toDomain(emitemrindto)));
    }

    @ApiOperation(value = "GetDraftByEMStoreEMItem", tags = {"EMItemRIn" },  notes = "GetDraftByEMStoreEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins/getdraft")
    public ResponseEntity<EMItemRInDTO> getDraftByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemRIn domain = new EMItemRIn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinMapping.toDto(emitemrinService.getDraft(domain)));
    }

    @ApiOperation(value = "CreateByEMStoreEMItem", tags = {"EMItemRIn" },  notes = "CreateByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins")
    @Transactional
    public ResponseEntity<EMItemRInDTO> createByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
		emitemrinService.create(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStoreEMItem", tags = {"EMItemRIn" },  notes = "createBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMStoreEMItem", tags = {"EMItemRIn" },  notes = "UpdateByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<EMItemRInDTO> updateByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        domain.setEmitemrinid(emitemrin_id);
		emitemrinService.update(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStoreEMItem", tags = {"EMItemRIn" },  notes = "UpdateBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMStoreEMItem", tags = {"EMItemRIn" },  notes = "SaveByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins/save")
    public ResponseEntity<Boolean> saveByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStoreEMItem", tags = {"EMItemRIn" },  notes = "SaveBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemrinService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMStoreEMItem", tags = {"EMItemRIn" },  notes = "GetByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    public ResponseEntity<EMItemRInDTO> getByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
        EMItemRIn domain = emitemrinService.get(emitemrin_id);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "RemoveByEMStoreEMItem", tags = {"EMItemRIn" },  notes = "RemoveByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.remove(emitemrin_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStoreEMItem", tags = {"EMItemRIn" },  notes = "RemoveBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMItem(@RequestBody List<String> ids) {
        emitemrinService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMStoreEMItem", tags = {"EMItemRIn" } ,notes = "fetchDEFAULTByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins/fetchdefault")
	public ResponseEntity<List<EMItemRInDTO>> fetchEMItemRInDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id,EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
        List<EMItemRInDTO> list = emitemrinMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStoreEMItem", tags = {"EMItemRIn" } ,notes = "searchDEFAULTByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins/searchdefault")
	public ResponseEntity<Page<EMItemRInDTO>> searchEMItemRInDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemrinMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CheckKeyByPFEmpEMItem", tags = {"EMItemRIn" },  notes = "CheckKeyByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemrinService.checkKey(emitemrinMapping.toDomain(emitemrindto)));
    }

    @ApiOperation(value = "GetDraftByPFEmpEMItem", tags = {"EMItemRIn" },  notes = "GetDraftByPFEmpEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins/getdraft")
    public ResponseEntity<EMItemRInDTO> getDraftByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemRIn domain = new EMItemRIn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinMapping.toDto(emitemrinService.getDraft(domain)));
    }

    @ApiOperation(value = "CreateByPFEmpEMItem", tags = {"EMItemRIn" },  notes = "CreateByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins")
    @Transactional
    public ResponseEntity<EMItemRInDTO> createByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
		emitemrinService.create(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFEmpEMItem", tags = {"EMItemRIn" },  notes = "createBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> createBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByPFEmpEMItem", tags = {"EMItemRIn" },  notes = "UpdateByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<EMItemRInDTO> updateByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        domain.setEmitemrinid(emitemrin_id);
		emitemrinService.update(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFEmpEMItem", tags = {"EMItemRIn" },  notes = "UpdateBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> updateBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByPFEmpEMItem", tags = {"EMItemRIn" },  notes = "SaveByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins/save")
    public ResponseEntity<Boolean> saveByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFEmpEMItem", tags = {"EMItemRIn" },  notes = "SaveBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemrinService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByPFEmpEMItem", tags = {"EMItemRIn" },  notes = "GetByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    public ResponseEntity<EMItemRInDTO> getByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
        EMItemRIn domain = emitemrinService.get(emitemrin_id);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "RemoveByPFEmpEMItem", tags = {"EMItemRIn" },  notes = "RemoveByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.remove(emitemrin_id));
    }

    @ApiOperation(value = "RemoveBatchByPFEmpEMItem", tags = {"EMItemRIn" },  notes = "RemoveBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> removeBatchByPFEmpEMItem(@RequestBody List<String> ids) {
        emitemrinService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByPFEmpEMItem", tags = {"EMItemRIn" } ,notes = "fetchDEFAULTByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins/fetchdefault")
	public ResponseEntity<List<EMItemRInDTO>> fetchEMItemRInDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id,EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
        List<EMItemRInDTO> list = emitemrinMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFEmpEMItem", tags = {"EMItemRIn" } ,notes = "searchDEFAULTByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins/searchdefault")
	public ResponseEntity<Page<EMItemRInDTO>> searchEMItemRInDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemrinMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CheckKeyByPFUnitEMItem", tags = {"EMItemRIn" },  notes = "CheckKeyByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemrinService.checkKey(emitemrinMapping.toDomain(emitemrindto)));
    }

    @ApiOperation(value = "GetDraftByPFUnitEMItem", tags = {"EMItemRIn" },  notes = "GetDraftByPFUnitEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins/getdraft")
    public ResponseEntity<EMItemRInDTO> getDraftByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemRIn domain = new EMItemRIn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinMapping.toDto(emitemrinService.getDraft(domain)));
    }

    @ApiOperation(value = "CreateByPFUnitEMItem", tags = {"EMItemRIn" },  notes = "CreateByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins")
    @Transactional
    public ResponseEntity<EMItemRInDTO> createByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
		emitemrinService.create(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFUnitEMItem", tags = {"EMItemRIn" },  notes = "createBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> createBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByPFUnitEMItem", tags = {"EMItemRIn" },  notes = "UpdateByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<EMItemRInDTO> updateByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        domain.setEmitemrinid(emitemrin_id);
		emitemrinService.update(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFUnitEMItem", tags = {"EMItemRIn" },  notes = "UpdateBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> updateBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByPFUnitEMItem", tags = {"EMItemRIn" },  notes = "SaveByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins/save")
    public ResponseEntity<Boolean> saveByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFUnitEMItem", tags = {"EMItemRIn" },  notes = "SaveBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemrinService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByPFUnitEMItem", tags = {"EMItemRIn" },  notes = "GetByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    public ResponseEntity<EMItemRInDTO> getByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
        EMItemRIn domain = emitemrinService.get(emitemrin_id);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "RemoveByPFUnitEMItem", tags = {"EMItemRIn" },  notes = "RemoveByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.remove(emitemrin_id));
    }

    @ApiOperation(value = "RemoveBatchByPFUnitEMItem", tags = {"EMItemRIn" },  notes = "RemoveBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> removeBatchByPFUnitEMItem(@RequestBody List<String> ids) {
        emitemrinService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByPFUnitEMItem", tags = {"EMItemRIn" } ,notes = "fetchDEFAULTByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins/fetchdefault")
	public ResponseEntity<List<EMItemRInDTO>> fetchEMItemRInDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id,EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
        List<EMItemRInDTO> list = emitemrinMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFUnitEMItem", tags = {"EMItemRIn" } ,notes = "searchDEFAULTByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins/searchdefault")
	public ResponseEntity<Page<EMItemRInDTO>> searchEMItemRInDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemrinMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}





    @ApiOperation(value = "CheckKeyByEMStoreEMStorePartEMItem", tags = {"EMItemRIn" },  notes = "CheckKeyByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemrinService.checkKey(emitemrinMapping.toDomain(emitemrindto)));
    }

    @ApiOperation(value = "GetDraftByEMStoreEMStorePartEMItem", tags = {"EMItemRIn" },  notes = "GetDraftByEMStoreEMStorePartEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/getdraft")
    public ResponseEntity<EMItemRInDTO> getDraftByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemRIn domain = new EMItemRIn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinMapping.toDto(emitemrinService.getDraft(domain)));
    }

    @ApiOperation(value = "CreateByEMStoreEMStorePartEMItem", tags = {"EMItemRIn" },  notes = "CreateByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins")
    @Transactional
    public ResponseEntity<EMItemRInDTO> createByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
		emitemrinService.create(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStoreEMStorePartEMItem", tags = {"EMItemRIn" },  notes = "createBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMStoreEMStorePartEMItem", tags = {"EMItemRIn" },  notes = "UpdateByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<EMItemRInDTO> updateByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        domain.setEmitemrinid(emitemrin_id);
		emitemrinService.update(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStoreEMStorePartEMItem", tags = {"EMItemRIn" },  notes = "UpdateBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMStoreEMStorePartEMItem", tags = {"EMItemRIn" },  notes = "SaveByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/save")
    public ResponseEntity<Boolean> saveByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStoreEMStorePartEMItem", tags = {"EMItemRIn" },  notes = "SaveBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemrinService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMStoreEMStorePartEMItem", tags = {"EMItemRIn" },  notes = "GetByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    public ResponseEntity<EMItemRInDTO> getByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
        EMItemRIn domain = emitemrinService.get(emitemrin_id);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "RemoveByEMStoreEMStorePartEMItem", tags = {"EMItemRIn" },  notes = "RemoveByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.remove(emitemrin_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStoreEMStorePartEMItem", tags = {"EMItemRIn" },  notes = "RemoveBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMStorePartEMItem(@RequestBody List<String> ids) {
        emitemrinService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMStoreEMStorePartEMItem", tags = {"EMItemRIn" } ,notes = "fetchDEFAULTByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/fetchdefault")
	public ResponseEntity<List<EMItemRInDTO>> fetchEMItemRInDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
        List<EMItemRInDTO> list = emitemrinMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStoreEMStorePartEMItem", tags = {"EMItemRIn" } ,notes = "searchDEFAULTByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/searchdefault")
	public ResponseEntity<Page<EMItemRInDTO>> searchEMItemRInDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemrinMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMItemRIn getEntity(){
        return new EMItemRIn();
    }

}
