package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMItemPRtn;
import cn.ibizlab.eam.core.eam_core.service.IEMItemPRtnService;
import cn.ibizlab.eam.core.eam_core.filter.EMItemPRtnSearchContext;




@Slf4j
@Api(tags = {"EMItemPRtn" })
@RestController("WebApi-emitemprtn")
@RequestMapping("")
public class EMItemPRtnResource {

    @Autowired
    private IEMItemPRtnService emitemprtnService;

    @Autowired
    @Lazy
    private EMItemPRtnMapping emitemprtnMapping;




    @ApiOperation(value = "CheckKey", tags = {"EMItemPRtn" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemprtns/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMItemPRtnDTO emitemprtndto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.checkKey(emitemprtnMapping.toDomain(emitemprtndto)));
    }




    @ApiOperation(value = "GetDraft", tags = {"EMItemPRtn" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emitemprtns/getdraft")
    public ResponseEntity<EMItemPRtnDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnMapping.toDto(emitemprtnService.getDraft(new EMItemPRtn())));
    }




    @PreAuthorize("hasPermission(#emitemprtn_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMItemPRtn" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> update(@PathVariable("emitemprtn_id") String emitemprtn_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
		EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setEmitemprtnid(emitemprtn_id);
		emitemprtnService.update(domain);
		EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emitemprtn_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMItemPRtn" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitemprtns/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        emitemprtnService.updateBatch(emitemprtnMapping.toDomain(emitemprtndtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emitemprtn_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMItemPRtn" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emitemprtns/{emitemprtn_id}")
    public ResponseEntity<EMItemPRtnDTO> get(@PathVariable("emitemprtn_id") String emitemprtn_id) {
        EMItemPRtn domain = emitemprtnService.get(emitemprtn_id);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "Save", tags = {"EMItemPRtn" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemprtns/save")
    public ResponseEntity<Boolean> save(@RequestBody EMItemPRtnDTO emitemprtndto) {
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.save(emitemprtnMapping.toDomain(emitemprtndto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMItemPRtn" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemprtns/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        emitemprtnService.saveBatch(emitemprtnMapping.toDomain(emitemprtndtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emitemprtn_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMItemPRtn" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emitemprtn_id") String emitemprtn_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.remove(emitemprtn_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMItemPRtn" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitemprtns/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emitemprtnService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMItemPRtn" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemprtns")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> create(@RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
		emitemprtnService.create(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMItemPRtn" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemprtns/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        emitemprtnService.createBatch(emitemprtnMapping.toDomain(emitemprtndtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPRtn-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMItemPRtn" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emitemprtns/fetchdefault")
	public ResponseEntity<List<EMItemPRtnDTO>> fetchDefault(EMItemPRtnSearchContext context) {
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
        List<EMItemPRtnDTO> list = emitemprtnMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPRtn-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMItemPRtn" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emitemprtns/searchdefault")
	public ResponseEntity<Page<EMItemPRtnDTO>> searchDefault(@RequestBody EMItemPRtnSearchContext context) {
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemprtnMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "CheckKeyByEMItem", tags = {"EMItemPRtn" },  notes = "CheckKeyByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemprtns/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.checkKey(emitemprtnMapping.toDomain(emitemprtndto)));
    }

    @ApiOperation(value = "GetDraftByEMItem", tags = {"EMItemPRtn" },  notes = "GetDraftByEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emitemprtns/getdraft")
    public ResponseEntity<EMItemPRtnDTO> getDraftByEMItem(@PathVariable("emitem_id") String emitem_id) {
        EMItemPRtn domain = new EMItemPRtn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnMapping.toDto(emitemprtnService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByEMItem", tags = {"EMItemPRtn" },  notes = "UpdateByEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> updateByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        domain.setEmitemprtnid(emitemprtn_id);
		emitemprtnService.update(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMItem", tags = {"EMItemPRtn" },  notes = "UpdateBatchByEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> updateBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMItem", tags = {"EMItemPRtn" },  notes = "GetByEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    public ResponseEntity<EMItemPRtnDTO> getByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
        EMItemPRtn domain = emitemprtnService.get(emitemprtn_id);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByEMItem", tags = {"EMItemPRtn" },  notes = "SaveByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemprtns/save")
    public ResponseEntity<Boolean> saveByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMItem", tags = {"EMItemPRtn" },  notes = "SaveBatchByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemprtns/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemprtnService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMItem", tags = {"EMItemPRtn" },  notes = "RemoveByEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.remove(emitemprtn_id));
    }

    @ApiOperation(value = "RemoveBatchByEMItem", tags = {"EMItemPRtn" },  notes = "RemoveBatchByEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> removeBatchByEMItem(@RequestBody List<String> ids) {
        emitemprtnService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMItem", tags = {"EMItemPRtn" },  notes = "CreateByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemprtns")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> createByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
		emitemprtnService.create(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMItem", tags = {"EMItemPRtn" },  notes = "createBatchByEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> createBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMItem", tags = {"EMItemPRtn" } ,notes = "fetchDEFAULTByEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/emitemprtns/fetchdefault")
	public ResponseEntity<List<EMItemPRtnDTO>> fetchEMItemPRtnDefaultByEMItem(@PathVariable("emitem_id") String emitem_id,EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
        List<EMItemPRtnDTO> list = emitemprtnMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMItem", tags = {"EMItemPRtn" } ,notes = "searchDEFAULTByEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/emitemprtns/searchdefault")
	public ResponseEntity<Page<EMItemPRtnDTO>> searchEMItemPRtnDefaultByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemprtnMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CheckKeyByEMServiceEMItem", tags = {"EMItemPRtn" },  notes = "CheckKeyByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.checkKey(emitemprtnMapping.toDomain(emitemprtndto)));
    }

    @ApiOperation(value = "GetDraftByEMServiceEMItem", tags = {"EMItemPRtn" },  notes = "GetDraftByEMServiceEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns/getdraft")
    public ResponseEntity<EMItemPRtnDTO> getDraftByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemPRtn domain = new EMItemPRtn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnMapping.toDto(emitemprtnService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByEMServiceEMItem", tags = {"EMItemPRtn" },  notes = "UpdateByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> updateByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        domain.setEmitemprtnid(emitemprtn_id);
		emitemprtnService.update(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMServiceEMItem", tags = {"EMItemPRtn" },  notes = "UpdateBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> updateBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMServiceEMItem", tags = {"EMItemPRtn" },  notes = "GetByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    public ResponseEntity<EMItemPRtnDTO> getByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
        EMItemPRtn domain = emitemprtnService.get(emitemprtn_id);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByEMServiceEMItem", tags = {"EMItemPRtn" },  notes = "SaveByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns/save")
    public ResponseEntity<Boolean> saveByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMServiceEMItem", tags = {"EMItemPRtn" },  notes = "SaveBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemprtnService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMServiceEMItem", tags = {"EMItemPRtn" },  notes = "RemoveByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.remove(emitemprtn_id));
    }

    @ApiOperation(value = "RemoveBatchByEMServiceEMItem", tags = {"EMItemPRtn" },  notes = "RemoveBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> removeBatchByEMServiceEMItem(@RequestBody List<String> ids) {
        emitemprtnService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMServiceEMItem", tags = {"EMItemPRtn" },  notes = "CreateByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> createByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
		emitemprtnService.create(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMServiceEMItem", tags = {"EMItemPRtn" },  notes = "createBatchByEMServiceEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> createBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMServiceEMItem", tags = {"EMItemPRtn" } ,notes = "fetchDEFAULTByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns/fetchdefault")
	public ResponseEntity<List<EMItemPRtnDTO>> fetchEMItemPRtnDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id,EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
        List<EMItemPRtnDTO> list = emitemprtnMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMServiceEMItem", tags = {"EMItemPRtn" } ,notes = "searchDEFAULTByEMServiceEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/emitemprtns/searchdefault")
	public ResponseEntity<Page<EMItemPRtnDTO>> searchEMItemPRtnDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemprtnMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CheckKeyByEMStorePartEMItem", tags = {"EMItemPRtn" },  notes = "CheckKeyByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.checkKey(emitemprtnMapping.toDomain(emitemprtndto)));
    }

    @ApiOperation(value = "GetDraftByEMStorePartEMItem", tags = {"EMItemPRtn" },  notes = "GetDraftByEMStorePartEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/getdraft")
    public ResponseEntity<EMItemPRtnDTO> getDraftByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemPRtn domain = new EMItemPRtn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnMapping.toDto(emitemprtnService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByEMStorePartEMItem", tags = {"EMItemPRtn" },  notes = "UpdateByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> updateByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        domain.setEmitemprtnid(emitemprtn_id);
		emitemprtnService.update(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStorePartEMItem", tags = {"EMItemPRtn" },  notes = "UpdateBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> updateBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMStorePartEMItem", tags = {"EMItemPRtn" },  notes = "GetByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    public ResponseEntity<EMItemPRtnDTO> getByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
        EMItemPRtn domain = emitemprtnService.get(emitemprtn_id);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByEMStorePartEMItem", tags = {"EMItemPRtn" },  notes = "SaveByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/save")
    public ResponseEntity<Boolean> saveByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStorePartEMItem", tags = {"EMItemPRtn" },  notes = "SaveBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemprtnService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMStorePartEMItem", tags = {"EMItemPRtn" },  notes = "RemoveByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.remove(emitemprtn_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStorePartEMItem", tags = {"EMItemPRtn" },  notes = "RemoveBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> removeBatchByEMStorePartEMItem(@RequestBody List<String> ids) {
        emitemprtnService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMStorePartEMItem", tags = {"EMItemPRtn" },  notes = "CreateByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> createByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
		emitemprtnService.create(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStorePartEMItem", tags = {"EMItemPRtn" },  notes = "createBatchByEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> createBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMStorePartEMItem", tags = {"EMItemPRtn" } ,notes = "fetchDEFAULTByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/fetchdefault")
	public ResponseEntity<List<EMItemPRtnDTO>> fetchEMItemPRtnDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
        List<EMItemPRtnDTO> list = emitemprtnMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStorePartEMItem", tags = {"EMItemPRtn" } ,notes = "searchDEFAULTByEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/searchdefault")
	public ResponseEntity<Page<EMItemPRtnDTO>> searchEMItemPRtnDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemprtnMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CheckKeyByEMStoreEMItem", tags = {"EMItemPRtn" },  notes = "CheckKeyByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.checkKey(emitemprtnMapping.toDomain(emitemprtndto)));
    }

    @ApiOperation(value = "GetDraftByEMStoreEMItem", tags = {"EMItemPRtn" },  notes = "GetDraftByEMStoreEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns/getdraft")
    public ResponseEntity<EMItemPRtnDTO> getDraftByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemPRtn domain = new EMItemPRtn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnMapping.toDto(emitemprtnService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByEMStoreEMItem", tags = {"EMItemPRtn" },  notes = "UpdateByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> updateByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        domain.setEmitemprtnid(emitemprtn_id);
		emitemprtnService.update(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStoreEMItem", tags = {"EMItemPRtn" },  notes = "UpdateBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMStoreEMItem", tags = {"EMItemPRtn" },  notes = "GetByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    public ResponseEntity<EMItemPRtnDTO> getByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
        EMItemPRtn domain = emitemprtnService.get(emitemprtn_id);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByEMStoreEMItem", tags = {"EMItemPRtn" },  notes = "SaveByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns/save")
    public ResponseEntity<Boolean> saveByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStoreEMItem", tags = {"EMItemPRtn" },  notes = "SaveBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemprtnService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMStoreEMItem", tags = {"EMItemPRtn" },  notes = "RemoveByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.remove(emitemprtn_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStoreEMItem", tags = {"EMItemPRtn" },  notes = "RemoveBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMItem(@RequestBody List<String> ids) {
        emitemprtnService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMStoreEMItem", tags = {"EMItemPRtn" },  notes = "CreateByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> createByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
		emitemprtnService.create(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStoreEMItem", tags = {"EMItemPRtn" },  notes = "createBatchByEMStoreEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMStoreEMItem", tags = {"EMItemPRtn" } ,notes = "fetchDEFAULTByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns/fetchdefault")
	public ResponseEntity<List<EMItemPRtnDTO>> fetchEMItemPRtnDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id,EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
        List<EMItemPRtnDTO> list = emitemprtnMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStoreEMItem", tags = {"EMItemPRtn" } ,notes = "searchDEFAULTByEMStoreEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/emitemprtns/searchdefault")
	public ResponseEntity<Page<EMItemPRtnDTO>> searchEMItemPRtnDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemprtnMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CheckKeyByPFEmpEMItem", tags = {"EMItemPRtn" },  notes = "CheckKeyByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.checkKey(emitemprtnMapping.toDomain(emitemprtndto)));
    }

    @ApiOperation(value = "GetDraftByPFEmpEMItem", tags = {"EMItemPRtn" },  notes = "GetDraftByPFEmpEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns/getdraft")
    public ResponseEntity<EMItemPRtnDTO> getDraftByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemPRtn domain = new EMItemPRtn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnMapping.toDto(emitemprtnService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByPFEmpEMItem", tags = {"EMItemPRtn" },  notes = "UpdateByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> updateByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        domain.setEmitemprtnid(emitemprtn_id);
		emitemprtnService.update(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFEmpEMItem", tags = {"EMItemPRtn" },  notes = "UpdateBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> updateBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByPFEmpEMItem", tags = {"EMItemPRtn" },  notes = "GetByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    public ResponseEntity<EMItemPRtnDTO> getByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
        EMItemPRtn domain = emitemprtnService.get(emitemprtn_id);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByPFEmpEMItem", tags = {"EMItemPRtn" },  notes = "SaveByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns/save")
    public ResponseEntity<Boolean> saveByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFEmpEMItem", tags = {"EMItemPRtn" },  notes = "SaveBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemprtnService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByPFEmpEMItem", tags = {"EMItemPRtn" },  notes = "RemoveByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.remove(emitemprtn_id));
    }

    @ApiOperation(value = "RemoveBatchByPFEmpEMItem", tags = {"EMItemPRtn" },  notes = "RemoveBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> removeBatchByPFEmpEMItem(@RequestBody List<String> ids) {
        emitemprtnService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByPFEmpEMItem", tags = {"EMItemPRtn" },  notes = "CreateByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> createByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
		emitemprtnService.create(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFEmpEMItem", tags = {"EMItemPRtn" },  notes = "createBatchByPFEmpEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> createBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByPFEmpEMItem", tags = {"EMItemPRtn" } ,notes = "fetchDEFAULTByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns/fetchdefault")
	public ResponseEntity<List<EMItemPRtnDTO>> fetchEMItemPRtnDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id,EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
        List<EMItemPRtnDTO> list = emitemprtnMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFEmpEMItem", tags = {"EMItemPRtn" } ,notes = "searchDEFAULTByPFEmpEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemprtns/searchdefault")
	public ResponseEntity<Page<EMItemPRtnDTO>> searchEMItemPRtnDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemprtnMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CheckKeyByPFUnitEMItem", tags = {"EMItemPRtn" },  notes = "CheckKeyByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.checkKey(emitemprtnMapping.toDomain(emitemprtndto)));
    }

    @ApiOperation(value = "GetDraftByPFUnitEMItem", tags = {"EMItemPRtn" },  notes = "GetDraftByPFUnitEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns/getdraft")
    public ResponseEntity<EMItemPRtnDTO> getDraftByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemPRtn domain = new EMItemPRtn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnMapping.toDto(emitemprtnService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByPFUnitEMItem", tags = {"EMItemPRtn" },  notes = "UpdateByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> updateByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        domain.setEmitemprtnid(emitemprtn_id);
		emitemprtnService.update(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFUnitEMItem", tags = {"EMItemPRtn" },  notes = "UpdateBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> updateBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByPFUnitEMItem", tags = {"EMItemPRtn" },  notes = "GetByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    public ResponseEntity<EMItemPRtnDTO> getByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
        EMItemPRtn domain = emitemprtnService.get(emitemprtn_id);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByPFUnitEMItem", tags = {"EMItemPRtn" },  notes = "SaveByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns/save")
    public ResponseEntity<Boolean> saveByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFUnitEMItem", tags = {"EMItemPRtn" },  notes = "SaveBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemprtnService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByPFUnitEMItem", tags = {"EMItemPRtn" },  notes = "RemoveByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.remove(emitemprtn_id));
    }

    @ApiOperation(value = "RemoveBatchByPFUnitEMItem", tags = {"EMItemPRtn" },  notes = "RemoveBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> removeBatchByPFUnitEMItem(@RequestBody List<String> ids) {
        emitemprtnService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByPFUnitEMItem", tags = {"EMItemPRtn" },  notes = "CreateByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> createByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
		emitemprtnService.create(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFUnitEMItem", tags = {"EMItemPRtn" },  notes = "createBatchByPFUnitEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> createBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByPFUnitEMItem", tags = {"EMItemPRtn" } ,notes = "fetchDEFAULTByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns/fetchdefault")
	public ResponseEntity<List<EMItemPRtnDTO>> fetchEMItemPRtnDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id,EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
        List<EMItemPRtnDTO> list = emitemprtnMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFUnitEMItem", tags = {"EMItemPRtn" } ,notes = "searchDEFAULTByPFUnitEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemprtns/searchdefault")
	public ResponseEntity<Page<EMItemPRtnDTO>> searchEMItemPRtnDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemprtnMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}





    @ApiOperation(value = "CheckKeyByEMStoreEMStorePartEMItem", tags = {"EMItemPRtn" },  notes = "CheckKeyByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.checkKey(emitemprtnMapping.toDomain(emitemprtndto)));
    }

    @ApiOperation(value = "GetDraftByEMStoreEMStorePartEMItem", tags = {"EMItemPRtn" },  notes = "GetDraftByEMStoreEMStorePartEMItem")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/getdraft")
    public ResponseEntity<EMItemPRtnDTO> getDraftByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemPRtn domain = new EMItemPRtn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnMapping.toDto(emitemprtnService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByEMStoreEMStorePartEMItem", tags = {"EMItemPRtn" },  notes = "UpdateByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> updateByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        domain.setEmitemprtnid(emitemprtn_id);
		emitemprtnService.update(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMStoreEMStorePartEMItem", tags = {"EMItemPRtn" },  notes = "UpdateBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMStoreEMStorePartEMItem", tags = {"EMItemPRtn" },  notes = "GetByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    public ResponseEntity<EMItemPRtnDTO> getByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
        EMItemPRtn domain = emitemprtnService.get(emitemprtn_id);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByEMStoreEMStorePartEMItem", tags = {"EMItemPRtn" },  notes = "SaveByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/save")
    public ResponseEntity<Boolean> saveByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMStoreEMStorePartEMItem", tags = {"EMItemPRtn" },  notes = "SaveBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemprtnService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMStoreEMStorePartEMItem", tags = {"EMItemPRtn" },  notes = "RemoveByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/{emitemprtn_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemprtn_id") String emitemprtn_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemprtnService.remove(emitemprtn_id));
    }

    @ApiOperation(value = "RemoveBatchByEMStoreEMStorePartEMItem", tags = {"EMItemPRtn" },  notes = "RemoveBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMStorePartEMItem(@RequestBody List<String> ids) {
        emitemprtnService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMStoreEMStorePartEMItem", tags = {"EMItemPRtn" },  notes = "CreateByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns")
    @Transactional
    public ResponseEntity<EMItemPRtnDTO> createByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnDTO emitemprtndto) {
        EMItemPRtn domain = emitemprtnMapping.toDomain(emitemprtndto);
        domain.setItemid(emitem_id);
		emitemprtnService.create(domain);
        EMItemPRtnDTO dto = emitemprtnMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMStoreEMStorePartEMItem", tags = {"EMItemPRtn" },  notes = "createBatchByEMStoreEMStorePartEMItem")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemPRtnDTO> emitemprtndtos) {
        List<EMItemPRtn> domainlist=emitemprtnMapping.toDomain(emitemprtndtos);
        for(EMItemPRtn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemprtnService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMStoreEMStorePartEMItem", tags = {"EMItemPRtn" } ,notes = "fetchDEFAULTByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/fetchdefault")
	public ResponseEntity<List<EMItemPRtnDTO>> fetchEMItemPRtnDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
        List<EMItemPRtnDTO> list = emitemprtnMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMStoreEMStorePartEMItem", tags = {"EMItemPRtn" } ,notes = "searchDEFAULTByEMStoreEMStorePartEMItem")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemprtns/searchdefault")
	public ResponseEntity<Page<EMItemPRtnDTO>> searchEMItemPRtnDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemPRtnSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemPRtn> domains = emitemprtnService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemprtnMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMItemPRtn getEntity(){
        return new EMItemPRtn();
    }

}
