package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEQMaintance;
import cn.ibizlab.eam.core.eam_core.service.IEMEQMaintanceService;
import cn.ibizlab.eam.core.eam_core.filter.EMEQMaintanceSearchContext;




@Slf4j
@Api(tags = {"EMEQMaintance" })
@RestController("WebApi-emeqmaintance")
@RequestMapping("")
public class EMEQMaintanceResource {

    @Autowired
    private IEMEQMaintanceService emeqmaintanceService;

    @Autowired
    @Lazy
    private EMEQMaintanceMapping emeqmaintanceMapping;




    @PreAuthorize("hasPermission(#emeqmaintance_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMEQMaintance" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqmaintances/{emeqmaintance_id}")
    @Transactional
    public ResponseEntity<EMEQMaintanceDTO> update(@PathVariable("emeqmaintance_id") String emeqmaintance_id, @RequestBody EMEQMaintanceDTO emeqmaintancedto) {
		EMEQMaintance domain = emeqmaintanceMapping.toDomain(emeqmaintancedto);
        domain.setEmeqmaintanceid(emeqmaintance_id);
		emeqmaintanceService.update(domain);
		EMEQMaintanceDTO dto = emeqmaintanceMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emeqmaintance_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEQMaintance" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqmaintances/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEQMaintanceDTO> emeqmaintancedtos) {
        emeqmaintanceService.updateBatch(emeqmaintanceMapping.toDomain(emeqmaintancedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMEQMaintance" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqmaintances/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEQMaintanceDTO emeqmaintancedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqmaintanceService.checkKey(emeqmaintanceMapping.toDomain(emeqmaintancedto)));
    }




    @PreAuthorize("hasPermission(#emeqmaintance_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMEQMaintance" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqmaintances/{emeqmaintance_id}")
    public ResponseEntity<EMEQMaintanceDTO> get(@PathVariable("emeqmaintance_id") String emeqmaintance_id) {
        EMEQMaintance domain = emeqmaintanceService.get(emeqmaintance_id);
        EMEQMaintanceDTO dto = emeqmaintanceMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @PreAuthorize("hasPermission(#emeqmaintance_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMEQMaintance" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqmaintances/{emeqmaintance_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeqmaintance_id") String emeqmaintance_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeqmaintanceService.remove(emeqmaintance_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMEQMaintance" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqmaintances/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeqmaintanceService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMEQMaintance" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqmaintances/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEQMaintanceDTO emeqmaintancedto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeqmaintanceService.save(emeqmaintanceMapping.toDomain(emeqmaintancedto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMEQMaintance" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqmaintances/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEQMaintanceDTO> emeqmaintancedtos) {
        emeqmaintanceService.saveBatch(emeqmaintanceMapping.toDomain(emeqmaintancedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMEQMaintance" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqmaintances")
    @Transactional
    public ResponseEntity<EMEQMaintanceDTO> create(@RequestBody EMEQMaintanceDTO emeqmaintancedto) {
        EMEQMaintance domain = emeqmaintanceMapping.toDomain(emeqmaintancedto);
		emeqmaintanceService.create(domain);
        EMEQMaintanceDTO dto = emeqmaintanceMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMEQMaintance" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqmaintances/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEQMaintanceDTO> emeqmaintancedtos) {
        emeqmaintanceService.createBatch(emeqmaintanceMapping.toDomain(emeqmaintancedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMEQMaintance" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqmaintances/getdraft")
    public ResponseEntity<EMEQMaintanceDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeqmaintanceMapping.toDto(emeqmaintanceService.getDraft(new EMEQMaintance())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQMaintance-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEQMaintance" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqmaintances/fetchdefault")
	public ResponseEntity<List<EMEQMaintanceDTO>> fetchDefault(EMEQMaintanceSearchContext context) {
        Page<EMEQMaintance> domains = emeqmaintanceService.searchDefault(context) ;
        List<EMEQMaintanceDTO> list = emeqmaintanceMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQMaintance-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEQMaintance" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqmaintances/searchdefault")
	public ResponseEntity<Page<EMEQMaintanceDTO>> searchDefault(@RequestBody EMEQMaintanceSearchContext context) {
        Page<EMEQMaintance> domains = emeqmaintanceService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqmaintanceMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "UpdateByEMEquip", tags = {"EMEQMaintance" },  notes = "UpdateByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emeqmaintances/{emeqmaintance_id}")
    @Transactional
    public ResponseEntity<EMEQMaintanceDTO> updateByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emeqmaintance_id") String emeqmaintance_id, @RequestBody EMEQMaintanceDTO emeqmaintancedto) {
        EMEQMaintance domain = emeqmaintanceMapping.toDomain(emeqmaintancedto);
        domain.setEquipid(emequip_id);
        domain.setEmeqmaintanceid(emeqmaintance_id);
		emeqmaintanceService.update(domain);
        EMEQMaintanceDTO dto = emeqmaintanceMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMEquip", tags = {"EMEQMaintance" },  notes = "UpdateBatchByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emeqmaintances/batch")
    public ResponseEntity<Boolean> updateBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQMaintanceDTO> emeqmaintancedtos) {
        List<EMEQMaintance> domainlist=emeqmaintanceMapping.toDomain(emeqmaintancedtos);
        for(EMEQMaintance domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqmaintanceService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMEquip", tags = {"EMEQMaintance" },  notes = "CheckKeyByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqmaintances/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEQMaintanceDTO emeqmaintancedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqmaintanceService.checkKey(emeqmaintanceMapping.toDomain(emeqmaintancedto)));
    }

    @ApiOperation(value = "GetByEMEquip", tags = {"EMEQMaintance" },  notes = "GetByEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emeqmaintances/{emeqmaintance_id}")
    public ResponseEntity<EMEQMaintanceDTO> getByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emeqmaintance_id") String emeqmaintance_id) {
        EMEQMaintance domain = emeqmaintanceService.get(emeqmaintance_id);
        EMEQMaintanceDTO dto = emeqmaintanceMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "RemoveByEMEquip", tags = {"EMEQMaintance" },  notes = "RemoveByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emeqmaintances/{emeqmaintance_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emeqmaintance_id") String emeqmaintance_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqmaintanceService.remove(emeqmaintance_id));
    }

    @ApiOperation(value = "RemoveBatchByEMEquip", tags = {"EMEQMaintance" },  notes = "RemoveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emeqmaintances/batch")
    public ResponseEntity<Boolean> removeBatchByEMEquip(@RequestBody List<String> ids) {
        emeqmaintanceService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMEquip", tags = {"EMEQMaintance" },  notes = "SaveByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqmaintances/save")
    public ResponseEntity<Boolean> saveByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEQMaintanceDTO emeqmaintancedto) {
        EMEQMaintance domain = emeqmaintanceMapping.toDomain(emeqmaintancedto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqmaintanceService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMEquip", tags = {"EMEQMaintance" },  notes = "SaveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqmaintances/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQMaintanceDTO> emeqmaintancedtos) {
        List<EMEQMaintance> domainlist=emeqmaintanceMapping.toDomain(emeqmaintancedtos);
        for(EMEQMaintance domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emeqmaintanceService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMEquip", tags = {"EMEQMaintance" },  notes = "CreateByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqmaintances")
    @Transactional
    public ResponseEntity<EMEQMaintanceDTO> createByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEQMaintanceDTO emeqmaintancedto) {
        EMEQMaintance domain = emeqmaintanceMapping.toDomain(emeqmaintancedto);
        domain.setEquipid(emequip_id);
		emeqmaintanceService.create(domain);
        EMEQMaintanceDTO dto = emeqmaintanceMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMEquip", tags = {"EMEQMaintance" },  notes = "createBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqmaintances/batch")
    public ResponseEntity<Boolean> createBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQMaintanceDTO> emeqmaintancedtos) {
        List<EMEQMaintance> domainlist=emeqmaintanceMapping.toDomain(emeqmaintancedtos);
        for(EMEQMaintance domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqmaintanceService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMEquip", tags = {"EMEQMaintance" },  notes = "GetDraftByEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emeqmaintances/getdraft")
    public ResponseEntity<EMEQMaintanceDTO> getDraftByEMEquip(@PathVariable("emequip_id") String emequip_id) {
        EMEQMaintance domain = new EMEQMaintance();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqmaintanceMapping.toDto(emeqmaintanceService.getDraft(domain)));
    }

	@ApiOperation(value = "fetchDEFAULTByEMEquip", tags = {"EMEQMaintance" } ,notes = "fetchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/{emequip_id}/emeqmaintances/fetchdefault")
	public ResponseEntity<List<EMEQMaintanceDTO>> fetchEMEQMaintanceDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id,EMEQMaintanceSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQMaintance> domains = emeqmaintanceService.searchDefault(context) ;
        List<EMEQMaintanceDTO> list = emeqmaintanceMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMEquip", tags = {"EMEQMaintance" } ,notes = "searchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/{emequip_id}/emeqmaintances/searchdefault")
	public ResponseEntity<Page<EMEQMaintanceDTO>> searchEMEQMaintanceDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEQMaintanceSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQMaintance> domains = emeqmaintanceService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqmaintanceMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "UpdateByEMEQTypeEMEquip", tags = {"EMEQMaintance" },  notes = "UpdateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqmaintances/{emeqmaintance_id}")
    @Transactional
    public ResponseEntity<EMEQMaintanceDTO> updateByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqmaintance_id") String emeqmaintance_id, @RequestBody EMEQMaintanceDTO emeqmaintancedto) {
        EMEQMaintance domain = emeqmaintanceMapping.toDomain(emeqmaintancedto);
        domain.setEquipid(emequip_id);
        domain.setEmeqmaintanceid(emeqmaintance_id);
		emeqmaintanceService.update(domain);
        EMEQMaintanceDTO dto = emeqmaintanceMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMEQTypeEMEquip", tags = {"EMEQMaintance" },  notes = "UpdateBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqmaintances/batch")
    public ResponseEntity<Boolean> updateBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQMaintanceDTO> emeqmaintancedtos) {
        List<EMEQMaintance> domainlist=emeqmaintanceMapping.toDomain(emeqmaintancedtos);
        for(EMEQMaintance domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqmaintanceService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMEQTypeEMEquip", tags = {"EMEQMaintance" },  notes = "CheckKeyByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqmaintances/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQMaintanceDTO emeqmaintancedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqmaintanceService.checkKey(emeqmaintanceMapping.toDomain(emeqmaintancedto)));
    }

    @ApiOperation(value = "GetByEMEQTypeEMEquip", tags = {"EMEQMaintance" },  notes = "GetByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqmaintances/{emeqmaintance_id}")
    public ResponseEntity<EMEQMaintanceDTO> getByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqmaintance_id") String emeqmaintance_id) {
        EMEQMaintance domain = emeqmaintanceService.get(emeqmaintance_id);
        EMEQMaintanceDTO dto = emeqmaintanceMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "RemoveByEMEQTypeEMEquip", tags = {"EMEQMaintance" },  notes = "RemoveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqmaintances/{emeqmaintance_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqmaintance_id") String emeqmaintance_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqmaintanceService.remove(emeqmaintance_id));
    }

    @ApiOperation(value = "RemoveBatchByEMEQTypeEMEquip", tags = {"EMEQMaintance" },  notes = "RemoveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqmaintances/batch")
    public ResponseEntity<Boolean> removeBatchByEMEQTypeEMEquip(@RequestBody List<String> ids) {
        emeqmaintanceService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMEQTypeEMEquip", tags = {"EMEQMaintance" },  notes = "SaveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqmaintances/save")
    public ResponseEntity<Boolean> saveByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQMaintanceDTO emeqmaintancedto) {
        EMEQMaintance domain = emeqmaintanceMapping.toDomain(emeqmaintancedto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqmaintanceService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMEQTypeEMEquip", tags = {"EMEQMaintance" },  notes = "SaveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqmaintances/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQMaintanceDTO> emeqmaintancedtos) {
        List<EMEQMaintance> domainlist=emeqmaintanceMapping.toDomain(emeqmaintancedtos);
        for(EMEQMaintance domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emeqmaintanceService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMEQTypeEMEquip", tags = {"EMEQMaintance" },  notes = "CreateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqmaintances")
    @Transactional
    public ResponseEntity<EMEQMaintanceDTO> createByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQMaintanceDTO emeqmaintancedto) {
        EMEQMaintance domain = emeqmaintanceMapping.toDomain(emeqmaintancedto);
        domain.setEquipid(emequip_id);
		emeqmaintanceService.create(domain);
        EMEQMaintanceDTO dto = emeqmaintanceMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMEQTypeEMEquip", tags = {"EMEQMaintance" },  notes = "createBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqmaintances/batch")
    public ResponseEntity<Boolean> createBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQMaintanceDTO> emeqmaintancedtos) {
        List<EMEQMaintance> domainlist=emeqmaintanceMapping.toDomain(emeqmaintancedtos);
        for(EMEQMaintance domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqmaintanceService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMEQTypeEMEquip", tags = {"EMEQMaintance" },  notes = "GetDraftByEMEQTypeEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqmaintances/getdraft")
    public ResponseEntity<EMEQMaintanceDTO> getDraftByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id) {
        EMEQMaintance domain = new EMEQMaintance();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqmaintanceMapping.toDto(emeqmaintanceService.getDraft(domain)));
    }

	@ApiOperation(value = "fetchDEFAULTByEMEQTypeEMEquip", tags = {"EMEQMaintance" } ,notes = "fetchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqmaintances/fetchdefault")
	public ResponseEntity<List<EMEQMaintanceDTO>> fetchEMEQMaintanceDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id,EMEQMaintanceSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQMaintance> domains = emeqmaintanceService.searchDefault(context) ;
        List<EMEQMaintanceDTO> list = emeqmaintanceMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMEQTypeEMEquip", tags = {"EMEQMaintance" } ,notes = "searchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqmaintances/searchdefault")
	public ResponseEntity<Page<EMEQMaintanceDTO>> searchEMEQMaintanceDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQMaintanceSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQMaintance> domains = emeqmaintanceService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqmaintanceMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "UpdateByPFTeamEMEquip", tags = {"EMEQMaintance" },  notes = "UpdateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqmaintances/{emeqmaintance_id}")
    @Transactional
    public ResponseEntity<EMEQMaintanceDTO> updateByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqmaintance_id") String emeqmaintance_id, @RequestBody EMEQMaintanceDTO emeqmaintancedto) {
        EMEQMaintance domain = emeqmaintanceMapping.toDomain(emeqmaintancedto);
        domain.setEquipid(emequip_id);
        domain.setEmeqmaintanceid(emeqmaintance_id);
		emeqmaintanceService.update(domain);
        EMEQMaintanceDTO dto = emeqmaintanceMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFTeamEMEquip", tags = {"EMEQMaintance" },  notes = "UpdateBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqmaintances/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQMaintanceDTO> emeqmaintancedtos) {
        List<EMEQMaintance> domainlist=emeqmaintanceMapping.toDomain(emeqmaintancedtos);
        for(EMEQMaintance domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqmaintanceService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByPFTeamEMEquip", tags = {"EMEQMaintance" },  notes = "CheckKeyByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqmaintances/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQMaintanceDTO emeqmaintancedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqmaintanceService.checkKey(emeqmaintanceMapping.toDomain(emeqmaintancedto)));
    }

    @ApiOperation(value = "GetByPFTeamEMEquip", tags = {"EMEQMaintance" },  notes = "GetByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqmaintances/{emeqmaintance_id}")
    public ResponseEntity<EMEQMaintanceDTO> getByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqmaintance_id") String emeqmaintance_id) {
        EMEQMaintance domain = emeqmaintanceService.get(emeqmaintance_id);
        EMEQMaintanceDTO dto = emeqmaintanceMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "RemoveByPFTeamEMEquip", tags = {"EMEQMaintance" },  notes = "RemoveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqmaintances/{emeqmaintance_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqmaintance_id") String emeqmaintance_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqmaintanceService.remove(emeqmaintance_id));
    }

    @ApiOperation(value = "RemoveBatchByPFTeamEMEquip", tags = {"EMEQMaintance" },  notes = "RemoveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqmaintances/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeamEMEquip(@RequestBody List<String> ids) {
        emeqmaintanceService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByPFTeamEMEquip", tags = {"EMEQMaintance" },  notes = "SaveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqmaintances/save")
    public ResponseEntity<Boolean> saveByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQMaintanceDTO emeqmaintancedto) {
        EMEQMaintance domain = emeqmaintanceMapping.toDomain(emeqmaintancedto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqmaintanceService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFTeamEMEquip", tags = {"EMEQMaintance" },  notes = "SaveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqmaintances/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQMaintanceDTO> emeqmaintancedtos) {
        List<EMEQMaintance> domainlist=emeqmaintanceMapping.toDomain(emeqmaintancedtos);
        for(EMEQMaintance domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emeqmaintanceService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByPFTeamEMEquip", tags = {"EMEQMaintance" },  notes = "CreateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqmaintances")
    @Transactional
    public ResponseEntity<EMEQMaintanceDTO> createByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQMaintanceDTO emeqmaintancedto) {
        EMEQMaintance domain = emeqmaintanceMapping.toDomain(emeqmaintancedto);
        domain.setEquipid(emequip_id);
		emeqmaintanceService.create(domain);
        EMEQMaintanceDTO dto = emeqmaintanceMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFTeamEMEquip", tags = {"EMEQMaintance" },  notes = "createBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqmaintances/batch")
    public ResponseEntity<Boolean> createBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQMaintanceDTO> emeqmaintancedtos) {
        List<EMEQMaintance> domainlist=emeqmaintanceMapping.toDomain(emeqmaintancedtos);
        for(EMEQMaintance domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqmaintanceService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFTeamEMEquip", tags = {"EMEQMaintance" },  notes = "GetDraftByPFTeamEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqmaintances/getdraft")
    public ResponseEntity<EMEQMaintanceDTO> getDraftByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id) {
        EMEQMaintance domain = new EMEQMaintance();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqmaintanceMapping.toDto(emeqmaintanceService.getDraft(domain)));
    }

	@ApiOperation(value = "fetchDEFAULTByPFTeamEMEquip", tags = {"EMEQMaintance" } ,notes = "fetchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqmaintances/fetchdefault")
	public ResponseEntity<List<EMEQMaintanceDTO>> fetchEMEQMaintanceDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id,EMEQMaintanceSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQMaintance> domains = emeqmaintanceService.searchDefault(context) ;
        List<EMEQMaintanceDTO> list = emeqmaintanceMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFTeamEMEquip", tags = {"EMEQMaintance" } ,notes = "searchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqmaintances/searchdefault")
	public ResponseEntity<Page<EMEQMaintanceDTO>> searchEMEQMaintanceDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQMaintanceSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQMaintance> domains = emeqmaintanceService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqmaintanceMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMEQMaintance getEntity(){
        return new EMEQMaintance();
    }

}
