package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEQLocation;
import cn.ibizlab.eam.core.eam_core.service.IEMEQLocationService;
import cn.ibizlab.eam.core.eam_core.filter.EMEQLocationSearchContext;




@Slf4j
@Api(tags = {"EMEQLocation" })
@RestController("WebApi-emeqlocation")
@RequestMapping("")
public class EMEQLocationResource {

    @Autowired
    private IEMEQLocationService emeqlocationService;

    @Autowired
    @Lazy
    private EMEQLocationMapping emeqlocationMapping;




    @PreAuthorize("hasPermission(#emeqlocation_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMEQLocation" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqlocations/{emeqlocation_id}")
    @Transactional
    public ResponseEntity<EMEQLocationDTO> update(@PathVariable("emeqlocation_id") String emeqlocation_id, @RequestBody EMEQLocationDTO emeqlocationdto) {
		EMEQLocation domain = emeqlocationMapping.toDomain(emeqlocationdto);
        domain.setEmeqlocationid(emeqlocation_id);
		emeqlocationService.update(domain);
		EMEQLocationDTO dto = emeqlocationMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emeqlocation_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEQLocation" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqlocations/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEQLocationDTO> emeqlocationdtos) {
        emeqlocationService.updateBatch(emeqlocationMapping.toDomain(emeqlocationdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeqlocation_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMEQLocation" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqlocations/{emeqlocation_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeqlocation_id") String emeqlocation_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeqlocationService.remove(emeqlocation_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMEQLocation" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqlocations/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeqlocationService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMEQLocation" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqlocations/getdraft")
    public ResponseEntity<EMEQLocationDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeqlocationMapping.toDto(emeqlocationService.getDraft(new EMEQLocation())));
    }




    @ApiOperation(value = "CheckKey", tags = {"EMEQLocation" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlocations/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEQLocationDTO emeqlocationdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqlocationService.checkKey(emeqlocationMapping.toDomain(emeqlocationdto)));
    }




    @ApiOperation(value = "Save", tags = {"EMEQLocation" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlocations/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEQLocationDTO emeqlocationdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeqlocationService.save(emeqlocationMapping.toDomain(emeqlocationdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMEQLocation" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlocations/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEQLocationDTO> emeqlocationdtos) {
        emeqlocationService.saveBatch(emeqlocationMapping.toDomain(emeqlocationdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMEQLocation" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlocations")
    @Transactional
    public ResponseEntity<EMEQLocationDTO> create(@RequestBody EMEQLocationDTO emeqlocationdto) {
        EMEQLocation domain = emeqlocationMapping.toDomain(emeqlocationdto);
		emeqlocationService.create(domain);
        EMEQLocationDTO dto = emeqlocationMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMEQLocation" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlocations/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEQLocationDTO> emeqlocationdtos) {
        emeqlocationService.createBatch(emeqlocationMapping.toDomain(emeqlocationdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeqlocation_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMEQLocation" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqlocations/{emeqlocation_id}")
    public ResponseEntity<EMEQLocationDTO> get(@PathVariable("emeqlocation_id") String emeqlocation_id) {
        EMEQLocation domain = emeqlocationService.get(emeqlocation_id);
        EMEQLocationDTO dto = emeqlocationMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQLocation-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEQLocation" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqlocations/fetchdefault")
	public ResponseEntity<List<EMEQLocationDTO>> fetchDefault(EMEQLocationSearchContext context) {
        Page<EMEQLocation> domains = emeqlocationService.searchDefault(context) ;
        List<EMEQLocationDTO> list = emeqlocationMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQLocation-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEQLocation" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqlocations/searchdefault")
	public ResponseEntity<Page<EMEQLocationDTO>> searchDefault(@RequestBody EMEQLocationSearchContext context) {
        Page<EMEQLocation> domains = emeqlocationService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqlocationMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMEQLocation getEntity(){
        return new EMEQLocation();
    }

}
