package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEQLCTFDJ;
import cn.ibizlab.eam.core.eam_core.service.IEMEQLCTFDJService;
import cn.ibizlab.eam.core.eam_core.filter.EMEQLCTFDJSearchContext;




@Slf4j
@Api(tags = {"EMEQLCTFDJ" })
@RestController("WebApi-emeqlctfdj")
@RequestMapping("")
public class EMEQLCTFDJResource {

    @Autowired
    private IEMEQLCTFDJService emeqlctfdjService;

    @Autowired
    @Lazy
    private EMEQLCTFDJMapping emeqlctfdjMapping;




    @PreAuthorize("hasPermission(#emeqlctfdj_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMEQLCTFDJ" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqlctfdjs/{emeqlctfdj_id}")
    public ResponseEntity<EMEQLCTFDJDTO> get(@PathVariable("emeqlctfdj_id") String emeqlctfdj_id) {
        EMEQLCTFDJ domain = emeqlctfdjService.get(emeqlctfdj_id);
        EMEQLCTFDJDTO dto = emeqlctfdjMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "Save", tags = {"EMEQLCTFDJ" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlctfdjs/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEQLCTFDJDTO emeqlctfdjdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeqlctfdjService.save(emeqlctfdjMapping.toDomain(emeqlctfdjdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMEQLCTFDJ" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlctfdjs/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEQLCTFDJDTO> emeqlctfdjdtos) {
        emeqlctfdjService.saveBatch(emeqlctfdjMapping.toDomain(emeqlctfdjdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeqlctfdj_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMEQLCTFDJ" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqlctfdjs/{emeqlctfdj_id}")
    @Transactional
    public ResponseEntity<EMEQLCTFDJDTO> update(@PathVariable("emeqlctfdj_id") String emeqlctfdj_id, @RequestBody EMEQLCTFDJDTO emeqlctfdjdto) {
		EMEQLCTFDJ domain = emeqlctfdjMapping.toDomain(emeqlctfdjdto);
        domain.setEmeqlocationid(emeqlctfdj_id);
		emeqlctfdjService.update(domain);
		EMEQLCTFDJDTO dto = emeqlctfdjMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emeqlctfdj_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEQLCTFDJ" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqlctfdjs/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEQLCTFDJDTO> emeqlctfdjdtos) {
        emeqlctfdjService.updateBatch(emeqlctfdjMapping.toDomain(emeqlctfdjdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMEQLCTFDJ" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlctfdjs")
    @Transactional
    public ResponseEntity<EMEQLCTFDJDTO> create(@RequestBody EMEQLCTFDJDTO emeqlctfdjdto) {
        EMEQLCTFDJ domain = emeqlctfdjMapping.toDomain(emeqlctfdjdto);
		emeqlctfdjService.create(domain);
        EMEQLCTFDJDTO dto = emeqlctfdjMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMEQLCTFDJ" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlctfdjs/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEQLCTFDJDTO> emeqlctfdjdtos) {
        emeqlctfdjService.createBatch(emeqlctfdjMapping.toDomain(emeqlctfdjdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeqlctfdj_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMEQLCTFDJ" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqlctfdjs/{emeqlctfdj_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeqlctfdj_id") String emeqlctfdj_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeqlctfdjService.remove(emeqlctfdj_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMEQLCTFDJ" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqlctfdjs/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeqlctfdjService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMEQLCTFDJ" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlctfdjs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEQLCTFDJDTO emeqlctfdjdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqlctfdjService.checkKey(emeqlctfdjMapping.toDomain(emeqlctfdjdto)));
    }




    @ApiOperation(value = "GetDraft", tags = {"EMEQLCTFDJ" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqlctfdjs/getdraft")
    public ResponseEntity<EMEQLCTFDJDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeqlctfdjMapping.toDto(emeqlctfdjService.getDraft(new EMEQLCTFDJ())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQLCTFDJ-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEQLCTFDJ" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqlctfdjs/fetchdefault")
	public ResponseEntity<List<EMEQLCTFDJDTO>> fetchDefault(EMEQLCTFDJSearchContext context) {
        Page<EMEQLCTFDJ> domains = emeqlctfdjService.searchDefault(context) ;
        List<EMEQLCTFDJDTO> list = emeqlctfdjMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQLCTFDJ-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEQLCTFDJ" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqlctfdjs/searchdefault")
	public ResponseEntity<Page<EMEQLCTFDJDTO>> searchDefault(@RequestBody EMEQLCTFDJSearchContext context) {
        Page<EMEQLCTFDJ> domains = emeqlctfdjService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqlctfdjMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMEQLCTFDJ getEntity(){
        return new EMEQLCTFDJ();
    }

}
