package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEQKPMap;
import cn.ibizlab.eam.core.eam_core.service.IEMEQKPMapService;
import cn.ibizlab.eam.core.eam_core.filter.EMEQKPMapSearchContext;




@Slf4j
@Api(tags = {"EMEQKPMap" })
@RestController("WebApi-emeqkpmap")
@RequestMapping("")
public class EMEQKPMapResource {

    @Autowired
    private IEMEQKPMapService emeqkpmapService;

    @Autowired
    @Lazy
    private EMEQKPMapMapping emeqkpmapMapping;




    @PreAuthorize("hasPermission(#emeqkpmap_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMEQKPMap" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqkpmaps/{emeqkpmap_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeqkpmap_id") String emeqkpmap_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeqkpmapService.remove(emeqkpmap_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMEQKPMap" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqkpmaps/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeqkpmapService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMEQKPMap" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqkpmaps/getdraft")
    public ResponseEntity<EMEQKPMapDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeqkpmapMapping.toDto(emeqkpmapService.getDraft(new EMEQKPMap())));
    }




    @PreAuthorize("hasPermission(#emeqkpmap_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMEQKPMap" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqkpmaps/{emeqkpmap_id}")
    @Transactional
    public ResponseEntity<EMEQKPMapDTO> update(@PathVariable("emeqkpmap_id") String emeqkpmap_id, @RequestBody EMEQKPMapDTO emeqkpmapdto) {
		EMEQKPMap domain = emeqkpmapMapping.toDomain(emeqkpmapdto);
        domain.setEmeqkpmapid(emeqkpmap_id);
		emeqkpmapService.update(domain);
		EMEQKPMapDTO dto = emeqkpmapMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emeqkpmap_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEQKPMap" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqkpmaps/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEQKPMapDTO> emeqkpmapdtos) {
        emeqkpmapService.updateBatch(emeqkpmapMapping.toDomain(emeqkpmapdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMEQKPMap" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqkpmaps")
    @Transactional
    public ResponseEntity<EMEQKPMapDTO> create(@RequestBody EMEQKPMapDTO emeqkpmapdto) {
        EMEQKPMap domain = emeqkpmapMapping.toDomain(emeqkpmapdto);
		emeqkpmapService.create(domain);
        EMEQKPMapDTO dto = emeqkpmapMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMEQKPMap" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqkpmaps/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEQKPMapDTO> emeqkpmapdtos) {
        emeqkpmapService.createBatch(emeqkpmapMapping.toDomain(emeqkpmapdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeqkpmap_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMEQKPMap" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqkpmaps/{emeqkpmap_id}")
    public ResponseEntity<EMEQKPMapDTO> get(@PathVariable("emeqkpmap_id") String emeqkpmap_id) {
        EMEQKPMap domain = emeqkpmapService.get(emeqkpmap_id);
        EMEQKPMapDTO dto = emeqkpmapMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMEQKPMap" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqkpmaps/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEQKPMapDTO emeqkpmapdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqkpmapService.checkKey(emeqkpmapMapping.toDomain(emeqkpmapdto)));
    }




    @ApiOperation(value = "Save", tags = {"EMEQKPMap" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqkpmaps/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEQKPMapDTO emeqkpmapdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeqkpmapService.save(emeqkpmapMapping.toDomain(emeqkpmapdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMEQKPMap" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqkpmaps/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEQKPMapDTO> emeqkpmapdtos) {
        emeqkpmapService.saveBatch(emeqkpmapMapping.toDomain(emeqkpmapdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQKPMap-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEQKPMap" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqkpmaps/fetchdefault")
	public ResponseEntity<List<EMEQKPMapDTO>> fetchDefault(EMEQKPMapSearchContext context) {
        Page<EMEQKPMap> domains = emeqkpmapService.searchDefault(context) ;
        List<EMEQKPMapDTO> list = emeqkpmapMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQKPMap-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEQKPMap" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqkpmaps/searchdefault")
	public ResponseEntity<Page<EMEQKPMapDTO>> searchDefault(@RequestBody EMEQKPMapSearchContext context) {
        Page<EMEQKPMap> domains = emeqkpmapService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqkpmapMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMEQKPMap getEntity(){
        return new EMEQKPMap();
    }

}
