package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEICellHist;
import cn.ibizlab.eam.core.eam_core.service.IEMEICellHistService;
import cn.ibizlab.eam.core.eam_core.filter.EMEICellHistSearchContext;




@Slf4j
@Api(tags = {"EMEICellHist" })
@RestController("WebApi-emeicellhist")
@RequestMapping("")
public class EMEICellHistResource {

    @Autowired
    private IEMEICellHistService emeicellhistService;

    @Autowired
    @Lazy
    private EMEICellHistMapping emeicellhistMapping;




    @ApiOperation(value = "CheckKey", tags = {"EMEICellHist" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicellhists/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEICellHistDTO emeicellhistdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeicellhistService.checkKey(emeicellhistMapping.toDomain(emeicellhistdto)));
    }




    @PreAuthorize("hasPermission(#emeicellhist_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMEICellHist" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeicellhists/{emeicellhist_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeicellhist_id") String emeicellhist_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeicellhistService.remove(emeicellhist_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMEICellHist" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeicellhists/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeicellhistService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeicellhist_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMEICellHist" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeicellhists/{emeicellhist_id}")
    public ResponseEntity<EMEICellHistDTO> get(@PathVariable("emeicellhist_id") String emeicellhist_id) {
        EMEICellHist domain = emeicellhistService.get(emeicellhist_id);
        EMEICellHistDTO dto = emeicellhistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "Save", tags = {"EMEICellHist" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicellhists/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEICellHistDTO emeicellhistdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeicellhistService.save(emeicellhistMapping.toDomain(emeicellhistdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMEICellHist" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicellhists/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEICellHistDTO> emeicellhistdtos) {
        emeicellhistService.saveBatch(emeicellhistMapping.toDomain(emeicellhistdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMEICellHist" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeicellhists/getdraft")
    public ResponseEntity<EMEICellHistDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeicellhistMapping.toDto(emeicellhistService.getDraft(new EMEICellHist())));
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMEICellHist" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicellhists")
    @Transactional
    public ResponseEntity<EMEICellHistDTO> create(@RequestBody EMEICellHistDTO emeicellhistdto) {
        EMEICellHist domain = emeicellhistMapping.toDomain(emeicellhistdto);
		emeicellhistService.create(domain);
        EMEICellHistDTO dto = emeicellhistMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMEICellHist" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicellhists/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEICellHistDTO> emeicellhistdtos) {
        emeicellhistService.createBatch(emeicellhistMapping.toDomain(emeicellhistdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeicellhist_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMEICellHist" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeicellhists/{emeicellhist_id}")
    @Transactional
    public ResponseEntity<EMEICellHistDTO> update(@PathVariable("emeicellhist_id") String emeicellhist_id, @RequestBody EMEICellHistDTO emeicellhistdto) {
		EMEICellHist domain = emeicellhistMapping.toDomain(emeicellhistdto);
        domain.setEmeicellhistid(emeicellhist_id);
		emeicellhistService.update(domain);
		EMEICellHistDTO dto = emeicellhistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emeicellhist_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEICellHist" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeicellhists/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEICellHistDTO> emeicellhistdtos) {
        emeicellhistService.updateBatch(emeicellhistMapping.toDomain(emeicellhistdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEICellHist-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEICellHist" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeicellhists/fetchdefault")
	public ResponseEntity<List<EMEICellHistDTO>> fetchDefault(EMEICellHistSearchContext context) {
        Page<EMEICellHist> domains = emeicellhistService.searchDefault(context) ;
        List<EMEICellHistDTO> list = emeicellhistMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEICellHist-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEICellHist" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeicellhists/searchdefault")
	public ResponseEntity<Page<EMEICellHistDTO>> searchDefault(@RequestBody EMEICellHistSearchContext context) {
        Page<EMEICellHist> domains = emeicellhistService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeicellhistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMEICellHist getEntity(){
        return new EMEICellHist();
    }

}
