package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEICamSetup;
import cn.ibizlab.eam.core.eam_core.service.IEMEICamSetupService;
import cn.ibizlab.eam.core.eam_core.filter.EMEICamSetupSearchContext;




@Slf4j
@Api(tags = {"EMEICamSetup" })
@RestController("WebApi-emeicamsetup")
@RequestMapping("")
public class EMEICamSetupResource {

    @Autowired
    private IEMEICamSetupService emeicamsetupService;

    @Autowired
    @Lazy
    private EMEICamSetupMapping emeicamsetupMapping;




    @PreAuthorize("hasPermission(#emeicamsetup_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMEICamSetup" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeicamsetups/{emeicamsetup_id}")
    @Transactional
    public ResponseEntity<EMEICamSetupDTO> update(@PathVariable("emeicamsetup_id") String emeicamsetup_id, @RequestBody EMEICamSetupDTO emeicamsetupdto) {
		EMEICamSetup domain = emeicamsetupMapping.toDomain(emeicamsetupdto);
        domain.setEmeicamsetupid(emeicamsetup_id);
		emeicamsetupService.update(domain);
		EMEICamSetupDTO dto = emeicamsetupMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emeicamsetup_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEICamSetup" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeicamsetups/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEICamSetupDTO> emeicamsetupdtos) {
        emeicamsetupService.updateBatch(emeicamsetupMapping.toDomain(emeicamsetupdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMEICamSetup" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicamsetups/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEICamSetupDTO emeicamsetupdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeicamsetupService.save(emeicamsetupMapping.toDomain(emeicamsetupdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMEICamSetup" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicamsetups/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEICamSetupDTO> emeicamsetupdtos) {
        emeicamsetupService.saveBatch(emeicamsetupMapping.toDomain(emeicamsetupdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMEICamSetup" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicamsetups")
    @Transactional
    public ResponseEntity<EMEICamSetupDTO> create(@RequestBody EMEICamSetupDTO emeicamsetupdto) {
        EMEICamSetup domain = emeicamsetupMapping.toDomain(emeicamsetupdto);
		emeicamsetupService.create(domain);
        EMEICamSetupDTO dto = emeicamsetupMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMEICamSetup" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicamsetups/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEICamSetupDTO> emeicamsetupdtos) {
        emeicamsetupService.createBatch(emeicamsetupMapping.toDomain(emeicamsetupdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeicamsetup_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMEICamSetup" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeicamsetups/{emeicamsetup_id}")
    public ResponseEntity<EMEICamSetupDTO> get(@PathVariable("emeicamsetup_id") String emeicamsetup_id) {
        EMEICamSetup domain = emeicamsetupService.get(emeicamsetup_id);
        EMEICamSetupDTO dto = emeicamsetupMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMEICamSetup" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicamsetups/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEICamSetupDTO emeicamsetupdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeicamsetupService.checkKey(emeicamsetupMapping.toDomain(emeicamsetupdto)));
    }




    @PreAuthorize("hasPermission(#emeicamsetup_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMEICamSetup" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeicamsetups/{emeicamsetup_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeicamsetup_id") String emeicamsetup_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeicamsetupService.remove(emeicamsetup_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMEICamSetup" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeicamsetups/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeicamsetupService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMEICamSetup" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeicamsetups/getdraft")
    public ResponseEntity<EMEICamSetupDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeicamsetupMapping.toDto(emeicamsetupService.getDraft(new EMEICamSetup())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEICamSetup-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEICamSetup" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeicamsetups/fetchdefault")
	public ResponseEntity<List<EMEICamSetupDTO>> fetchDefault(EMEICamSetupSearchContext context) {
        Page<EMEICamSetup> domains = emeicamsetupService.searchDefault(context) ;
        List<EMEICamSetupDTO> list = emeicamsetupMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEICamSetup-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEICamSetup" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeicamsetups/searchdefault")
	public ResponseEntity<Page<EMEICamSetupDTO>> searchDefault(@RequestBody EMEICamSetupSearchContext context) {
        Page<EMEICamSetup> domains = emeicamsetupService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeicamsetupMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMEICamSetup getEntity(){
        return new EMEICamSetup();
    }

}
