package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEICamHist;
import cn.ibizlab.eam.core.eam_core.service.IEMEICamHistService;
import cn.ibizlab.eam.core.eam_core.filter.EMEICamHistSearchContext;




@Slf4j
@Api(tags = {"EMEICamHist" })
@RestController("WebApi-emeicamhist")
@RequestMapping("")
public class EMEICamHistResource {

    @Autowired
    private IEMEICamHistService emeicamhistService;

    @Autowired
    @Lazy
    private EMEICamHistMapping emeicamhistMapping;




    @ApiOperation(value = "Save", tags = {"EMEICamHist" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicamhists/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEICamHistDTO emeicamhistdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeicamhistService.save(emeicamhistMapping.toDomain(emeicamhistdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMEICamHist" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicamhists/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEICamHistDTO> emeicamhistdtos) {
        emeicamhistService.saveBatch(emeicamhistMapping.toDomain(emeicamhistdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMEICamHist" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeicamhists/getdraft")
    public ResponseEntity<EMEICamHistDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeicamhistMapping.toDto(emeicamhistService.getDraft(new EMEICamHist())));
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMEICamHist" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicamhists")
    @Transactional
    public ResponseEntity<EMEICamHistDTO> create(@RequestBody EMEICamHistDTO emeicamhistdto) {
        EMEICamHist domain = emeicamhistMapping.toDomain(emeicamhistdto);
		emeicamhistService.create(domain);
        EMEICamHistDTO dto = emeicamhistMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMEICamHist" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicamhists/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEICamHistDTO> emeicamhistdtos) {
        emeicamhistService.createBatch(emeicamhistMapping.toDomain(emeicamhistdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeicamhist_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMEICamHist" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeicamhists/{emeicamhist_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeicamhist_id") String emeicamhist_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeicamhistService.remove(emeicamhist_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMEICamHist" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeicamhists/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeicamhistService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeicamhist_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMEICamHist" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeicamhists/{emeicamhist_id}")
    public ResponseEntity<EMEICamHistDTO> get(@PathVariable("emeicamhist_id") String emeicamhist_id) {
        EMEICamHist domain = emeicamhistService.get(emeicamhist_id);
        EMEICamHistDTO dto = emeicamhistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMEICamHist" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicamhists/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEICamHistDTO emeicamhistdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeicamhistService.checkKey(emeicamhistMapping.toDomain(emeicamhistdto)));
    }




    @PreAuthorize("hasPermission(#emeicamhist_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMEICamHist" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeicamhists/{emeicamhist_id}")
    @Transactional
    public ResponseEntity<EMEICamHistDTO> update(@PathVariable("emeicamhist_id") String emeicamhist_id, @RequestBody EMEICamHistDTO emeicamhistdto) {
		EMEICamHist domain = emeicamhistMapping.toDomain(emeicamhistdto);
        domain.setEmeicamhistid(emeicamhist_id);
		emeicamhistService.update(domain);
		EMEICamHistDTO dto = emeicamhistMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emeicamhist_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEICamHist" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeicamhists/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEICamHistDTO> emeicamhistdtos) {
        emeicamhistService.updateBatch(emeicamhistMapping.toDomain(emeicamhistdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEICamHist-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEICamHist" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeicamhists/fetchdefault")
	public ResponseEntity<List<EMEICamHistDTO>> fetchDefault(EMEICamHistSearchContext context) {
        Page<EMEICamHist> domains = emeicamhistService.searchDefault(context) ;
        List<EMEICamHistDTO> list = emeicamhistMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEICamHist-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEICamHist" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeicamhists/searchdefault")
	public ResponseEntity<Page<EMEICamHistDTO>> searchDefault(@RequestBody EMEICamHistSearchContext context) {
        Page<EMEICamHist> domains = emeicamhistService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeicamhistMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMEICamHist getEntity(){
        return new EMEICamHist();
    }

}
