package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEIBattery;
import cn.ibizlab.eam.core.eam_core.service.IEMEIBatteryService;
import cn.ibizlab.eam.core.eam_core.filter.EMEIBatterySearchContext;




@Slf4j
@Api(tags = {"EMEIBattery" })
@RestController("WebApi-emeibattery")
@RequestMapping("")
public class EMEIBatteryResource {

    @Autowired
    private IEMEIBatteryService emeibatteryService;

    @Autowired
    @Lazy
    private EMEIBatteryMapping emeibatteryMapping;




    @PreAuthorize("hasPermission(#emeibattery_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMEIBattery" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeibatteries/{emeibattery_id}")
    public ResponseEntity<EMEIBatteryDTO> get(@PathVariable("emeibattery_id") String emeibattery_id) {
        EMEIBattery domain = emeibatteryService.get(emeibattery_id);
        EMEIBatteryDTO dto = emeibatteryMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "Save", tags = {"EMEIBattery" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeibatteries/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEIBatteryDTO emeibatterydto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeibatteryService.save(emeibatteryMapping.toDomain(emeibatterydto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMEIBattery" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeibatteries/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEIBatteryDTO> emeibatterydtos) {
        emeibatteryService.saveBatch(emeibatteryMapping.toDomain(emeibatterydtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMEIBattery" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeibatteries/getdraft")
    public ResponseEntity<EMEIBatteryDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeibatteryMapping.toDto(emeibatteryService.getDraft(new EMEIBattery())));
    }




    @PreAuthorize("hasPermission(#emeibattery_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMEIBattery" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeibatteries/{emeibattery_id}")
    @Transactional
    public ResponseEntity<EMEIBatteryDTO> update(@PathVariable("emeibattery_id") String emeibattery_id, @RequestBody EMEIBatteryDTO emeibatterydto) {
		EMEIBattery domain = emeibatteryMapping.toDomain(emeibatterydto);
        domain.setEmeibatteryid(emeibattery_id);
		emeibatteryService.update(domain);
		EMEIBatteryDTO dto = emeibatteryMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emeibattery_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEIBattery" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeibatteries/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEIBatteryDTO> emeibatterydtos) {
        emeibatteryService.updateBatch(emeibatteryMapping.toDomain(emeibatterydtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMEIBattery" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeibatteries/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEIBatteryDTO emeibatterydto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeibatteryService.checkKey(emeibatteryMapping.toDomain(emeibatterydto)));
    }




    @PreAuthorize("hasPermission(#emeibattery_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMEIBattery" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeibatteries/{emeibattery_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeibattery_id") String emeibattery_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeibatteryService.remove(emeibattery_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMEIBattery" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeibatteries/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeibatteryService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMEIBattery" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeibatteries")
    @Transactional
    public ResponseEntity<EMEIBatteryDTO> create(@RequestBody EMEIBatteryDTO emeibatterydto) {
        EMEIBattery domain = emeibatteryMapping.toDomain(emeibatterydto);
		emeibatteryService.create(domain);
        EMEIBatteryDTO dto = emeibatteryMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMEIBattery" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeibatteries/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEIBatteryDTO> emeibatterydtos) {
        emeibatteryService.createBatch(emeibatteryMapping.toDomain(emeibatterydtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEIBattery-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEIBattery" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeibatteries/fetchdefault")
	public ResponseEntity<List<EMEIBatteryDTO>> fetchDefault(EMEIBatterySearchContext context) {
        Page<EMEIBattery> domains = emeibatteryService.searchDefault(context) ;
        List<EMEIBatteryDTO> list = emeibatteryMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEIBattery-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEIBattery" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeibatteries/searchdefault")
	public ResponseEntity<Page<EMEIBatteryDTO>> searchDefault(@RequestBody EMEIBatterySearchContext context) {
        Page<EMEIBattery> domains = emeibatteryService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeibatteryMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMEIBattery getEntity(){
        return new EMEIBattery();
    }

}
