package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMDPRCT;
import cn.ibizlab.eam.core.eam_core.service.IEMDPRCTService;
import cn.ibizlab.eam.core.eam_core.filter.EMDPRCTSearchContext;




@Slf4j
@Api(tags = {"EMDPRCT" })
@RestController("WebApi-emdprct")
@RequestMapping("")
public class EMDPRCTResource {

    @Autowired
    private IEMDPRCTService emdprctService;

    @Autowired
    @Lazy
    private EMDPRCTMapping emdprctMapping;




    @ApiOperation(value = "CheckKey", tags = {"EMDPRCT" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emdprcts/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMDPRCTDTO emdprctdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emdprctService.checkKey(emdprctMapping.toDomain(emdprctdto)));
    }




    @ApiOperation(value = "GetDraft", tags = {"EMDPRCT" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emdprcts/getdraft")
    public ResponseEntity<EMDPRCTDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emdprctMapping.toDto(emdprctService.getDraft(new EMDPRCT())));
    }




    @PreAuthorize("hasPermission(#emdprct_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMDPRCT" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emdprcts/{emdprct_id}")
    @Transactional
    public ResponseEntity<EMDPRCTDTO> update(@PathVariable("emdprct_id") String emdprct_id, @RequestBody EMDPRCTDTO emdprctdto) {
		EMDPRCT domain = emdprctMapping.toDomain(emdprctdto);
        domain.setEmdprctid(emdprct_id);
		emdprctService.update(domain);
		EMDPRCTDTO dto = emdprctMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emdprct_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMDPRCT" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emdprcts/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMDPRCTDTO> emdprctdtos) {
        emdprctService.updateBatch(emdprctMapping.toDomain(emdprctdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMDPRCT" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emdprcts")
    @Transactional
    public ResponseEntity<EMDPRCTDTO> create(@RequestBody EMDPRCTDTO emdprctdto) {
        EMDPRCT domain = emdprctMapping.toDomain(emdprctdto);
		emdprctService.create(domain);
        EMDPRCTDTO dto = emdprctMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMDPRCT" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emdprcts/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMDPRCTDTO> emdprctdtos) {
        emdprctService.createBatch(emdprctMapping.toDomain(emdprctdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emdprct_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMDPRCT" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emdprcts/{emdprct_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emdprct_id") String emdprct_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emdprctService.remove(emdprct_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMDPRCT" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emdprcts/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emdprctService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMDPRCT" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emdprcts/save")
    public ResponseEntity<Boolean> save(@RequestBody EMDPRCTDTO emdprctdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emdprctService.save(emdprctMapping.toDomain(emdprctdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMDPRCT" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emdprcts/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMDPRCTDTO> emdprctdtos) {
        emdprctService.saveBatch(emdprctMapping.toDomain(emdprctdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emdprct_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMDPRCT" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emdprcts/{emdprct_id}")
    public ResponseEntity<EMDPRCTDTO> get(@PathVariable("emdprct_id") String emdprct_id) {
        EMDPRCT domain = emdprctService.get(emdprct_id);
        EMDPRCTDTO dto = emdprctMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMDPRCT-IndexDER-all')")
	@ApiOperation(value = "fetchIndexDER", tags = {"EMDPRCT" } ,notes = "fetchIndexDER")
    @RequestMapping(method= RequestMethod.GET , value="/emdprcts/fetchindexder")
	public ResponseEntity<List<EMDPRCTDTO>> fetchIndexDER(EMDPRCTSearchContext context) {
        Page<EMDPRCT> domains = emdprctService.searchIndexDER(context) ;
        List<EMDPRCTDTO> list = emdprctMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMDPRCT-IndexDER-all')")
	@ApiOperation(value = "searchIndexDER", tags = {"EMDPRCT" } ,notes = "searchIndexDER")
    @RequestMapping(method= RequestMethod.POST , value="/emdprcts/searchindexder")
	public ResponseEntity<Page<EMDPRCTDTO>> searchIndexDER(@RequestBody EMDPRCTSearchContext context) {
        Page<EMDPRCT> domains = emdprctService.searchIndexDER(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emdprctMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMDPRCT-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMDPRCT" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emdprcts/fetchdefault")
	public ResponseEntity<List<EMDPRCTDTO>> fetchDefault(EMDPRCTSearchContext context) {
        Page<EMDPRCT> domains = emdprctService.searchDefault(context) ;
        List<EMDPRCTDTO> list = emdprctMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMDPRCT-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMDPRCT" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emdprcts/searchdefault")
	public ResponseEntity<Page<EMDPRCTDTO>> searchDefault(@RequestBody EMDPRCTSearchContext context) {
        Page<EMDPRCT> domains = emdprctService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emdprctMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMDPRCT getEntity(){
        return new EMDPRCT();
    }

}
