package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMCab;
import cn.ibizlab.eam.core.eam_core.service.IEMCabService;
import cn.ibizlab.eam.core.eam_core.filter.EMCabSearchContext;




@Slf4j
@Api(tags = {"EMCab" })
@RestController("WebApi-emcab")
@RequestMapping("")
public class EMCabResource {

    @Autowired
    private IEMCabService emcabService;

    @Autowired
    @Lazy
    private EMCabMapping emcabMapping;




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMCab" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emcabs")
    @Transactional
    public ResponseEntity<EMCabDTO> create(@RequestBody EMCabDTO emcabdto) {
        EMCab domain = emcabMapping.toDomain(emcabdto);
		emcabService.create(domain);
        EMCabDTO dto = emcabMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMCab" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emcabs/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMCabDTO> emcabdtos) {
        emcabService.createBatch(emcabMapping.toDomain(emcabdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMCab" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emcabs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMCabDTO emcabdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emcabService.checkKey(emcabMapping.toDomain(emcabdto)));
    }




    @ApiOperation(value = "GetDraft", tags = {"EMCab" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emcabs/getdraft")
    public ResponseEntity<EMCabDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emcabMapping.toDto(emcabService.getDraft(new EMCab())));
    }




    @PreAuthorize("hasPermission(#emcab_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMCab" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emcabs/{emcab_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emcab_id") String emcab_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emcabService.remove(emcab_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMCab" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emcabs/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emcabService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMCab" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emcabs/save")
    public ResponseEntity<Boolean> save(@RequestBody EMCabDTO emcabdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emcabService.save(emcabMapping.toDomain(emcabdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMCab" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emcabs/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMCabDTO> emcabdtos) {
        emcabService.saveBatch(emcabMapping.toDomain(emcabdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emcab_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMCab" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emcabs/{emcab_id}")
    public ResponseEntity<EMCabDTO> get(@PathVariable("emcab_id") String emcab_id) {
        EMCab domain = emcabService.get(emcab_id);
        EMCabDTO dto = emcabMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @PreAuthorize("hasPermission(#emcab_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMCab" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emcabs/{emcab_id}")
    @Transactional
    public ResponseEntity<EMCabDTO> update(@PathVariable("emcab_id") String emcab_id, @RequestBody EMCabDTO emcabdto) {
		EMCab domain = emcabMapping.toDomain(emcabdto);
        domain.setEmcabid(emcab_id);
		emcabService.update(domain);
		EMCabDTO dto = emcabMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emcab_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMCab" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emcabs/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMCabDTO> emcabdtos) {
        emcabService.updateBatch(emcabMapping.toDomain(emcabdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMCab-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMCab" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emcabs/fetchdefault")
	public ResponseEntity<List<EMCabDTO>> fetchDefault(EMCabSearchContext context) {
        Page<EMCab> domains = emcabService.searchDefault(context) ;
        List<EMCabDTO> list = emcabMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMCab-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMCab" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emcabs/searchdefault")
	public ResponseEntity<Page<EMCabDTO>> searchDefault(@RequestBody EMCabSearchContext context) {
        Page<EMCab> domains = emcabService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emcabMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMCab getEntity(){
        return new EMCab();
    }

}
