package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMAsset;
import cn.ibizlab.eam.core.eam_core.service.IEMAssetService;
import cn.ibizlab.eam.core.eam_core.filter.EMAssetSearchContext;




@Slf4j
@Api(tags = {"EMAsset" })
@RestController("WebApi-emasset")
@RequestMapping("")
public class EMAssetResource {

    @Autowired
    private IEMAssetService emassetService;

    @Autowired
    @Lazy
    private EMAssetMapping emassetMapping;




    @PreAuthorize("hasPermission(#emasset_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMAsset" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emassets/{emasset_id}")
    public ResponseEntity<EMAssetDTO> get(@PathVariable("emasset_id") String emasset_id) {
        EMAsset domain = emassetService.get(emasset_id);
        EMAssetDTO dto = emassetMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "Save", tags = {"EMAsset" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emassets/save")
    public ResponseEntity<Boolean> save(@RequestBody EMAssetDTO emassetdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emassetService.save(emassetMapping.toDomain(emassetdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMAsset" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emassets/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMAssetDTO> emassetdtos) {
        emassetService.saveBatch(emassetMapping.toDomain(emassetdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emasset_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMAsset" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emassets/{emasset_id}")
    @Transactional
    public ResponseEntity<EMAssetDTO> update(@PathVariable("emasset_id") String emasset_id, @RequestBody EMAssetDTO emassetdto) {
		EMAsset domain = emassetMapping.toDomain(emassetdto);
        domain.setEmassetid(emasset_id);
		emassetService.update(domain);
		EMAssetDTO dto = emassetMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emasset_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMAsset" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emassets/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMAssetDTO> emassetdtos) {
        emassetService.updateBatch(emassetMapping.toDomain(emassetdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMAsset" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emassets")
    @Transactional
    public ResponseEntity<EMAssetDTO> create(@RequestBody EMAssetDTO emassetdto) {
        EMAsset domain = emassetMapping.toDomain(emassetdto);
		emassetService.create(domain);
        EMAssetDTO dto = emassetMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMAsset" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emassets/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMAssetDTO> emassetdtos) {
        emassetService.createBatch(emassetMapping.toDomain(emassetdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emasset_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMAsset" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emassets/{emasset_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emasset_id") String emasset_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emassetService.remove(emasset_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMAsset" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emassets/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emassetService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMAsset" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emassets/getdraft")
    public ResponseEntity<EMAssetDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emassetMapping.toDto(emassetService.getDraft(new EMAsset())));
    }




    @ApiOperation(value = "CheckKey", tags = {"EMAsset" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emassets/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMAssetDTO emassetdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emassetService.checkKey(emassetMapping.toDomain(emassetdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMAsset-AssetBf-all')")
	@ApiOperation(value = "fetch报废资产", tags = {"EMAsset" } ,notes = "fetch报废资产")
    @RequestMapping(method= RequestMethod.GET , value="/emassets/fetchassetbf")
	public ResponseEntity<List<EMAssetDTO>> fetchAssetBf(EMAssetSearchContext context) {
        Page<EMAsset> domains = emassetService.searchAssetBf(context) ;
        List<EMAssetDTO> list = emassetMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMAsset-AssetBf-all')")
	@ApiOperation(value = "search报废资产", tags = {"EMAsset" } ,notes = "search报废资产")
    @RequestMapping(method= RequestMethod.POST , value="/emassets/searchassetbf")
	public ResponseEntity<Page<EMAssetDTO>> searchAssetBf(@RequestBody EMAssetSearchContext context) {
        Page<EMAsset> domains = emassetService.searchAssetBf(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emassetMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMAsset-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMAsset" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emassets/fetchdefault")
	public ResponseEntity<List<EMAssetDTO>> fetchDefault(EMAssetSearchContext context) {
        Page<EMAsset> domains = emassetService.searchDefault(context) ;
        List<EMAssetDTO> list = emassetMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMAsset-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMAsset" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emassets/searchdefault")
	public ResponseEntity<Page<EMAssetDTO>> searchDefault(@RequestBody EMAssetSearchContext context) {
        Page<EMAsset> domains = emassetService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emassetMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMAsset getEntity(){
        return new EMAsset();
    }

}
