package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMWork;
import cn.ibizlab.eam.core.eam_core.service.IEMWorkService;
import cn.ibizlab.eam.core.eam_core.filter.EMWorkSearchContext;




@Slf4j
@Api(tags = {"EMWork" })
@RestController("WebApi-emwork")
@RequestMapping("")
public class EMWorkResource {

    @Autowired
    private IEMWorkService emworkService;

    @Autowired
    @Lazy
    private EMWorkMapping emworkMapping;




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMWork" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emworks")
    @Transactional
    public ResponseEntity<EMWorkDTO> create(@RequestBody EMWorkDTO emworkdto) {
        EMWork domain = emworkMapping.toDomain(emworkdto);
		emworkService.create(domain);
        EMWorkDTO dto = emworkMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMWork" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emworks/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMWorkDTO> emworkdtos) {
        emworkService.createBatch(emworkMapping.toDomain(emworkdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMWork" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emworks/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMWorkDTO emworkdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emworkService.checkKey(emworkMapping.toDomain(emworkdto)));
    }




    @PreAuthorize("hasPermission(#emwork_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMWork" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emworks/{emwork_id}")
    public ResponseEntity<EMWorkDTO> get(@PathVariable("emwork_id") String emwork_id) {
        EMWork domain = emworkService.get(emwork_id);
        EMWorkDTO dto = emworkMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMWork" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emworks/getdraft")
    public ResponseEntity<EMWorkDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emworkMapping.toDto(emworkService.getDraft(new EMWork())));
    }




    @PreAuthorize("hasPermission(#emwork_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMWork" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emworks/{emwork_id}")
    @Transactional
    public ResponseEntity<EMWorkDTO> update(@PathVariable("emwork_id") String emwork_id, @RequestBody EMWorkDTO emworkdto) {
		EMWork domain = emworkMapping.toDomain(emworkdto);
        domain.setEmworkid(emwork_id);
		emworkService.update(domain);
		EMWorkDTO dto = emworkMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emwork_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMWork" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emworks/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMWorkDTO> emworkdtos) {
        emworkService.updateBatch(emworkMapping.toDomain(emworkdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMWork" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emworks/save")
    public ResponseEntity<Boolean> save(@RequestBody EMWorkDTO emworkdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emworkService.save(emworkMapping.toDomain(emworkdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMWork" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emworks/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMWorkDTO> emworkdtos) {
        emworkService.saveBatch(emworkMapping.toDomain(emworkdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emwork_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMWork" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emworks/{emwork_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emwork_id") String emwork_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emworkService.remove(emwork_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMWork" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emworks/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emworkService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWork-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMWork" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emworks/fetchdefault")
	public ResponseEntity<List<EMWorkDTO>> fetchDefault(EMWorkSearchContext context) {
        Page<EMWork> domains = emworkService.searchDefault(context) ;
        List<EMWorkDTO> list = emworkMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWork-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMWork" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emworks/searchdefault")
	public ResponseEntity<Page<EMWorkDTO>> searchDefault(@RequestBody EMWorkSearchContext context) {
        Page<EMWork> domains = emworkService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emworkMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMWork getEntity(){
        return new EMWork();
    }

}
