package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMWO_OSC;
import cn.ibizlab.eam.core.eam_core.service.IEMWO_OSCService;
import cn.ibizlab.eam.core.eam_core.filter.EMWO_OSCSearchContext;




@Slf4j
@Api(tags = {"EMWO_OSC" })
@RestController("WebApi-emwo_osc")
@RequestMapping("")
public class EMWO_OSCResource {

    @Autowired
    private IEMWO_OSCService emwo_oscService;

    @Autowired
    @Lazy
    private EMWO_OSCMapping emwo_oscMapping;




    @ApiOperation(value = "GetDraft", tags = {"EMWO_OSC" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emwo_oscs/getdraft")
    public ResponseEntity<EMWO_OSCDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emwo_oscMapping.toDto(emwo_oscService.getDraft(new EMWO_OSC())));
    }




    @PreAuthorize("hasPermission(#emwo_osc_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMWO_OSC" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emwo_oscs/{emwo_osc_id}")
    @Transactional
    public ResponseEntity<EMWO_OSCDTO> update(@PathVariable("emwo_osc_id") String emwo_osc_id, @RequestBody EMWO_OSCDTO emwo_oscdto) {
		EMWO_OSC domain = emwo_oscMapping.toDomain(emwo_oscdto);
        domain.setEmwoOscid(emwo_osc_id);
		emwo_oscService.update(domain);
		EMWO_OSCDTO dto = emwo_oscMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emwo_osc_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMWO_OSC" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emwo_oscs/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMWO_OSCDTO> emwo_oscdtos) {
        emwo_oscService.updateBatch(emwo_oscMapping.toDomain(emwo_oscdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMWO_OSC" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_oscs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMWO_OSCDTO emwo_oscdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_oscService.checkKey(emwo_oscMapping.toDomain(emwo_oscdto)));
    }




    @PreAuthorize("hasPermission(#emwo_osc_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMWO_OSC" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emwo_oscs/{emwo_osc_id}")
    public ResponseEntity<EMWO_OSCDTO> get(@PathVariable("emwo_osc_id") String emwo_osc_id) {
        EMWO_OSC domain = emwo_oscService.get(emwo_osc_id);
        EMWO_OSCDTO dto = emwo_oscMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMWO_OSC" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_oscs")
    @Transactional
    public ResponseEntity<EMWO_OSCDTO> create(@RequestBody EMWO_OSCDTO emwo_oscdto) {
        EMWO_OSC domain = emwo_oscMapping.toDomain(emwo_oscdto);
		emwo_oscService.create(domain);
        EMWO_OSCDTO dto = emwo_oscMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMWO_OSC" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_oscs/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMWO_OSCDTO> emwo_oscdtos) {
        emwo_oscService.createBatch(emwo_oscMapping.toDomain(emwo_oscdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMWO_OSC" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_oscs/save")
    public ResponseEntity<Boolean> save(@RequestBody EMWO_OSCDTO emwo_oscdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emwo_oscService.save(emwo_oscMapping.toDomain(emwo_oscdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMWO_OSC" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_oscs/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMWO_OSCDTO> emwo_oscdtos) {
        emwo_oscService.saveBatch(emwo_oscMapping.toDomain(emwo_oscdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emwo_osc_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMWO_OSC" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emwo_oscs/{emwo_osc_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emwo_osc_id") String emwo_osc_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emwo_oscService.remove(emwo_osc_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMWO_OSC" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emwo_oscs/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emwo_oscService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_OSC-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMWO_OSC" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emwo_oscs/fetchdefault")
	public ResponseEntity<List<EMWO_OSCDTO>> fetchDefault(EMWO_OSCSearchContext context) {
        Page<EMWO_OSC> domains = emwo_oscService.searchDefault(context) ;
        List<EMWO_OSCDTO> list = emwo_oscMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_OSC-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMWO_OSC" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emwo_oscs/searchdefault")
	public ResponseEntity<Page<EMWO_OSCDTO>> searchDefault(@RequestBody EMWO_OSCSearchContext context) {
        Page<EMWO_OSC> domains = emwo_oscService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_oscMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "GetDraftByEMEquip", tags = {"EMWO_OSC" },  notes = "GetDraftByEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emwo_oscs/getdraft")
    public ResponseEntity<EMWO_OSCDTO> getDraftByEMEquip(@PathVariable("emequip_id") String emequip_id) {
        EMWO_OSC domain = new EMWO_OSC();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_oscMapping.toDto(emwo_oscService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByEMEquip", tags = {"EMWO_OSC" },  notes = "UpdateByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emwo_oscs/{emwo_osc_id}")
    @Transactional
    public ResponseEntity<EMWO_OSCDTO> updateByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_osc_id") String emwo_osc_id, @RequestBody EMWO_OSCDTO emwo_oscdto) {
        EMWO_OSC domain = emwo_oscMapping.toDomain(emwo_oscdto);
        domain.setEquipid(emequip_id);
        domain.setEmwoOscid(emwo_osc_id);
		emwo_oscService.update(domain);
        EMWO_OSCDTO dto = emwo_oscMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMEquip", tags = {"EMWO_OSC" },  notes = "UpdateBatchByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emwo_oscs/batch")
    public ResponseEntity<Boolean> updateBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_OSCDTO> emwo_oscdtos) {
        List<EMWO_OSC> domainlist=emwo_oscMapping.toDomain(emwo_oscdtos);
        for(EMWO_OSC domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_oscService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMEquip", tags = {"EMWO_OSC" },  notes = "CheckKeyByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_oscs/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_OSCDTO emwo_oscdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_oscService.checkKey(emwo_oscMapping.toDomain(emwo_oscdto)));
    }

    @ApiOperation(value = "GetByEMEquip", tags = {"EMWO_OSC" },  notes = "GetByEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emwo_oscs/{emwo_osc_id}")
    public ResponseEntity<EMWO_OSCDTO> getByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_osc_id") String emwo_osc_id) {
        EMWO_OSC domain = emwo_oscService.get(emwo_osc_id);
        EMWO_OSCDTO dto = emwo_oscMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CreateByEMEquip", tags = {"EMWO_OSC" },  notes = "CreateByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_oscs")
    @Transactional
    public ResponseEntity<EMWO_OSCDTO> createByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_OSCDTO emwo_oscdto) {
        EMWO_OSC domain = emwo_oscMapping.toDomain(emwo_oscdto);
        domain.setEquipid(emequip_id);
		emwo_oscService.create(domain);
        EMWO_OSCDTO dto = emwo_oscMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMEquip", tags = {"EMWO_OSC" },  notes = "createBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_oscs/batch")
    public ResponseEntity<Boolean> createBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_OSCDTO> emwo_oscdtos) {
        List<EMWO_OSC> domainlist=emwo_oscMapping.toDomain(emwo_oscdtos);
        for(EMWO_OSC domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_oscService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMEquip", tags = {"EMWO_OSC" },  notes = "SaveByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_oscs/save")
    public ResponseEntity<Boolean> saveByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_OSCDTO emwo_oscdto) {
        EMWO_OSC domain = emwo_oscMapping.toDomain(emwo_oscdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_oscService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMEquip", tags = {"EMWO_OSC" },  notes = "SaveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_oscs/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_OSCDTO> emwo_oscdtos) {
        List<EMWO_OSC> domainlist=emwo_oscMapping.toDomain(emwo_oscdtos);
        for(EMWO_OSC domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emwo_oscService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMEquip", tags = {"EMWO_OSC" },  notes = "RemoveByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emwo_oscs/{emwo_osc_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_osc_id") String emwo_osc_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwo_oscService.remove(emwo_osc_id));
    }

    @ApiOperation(value = "RemoveBatchByEMEquip", tags = {"EMWO_OSC" },  notes = "RemoveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emwo_oscs/batch")
    public ResponseEntity<Boolean> removeBatchByEMEquip(@RequestBody List<String> ids) {
        emwo_oscService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMEquip", tags = {"EMWO_OSC" } ,notes = "fetchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/{emequip_id}/emwo_oscs/fetchdefault")
	public ResponseEntity<List<EMWO_OSCDTO>> fetchEMWO_OSCDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id,EMWO_OSCSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_OSC> domains = emwo_oscService.searchDefault(context) ;
        List<EMWO_OSCDTO> list = emwo_oscMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMEquip", tags = {"EMWO_OSC" } ,notes = "searchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/{emequip_id}/emwo_oscs/searchdefault")
	public ResponseEntity<Page<EMWO_OSCDTO>> searchEMWO_OSCDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_OSCSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_OSC> domains = emwo_oscService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_oscMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "GetDraftByEMEQTypeEMEquip", tags = {"EMWO_OSC" },  notes = "GetDraftByEMEQTypeEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_oscs/getdraft")
    public ResponseEntity<EMWO_OSCDTO> getDraftByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id) {
        EMWO_OSC domain = new EMWO_OSC();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_oscMapping.toDto(emwo_oscService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByEMEQTypeEMEquip", tags = {"EMWO_OSC" },  notes = "UpdateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_oscs/{emwo_osc_id}")
    @Transactional
    public ResponseEntity<EMWO_OSCDTO> updateByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_osc_id") String emwo_osc_id, @RequestBody EMWO_OSCDTO emwo_oscdto) {
        EMWO_OSC domain = emwo_oscMapping.toDomain(emwo_oscdto);
        domain.setEquipid(emequip_id);
        domain.setEmwoOscid(emwo_osc_id);
		emwo_oscService.update(domain);
        EMWO_OSCDTO dto = emwo_oscMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMEQTypeEMEquip", tags = {"EMWO_OSC" },  notes = "UpdateBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_oscs/batch")
    public ResponseEntity<Boolean> updateBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_OSCDTO> emwo_oscdtos) {
        List<EMWO_OSC> domainlist=emwo_oscMapping.toDomain(emwo_oscdtos);
        for(EMWO_OSC domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_oscService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMEQTypeEMEquip", tags = {"EMWO_OSC" },  notes = "CheckKeyByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_oscs/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_OSCDTO emwo_oscdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_oscService.checkKey(emwo_oscMapping.toDomain(emwo_oscdto)));
    }

    @ApiOperation(value = "GetByEMEQTypeEMEquip", tags = {"EMWO_OSC" },  notes = "GetByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_oscs/{emwo_osc_id}")
    public ResponseEntity<EMWO_OSCDTO> getByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_osc_id") String emwo_osc_id) {
        EMWO_OSC domain = emwo_oscService.get(emwo_osc_id);
        EMWO_OSCDTO dto = emwo_oscMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CreateByEMEQTypeEMEquip", tags = {"EMWO_OSC" },  notes = "CreateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_oscs")
    @Transactional
    public ResponseEntity<EMWO_OSCDTO> createByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_OSCDTO emwo_oscdto) {
        EMWO_OSC domain = emwo_oscMapping.toDomain(emwo_oscdto);
        domain.setEquipid(emequip_id);
		emwo_oscService.create(domain);
        EMWO_OSCDTO dto = emwo_oscMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMEQTypeEMEquip", tags = {"EMWO_OSC" },  notes = "createBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_oscs/batch")
    public ResponseEntity<Boolean> createBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_OSCDTO> emwo_oscdtos) {
        List<EMWO_OSC> domainlist=emwo_oscMapping.toDomain(emwo_oscdtos);
        for(EMWO_OSC domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_oscService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMEQTypeEMEquip", tags = {"EMWO_OSC" },  notes = "SaveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_oscs/save")
    public ResponseEntity<Boolean> saveByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_OSCDTO emwo_oscdto) {
        EMWO_OSC domain = emwo_oscMapping.toDomain(emwo_oscdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_oscService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMEQTypeEMEquip", tags = {"EMWO_OSC" },  notes = "SaveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_oscs/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_OSCDTO> emwo_oscdtos) {
        List<EMWO_OSC> domainlist=emwo_oscMapping.toDomain(emwo_oscdtos);
        for(EMWO_OSC domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emwo_oscService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByEMEQTypeEMEquip", tags = {"EMWO_OSC" },  notes = "RemoveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_oscs/{emwo_osc_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_osc_id") String emwo_osc_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwo_oscService.remove(emwo_osc_id));
    }

    @ApiOperation(value = "RemoveBatchByEMEQTypeEMEquip", tags = {"EMWO_OSC" },  notes = "RemoveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_oscs/batch")
    public ResponseEntity<Boolean> removeBatchByEMEQTypeEMEquip(@RequestBody List<String> ids) {
        emwo_oscService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMEQTypeEMEquip", tags = {"EMWO_OSC" } ,notes = "fetchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_oscs/fetchdefault")
	public ResponseEntity<List<EMWO_OSCDTO>> fetchEMWO_OSCDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id,EMWO_OSCSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_OSC> domains = emwo_oscService.searchDefault(context) ;
        List<EMWO_OSCDTO> list = emwo_oscMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMEQTypeEMEquip", tags = {"EMWO_OSC" } ,notes = "searchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_oscs/searchdefault")
	public ResponseEntity<Page<EMWO_OSCDTO>> searchEMWO_OSCDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_OSCSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_OSC> domains = emwo_oscService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_oscMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "GetDraftByPFTeamEMEquip", tags = {"EMWO_OSC" },  notes = "GetDraftByPFTeamEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_oscs/getdraft")
    public ResponseEntity<EMWO_OSCDTO> getDraftByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id) {
        EMWO_OSC domain = new EMWO_OSC();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_oscMapping.toDto(emwo_oscService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByPFTeamEMEquip", tags = {"EMWO_OSC" },  notes = "UpdateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_oscs/{emwo_osc_id}")
    @Transactional
    public ResponseEntity<EMWO_OSCDTO> updateByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_osc_id") String emwo_osc_id, @RequestBody EMWO_OSCDTO emwo_oscdto) {
        EMWO_OSC domain = emwo_oscMapping.toDomain(emwo_oscdto);
        domain.setEquipid(emequip_id);
        domain.setEmwoOscid(emwo_osc_id);
		emwo_oscService.update(domain);
        EMWO_OSCDTO dto = emwo_oscMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFTeamEMEquip", tags = {"EMWO_OSC" },  notes = "UpdateBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_oscs/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_OSCDTO> emwo_oscdtos) {
        List<EMWO_OSC> domainlist=emwo_oscMapping.toDomain(emwo_oscdtos);
        for(EMWO_OSC domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_oscService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByPFTeamEMEquip", tags = {"EMWO_OSC" },  notes = "CheckKeyByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_oscs/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_OSCDTO emwo_oscdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_oscService.checkKey(emwo_oscMapping.toDomain(emwo_oscdto)));
    }

    @ApiOperation(value = "GetByPFTeamEMEquip", tags = {"EMWO_OSC" },  notes = "GetByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_oscs/{emwo_osc_id}")
    public ResponseEntity<EMWO_OSCDTO> getByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_osc_id") String emwo_osc_id) {
        EMWO_OSC domain = emwo_oscService.get(emwo_osc_id);
        EMWO_OSCDTO dto = emwo_oscMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CreateByPFTeamEMEquip", tags = {"EMWO_OSC" },  notes = "CreateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_oscs")
    @Transactional
    public ResponseEntity<EMWO_OSCDTO> createByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_OSCDTO emwo_oscdto) {
        EMWO_OSC domain = emwo_oscMapping.toDomain(emwo_oscdto);
        domain.setEquipid(emequip_id);
		emwo_oscService.create(domain);
        EMWO_OSCDTO dto = emwo_oscMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFTeamEMEquip", tags = {"EMWO_OSC" },  notes = "createBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_oscs/batch")
    public ResponseEntity<Boolean> createBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_OSCDTO> emwo_oscdtos) {
        List<EMWO_OSC> domainlist=emwo_oscMapping.toDomain(emwo_oscdtos);
        for(EMWO_OSC domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_oscService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByPFTeamEMEquip", tags = {"EMWO_OSC" },  notes = "SaveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_oscs/save")
    public ResponseEntity<Boolean> saveByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_OSCDTO emwo_oscdto) {
        EMWO_OSC domain = emwo_oscMapping.toDomain(emwo_oscdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_oscService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFTeamEMEquip", tags = {"EMWO_OSC" },  notes = "SaveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_oscs/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_OSCDTO> emwo_oscdtos) {
        List<EMWO_OSC> domainlist=emwo_oscMapping.toDomain(emwo_oscdtos);
        for(EMWO_OSC domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emwo_oscService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "RemoveByPFTeamEMEquip", tags = {"EMWO_OSC" },  notes = "RemoveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_oscs/{emwo_osc_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_osc_id") String emwo_osc_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwo_oscService.remove(emwo_osc_id));
    }

    @ApiOperation(value = "RemoveBatchByPFTeamEMEquip", tags = {"EMWO_OSC" },  notes = "RemoveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_oscs/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeamEMEquip(@RequestBody List<String> ids) {
        emwo_oscService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByPFTeamEMEquip", tags = {"EMWO_OSC" } ,notes = "fetchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_oscs/fetchdefault")
	public ResponseEntity<List<EMWO_OSCDTO>> fetchEMWO_OSCDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id,EMWO_OSCSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_OSC> domains = emwo_oscService.searchDefault(context) ;
        List<EMWO_OSCDTO> list = emwo_oscMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFTeamEMEquip", tags = {"EMWO_OSC" } ,notes = "searchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_oscs/searchdefault")
	public ResponseEntity<Page<EMWO_OSCDTO>> searchEMWO_OSCDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_OSCSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_OSC> domains = emwo_oscService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_oscMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMWO_OSC getEntity(){
        return new EMWO_OSC();
    }

}
