package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMRiggingH;
import cn.ibizlab.eam.core.eam_core.service.IEMRiggingHService;
import cn.ibizlab.eam.core.eam_core.filter.EMRiggingHSearchContext;




@Slf4j
@Api(tags = {"EMRiggingH" })
@RestController("WebApi-emriggingh")
@RequestMapping("")
public class EMRiggingHResource {

    @Autowired
    private IEMRiggingHService emrigginghService;

    @Autowired
    @Lazy
    private EMRiggingHMapping emrigginghMapping;




    @PreAuthorize("hasPermission(#emriggingh_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMRiggingH" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrigginghs/{emriggingh_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emriggingh_id") String emriggingh_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emrigginghService.remove(emriggingh_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMRiggingH" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emrigginghs/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emrigginghService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMRiggingH" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emrigginghs/save")
    public ResponseEntity<Boolean> save(@RequestBody EMRiggingHDTO emrigginghdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emrigginghService.save(emrigginghMapping.toDomain(emrigginghdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMRiggingH" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emrigginghs/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMRiggingHDTO> emrigginghdtos) {
        emrigginghService.saveBatch(emrigginghMapping.toDomain(emrigginghdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emriggingh_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMRiggingH" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrigginghs/{emriggingh_id}")
    @Transactional
    public ResponseEntity<EMRiggingHDTO> update(@PathVariable("emriggingh_id") String emriggingh_id, @RequestBody EMRiggingHDTO emrigginghdto) {
		EMRiggingH domain = emrigginghMapping.toDomain(emrigginghdto);
        domain.setEmrigginghid(emriggingh_id);
		emrigginghService.update(domain);
		EMRiggingHDTO dto = emrigginghMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emriggingh_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMRiggingH" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emrigginghs/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMRiggingHDTO> emrigginghdtos) {
        emrigginghService.updateBatch(emrigginghMapping.toDomain(emrigginghdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMRiggingH" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emrigginghs")
    @Transactional
    public ResponseEntity<EMRiggingHDTO> create(@RequestBody EMRiggingHDTO emrigginghdto) {
        EMRiggingH domain = emrigginghMapping.toDomain(emrigginghdto);
		emrigginghService.create(domain);
        EMRiggingHDTO dto = emrigginghMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMRiggingH" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emrigginghs/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMRiggingHDTO> emrigginghdtos) {
        emrigginghService.createBatch(emrigginghMapping.toDomain(emrigginghdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emriggingh_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMRiggingH" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emrigginghs/{emriggingh_id}")
    public ResponseEntity<EMRiggingHDTO> get(@PathVariable("emriggingh_id") String emriggingh_id) {
        EMRiggingH domain = emrigginghService.get(emriggingh_id);
        EMRiggingHDTO dto = emrigginghMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMRiggingH" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emrigginghs/getdraft")
    public ResponseEntity<EMRiggingHDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emrigginghMapping.toDto(emrigginghService.getDraft(new EMRiggingH())));
    }




    @ApiOperation(value = "CheckKey", tags = {"EMRiggingH" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emrigginghs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMRiggingHDTO emrigginghdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emrigginghService.checkKey(emrigginghMapping.toDomain(emrigginghdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRiggingH-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMRiggingH" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emrigginghs/fetchdefault")
	public ResponseEntity<List<EMRiggingHDTO>> fetchDefault(EMRiggingHSearchContext context) {
        Page<EMRiggingH> domains = emrigginghService.searchDefault(context) ;
        List<EMRiggingHDTO> list = emrigginghMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRiggingH-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMRiggingH" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emrigginghs/searchdefault")
	public ResponseEntity<Page<EMRiggingHDTO>> searchDefault(@RequestBody EMRiggingHSearchContext context) {
        Page<EMRiggingH> domains = emrigginghService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emrigginghMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMRiggingH getEntity(){
        return new EMRiggingH();
    }

}
