package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMPlanTDetail;
import cn.ibizlab.eam.core.eam_core.service.IEMPlanTDetailService;
import cn.ibizlab.eam.core.eam_core.filter.EMPlanTDetailSearchContext;




@Slf4j
@Api(tags = {"EMPlanTDetail" })
@RestController("WebApi-emplantdetail")
@RequestMapping("")
public class EMPlanTDetailResource {

    @Autowired
    private IEMPlanTDetailService emplantdetailService;

    @Autowired
    @Lazy
    private EMPlanTDetailMapping emplantdetailMapping;




    @PreAuthorize("hasPermission(#emplantdetail_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMPlanTDetail" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emplantdetails/{emplantdetail_id}")
    @Transactional
    public ResponseEntity<EMPlanTDetailDTO> update(@PathVariable("emplantdetail_id") String emplantdetail_id, @RequestBody EMPlanTDetailDTO emplantdetaildto) {
		EMPlanTDetail domain = emplantdetailMapping.toDomain(emplantdetaildto);
        domain.setEmplantdetailid(emplantdetail_id);
		emplantdetailService.update(domain);
		EMPlanTDetailDTO dto = emplantdetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emplantdetail_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMPlanTDetail" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emplantdetails/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMPlanTDetailDTO> emplantdetaildtos) {
        emplantdetailService.updateBatch(emplantdetailMapping.toDomain(emplantdetaildtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMPlanTDetail" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emplantdetails/getdraft")
    public ResponseEntity<EMPlanTDetailDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emplantdetailMapping.toDto(emplantdetailService.getDraft(new EMPlanTDetail())));
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMPlanTDetail" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emplantdetails")
    @Transactional
    public ResponseEntity<EMPlanTDetailDTO> create(@RequestBody EMPlanTDetailDTO emplantdetaildto) {
        EMPlanTDetail domain = emplantdetailMapping.toDomain(emplantdetaildto);
		emplantdetailService.create(domain);
        EMPlanTDetailDTO dto = emplantdetailMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMPlanTDetail" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emplantdetails/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMPlanTDetailDTO> emplantdetaildtos) {
        emplantdetailService.createBatch(emplantdetailMapping.toDomain(emplantdetaildtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMPlanTDetail" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emplantdetails/save")
    public ResponseEntity<Boolean> save(@RequestBody EMPlanTDetailDTO emplantdetaildto) {
        return ResponseEntity.status(HttpStatus.OK).body(emplantdetailService.save(emplantdetailMapping.toDomain(emplantdetaildto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMPlanTDetail" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emplantdetails/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMPlanTDetailDTO> emplantdetaildtos) {
        emplantdetailService.saveBatch(emplantdetailMapping.toDomain(emplantdetaildtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emplantdetail_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMPlanTDetail" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emplantdetails/{emplantdetail_id}")
    public ResponseEntity<EMPlanTDetailDTO> get(@PathVariable("emplantdetail_id") String emplantdetail_id) {
        EMPlanTDetail domain = emplantdetailService.get(emplantdetail_id);
        EMPlanTDetailDTO dto = emplantdetailMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @PreAuthorize("hasPermission(#emplantdetail_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMPlanTDetail" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emplantdetails/{emplantdetail_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emplantdetail_id") String emplantdetail_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emplantdetailService.remove(emplantdetail_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMPlanTDetail" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emplantdetails/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emplantdetailService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMPlanTDetail" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emplantdetails/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMPlanTDetailDTO emplantdetaildto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplantdetailService.checkKey(emplantdetailMapping.toDomain(emplantdetaildto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTDetail-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMPlanTDetail" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emplantdetails/fetchdefault")
	public ResponseEntity<List<EMPlanTDetailDTO>> fetchDefault(EMPlanTDetailSearchContext context) {
        Page<EMPlanTDetail> domains = emplantdetailService.searchDefault(context) ;
        List<EMPlanTDetailDTO> list = emplantdetailMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanTDetail-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMPlanTDetail" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emplantdetails/searchdefault")
	public ResponseEntity<Page<EMPlanTDetailDTO>> searchDefault(@RequestBody EMPlanTDetailSearchContext context) {
        Page<EMPlanTDetail> domains = emplantdetailService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplantdetailMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMPlanTDetail getEntity(){
        return new EMPlanTDetail();
    }

}
