package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMPlanCDT;
import cn.ibizlab.eam.core.eam_core.service.IEMPlanCDTService;
import cn.ibizlab.eam.core.eam_core.filter.EMPlanCDTSearchContext;




@Slf4j
@Api(tags = {"EMPlanCDT" })
@RestController("WebApi-emplancdt")
@RequestMapping("")
public class EMPlanCDTResource {

    @Autowired
    private IEMPlanCDTService emplancdtService;

    @Autowired
    @Lazy
    private EMPlanCDTMapping emplancdtMapping;




    @PreAuthorize("hasPermission(#emplancdt_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMPlanCDT" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emplancdts/{emplancdt_id}")
    public ResponseEntity<EMPlanCDTDTO> get(@PathVariable("emplancdt_id") String emplancdt_id) {
        EMPlanCDT domain = emplancdtService.get(emplancdt_id);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "Save", tags = {"EMPlanCDT" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emplancdts/save")
    public ResponseEntity<Boolean> save(@RequestBody EMPlanCDTDTO emplancdtdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.save(emplancdtMapping.toDomain(emplancdtdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMPlanCDT" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emplancdts/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        emplancdtService.saveBatch(emplancdtMapping.toDomain(emplancdtdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMPlanCDT" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emplancdts")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> create(@RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
		emplancdtService.create(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMPlanCDT" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emplancdts/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        emplancdtService.createBatch(emplancdtMapping.toDomain(emplancdtdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMPlanCDT" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emplancdts/getdraft")
    public ResponseEntity<EMPlanCDTDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtMapping.toDto(emplancdtService.getDraft(new EMPlanCDT())));
    }




    @PreAuthorize("hasPermission(#emplancdt_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMPlanCDT" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> update(@PathVariable("emplancdt_id") String emplancdt_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
		EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setEmplancdtid(emplancdt_id);
		emplancdtService.update(domain);
		EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emplancdt_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMPlanCDT" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emplancdts/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        emplancdtService.updateBatch(emplancdtMapping.toDomain(emplancdtdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMPlanCDT" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emplancdts/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMPlanCDTDTO emplancdtdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplancdtService.checkKey(emplancdtMapping.toDomain(emplancdtdto)));
    }




    @PreAuthorize("hasPermission(#emplancdt_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMPlanCDT" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emplancdt_id") String emplancdt_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.remove(emplancdt_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMPlanCDT" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emplancdts/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emplancdtService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanCDT-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMPlanCDT" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emplancdts/fetchdefault")
	public ResponseEntity<List<EMPlanCDTDTO>> fetchDefault(EMPlanCDTSearchContext context) {
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
        List<EMPlanCDTDTO> list = emplancdtMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPlanCDT-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMPlanCDT" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emplancdts/searchdefault")
	public ResponseEntity<Page<EMPlanCDTDTO>> searchDefault(@RequestBody EMPlanCDTSearchContext context) {
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplancdtMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "GetByEMPlan", tags = {"EMPlanCDT" },  notes = "GetByEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    public ResponseEntity<EMPlanCDTDTO> getByEMPlan(@PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
        EMPlanCDT domain = emplancdtService.get(emplancdt_id);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByEMPlan", tags = {"EMPlanCDT" },  notes = "SaveByEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emplans/{emplan_id}/emplancdts/save")
    public ResponseEntity<Boolean> saveByEMPlan(@PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMPlan", tags = {"EMPlanCDT" },  notes = "SaveBatchByEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emplans/{emplan_id}/emplancdts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMPlan(@PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplancdtService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMPlan", tags = {"EMPlanCDT" },  notes = "CreateByEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emplans/{emplan_id}/emplancdts")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> createByEMPlan(@PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
		emplancdtService.create(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMPlan", tags = {"EMPlanCDT" },  notes = "createBatchByEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> createBatchByEMPlan(@PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMPlan", tags = {"EMPlanCDT" },  notes = "GetDraftByEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/emplans/{emplan_id}/emplancdts/getdraft")
    public ResponseEntity<EMPlanCDTDTO> getDraftByEMPlan(@PathVariable("emplan_id") String emplan_id) {
        EMPlanCDT domain = new EMPlanCDT();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtMapping.toDto(emplancdtService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateByEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> updateByEMPlan(@PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        domain.setEmplancdtid(emplancdt_id);
		emplancdtService.update(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateBatchByEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> updateBatchByEMPlan(@PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMPlan", tags = {"EMPlanCDT" },  notes = "CheckKeyByEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emplans/{emplan_id}/emplancdts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMPlan(@PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplancdtService.checkKey(emplancdtMapping.toDomain(emplancdtdto)));
    }

    @ApiOperation(value = "RemoveByEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveByEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMPlan(@PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.remove(emplancdt_id));
    }

    @ApiOperation(value = "RemoveBatchByEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveBatchByEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> removeBatchByEMPlan(@RequestBody List<String> ids) {
        emplancdtService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMPlan", tags = {"EMPlanCDT" } ,notes = "fetchDEFAULTByEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/emplans/{emplan_id}/emplancdts/fetchdefault")
	public ResponseEntity<List<EMPlanCDTDTO>> fetchEMPlanCDTDefaultByEMPlan(@PathVariable("emplan_id") String emplan_id,EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
        List<EMPlanCDTDTO> list = emplancdtMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMPlan", tags = {"EMPlanCDT" } ,notes = "searchDEFAULTByEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/emplans/{emplan_id}/emplancdts/searchdefault")
	public ResponseEntity<Page<EMPlanCDTDTO>> searchEMPlanCDTDefaultByEMPlan(@PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplancdtMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "GetByEMACClassEMPlan", tags = {"EMPlanCDT" },  notes = "GetByEMACClassEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    public ResponseEntity<EMPlanCDTDTO> getByEMACClassEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
        EMPlanCDT domain = emplancdtService.get(emplancdt_id);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByEMACClassEMPlan", tags = {"EMPlanCDT" },  notes = "SaveByEMACClassEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplancdts/save")
    public ResponseEntity<Boolean> saveByEMACClassEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMACClassEMPlan", tags = {"EMPlanCDT" },  notes = "SaveBatchByEMACClassEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplancdts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMACClassEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplancdtService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMACClassEMPlan", tags = {"EMPlanCDT" },  notes = "CreateByEMACClassEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplancdts")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> createByEMACClassEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
		emplancdtService.create(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMACClassEMPlan", tags = {"EMPlanCDT" },  notes = "createBatchByEMACClassEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> createBatchByEMACClassEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMACClassEMPlan", tags = {"EMPlanCDT" },  notes = "GetDraftByEMACClassEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplancdts/getdraft")
    public ResponseEntity<EMPlanCDTDTO> getDraftByEMACClassEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanCDT domain = new EMPlanCDT();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtMapping.toDto(emplancdtService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByEMACClassEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateByEMACClassEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> updateByEMACClassEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        domain.setEmplancdtid(emplancdt_id);
		emplancdtService.update(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMACClassEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateBatchByEMACClassEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> updateBatchByEMACClassEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMACClassEMPlan", tags = {"EMPlanCDT" },  notes = "CheckKeyByEMACClassEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplancdts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMACClassEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplancdtService.checkKey(emplancdtMapping.toDomain(emplancdtdto)));
    }

    @ApiOperation(value = "RemoveByEMACClassEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveByEMACClassEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMACClassEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.remove(emplancdt_id));
    }

    @ApiOperation(value = "RemoveBatchByEMACClassEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveBatchByEMACClassEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> removeBatchByEMACClassEMPlan(@RequestBody List<String> ids) {
        emplancdtService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMACClassEMPlan", tags = {"EMPlanCDT" } ,notes = "fetchDEFAULTByEMACClassEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplancdts/fetchdefault")
	public ResponseEntity<List<EMPlanCDTDTO>> fetchEMPlanCDTDefaultByEMACClassEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id,EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
        List<EMPlanCDTDTO> list = emplancdtMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMACClassEMPlan", tags = {"EMPlanCDT" } ,notes = "searchDEFAULTByEMACClassEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/emacclasses/{emacclass_id}/emplans/{emplan_id}/emplancdts/searchdefault")
	public ResponseEntity<Page<EMPlanCDTDTO>> searchEMPlanCDTDefaultByEMACClassEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplancdtMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "GetByEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "GetByEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    public ResponseEntity<EMPlanCDTDTO> getByEMEquipEMPlan(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
        EMPlanCDT domain = emplancdtService.get(emplancdt_id);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "SaveByEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/save")
    public ResponseEntity<Boolean> saveByEMEquipEMPlan(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "SaveBatchByEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEquipEMPlan(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplancdtService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "CreateByEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> createByEMEquipEMPlan(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
		emplancdtService.create(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "createBatchByEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> createBatchByEMEquipEMPlan(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "GetDraftByEMEquipEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/getdraft")
    public ResponseEntity<EMPlanCDTDTO> getDraftByEMEquipEMPlan(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanCDT domain = new EMPlanCDT();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtMapping.toDto(emplancdtService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateByEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> updateByEMEquipEMPlan(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        domain.setEmplancdtid(emplancdt_id);
		emplancdtService.update(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateBatchByEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> updateBatchByEMEquipEMPlan(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "CheckKeyByEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEquipEMPlan(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplancdtService.checkKey(emplancdtMapping.toDomain(emplancdtdto)));
    }

    @ApiOperation(value = "RemoveByEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveByEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEquipEMPlan(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.remove(emplancdt_id));
    }

    @ApiOperation(value = "RemoveBatchByEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveBatchByEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> removeBatchByEMEquipEMPlan(@RequestBody List<String> ids) {
        emplancdtService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMEquipEMPlan", tags = {"EMPlanCDT" } ,notes = "fetchDEFAULTByEMEquipEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/fetchdefault")
	public ResponseEntity<List<EMPlanCDTDTO>> fetchEMPlanCDTDefaultByEMEquipEMPlan(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id,EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
        List<EMPlanCDTDTO> list = emplancdtMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMEquipEMPlan", tags = {"EMPlanCDT" } ,notes = "searchDEFAULTByEMEquipEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/searchdefault")
	public ResponseEntity<Page<EMPlanCDTDTO>> searchEMPlanCDTDefaultByEMEquipEMPlan(@PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplancdtMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "GetByEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "GetByEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    public ResponseEntity<EMPlanCDTDTO> getByEMPlanTemplEMPlan(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
        EMPlanCDT domain = emplancdtService.get(emplancdt_id);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "SaveByEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/save")
    public ResponseEntity<Boolean> saveByEMPlanTemplEMPlan(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "SaveBatchByEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMPlanTemplEMPlan(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplancdtService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "CreateByEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> createByEMPlanTemplEMPlan(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
		emplancdtService.create(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "createBatchByEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> createBatchByEMPlanTemplEMPlan(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "GetDraftByEMPlanTemplEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/getdraft")
    public ResponseEntity<EMPlanCDTDTO> getDraftByEMPlanTemplEMPlan(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanCDT domain = new EMPlanCDT();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtMapping.toDto(emplancdtService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateByEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> updateByEMPlanTemplEMPlan(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        domain.setEmplancdtid(emplancdt_id);
		emplancdtService.update(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateBatchByEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> updateBatchByEMPlanTemplEMPlan(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "CheckKeyByEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMPlanTemplEMPlan(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplancdtService.checkKey(emplancdtMapping.toDomain(emplancdtdto)));
    }

    @ApiOperation(value = "RemoveByEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveByEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMPlanTemplEMPlan(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.remove(emplancdt_id));
    }

    @ApiOperation(value = "RemoveBatchByEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveBatchByEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> removeBatchByEMPlanTemplEMPlan(@RequestBody List<String> ids) {
        emplancdtService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMPlanTemplEMPlan", tags = {"EMPlanCDT" } ,notes = "fetchDEFAULTByEMPlanTemplEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/fetchdefault")
	public ResponseEntity<List<EMPlanCDTDTO>> fetchEMPlanCDTDefaultByEMPlanTemplEMPlan(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id,EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
        List<EMPlanCDTDTO> list = emplancdtMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMPlanTemplEMPlan", tags = {"EMPlanCDT" } ,notes = "searchDEFAULTByEMPlanTemplEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/searchdefault")
	public ResponseEntity<Page<EMPlanCDTDTO>> searchEMPlanCDTDefaultByEMPlanTemplEMPlan(@PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplancdtMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "GetByEMServiceEMPlan", tags = {"EMPlanCDT" },  notes = "GetByEMServiceEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    public ResponseEntity<EMPlanCDTDTO> getByEMServiceEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
        EMPlanCDT domain = emplancdtService.get(emplancdt_id);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByEMServiceEMPlan", tags = {"EMPlanCDT" },  notes = "SaveByEMServiceEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplans/{emplan_id}/emplancdts/save")
    public ResponseEntity<Boolean> saveByEMServiceEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMServiceEMPlan", tags = {"EMPlanCDT" },  notes = "SaveBatchByEMServiceEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplans/{emplan_id}/emplancdts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMServiceEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplancdtService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMServiceEMPlan", tags = {"EMPlanCDT" },  notes = "CreateByEMServiceEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplans/{emplan_id}/emplancdts")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> createByEMServiceEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
		emplancdtService.create(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMServiceEMPlan", tags = {"EMPlanCDT" },  notes = "createBatchByEMServiceEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> createBatchByEMServiceEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMServiceEMPlan", tags = {"EMPlanCDT" },  notes = "GetDraftByEMServiceEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emplans/{emplan_id}/emplancdts/getdraft")
    public ResponseEntity<EMPlanCDTDTO> getDraftByEMServiceEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanCDT domain = new EMPlanCDT();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtMapping.toDto(emplancdtService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByEMServiceEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateByEMServiceEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> updateByEMServiceEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        domain.setEmplancdtid(emplancdt_id);
		emplancdtService.update(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMServiceEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateBatchByEMServiceEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> updateBatchByEMServiceEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMServiceEMPlan", tags = {"EMPlanCDT" },  notes = "CheckKeyByEMServiceEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplans/{emplan_id}/emplancdts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMServiceEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplancdtService.checkKey(emplancdtMapping.toDomain(emplancdtdto)));
    }

    @ApiOperation(value = "RemoveByEMServiceEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveByEMServiceEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMServiceEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.remove(emplancdt_id));
    }

    @ApiOperation(value = "RemoveBatchByEMServiceEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveBatchByEMServiceEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> removeBatchByEMServiceEMPlan(@RequestBody List<String> ids) {
        emplancdtService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMServiceEMPlan", tags = {"EMPlanCDT" } ,notes = "fetchDEFAULTByEMServiceEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emplans/{emplan_id}/emplancdts/fetchdefault")
	public ResponseEntity<List<EMPlanCDTDTO>> fetchEMPlanCDTDefaultByEMServiceEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id,EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
        List<EMPlanCDTDTO> list = emplancdtMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMServiceEMPlan", tags = {"EMPlanCDT" } ,notes = "searchDEFAULTByEMServiceEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emplans/{emplan_id}/emplancdts/searchdefault")
	public ResponseEntity<Page<EMPlanCDTDTO>> searchEMPlanCDTDefaultByEMServiceEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplancdtMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "GetByPFDeptEMPlan", tags = {"EMPlanCDT" },  notes = "GetByPFDeptEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    public ResponseEntity<EMPlanCDTDTO> getByPFDeptEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
        EMPlanCDT domain = emplancdtService.get(emplancdt_id);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByPFDeptEMPlan", tags = {"EMPlanCDT" },  notes = "SaveByPFDeptEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplancdts/save")
    public ResponseEntity<Boolean> saveByPFDeptEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFDeptEMPlan", tags = {"EMPlanCDT" },  notes = "SaveBatchByPFDeptEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplancdts/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFDeptEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplancdtService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByPFDeptEMPlan", tags = {"EMPlanCDT" },  notes = "CreateByPFDeptEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplancdts")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> createByPFDeptEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
		emplancdtService.create(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFDeptEMPlan", tags = {"EMPlanCDT" },  notes = "createBatchByPFDeptEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> createBatchByPFDeptEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFDeptEMPlan", tags = {"EMPlanCDT" },  notes = "GetDraftByPFDeptEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplancdts/getdraft")
    public ResponseEntity<EMPlanCDTDTO> getDraftByPFDeptEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanCDT domain = new EMPlanCDT();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtMapping.toDto(emplancdtService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByPFDeptEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateByPFDeptEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> updateByPFDeptEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        domain.setEmplancdtid(emplancdt_id);
		emplancdtService.update(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFDeptEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateBatchByPFDeptEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> updateBatchByPFDeptEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByPFDeptEMPlan", tags = {"EMPlanCDT" },  notes = "CheckKeyByPFDeptEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplancdts/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFDeptEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplancdtService.checkKey(emplancdtMapping.toDomain(emplancdtdto)));
    }

    @ApiOperation(value = "RemoveByPFDeptEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveByPFDeptEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFDeptEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.remove(emplancdt_id));
    }

    @ApiOperation(value = "RemoveBatchByPFDeptEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveBatchByPFDeptEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> removeBatchByPFDeptEMPlan(@RequestBody List<String> ids) {
        emplancdtService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByPFDeptEMPlan", tags = {"EMPlanCDT" } ,notes = "fetchDEFAULTByPFDeptEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplancdts/fetchdefault")
	public ResponseEntity<List<EMPlanCDTDTO>> fetchEMPlanCDTDefaultByPFDeptEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id,EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
        List<EMPlanCDTDTO> list = emplancdtMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFDeptEMPlan", tags = {"EMPlanCDT" } ,notes = "searchDEFAULTByPFDeptEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/pfdepts/{pfdept_id}/emplans/{emplan_id}/emplancdts/searchdefault")
	public ResponseEntity<Page<EMPlanCDTDTO>> searchEMPlanCDTDefaultByPFDeptEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplancdtMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "GetByPFEmpEMPlan", tags = {"EMPlanCDT" },  notes = "GetByPFEmpEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    public ResponseEntity<EMPlanCDTDTO> getByPFEmpEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
        EMPlanCDT domain = emplancdtService.get(emplancdt_id);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByPFEmpEMPlan", tags = {"EMPlanCDT" },  notes = "SaveByPFEmpEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplans/{emplan_id}/emplancdts/save")
    public ResponseEntity<Boolean> saveByPFEmpEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFEmpEMPlan", tags = {"EMPlanCDT" },  notes = "SaveBatchByPFEmpEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplans/{emplan_id}/emplancdts/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFEmpEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplancdtService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByPFEmpEMPlan", tags = {"EMPlanCDT" },  notes = "CreateByPFEmpEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplans/{emplan_id}/emplancdts")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> createByPFEmpEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
		emplancdtService.create(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFEmpEMPlan", tags = {"EMPlanCDT" },  notes = "createBatchByPFEmpEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> createBatchByPFEmpEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFEmpEMPlan", tags = {"EMPlanCDT" },  notes = "GetDraftByPFEmpEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emplans/{emplan_id}/emplancdts/getdraft")
    public ResponseEntity<EMPlanCDTDTO> getDraftByPFEmpEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanCDT domain = new EMPlanCDT();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtMapping.toDto(emplancdtService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByPFEmpEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateByPFEmpEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> updateByPFEmpEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        domain.setEmplancdtid(emplancdt_id);
		emplancdtService.update(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFEmpEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateBatchByPFEmpEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> updateBatchByPFEmpEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByPFEmpEMPlan", tags = {"EMPlanCDT" },  notes = "CheckKeyByPFEmpEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplans/{emplan_id}/emplancdts/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFEmpEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplancdtService.checkKey(emplancdtMapping.toDomain(emplancdtdto)));
    }

    @ApiOperation(value = "RemoveByPFEmpEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveByPFEmpEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFEmpEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.remove(emplancdt_id));
    }

    @ApiOperation(value = "RemoveBatchByPFEmpEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveBatchByPFEmpEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> removeBatchByPFEmpEMPlan(@RequestBody List<String> ids) {
        emplancdtService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByPFEmpEMPlan", tags = {"EMPlanCDT" } ,notes = "fetchDEFAULTByPFEmpEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emplans/{emplan_id}/emplancdts/fetchdefault")
	public ResponseEntity<List<EMPlanCDTDTO>> fetchEMPlanCDTDefaultByPFEmpEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id,EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
        List<EMPlanCDTDTO> list = emplancdtMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFEmpEMPlan", tags = {"EMPlanCDT" } ,notes = "searchDEFAULTByPFEmpEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emplans/{emplan_id}/emplancdts/searchdefault")
	public ResponseEntity<Page<EMPlanCDTDTO>> searchEMPlanCDTDefaultByPFEmpEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplancdtMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "GetByPFTeamEMPlan", tags = {"EMPlanCDT" },  notes = "GetByPFTeamEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    public ResponseEntity<EMPlanCDTDTO> getByPFTeamEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
        EMPlanCDT domain = emplancdtService.get(emplancdt_id);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByPFTeamEMPlan", tags = {"EMPlanCDT" },  notes = "SaveByPFTeamEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplans/{emplan_id}/emplancdts/save")
    public ResponseEntity<Boolean> saveByPFTeamEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFTeamEMPlan", tags = {"EMPlanCDT" },  notes = "SaveBatchByPFTeamEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplans/{emplan_id}/emplancdts/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeamEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplancdtService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByPFTeamEMPlan", tags = {"EMPlanCDT" },  notes = "CreateByPFTeamEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplans/{emplan_id}/emplancdts")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> createByPFTeamEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
		emplancdtService.create(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFTeamEMPlan", tags = {"EMPlanCDT" },  notes = "createBatchByPFTeamEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> createBatchByPFTeamEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFTeamEMPlan", tags = {"EMPlanCDT" },  notes = "GetDraftByPFTeamEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emplans/{emplan_id}/emplancdts/getdraft")
    public ResponseEntity<EMPlanCDTDTO> getDraftByPFTeamEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanCDT domain = new EMPlanCDT();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtMapping.toDto(emplancdtService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByPFTeamEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateByPFTeamEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> updateByPFTeamEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        domain.setEmplancdtid(emplancdt_id);
		emplancdtService.update(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFTeamEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateBatchByPFTeamEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeamEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByPFTeamEMPlan", tags = {"EMPlanCDT" },  notes = "CheckKeyByPFTeamEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplans/{emplan_id}/emplancdts/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeamEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplancdtService.checkKey(emplancdtMapping.toDomain(emplancdtdto)));
    }

    @ApiOperation(value = "RemoveByPFTeamEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveByPFTeamEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeamEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.remove(emplancdt_id));
    }

    @ApiOperation(value = "RemoveBatchByPFTeamEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveBatchByPFTeamEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeamEMPlan(@RequestBody List<String> ids) {
        emplancdtService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByPFTeamEMPlan", tags = {"EMPlanCDT" } ,notes = "fetchDEFAULTByPFTeamEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emplans/{emplan_id}/emplancdts/fetchdefault")
	public ResponseEntity<List<EMPlanCDTDTO>> fetchEMPlanCDTDefaultByPFTeamEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id,EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
        List<EMPlanCDTDTO> list = emplancdtMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFTeamEMPlan", tags = {"EMPlanCDT" } ,notes = "searchDEFAULTByPFTeamEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emplans/{emplan_id}/emplancdts/searchdefault")
	public ResponseEntity<Page<EMPlanCDTDTO>> searchEMPlanCDTDefaultByPFTeamEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplancdtMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}





    @ApiOperation(value = "GetByEMEQTypeEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "GetByEMEQTypeEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    public ResponseEntity<EMPlanCDTDTO> getByEMEQTypeEMEquipEMPlan(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
        EMPlanCDT domain = emplancdtService.get(emplancdt_id);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByEMEQTypeEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "SaveByEMEQTypeEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/save")
    public ResponseEntity<Boolean> saveByEMEQTypeEMEquipEMPlan(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMEQTypeEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "SaveBatchByEMEQTypeEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEQTypeEMEquipEMPlan(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplancdtService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMEQTypeEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "CreateByEMEQTypeEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> createByEMEQTypeEMEquipEMPlan(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
		emplancdtService.create(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMEQTypeEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "createBatchByEMEQTypeEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> createBatchByEMEQTypeEMEquipEMPlan(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMEQTypeEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "GetDraftByEMEQTypeEMEquipEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/getdraft")
    public ResponseEntity<EMPlanCDTDTO> getDraftByEMEQTypeEMEquipEMPlan(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanCDT domain = new EMPlanCDT();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtMapping.toDto(emplancdtService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByEMEQTypeEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateByEMEQTypeEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> updateByEMEQTypeEMEquipEMPlan(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        domain.setEmplancdtid(emplancdt_id);
		emplancdtService.update(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMEQTypeEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateBatchByEMEQTypeEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> updateBatchByEMEQTypeEMEquipEMPlan(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMEQTypeEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "CheckKeyByEMEQTypeEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEQTypeEMEquipEMPlan(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplancdtService.checkKey(emplancdtMapping.toDomain(emplancdtdto)));
    }

    @ApiOperation(value = "RemoveByEMEQTypeEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveByEMEQTypeEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEQTypeEMEquipEMPlan(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.remove(emplancdt_id));
    }

    @ApiOperation(value = "RemoveBatchByEMEQTypeEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveBatchByEMEQTypeEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> removeBatchByEMEQTypeEMEquipEMPlan(@RequestBody List<String> ids) {
        emplancdtService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMEQTypeEMEquipEMPlan", tags = {"EMPlanCDT" } ,notes = "fetchDEFAULTByEMEQTypeEMEquipEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/fetchdefault")
	public ResponseEntity<List<EMPlanCDTDTO>> fetchEMPlanCDTDefaultByEMEQTypeEMEquipEMPlan(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id,EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
        List<EMPlanCDTDTO> list = emplancdtMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMEQTypeEMEquipEMPlan", tags = {"EMPlanCDT" } ,notes = "searchDEFAULTByEMEQTypeEMEquipEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/searchdefault")
	public ResponseEntity<Page<EMPlanCDTDTO>> searchEMPlanCDTDefaultByEMEQTypeEMEquipEMPlan(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplancdtMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}





    @ApiOperation(value = "GetByPFTeamEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "GetByPFTeamEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    public ResponseEntity<EMPlanCDTDTO> getByPFTeamEMEquipEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
        EMPlanCDT domain = emplancdtService.get(emplancdt_id);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByPFTeamEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "SaveByPFTeamEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/save")
    public ResponseEntity<Boolean> saveByPFTeamEMEquipEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFTeamEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "SaveBatchByPFTeamEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeamEMEquipEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplancdtService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByPFTeamEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "CreateByPFTeamEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> createByPFTeamEMEquipEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
		emplancdtService.create(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFTeamEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "createBatchByPFTeamEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> createBatchByPFTeamEMEquipEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFTeamEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "GetDraftByPFTeamEMEquipEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/getdraft")
    public ResponseEntity<EMPlanCDTDTO> getDraftByPFTeamEMEquipEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanCDT domain = new EMPlanCDT();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtMapping.toDto(emplancdtService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByPFTeamEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateByPFTeamEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> updateByPFTeamEMEquipEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        domain.setEmplancdtid(emplancdt_id);
		emplancdtService.update(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFTeamEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateBatchByPFTeamEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeamEMEquipEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByPFTeamEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "CheckKeyByPFTeamEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeamEMEquipEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplancdtService.checkKey(emplancdtMapping.toDomain(emplancdtdto)));
    }

    @ApiOperation(value = "RemoveByPFTeamEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveByPFTeamEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeamEMEquipEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.remove(emplancdt_id));
    }

    @ApiOperation(value = "RemoveBatchByPFTeamEMEquipEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveBatchByPFTeamEMEquipEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeamEMEquipEMPlan(@RequestBody List<String> ids) {
        emplancdtService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByPFTeamEMEquipEMPlan", tags = {"EMPlanCDT" } ,notes = "fetchDEFAULTByPFTeamEMEquipEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/fetchdefault")
	public ResponseEntity<List<EMPlanCDTDTO>> fetchEMPlanCDTDefaultByPFTeamEMEquipEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id,EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
        List<EMPlanCDTDTO> list = emplancdtMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFTeamEMEquipEMPlan", tags = {"EMPlanCDT" } ,notes = "searchDEFAULTByPFTeamEMEquipEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emplans/{emplan_id}/emplancdts/searchdefault")
	public ResponseEntity<Page<EMPlanCDTDTO>> searchEMPlanCDTDefaultByPFTeamEMEquipEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplancdtMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}





    @ApiOperation(value = "GetByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "GetByEMACClassEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    public ResponseEntity<EMPlanCDTDTO> getByEMACClassEMPlanTemplEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
        EMPlanCDT domain = emplancdtService.get(emplancdt_id);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "SaveByEMACClassEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/save")
    public ResponseEntity<Boolean> saveByEMACClassEMPlanTemplEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "SaveBatchByEMACClassEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMACClassEMPlanTemplEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplancdtService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "CreateByEMACClassEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> createByEMACClassEMPlanTemplEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
		emplancdtService.create(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "createBatchByEMACClassEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> createBatchByEMACClassEMPlanTemplEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "GetDraftByEMACClassEMPlanTemplEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/getdraft")
    public ResponseEntity<EMPlanCDTDTO> getDraftByEMACClassEMPlanTemplEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanCDT domain = new EMPlanCDT();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtMapping.toDto(emplancdtService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateByEMACClassEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> updateByEMACClassEMPlanTemplEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        domain.setEmplancdtid(emplancdt_id);
		emplancdtService.update(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateBatchByEMACClassEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> updateBatchByEMACClassEMPlanTemplEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "CheckKeyByEMACClassEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMACClassEMPlanTemplEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplancdtService.checkKey(emplancdtMapping.toDomain(emplancdtdto)));
    }

    @ApiOperation(value = "RemoveByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveByEMACClassEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMACClassEMPlanTemplEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.remove(emplancdt_id));
    }

    @ApiOperation(value = "RemoveBatchByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveBatchByEMACClassEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> removeBatchByEMACClassEMPlanTemplEMPlan(@RequestBody List<String> ids) {
        emplancdtService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanCDT" } ,notes = "fetchDEFAULTByEMACClassEMPlanTemplEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/fetchdefault")
	public ResponseEntity<List<EMPlanCDTDTO>> fetchEMPlanCDTDefaultByEMACClassEMPlanTemplEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id,EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
        List<EMPlanCDTDTO> list = emplancdtMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMACClassEMPlanTemplEMPlan", tags = {"EMPlanCDT" } ,notes = "searchDEFAULTByEMACClassEMPlanTemplEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/emacclasses/{emacclass_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/searchdefault")
	public ResponseEntity<Page<EMPlanCDTDTO>> searchEMPlanCDTDefaultByEMACClassEMPlanTemplEMPlan(@PathVariable("emacclass_id") String emacclass_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplancdtMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}





    @ApiOperation(value = "GetByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "GetByEMServiceEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    public ResponseEntity<EMPlanCDTDTO> getByEMServiceEMPlanTemplEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
        EMPlanCDT domain = emplancdtService.get(emplancdt_id);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "SaveByEMServiceEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/save")
    public ResponseEntity<Boolean> saveByEMServiceEMPlanTemplEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "SaveBatchByEMServiceEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMServiceEMPlanTemplEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplancdtService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "CreateByEMServiceEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> createByEMServiceEMPlanTemplEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
		emplancdtService.create(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "createBatchByEMServiceEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> createBatchByEMServiceEMPlanTemplEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "GetDraftByEMServiceEMPlanTemplEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/getdraft")
    public ResponseEntity<EMPlanCDTDTO> getDraftByEMServiceEMPlanTemplEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanCDT domain = new EMPlanCDT();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtMapping.toDto(emplancdtService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateByEMServiceEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> updateByEMServiceEMPlanTemplEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        domain.setEmplancdtid(emplancdt_id);
		emplancdtService.update(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateBatchByEMServiceEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> updateBatchByEMServiceEMPlanTemplEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "CheckKeyByEMServiceEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMServiceEMPlanTemplEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplancdtService.checkKey(emplancdtMapping.toDomain(emplancdtdto)));
    }

    @ApiOperation(value = "RemoveByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveByEMServiceEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMServiceEMPlanTemplEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.remove(emplancdt_id));
    }

    @ApiOperation(value = "RemoveBatchByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveBatchByEMServiceEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> removeBatchByEMServiceEMPlanTemplEMPlan(@RequestBody List<String> ids) {
        emplancdtService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanCDT" } ,notes = "fetchDEFAULTByEMServiceEMPlanTemplEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/fetchdefault")
	public ResponseEntity<List<EMPlanCDTDTO>> fetchEMPlanCDTDefaultByEMServiceEMPlanTemplEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id,EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
        List<EMPlanCDTDTO> list = emplancdtMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMServiceEMPlanTemplEMPlan", tags = {"EMPlanCDT" } ,notes = "searchDEFAULTByEMServiceEMPlanTemplEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/searchdefault")
	public ResponseEntity<Page<EMPlanCDTDTO>> searchEMPlanCDTDefaultByEMServiceEMPlanTemplEMPlan(@PathVariable("emservice_id") String emservice_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplancdtMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}





    @ApiOperation(value = "GetByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "GetByPFDeptEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    public ResponseEntity<EMPlanCDTDTO> getByPFDeptEMPlanTemplEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
        EMPlanCDT domain = emplancdtService.get(emplancdt_id);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "SaveByPFDeptEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/save")
    public ResponseEntity<Boolean> saveByPFDeptEMPlanTemplEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "SaveBatchByPFDeptEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFDeptEMPlanTemplEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplancdtService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "CreateByPFDeptEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> createByPFDeptEMPlanTemplEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
		emplancdtService.create(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "createBatchByPFDeptEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> createBatchByPFDeptEMPlanTemplEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "GetDraftByPFDeptEMPlanTemplEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/getdraft")
    public ResponseEntity<EMPlanCDTDTO> getDraftByPFDeptEMPlanTemplEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanCDT domain = new EMPlanCDT();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtMapping.toDto(emplancdtService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateByPFDeptEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> updateByPFDeptEMPlanTemplEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        domain.setEmplancdtid(emplancdt_id);
		emplancdtService.update(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateBatchByPFDeptEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> updateBatchByPFDeptEMPlanTemplEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "CheckKeyByPFDeptEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFDeptEMPlanTemplEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplancdtService.checkKey(emplancdtMapping.toDomain(emplancdtdto)));
    }

    @ApiOperation(value = "RemoveByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveByPFDeptEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFDeptEMPlanTemplEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.remove(emplancdt_id));
    }

    @ApiOperation(value = "RemoveBatchByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveBatchByPFDeptEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> removeBatchByPFDeptEMPlanTemplEMPlan(@RequestBody List<String> ids) {
        emplancdtService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanCDT" } ,notes = "fetchDEFAULTByPFDeptEMPlanTemplEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/fetchdefault")
	public ResponseEntity<List<EMPlanCDTDTO>> fetchEMPlanCDTDefaultByPFDeptEMPlanTemplEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id,EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
        List<EMPlanCDTDTO> list = emplancdtMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFDeptEMPlanTemplEMPlan", tags = {"EMPlanCDT" } ,notes = "searchDEFAULTByPFDeptEMPlanTemplEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/pfdepts/{pfdept_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/searchdefault")
	public ResponseEntity<Page<EMPlanCDTDTO>> searchEMPlanCDTDefaultByPFDeptEMPlanTemplEMPlan(@PathVariable("pfdept_id") String pfdept_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplancdtMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}





    @ApiOperation(value = "GetByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "GetByPFEmpEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    public ResponseEntity<EMPlanCDTDTO> getByPFEmpEMPlanTemplEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
        EMPlanCDT domain = emplancdtService.get(emplancdt_id);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "SaveByPFEmpEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/save")
    public ResponseEntity<Boolean> saveByPFEmpEMPlanTemplEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "SaveBatchByPFEmpEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFEmpEMPlanTemplEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplancdtService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "CreateByPFEmpEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> createByPFEmpEMPlanTemplEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
		emplancdtService.create(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "createBatchByPFEmpEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> createBatchByPFEmpEMPlanTemplEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "GetDraftByPFEmpEMPlanTemplEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/getdraft")
    public ResponseEntity<EMPlanCDTDTO> getDraftByPFEmpEMPlanTemplEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanCDT domain = new EMPlanCDT();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtMapping.toDto(emplancdtService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateByPFEmpEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> updateByPFEmpEMPlanTemplEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        domain.setEmplancdtid(emplancdt_id);
		emplancdtService.update(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateBatchByPFEmpEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> updateBatchByPFEmpEMPlanTemplEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "CheckKeyByPFEmpEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFEmpEMPlanTemplEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplancdtService.checkKey(emplancdtMapping.toDomain(emplancdtdto)));
    }

    @ApiOperation(value = "RemoveByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveByPFEmpEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFEmpEMPlanTemplEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.remove(emplancdt_id));
    }

    @ApiOperation(value = "RemoveBatchByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveBatchByPFEmpEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> removeBatchByPFEmpEMPlanTemplEMPlan(@RequestBody List<String> ids) {
        emplancdtService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanCDT" } ,notes = "fetchDEFAULTByPFEmpEMPlanTemplEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/fetchdefault")
	public ResponseEntity<List<EMPlanCDTDTO>> fetchEMPlanCDTDefaultByPFEmpEMPlanTemplEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id,EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
        List<EMPlanCDTDTO> list = emplancdtMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFEmpEMPlanTemplEMPlan", tags = {"EMPlanCDT" } ,notes = "searchDEFAULTByPFEmpEMPlanTemplEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/searchdefault")
	public ResponseEntity<Page<EMPlanCDTDTO>> searchEMPlanCDTDefaultByPFEmpEMPlanTemplEMPlan(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplancdtMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}





    @ApiOperation(value = "GetByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "GetByPFTeamEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    public ResponseEntity<EMPlanCDTDTO> getByPFTeamEMPlanTemplEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
        EMPlanCDT domain = emplancdtService.get(emplancdt_id);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "SaveByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "SaveByPFTeamEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/save")
    public ResponseEntity<Boolean> saveByPFTeamEMPlanTemplEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "SaveBatchByPFTeamEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeamEMPlanTemplEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
             domain.setPlanid(emplan_id);
        }
        emplancdtService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "CreateByPFTeamEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> createByPFTeamEMPlanTemplEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
		emplancdtService.create(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "createBatchByPFTeamEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> createBatchByPFTeamEMPlanTemplEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "GetDraftByPFTeamEMPlanTemplEMPlan")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/getdraft")
    public ResponseEntity<EMPlanCDTDTO> getDraftByPFTeamEMPlanTemplEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id) {
        EMPlanCDT domain = new EMPlanCDT();
        domain.setPlanid(emplan_id);
        return ResponseEntity.status(HttpStatus.OK).body(emplancdtMapping.toDto(emplancdtService.getDraft(domain)));
    }

    @ApiOperation(value = "UpdateByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateByPFTeamEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<EMPlanCDTDTO> updateByPFTeamEMPlanTemplEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        EMPlanCDT domain = emplancdtMapping.toDomain(emplancdtdto);
        domain.setPlanid(emplan_id);
        domain.setEmplancdtid(emplancdt_id);
		emplancdtService.update(domain);
        EMPlanCDTDTO dto = emplancdtMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "UpdateBatchByPFTeamEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeamEMPlanTemplEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody List<EMPlanCDTDTO> emplancdtdtos) {
        List<EMPlanCDT> domainlist=emplancdtMapping.toDomain(emplancdtdtos);
        for(EMPlanCDT domain:domainlist){
            domain.setPlanid(emplan_id);
        }
        emplancdtService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "CheckKeyByPFTeamEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeamEMPlanTemplEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTDTO emplancdtdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emplancdtService.checkKey(emplancdtMapping.toDomain(emplancdtdto)));
    }

    @ApiOperation(value = "RemoveByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveByPFTeamEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/{emplancdt_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeamEMPlanTemplEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @PathVariable("emplancdt_id") String emplancdt_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emplancdtService.remove(emplancdt_id));
    }

    @ApiOperation(value = "RemoveBatchByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanCDT" },  notes = "RemoveBatchByPFTeamEMPlanTemplEMPlan")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeamEMPlanTemplEMPlan(@RequestBody List<String> ids) {
        emplancdtService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

	@ApiOperation(value = "fetchDEFAULTByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanCDT" } ,notes = "fetchDEFAULTByPFTeamEMPlanTemplEMPlan")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/fetchdefault")
	public ResponseEntity<List<EMPlanCDTDTO>> fetchEMPlanCDTDefaultByPFTeamEMPlanTemplEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id,EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
        List<EMPlanCDTDTO> list = emplancdtMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFTeamEMPlanTemplEMPlan", tags = {"EMPlanCDT" } ,notes = "searchDEFAULTByPFTeamEMPlanTemplEMPlan")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emplantempls/{emplantempl_id}/emplans/{emplan_id}/emplancdts/searchdefault")
	public ResponseEntity<Page<EMPlanCDTDTO>> searchEMPlanCDTDefaultByPFTeamEMPlanTemplEMPlan(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emplantempl_id") String emplantempl_id, @PathVariable("emplan_id") String emplan_id, @RequestBody EMPlanCDTSearchContext context) {
        context.setN_planid_eq(emplan_id);
        Page<EMPlanCDT> domains = emplancdtService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emplancdtMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMPlanCDT getEntity(){
        return new EMPlanCDT();
    }

}
