package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMItemPL;
import cn.ibizlab.eam.core.eam_core.service.IEMItemPLService;
import cn.ibizlab.eam.core.eam_core.filter.EMItemPLSearchContext;




@Slf4j
@Api(tags = {"EMItemPL" })
@RestController("WebApi-emitempl")
@RequestMapping("")
public class EMItemPLResource {

    @Autowired
    private IEMItemPLService emitemplService;

    @Autowired
    @Lazy
    private EMItemPLMapping emitemplMapping;




    @PreAuthorize("hasPermission(#emitempl_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMItemPL" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitempls/{emitempl_id}")
    @Transactional
    public ResponseEntity<EMItemPLDTO> update(@PathVariable("emitempl_id") String emitempl_id, @RequestBody EMItemPLDTO emitempldto) {
		EMItemPL domain = emitemplMapping.toDomain(emitempldto);
        domain.setEmitemplid(emitempl_id);
		emitemplService.update(domain);
		EMItemPLDTO dto = emitemplMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emitempl_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMItemPL" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitempls/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMItemPLDTO> emitempldtos) {
        emitemplService.updateBatch(emitemplMapping.toDomain(emitempldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMItemPL" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emitempls")
    @Transactional
    public ResponseEntity<EMItemPLDTO> create(@RequestBody EMItemPLDTO emitempldto) {
        EMItemPL domain = emitemplMapping.toDomain(emitempldto);
		emitemplService.create(domain);
        EMItemPLDTO dto = emitemplMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMItemPL" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emitempls/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMItemPLDTO> emitempldtos) {
        emitemplService.createBatch(emitemplMapping.toDomain(emitempldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMItemPL" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emitempls/save")
    public ResponseEntity<Boolean> save(@RequestBody EMItemPLDTO emitempldto) {
        return ResponseEntity.status(HttpStatus.OK).body(emitemplService.save(emitemplMapping.toDomain(emitempldto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMItemPL" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emitempls/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMItemPLDTO> emitempldtos) {
        emitemplService.saveBatch(emitemplMapping.toDomain(emitempldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMItemPL" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emitempls/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMItemPLDTO emitempldto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemplService.checkKey(emitemplMapping.toDomain(emitempldto)));
    }




    @PreAuthorize("hasPermission(#emitempl_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMItemPL" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitempls/{emitempl_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emitempl_id") String emitempl_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emitemplService.remove(emitempl_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMItemPL" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitempls/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emitemplService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emitempl_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMItemPL" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emitempls/{emitempl_id}")
    public ResponseEntity<EMItemPLDTO> get(@PathVariable("emitempl_id") String emitempl_id) {
        EMItemPL domain = emitemplService.get(emitempl_id);
        EMItemPLDTO dto = emitemplMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMItemPL" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emitempls/getdraft")
    public ResponseEntity<EMItemPLDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emitemplMapping.toDto(emitemplService.getDraft(new EMItemPL())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPL-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMItemPL" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emitempls/fetchdefault")
	public ResponseEntity<List<EMItemPLDTO>> fetchDefault(EMItemPLSearchContext context) {
        Page<EMItemPL> domains = emitemplService.searchDefault(context) ;
        List<EMItemPLDTO> list = emitemplMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPL-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMItemPL" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emitempls/searchdefault")
	public ResponseEntity<Page<EMItemPLDTO>> searchDefault(@RequestBody EMItemPLSearchContext context) {
        Page<EMItemPL> domains = emitemplService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemplMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMItemPL getEntity(){
        return new EMItemPL();
    }

}
