package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEQMPMTR;
import cn.ibizlab.eam.core.eam_core.service.IEMEQMPMTRService;
import cn.ibizlab.eam.core.eam_core.filter.EMEQMPMTRSearchContext;




@Slf4j
@Api(tags = {"EMEQMPMTR" })
@RestController("WebApi-emeqmpmtr")
@RequestMapping("")
public class EMEQMPMTRResource {

    @Autowired
    private IEMEQMPMTRService emeqmpmtrService;

    @Autowired
    @Lazy
    private EMEQMPMTRMapping emeqmpmtrMapping;




    @ApiOperation(value = "Save", tags = {"EMEQMPMTR" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqmpmtrs/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEQMPMTRDTO emeqmpmtrdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeqmpmtrService.save(emeqmpmtrMapping.toDomain(emeqmpmtrdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMEQMPMTR" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqmpmtrs/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEQMPMTRDTO> emeqmpmtrdtos) {
        emeqmpmtrService.saveBatch(emeqmpmtrMapping.toDomain(emeqmpmtrdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeqmpmtr_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMEQMPMTR" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqmpmtrs/{emeqmpmtr_id}")
    @Transactional
    public ResponseEntity<EMEQMPMTRDTO> update(@PathVariable("emeqmpmtr_id") String emeqmpmtr_id, @RequestBody EMEQMPMTRDTO emeqmpmtrdto) {
		EMEQMPMTR domain = emeqmpmtrMapping.toDomain(emeqmpmtrdto);
        domain.setEmeqmpmtrid(emeqmpmtr_id);
		emeqmpmtrService.update(domain);
		EMEQMPMTRDTO dto = emeqmpmtrMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emeqmpmtr_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEQMPMTR" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqmpmtrs/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEQMPMTRDTO> emeqmpmtrdtos) {
        emeqmpmtrService.updateBatch(emeqmpmtrMapping.toDomain(emeqmpmtrdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeqmpmtr_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMEQMPMTR" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqmpmtrs/{emeqmpmtr_id}")
    public ResponseEntity<EMEQMPMTRDTO> get(@PathVariable("emeqmpmtr_id") String emeqmpmtr_id) {
        EMEQMPMTR domain = emeqmpmtrService.get(emeqmpmtr_id);
        EMEQMPMTRDTO dto = emeqmpmtrMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMEQMPMTR" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqmpmtrs/getdraft")
    public ResponseEntity<EMEQMPMTRDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeqmpmtrMapping.toDto(emeqmpmtrService.getDraft(new EMEQMPMTR())));
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMEQMPMTR" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqmpmtrs")
    @Transactional
    public ResponseEntity<EMEQMPMTRDTO> create(@RequestBody EMEQMPMTRDTO emeqmpmtrdto) {
        EMEQMPMTR domain = emeqmpmtrMapping.toDomain(emeqmpmtrdto);
		emeqmpmtrService.create(domain);
        EMEQMPMTRDTO dto = emeqmpmtrMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMEQMPMTR" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqmpmtrs/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEQMPMTRDTO> emeqmpmtrdtos) {
        emeqmpmtrService.createBatch(emeqmpmtrMapping.toDomain(emeqmpmtrdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeqmpmtr_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMEQMPMTR" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqmpmtrs/{emeqmpmtr_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeqmpmtr_id") String emeqmpmtr_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeqmpmtrService.remove(emeqmpmtr_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMEQMPMTR" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqmpmtrs/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeqmpmtrService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMEQMPMTR" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqmpmtrs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEQMPMTRDTO emeqmpmtrdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqmpmtrService.checkKey(emeqmpmtrMapping.toDomain(emeqmpmtrdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQMPMTR-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEQMPMTR" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqmpmtrs/fetchdefault")
	public ResponseEntity<List<EMEQMPMTRDTO>> fetchDefault(EMEQMPMTRSearchContext context) {
        Page<EMEQMPMTR> domains = emeqmpmtrService.searchDefault(context) ;
        List<EMEQMPMTRDTO> list = emeqmpmtrMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQMPMTR-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEQMPMTR" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqmpmtrs/searchdefault")
	public ResponseEntity<Page<EMEQMPMTRDTO>> searchDefault(@RequestBody EMEQMPMTRSearchContext context) {
        Page<EMEQMPMTR> domains = emeqmpmtrService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqmpmtrMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMEQMPMTR getEntity(){
        return new EMEQMPMTR();
    }

}
