package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEIReportM;
import cn.ibizlab.eam.core.eam_core.service.IEMEIReportMService;
import cn.ibizlab.eam.core.eam_core.filter.EMEIReportMSearchContext;




@Slf4j
@Api(tags = {"EMEIReportM" })
@RestController("WebApi-emeireportm")
@RequestMapping("")
public class EMEIReportMResource {

    @Autowired
    private IEMEIReportMService emeireportmService;

    @Autowired
    @Lazy
    private EMEIReportMMapping emeireportmMapping;




    @ApiOperation(value = "GetDraft", tags = {"EMEIReportM" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeireportms/getdraft")
    public ResponseEntity<EMEIReportMDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeireportmMapping.toDto(emeireportmService.getDraft(new EMEIReportM())));
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMEIReportM" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeireportms")
    @Transactional
    public ResponseEntity<EMEIReportMDTO> create(@RequestBody EMEIReportMDTO emeireportmdto) {
        EMEIReportM domain = emeireportmMapping.toDomain(emeireportmdto);
		emeireportmService.create(domain);
        EMEIReportMDTO dto = emeireportmMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMEIReportM" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeireportms/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEIReportMDTO> emeireportmdtos) {
        emeireportmService.createBatch(emeireportmMapping.toDomain(emeireportmdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMEIReportM" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeireportms/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEIReportMDTO emeireportmdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeireportmService.save(emeireportmMapping.toDomain(emeireportmdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMEIReportM" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeireportms/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEIReportMDTO> emeireportmdtos) {
        emeireportmService.saveBatch(emeireportmMapping.toDomain(emeireportmdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMEIReportM" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeireportms/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEIReportMDTO emeireportmdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeireportmService.checkKey(emeireportmMapping.toDomain(emeireportmdto)));
    }




    @PreAuthorize("hasPermission(#emeireportm_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMEIReportM" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeireportms/{emeireportm_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeireportm_id") String emeireportm_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeireportmService.remove(emeireportm_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMEIReportM" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeireportms/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeireportmService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeireportm_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMEIReportM" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeireportms/{emeireportm_id}")
    @Transactional
    public ResponseEntity<EMEIReportMDTO> update(@PathVariable("emeireportm_id") String emeireportm_id, @RequestBody EMEIReportMDTO emeireportmdto) {
		EMEIReportM domain = emeireportmMapping.toDomain(emeireportmdto);
        domain.setEmeireportmid(emeireportm_id);
		emeireportmService.update(domain);
		EMEIReportMDTO dto = emeireportmMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emeireportm_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEIReportM" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeireportms/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEIReportMDTO> emeireportmdtos) {
        emeireportmService.updateBatch(emeireportmMapping.toDomain(emeireportmdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeireportm_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMEIReportM" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeireportms/{emeireportm_id}")
    public ResponseEntity<EMEIReportMDTO> get(@PathVariable("emeireportm_id") String emeireportm_id) {
        EMEIReportM domain = emeireportmService.get(emeireportm_id);
        EMEIReportMDTO dto = emeireportmMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEIReportM-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEIReportM" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeireportms/fetchdefault")
	public ResponseEntity<List<EMEIReportMDTO>> fetchDefault(EMEIReportMSearchContext context) {
        Page<EMEIReportM> domains = emeireportmService.searchDefault(context) ;
        List<EMEIReportMDTO> list = emeireportmMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEIReportM-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEIReportM" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeireportms/searchdefault")
	public ResponseEntity<Page<EMEIReportMDTO>> searchDefault(@RequestBody EMEIReportMSearchContext context) {
        Page<EMEIReportM> domains = emeireportmService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeireportmMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMEIReportM getEntity(){
        return new EMEIReportM();
    }

}
